/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.vo.EndpointSet;

public class Endpoints {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    private static final EndpointSet REGTAP = Endpoints.initDefaultTapEndpointSet("http://reg.g-vo.org/tap");

    public static EndpointSet getRegTapEndpointSet() {
        return REGTAP;
    }

    public static EndpointSet createDefaultTapEndpointSet(String baseUrl) {
        try {
            return Endpoints.createDefaultTapEndpointSet(new URL(baseUrl));
        }
        catch (MalformedURLException e) {
            throw (RuntimeException)new IllegalArgumentException("Not a URL: " + baseUrl).initCause(e);
        }
    }

    public static EndpointSet createDefaultTapEndpointSet(URL baseUrl) {
        final String identity = baseUrl.toString();
        final URL sync = Endpoints.appendPath(baseUrl, "/sync");
        final URL async = Endpoints.appendPath(baseUrl, "/async");
        final URL tables = Endpoints.appendPath(baseUrl, "/tables");
        final URL capabilities = Endpoints.appendPath(baseUrl, "/capabilities");
        final URL availability = Endpoints.appendPath(baseUrl, "/availability");
        final URL examples = Endpoints.appendPath(baseUrl, "/examples");
        return new EndpointSet(){

            @Override
            public String getIdentity() {
                return identity;
            }

            @Override
            public URL getSyncEndpoint() {
                return sync;
            }

            @Override
            public URL getAsyncEndpoint() {
                return async;
            }

            @Override
            public URL getTablesEndpoint() {
                return tables;
            }

            @Override
            public URL getCapabilitiesEndpoint() {
                return capabilities;
            }

            @Override
            public URL getAvailabilityEndpoint() {
                return availability;
            }

            @Override
            public URL getExamplesEndpoint() {
                return examples;
            }
        };
    }

    private static URL appendPath(URL base, String subPath) {
        try {
            return new URL(base.toString() + subPath);
        }
        catch (MalformedURLException e) {
            assert (false);
            throw (RuntimeException)new IllegalArgumentException("Bad URL???").initCause(e);
        }
    }

    private static EndpointSet initDefaultTapEndpointSet(String baseUrl) {
        try {
            return Endpoints.createDefaultTapEndpointSet(new URL(baseUrl));
        }
        catch (MalformedURLException e) {
            logger_.log(Level.WARNING, "Failed to get endpoints for TAP service: " + baseUrl, e);
            return null;
        }
    }
}

