/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.Endpoints;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapServiceFinder;

public class GlotsServiceFinder
implements TapServiceFinder {
    private final EndpointSet endpointSet_;
    private final ContentCoding coding_;
    private final AdqlSyntax syntax_;
    public static final String GAVO_DC_TAP_URL = "http://reg.g-vo.org/tap";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public GlotsServiceFinder() {
        this(Endpoints.createDefaultTapEndpointSet(GAVO_DC_TAP_URL), ContentCoding.GZIP);
    }

    public GlotsServiceFinder(EndpointSet glotsEndpointSet, ContentCoding coding) {
        this.endpointSet_ = glotsEndpointSet;
        this.coding_ = coding;
        this.syntax_ = AdqlSyntax.getInstance();
    }

    @Override
    public TapServiceFinder.Service[] readAllServices() throws IOException {
        String[] stringArray = new String[6];
        final String IVOID = "ivoid";
        stringArray[0] = "ivoid";
        final String NAME = "short_name";
        stringArray[1] = "short_name";
        final String TITLE = "res_title";
        stringArray[2] = "res_title";
        final String DESCRIP = "res_description";
        stringArray[3] = "res_description";
        final String URL2 = "accessurl";
        stringArray[4] = "accessurl";
        final String NTABLE = "ntable";
        stringArray[5] = "ntable";
        final String[] colNames = stringArray;
        String adql = new StringBuffer().append("SELECT").append(GlotsServiceFinder.commaJoin(colNames)).append(" FROM").append(" (SELECT").append(GlotsServiceFinder.commaJoin(new String[]{IVOID, URL2})).append(", COUNT(").append(IVOID).append(") AS ").append(NTABLE).append(" FROM glots.services").append(" JOIN glots.tables USING (").append(IVOID).append(")").append(" GROUP BY ").append(IVOID).append(") AS t").append(" JOIN rr.resource USING (").append(IVOID).append(")").toString();
        logger_.info("TAP Query: " + adql);
        TapQuery tq = new TapQuery(this.endpointSet_, adql, null);
        final ArrayList serviceList = new ArrayList();
        try {
            boolean isTrunc = tq.executeSync(new TableSink(){

                @Override
                public void acceptRow(Object[] row) {
                    Map<String, String> valueMap = GlotsServiceFinder.toValueMap(colNames, row);
                    final String id = valueMap.get(IVOID);
                    final String name = valueMap.get(NAME);
                    final String title = valueMap.get(TITLE);
                    final String descrip = valueMap.get(DESCRIP);
                    final String url = valueMap.get(URL2);
                    String ntableStr = valueMap.get(NTABLE);
                    int nt = -1;
                    if (ntableStr != null) {
                        try {
                            nt = Integer.parseInt(ntableStr);
                        }
                        catch (RuntimeException e) {
                            // empty catch block
                        }
                    }
                    final int ntable = nt;
                    serviceList.add(new TapServiceFinder.Service(){

                        @Override
                        public String getId() {
                            return id;
                        }

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public String getTitle() {
                            return title;
                        }

                        @Override
                        public String getDescription() {
                            return descrip;
                        }

                        @Override
                        public String getServiceUrl() {
                            return url;
                        }

                        @Override
                        public int getTableCount() {
                            return ntable;
                        }
                    });
                }

                @Override
                public void acceptMetadata(StarTable meta) {
                }

                @Override
                public void endRows() {
                }
            }, this.coding_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Error parsing VOTable result: " + e).initCause(e);
        }
        return serviceList.toArray(new TapServiceFinder.Service[0]);
    }

    @Override
    public TapServiceFinder.Table[] readSelectedTables(TapServiceFinder.Constraint constraint) throws IOException {
        String[] words = constraint.getKeywords();
        boolean isAnd = constraint.isAndKeywords();
        ArrayList<TapServiceFinder.Target> tTargets = new ArrayList<TapServiceFinder.Target>();
        for (TapServiceFinder.Target targ : constraint.getTargets()) {
            if (targ.isServiceMeta()) continue;
            assert (targ.getGlotsTablesCol() != null);
            tTargets.add(targ);
        }
        if (tTargets.size() == 0) {
            return new TapServiceFinder.Table[0];
        }
        String[] stringArray = new String[3];
        final String SERVICE_ID = "ivoid";
        stringArray[0] = "ivoid";
        final String NAME = "table_name";
        stringArray[1] = "table_name";
        final String DESCRIP = "table_desc";
        stringArray[2] = "table_desc";
        final String[] colNames = stringArray;
        StringBuffer sbuf = new StringBuffer().append("SELECT").append(GlotsServiceFinder.commaJoin(colNames)).append(" FROM glots.tables").append(" WHERE");
        for (int iw = 0; iw < words.length; ++iw) {
            String word = words[iw];
            if (iw > 0) {
                sbuf.append(isAnd ? " AND" : " OR");
            }
            sbuf.append(" (");
            for (int it = 0; it < tTargets.size(); ++it) {
                if (it > 0) {
                    sbuf.append(" OR ");
                }
                sbuf.append(this.getAdqlTest(word, (TapServiceFinder.Target)((Object)tTargets.get(it))));
            }
            sbuf.append(")");
        }
        logger_.info("TAP Query: " + sbuf);
        TapQuery tq = new TapQuery(this.endpointSet_, sbuf.toString(), null);
        final ArrayList tableList = new ArrayList();
        try {
            boolean isTrunc = tq.executeSync(new TableSink(){

                @Override
                public void acceptRow(Object[] row) {
                    Map<String, String> valueMap = GlotsServiceFinder.toValueMap(colNames, row);
                    final String serviceId = valueMap.get(SERVICE_ID);
                    final String name = valueMap.get(NAME);
                    final String descrip = valueMap.get(DESCRIP);
                    tableList.add(new TapServiceFinder.Table(){

                        @Override
                        public String getServiceId() {
                            return serviceId;
                        }

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public String getDescription() {
                            return descrip;
                        }
                    });
                }

                @Override
                public void acceptMetadata(StarTable meta) {
                }

                @Override
                public void endRows() {
                }
            }, this.coding_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Error parsing VOTable result: " + e).initCause(e);
        }
        return tableList.toArray(new TapServiceFinder.Table[0]);
    }

    private String getAdqlTest(String keyword, TapServiceFinder.Target target) {
        String glotsName = target.getGlotsTablesCol();
        if (target.isWords()) {
            return new StringBuffer().append("1=ivo_hasWord(").append(glotsName).append(", ").append(this.syntax_.characterLiteral(keyword)).append(")").toString();
        }
        return new StringBuffer().append("1=ivo_nocasematch(").append(glotsName).append(", ").append(this.syntax_.characterLiteral("%" + keyword + "%")).append(")").toString();
    }

    static String commaJoin(String[] words) {
        StringBuffer sbuf = new StringBuffer();
        for (String word : words) {
            if (sbuf.length() > 0) {
                sbuf.append(",");
            }
            sbuf.append(" ");
            sbuf.append(word);
        }
        return sbuf.toString();
    }

    static Map<String, String> toValueMap(String[] keys, Object[] values) {
        int n = keys.length;
        HashMap<String, String> map = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String key = keys[i];
            Object val = values[i];
            map.put(key, val == null ? null : val.toString());
        }
        return map;
    }
}

