/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import uk.ac.starlink.vo.UrlHandler;

public class HintPanel
extends JPanel {
    private final UrlHandler urlHandler_;
    private final JEditorPane edPanel_;
    private final HTMLDocument doc_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    static final String HINTS_FILE = "adql_hints.html";

    public HintPanel(final UrlHandler urlHandler) {
        super(new BorderLayout());
        this.urlHandler_ = urlHandler;
        HTMLEditorKit edKit = new HTMLEditorKit();
        this.doc_ = (HTMLDocument)edKit.createDefaultDocument();
        this.edPanel_ = new JEditorPane();
        this.edPanel_.setEditorKit(edKit);
        this.edPanel_.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.edPanel_.setEditable(false);
        this.edPanel_.setOpaque(false);
        URL docResource = HintPanel.class.getResource(HINTS_FILE);
        if (docResource != null) {
            try {
                this.edPanel_.read(docResource.openStream(), (Object)this.doc_);
            }
            catch (IOException e) {
                String msg = "Read error for: " + docResource + " - " + e;
                logger_.warning(msg);
                this.edPanel_.setText(msg);
            }
        } else {
            String msg = "No content";
            logger_.warning(msg);
            this.edPanel_.setText(msg);
        }
        this.edPanel_.setCaretPosition(0);
        if (urlHandler != null) {
            this.edPanel_.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(evt.getEventType())) {
                        URL url = evt.getURL();
                        urlHandler.clickUrl(url);
                    }
                }
            });
        }
        this.add((Component)this.edPanel_, "Center");
    }

    public void setExamplesUrl(String url) {
        StringBuffer sbuf = new StringBuffer();
        if (url == null) {
            sbuf.append("This service has no ").append("<em>service-provided</em> examples");
        } else {
            sbuf.append("This service has data-specific examples: <br></br>").append("you can see them in the ").append("<span id='menu'>Service Provided</span> ").append("Examples sub-menu, <br></br>").append("or <a href='").append(url).append("'>with explanation</a> in your browser.");
        }
        try {
            HTMLDocument doc = (HTMLDocument)this.edPanel_.getDocument();
            Element exEl = doc.getElement("EXAMPLE_CONTENT");
            doc.setInnerHTML(exEl, sbuf.toString());
        }
        catch (Exception e) {
            logger_.warning("Trouble editing HTML: " + e);
        }
    }
}

