/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.TapQuery;

public class QuickLookWindow
extends JFrame {
    private final TapQuery tq_;
    private final StarTableFactory tfact_;
    private final ContentCoding coding_;
    private final JTabbedPane tabber_;
    private final JComponent resultPanel_;
    private final ExecutorService executor_;
    private Future<?> job_;

    public QuickLookWindow(TapQuery tq, StarTableFactory tfact, ContentCoding coding) {
        this.setTitle("TAP Quick Look");
        this.tq_ = tq;
        this.tfact_ = tfact;
        this.coding_ = coding;
        this.setDefaultCloseOperation(2);
        AbstractAction closeAct = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuickLookWindow.this.dispose();
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                QuickLookWindow.this.executor_.shutdownNow();
                QuickLookWindow.this.setResultComponent(QuickLookWindow.createLabelPanel("Cancelled."));
            }
        });
        this.executor_ = Executors.newSingleThreadExecutor();
        this.tabber_ = new JTabbedPane();
        this.tabber_.setPreferredSize(new Dimension(400, 180));
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)new JLabel("TAP Quick Look"), "North");
        content.add((Component)this.tabber_, "Center");
        Box buttonLine = Box.createHorizontalBox();
        buttonLine.add(Box.createHorizontalGlue());
        buttonLine.add(new JButton(closeAct));
        buttonLine.add(Box.createHorizontalGlue());
        buttonLine.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        content.add((Component)buttonLine, "South");
        this.resultPanel_ = new JPanel(new BorderLayout());
        this.tabber_.add("Query", QuickLookWindow.createTextPanel(tq.getAdql()));
        this.tabber_.add("Result", this.resultPanel_);
        this.pack();
    }

    public void executeQuery() {
        this.setResultComponent(QuickLookWindow.createLabelPanel("Running ..."));
        this.job_ = this.executor_.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    final StarTable table = QuickLookWindow.this.tq_.executeSync(QuickLookWindow.this.tfact_.getStoragePolicy(), QuickLookWindow.this.coding_);
                    this.schedule(new Runnable(){

                        @Override
                        public void run() {
                            QuickLookWindow.this.displayTable(table);
                        }
                    });
                }
                catch (IOException e) {
                    this.schedule(new Runnable(){

                        @Override
                        public void run() {
                            QuickLookWindow.this.displayError(e);
                        }
                    });
                }
            }

            private void schedule(final Runnable r) {
                if (!QuickLookWindow.this.job_.isCancelled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!QuickLookWindow.this.job_.isCancelled()) {
                                r.run();
                            }
                        }
                    });
                }
            }
        });
    }

    private void displayTable(StarTable table) {
        StarJTable jt = new StarJTable(table, true);
        jt.configureColumnWidths(350, 10000);
        this.setResultComponent(new JScrollPane(jt));
    }

    private void displayError(IOException error) {
        StringWriter traceWriter = new StringWriter();
        error.printStackTrace(new PrintWriter(traceWriter));
        String trace = traceWriter.toString();
        this.setResultComponent(QuickLookWindow.createTextPanel(trace));
    }

    private void setResultComponent(JComponent comp) {
        this.resultPanel_.removeAll();
        this.resultPanel_.add(comp);
        this.resultPanel_.revalidate();
        this.resultPanel_.repaint();
        this.tabber_.setSelectedIndex(1);
    }

    private static JComponent createTextPanel(String txt) {
        JTextArea textPanel = new JTextArea();
        textPanel.setEditable(false);
        textPanel.setLineWrap(false);
        textPanel.setText(txt);
        textPanel.setCaretPosition(0);
        return new JScrollPane(textPanel);
    }

    private static JComponent createLabelPanel(String txt) {
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        hbox.add(new JLabel(txt));
        hbox.add(Box.createHorizontalGlue());
        Box vbox = Box.createVerticalBox();
        vbox.add(Box.createVerticalGlue());
        vbox.add(hbox);
        vbox.add(Box.createVerticalGlue());
        return vbox;
    }
}

