/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TreeSet;
import java.util.logging.Logger;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.Endpoints;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegTapRegistryQuery;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.ResourceField;
import uk.ac.starlink.vo.Ri1RegistryQuery;

public abstract class RegistryProtocol {
    private final String shortName_;
    private final String fullName_;
    private final String[] dfltUrls_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    public static final RegistryProtocol RI1 = new Ri1RegistryProtocol();
    public static final RegistryProtocol REGTAP = new RegTapRegistryProtocol();
    public static final RegistryProtocol[] PROTOCOLS = new RegistryProtocol[]{REGTAP, RI1};

    protected RegistryProtocol(String shortName, String fullName, String[] dfltUrls) {
        this.shortName_ = shortName;
        this.fullName_ = fullName;
        this.dfltUrls_ = (String[])dfltUrls.clone();
    }

    public String getShortName() {
        return this.shortName_;
    }

    public String getFullName() {
        return this.fullName_;
    }

    public String[] getDefaultRegistryUrls() {
        return (String[])this.dfltUrls_.clone();
    }

    public abstract String[] discoverRegistryUrls(String var1) throws IOException;

    public abstract RegistryQuery createIdListQuery(String[] var1, Capability var2, URL var3);

    public abstract RegistryQuery createKeywordQuery(String[] var1, ResourceField[] var2, boolean var3, Capability var4, URL var5);

    public abstract boolean hasCapability(Capability var1, RegCapabilityInterface var2);

    private static class RegTapRegistryProtocol
    extends RegistryProtocol {
        public RegTapRegistryProtocol() {
            super("RegTAP", "Relational Registry 1.0", RegTapRegistryQuery.REGISTRIES);
        }

        @Override
        public String[] discoverRegistryUrls(String regUrl0) throws IOException {
            try {
                EndpointSet endpointSet0 = Endpoints.createDefaultTapEndpointSet(new URL(regUrl0));
                return RegTapRegistryQuery.getSearchableRegistries(endpointSet0);
            }
            catch (MalformedURLException e) {
                return new String[0];
            }
        }

        @Override
        public RegistryQuery createIdListQuery(String[] ivoids, Capability capability, URL regUrl) {
            if (ivoids == null || ivoids.length == 0) {
                return null;
            }
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("ivoid IN (");
            for (int i = 0; i < ivoids.length; ++i) {
                if (i > 0) {
                    sbuf.append(", ");
                }
                sbuf.append("'").append(ivoids[i].toLowerCase()).append("'");
            }
            sbuf.append(")");
            String idsWhere = sbuf.toString();
            EndpointSet endpointSet = Endpoints.createDefaultTapEndpointSet(regUrl);
            return new RegTapRegistryQuery(endpointSet, capability.getStandardId().toLowerCase(), idsWhere);
        }

        @Override
        public RegistryQuery createKeywordQuery(String[] keywords, ResourceField[] fields, boolean isOr, Capability capability, URL regUrl) {
            String conjunction = isOr ? " OR " : " AND ";
            StringBuffer sbuf = new StringBuffer();
            TreeSet<String> failFields = new TreeSet<String>();
            for (int iw = 0; iw < keywords.length; ++iw) {
                String word = keywords[iw];
                if (iw > 0) {
                    sbuf.append(conjunction);
                }
                sbuf.append("(");
                boolean hasField = false;
                for (int ip = 0; ip < fields.length; ++ip) {
                    ResourceField field = fields[ip];
                    String keyCond = RegTapRegistryQuery.getAdqlCondition(field, word);
                    if (keyCond != null) {
                        if (hasField) {
                            sbuf.append(" OR ");
                        }
                        hasField = true;
                        sbuf.append(keyCond);
                        continue;
                    }
                    failFields.add(field.getLabel());
                }
                if (!hasField) {
                    sbuf.append("1=1");
                }
                sbuf.append(")");
            }
            if (!failFields.isEmpty()) {
                logger_.warning("Failed to set constraint for fields " + failFields);
            }
            String keywordWhere = sbuf.toString();
            EndpointSet endpointSet = Endpoints.createDefaultTapEndpointSet(regUrl);
            return new RegTapRegistryQuery(endpointSet, capability.getStandardId().toLowerCase(), keywordWhere);
        }

        @Override
        public boolean hasCapability(Capability stdCap, RegCapabilityInterface resCap) {
            String resId = resCap.getStandardId();
            String stdId = stdCap.getStandardId();
            return stdId != null && stdId.equalsIgnoreCase(resId);
        }
    }

    private static class Ri1RegistryProtocol
    extends RegistryProtocol {
        Ri1RegistryProtocol() {
            super("RI1.0", "Registry Interface 1.0", Ri1RegistryQuery.REGISTRIES);
        }

        @Override
        public String[] discoverRegistryUrls(String regUrl0) throws IOException {
            return Ri1RegistryQuery.getSearchableRegistries(regUrl0);
        }

        @Override
        public RegistryQuery createIdListQuery(String[] ivoids, Capability capability, URL regUrl) {
            if (ivoids == null || ivoids.length == 0) {
                return null;
            }
            StringBuffer sbuf = new StringBuffer();
            if (capability != null) {
                sbuf.append("(").append(Ri1RegistryQuery.getAdqlWhere(capability)).append(")");
            }
            if (sbuf.length() > 0) {
                sbuf.append(" AND ");
            }
            sbuf.append("(");
            for (int i = 0; i < ivoids.length; ++i) {
                if (i > 0) {
                    sbuf.append(" OR ");
                }
                sbuf.append("identifier = '").append(ivoids[i]).append("'");
            }
            sbuf.append(")");
            String adql = sbuf.toString();
            return new Ri1RegistryQuery(regUrl.toString(), adql);
        }

        @Override
        public RegistryQuery createKeywordQuery(String[] keywords, ResourceField[] fields, boolean isOr, Capability capability, URL regUrl) {
            String conjunction = isOr ? " OR " : " AND ";
            StringBuffer sbuf = new StringBuffer();
            if (capability != null) {
                sbuf.append(Ri1RegistryQuery.getAdqlWhere(capability));
            }
            if (keywords.length > 0) {
                if (sbuf.length() > 0) {
                    sbuf.append(" AND ( ");
                }
                for (int iw = 0; iw < keywords.length; ++iw) {
                    if (iw > 0) {
                        sbuf.append(conjunction);
                    }
                    sbuf.append("(");
                    for (int ip = 0; ip < fields.length; ++ip) {
                        if (ip > 0) {
                            sbuf.append(" OR ");
                        }
                        sbuf.append(fields[ip].getXpath()).append(" LIKE ").append("'%").append(keywords[iw]).append("%'");
                    }
                    sbuf.append(")");
                }
                sbuf.append(" )");
            }
            String adql = sbuf.toString();
            return new Ri1RegistryQuery(regUrl.toString(), adql);
        }

        @Override
        public boolean hasCapability(Capability stdCap, RegCapabilityInterface resCap) {
            String resType = resCap.getXsiType();
            String stdTypeTail = stdCap.getXsiTypeTail();
            String resId = resCap.getStandardId();
            String stdId = stdCap.getStandardId();
            return stdId != null && stdId.equals(resId) || resType != null && stdTypeTail != null && resType.endsWith(stdTypeTail);
        }
    }
}

