/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import uk.ac.starlink.util.gui.Downloader;
import uk.ac.starlink.vo.RegistryProtocol;
import uk.ac.starlink.vo.RegistrySelectorModel;

public class RegistrySelector
extends JPanel {
    private final JComboBox comboBox_ = new JComboBox(){

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension(super.getPreferredSize());
            size.width = Math.min(size.width, 400);
            return size;
        }

        @Override
        public void configureEditor(ComboBoxEditor editor, Object item) {
            super.configureEditor(editor, item);
            Component comp = editor.getEditorComponent();
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setCaretPosition(0);
            }
        }
    };
    private final Action updateAction_;
    private final EndpointDownloader endpointDownloader_;
    private RegistrySelectorModel model_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public RegistrySelector() {
        this(new RegistrySelectorModel(RegistryProtocol.RI1));
    }

    public RegistrySelector(RegistrySelectorModel model) {
        this.comboBox_.setEditable(true);
        this.comboBox_.setToolTipText("Endpoint of VOResource 1.0 registry service");
        this.comboBox_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RegistrySelector.this.endpointDownloader_.setQuery(RegistrySelector.this.getRegKey());
            }
        });
        this.endpointDownloader_ = new EndpointDownloader();
        this.updateAction_ = new AbstractAction("Update Registry List"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                final RegKey regKey = RegistrySelector.this.getRegKey();
                RegistrySelector.this.endpointDownloader_.setQuery(regKey);
                RegistrySelector.this.updateAction_.setEnabled(false);
                new Thread("Registry search"){

                    @Override
                    public void run() {
                        final String[] acurls = (String[])RegistrySelector.this.endpointDownloader_.waitForData();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RegistrySelector.this.updateAction_.setEnabled(true);
                                if (RegistrySelector.this.model_.getProtocol() == regKey.proto_ && acurls != null) {
                                    RegistrySelector.this.updateSelector(acurls);
                                }
                            }
                        });
                    }
                }.start();
            }
        };
        this.updateAction_.putValue("ShortDescription", "Search the registry for searchable registries, and update options in the selector");
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel("Registry: "));
        this.add(this.comboBox_);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.endpointDownloader_.createMonitorComponent());
        this.setModel(model);
    }

    public void setModel(RegistrySelectorModel model) {
        this.model_ = model;
        ComboBoxModel urlModel = model.getUrlSelectionModel();
        this.comboBox_.setModel(urlModel);
        this.updateAction_.setEnabled(urlModel instanceof MutableComboBoxModel);
        this.endpointDownloader_.setQuery(this.getRegKey());
    }

    public RegistrySelectorModel getModel() {
        return this.model_;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBox_.setEnabled(enabled);
    }

    public String getUrl() {
        return (String)this.comboBox_.getSelectedItem();
    }

    public Action getRegistryUpdateAction() {
        return this.updateAction_;
    }

    private RegKey getRegKey() {
        RegistryProtocol proto = this.model_.getProtocol();
        String reg = (String)this.comboBox_.getSelectedItem();
        return new RegKey(proto, reg);
    }

    private void updateSelector(String[] acurls) {
        ComboBoxModel model = this.comboBox_.getModel();
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            values.add((String)model.getElementAt(i));
        }
        ArrayList<String> addUrls = new ArrayList<String>();
        for (int i = 0; i < acurls.length; ++i) {
            String acurl = acurls[i];
            if (!values.add(acurl)) continue;
            addUrls.add(acurl);
        }
        if (addUrls.size() > 0) {
            if (model instanceof MutableComboBoxModel) {
                MutableComboBoxModel mmodel = (MutableComboBoxModel)model;
                for (String url : addUrls) {
                    mmodel.addElement(url);
                }
            } else {
                logger_.warning("Can't add access URLs to immutable combo box (" + addUrls.size() + " new URLs ignored)");
            }
        }
    }

    private static class RegKey {
        final RegistryProtocol proto_;
        final String reg_;

        RegKey(RegistryProtocol proto, String reg) {
            this.proto_ = proto;
            this.reg_ = reg;
        }

        public int hashCode() {
            return this.proto_.hashCode() * 5001 + this.reg_.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RegKey) {
                RegKey other = (RegKey)o;
                return this.proto_.equals(other.proto_) && this.reg_.equals(other.reg_);
            }
            return false;
        }

        public String toString() {
            return this.proto_ + "-" + this.reg_;
        }
    }

    private static class EndpointDownloader
    extends Downloader<String[]> {
        private RegKey key_;

        EndpointDownloader() {
            super(String[].class, "Registry service URLs");
        }

        public void setQuery(RegKey key) {
            this.clearData();
            this.key_ = key;
        }

        @Override
        public String[] attemptReadData() throws IOException {
            return this.key_.proto_.discoverRegistryUrls(this.key_.reg_);
        }
    }
}

