/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryQuery;

public class RegistryStarTable
extends ColumnStarTable {
    private final Record[] records_;
    private static final ValueInfo IDENTIFIER_INFO = new DefaultValueInfo("ID", String.class, "Registry identifier URI for resource");
    private static final ValueInfo SHORTNAME_INFO = new DefaultValueInfo("ShortName", String.class, "Short name for resource");
    private static final ValueInfo TITLE_INFO = new DefaultValueInfo("Title", String.class, "Title for resource");
    private static final ValueInfo PUBLISHER_INFO = new DefaultValueInfo("Publisher", String.class, "Person or organisation responsible for publishing the resource");
    private static final ValueInfo SUBJECTS_INFO = new DefaultValueInfo("Subjects", String[].class, "Topic, object type, or other descriptive keywords about the resource");
    private static final ValueInfo REFURL_INFO = new DefaultValueInfo("ReferenceURL", String.class, "URL describing the resource");
    private static final ValueInfo CONTACT_INFO = new DefaultValueInfo("Contact", String.class, "Person to contact concerning this resource");
    private static final ValueInfo CAP_DESCRIPTION_INFO = new DefaultValueInfo("CapDesc", String.class, "Description of the service capability");
    private static final ValueInfo CAP_STDID_INFO = new DefaultValueInfo("CapStdId", String.class, "Standard ID URI describing the type of service capability provided");
    private static final ValueInfo CAP_ACURL_INFO = new DefaultValueInfo("AccessURL", String.class, "Access URL for the service capability");
    private static final ValueInfo CAP_VERSION_INFO = new DefaultValueInfo("CapVersion", String.class, "Version of the service capability provided");
    private static final RegCapabilityInterface EMPTY_CAPABILITY = new RegCapabilityInterface(){

        @Override
        public String getAccessUrl() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getStandardId() {
            return null;
        }

        @Override
        public String getXsiType() {
            return null;
        }

        @Override
        public String getVersion() {
            return null;
        }
    };

    public RegistryStarTable(RegistryQuery query) throws IOException {
        this.records_ = RegistryStarTable.getRecords(query);
        this.setParameters(new ArrayList<DescribedValue>(Arrays.asList(query.getMetadata())));
        this.addColumn(new ColumnData(IDENTIFIER_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getIdentifier();
            }
        });
        this.addColumn(new ColumnData(SHORTNAME_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getShortName();
            }
        });
        this.addColumn(new ColumnData(TITLE_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getTitle();
            }
        });
        this.addColumn(new ColumnData(PUBLISHER_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getPublisher();
            }
        });
        this.addColumn(new ColumnData(SUBJECTS_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getSubjects();
            }
        });
        this.addColumn(new ColumnData(REFURL_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getReferenceUrl();
            }
        });
        this.addColumn(new ColumnData(CONTACT_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getContact();
            }
        });
        this.addColumn(new ColumnData(CAP_DESCRIPTION_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).capability_.getDescription();
            }
        });
        this.addColumn(new ColumnData(CAP_STDID_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).capability_.getStandardId();
            }
        });
        this.addColumn(new ColumnData(CAP_ACURL_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).capability_.getAccessUrl();
            }
        });
        this.addColumn(new ColumnData(CAP_VERSION_INFO){

            @Override
            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).capability_.getVersion();
            }
        });
    }

    @Override
    public long getRowCount() {
        return this.records_.length;
    }

    private Record getRecord(long irow) {
        return this.records_[Tables.checkedLongToInt(irow)];
    }

    private static Record[] getRecords(RegistryQuery query) throws IOException {
        ArrayList<Record> recList = new ArrayList<Record>();
        Iterator<RegResource> it = query.getQueryIterator();
        while (it.hasNext()) {
            RegResource resource = it.next();
            RegCapabilityInterface[] caps = resource.getCapabilities();
            if (caps.length == 0) {
                recList.add(new Record(resource, EMPTY_CAPABILITY));
                continue;
            }
            for (int ic = 0; ic < caps.length; ++ic) {
                recList.add(new Record(resource, caps[ic]));
            }
        }
        return recList.toArray(new Record[0]);
    }

    private static class Record {
        final RegResource resource_;
        final RegCapabilityInterface capability_;

        Record(RegResource resource, RegCapabilityInterface capability) {
            this.resource_ = resource;
            this.capability_ = capability;
        }
    }
}

