/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Container;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.util.gui.ArrayTableSorter;
import uk.ac.starlink.vo.MetaColumnModel;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.ResourceTableModel;

public class RegistryTable
extends JTable {
    private final ResourceTableModel tModel_;
    private final MetaColumnModel colModel_;
    private final ArrayTableSorter sorter_;
    private int iSortcol_;
    private boolean descending_;
    private static String[] DEFAULT_COLUMNS = new String[]{"Short Name", "Title"};

    public RegistryTable() {
        this(new ResourceTableModel());
    }

    public RegistryTable(ResourceTableModel tModel) {
        this.tModel_ = tModel;
        this.setModel(this.tModel_);
        this.colModel_ = RegistryTable.makeMetaColumnModel(this.getColumnModel(), this.tModel_, DEFAULT_COLUMNS);
        this.colModel_.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent evt) {
                StarJTable.configureColumnWidth(RegistryTable.this, 1000, 1000, evt.getToIndex());
                RegistryTable.this.reconfigureResizeMode();
                int from = evt.getToIndex();
                int to = RegistryTable.this.colModel_.getColumnCount() - 1;
            }

            @Override
            public void columnRemoved(TableColumnModelEvent evt) {
                RegistryTable.this.reconfigureResizeMode();
            }

            @Override
            public void columnMarginChanged(ChangeEvent evt) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent evt) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent evt) {
            }
        });
        this.setColumnModel(this.colModel_);
        this.sorter_ = new ArrayTableSorter(tModel);
        this.sorter_.install(this.getTableHeader());
        this.setSorting(0, false);
    }

    public void setData(RegResource[] data) {
        this.tModel_.setResources(data);
        if (this.iSortcol_ >= 0) {
            this.tModel_.sortByColumn(this.iSortcol_, this.descending_);
        }
        this.colModel_.purgeEmptyColumns();
        StarJTable.configureColumnWidths(this, 1000, 10000);
    }

    public RegResource[] getData() {
        return this.tModel_.getResources();
    }

    public MetaColumnModel getMetaColumnModel() {
        return this.colModel_;
    }

    public void setSorting(int icol, boolean descending) {
        this.sorter_.setSorting(icol, descending);
    }

    private void reconfigureResizeMode() {
        Container holder = this.getParent();
        if (holder instanceof JViewport) {
            int cwidth = 0;
            TableColumnModel cmodel = this.getColumnModel();
            for (int i = 0; i < cmodel.getColumnCount(); ++i) {
                cwidth += cmodel.getColumn(i).getPreferredWidth();
            }
            this.setAutoResizeMode(cwidth <= holder.getSize().width ? 4 : 0);
        }
    }

    private static MetaColumnModel makeMetaColumnModel(TableColumnModel cmodel, TableModel tmodel, Object[] initcols) {
        int ic;
        int nfix = 0;
        block0: for (int iv = 0; iv < initcols.length; ++iv) {
            for (ic = nfix; ic < cmodel.getColumnCount(); ++ic) {
                TableColumn col = cmodel.getColumn(ic);
                if (!initcols[iv].equals(col.getHeaderValue())) continue;
                cmodel.moveColumn(ic, nfix++);
                continue block0;
            }
        }
        MetaColumnModel mcmodel = new MetaColumnModel(cmodel, tmodel);
        for (ic = mcmodel.getColumnCount() - 1; ic >= nfix; --ic) {
            mcmodel.removeColumn(mcmodel.getColumn(ic));
        }
        return mcmodel;
    }
}

