/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.util.gui.ArrayTableColumn;
import uk.ac.starlink.util.gui.ArrayTableModel;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;

public class ResourceTableModel
extends ArrayTableModel {
    public ResourceTableModel() {
        this(false);
    }

    public ResourceTableModel(boolean includeAcref) {
        ArrayList<ArrayTableColumn> colList = new ArrayList<ArrayTableColumn>(Arrays.asList(new ArrayTableColumn("Short Name", String.class){

            @Override
            public Object getValue(Object item) {
                return ResourceTableModel.this.getResource(item).getShortName();
            }
        }, new ArrayTableColumn("Title", String.class){

            @Override
            public Object getValue(Object item) {
                return ResourceTableModel.this.getResource(item).getTitle();
            }
        }, new ArrayTableColumn("Subjects", String.class){

            @Override
            public Object getValue(Object item) {
                return ResourceTableModel.arrayToString(ResourceTableModel.this.getResource(item).getSubjects());
            }
        }, new ArrayTableColumn("Identifier", String.class){

            @Override
            public Object getValue(Object item) {
                return ResourceTableModel.this.getResource(item).getIdentifier();
            }
        }, new ArrayTableColumn("Publisher", String.class){

            @Override
            public Object getValue(Object item) {
                return ResourceTableModel.this.getResource(item).getPublisher();
            }
        }, new ArrayTableColumn("Contact", String.class){

            @Override
            public Object getValue(Object item) {
                return ResourceTableModel.this.getResource(item).getContact();
            }
        }, new ArrayTableColumn("Reference URL", String.class){

            @Override
            public Object getValue(Object item) {
                return ResourceTableModel.this.getResource(item).getReferenceUrl();
            }
        }));
        if (includeAcref) {
            colList.add(new ArrayTableColumn("soleAccessURL", String.class){

                @Override
                public Object getValue(Object item) {
                    RegCapabilityInterface[] caps = ResourceTableModel.this.getResource(item).getCapabilities();
                    return caps != null && caps.length == 1 ? caps[0].getAccessUrl() : null;
                }
            });
        }
        this.setColumns(colList.toArray(new ArrayTableColumn[0]));
        this.setItems(new RegResource[0]);
    }

    public void setResources(RegResource[] resources) {
        super.setItems(resources);
    }

    public RegResource[] getResources() {
        return (RegResource[])super.getItems();
    }

    private RegResource getResource(Object item) {
        return (RegResource)item;
    }

    private static String arrayToString(String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        for (int iv = 0; iv < values.length; ++iv) {
            String val = values[iv];
            if (val == null || val.trim().length() <= 0) continue;
            if (sbuf.length() > 0) {
                sbuf.append(", ");
            }
            sbuf.append(val.trim());
        }
        return sbuf.toString();
    }
}

