/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapTableLoadDialog;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.vo.UwsJobInfo;
import uk.ac.starlink.vo.UwsJobPanel;
import uk.ac.starlink.vo.UwsStage;

class ResumeTapQueryPanel
extends JPanel {
    private final TapTableLoadDialog tld_;
    private final UwsJobPanel jobPanel_;
    private final JComponent mainBox_;
    private final JTextField urlField_;
    private final Action resumeAct_;
    private final Action loadResultAct_;
    private final Timer phaseTimer_;
    private Thread fetcher_;

    public ResumeTapQueryPanel(TapTableLoadDialog tld) {
        super(new BorderLayout());
        this.tld_ = tld;
        this.urlField_ = new JTextField();
        this.jobPanel_ = new UwsJobPanel(true);
        AbstractAction clearAct = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResumeTapQueryPanel.this.setStatus("");
                ResumeTapQueryPanel.this.urlField_.setText("");
            }
        };
        final AbstractAction jobAct = new AbstractAction("View"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String urlTxt = ResumeTapQueryPanel.this.urlField_.getText();
                try {
                    ResumeTapQueryPanel.this.viewJob(new UwsJob(new URL(urlTxt)));
                }
                catch (MalformedURLException e) {
                    assert (false);
                    return;
                }
            }
        };
        this.urlField_.addActionListener(jobAct);
        this.urlField_.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                String txt = ResumeTapQueryPanel.this.urlField_.getText();
                if (txt != null && txt.trim().length() > 0) {
                    try {
                        new URL(ResumeTapQueryPanel.this.urlField_.getText());
                        jobAct.setEnabled(true);
                        return;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                jobAct.setEnabled(false);
            }
        });
        final ActionEvent dummyEvt = new ActionEvent(this, 0, "resume");
        this.resumeAct_ = new AbstractAction("Resume"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResumeTapQueryPanel.this.tld_.getSubmitAction().actionPerformed(dummyEvt);
                ResumeTapQueryPanel.this.urlField_.setText("");
                ResumeTapQueryPanel.this.setJob(null);
            }
        };
        this.loadResultAct_ = new AbstractAction("Load Result"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResumeTapQueryPanel.this.tld_.getSubmitAction().actionPerformed(dummyEvt);
                ResumeTapQueryPanel.this.urlField_.setText("");
                ResumeTapQueryPanel.this.setJob(null);
            }
        };
        this.phaseTimer_ = new Timer(4000, new ActionListener(){
            private volatile boolean isRunning;
            private UwsJob lastJob;

            @Override
            public void actionPerformed(ActionEvent evt) {
                final UwsJob job = ResumeTapQueryPanel.this.jobPanel_.getJob();
                if (job != this.lastJob) {
                    this.isRunning = false;
                    this.lastJob = job;
                }
                if (job != null) {
                    new Thread("UWS job phase reader " + job.getJobUrl()){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (ResumeTapQueryPanel.this.jobPanel_.getJob() == job && !isRunning) {
                                String errMsg = null;
                                isRunning = true;
                                UwsJobInfo info = null;
                                try {
                                    info = job.readInfo();
                                }
                                catch (FileNotFoundException e) {
                                    errMsg = "Job has been deleted";
                                }
                                catch (IOException e) {
                                    errMsg = e.toString();
                                }
                                finally {
                                    isRunning = false;
                                }
                                final UwsJobInfo info0 = info;
                                final String errMsg0 = errMsg;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (errMsg0 != null) {
                                            ResumeTapQueryPanel.this.setStatus(errMsg0);
                                            ResumeTapQueryPanel.this.setJob(null);
                                        } else {
                                            ResumeTapQueryPanel.this.setJobState(job, info0);
                                        }
                                    }
                                });
                            }
                        }
                    }.start();
                }
            }
        });
        this.phaseTimer_.setRepeats(true);
        this.phaseTimer_.setInitialDelay(0);
        this.phaseTimer_.setCoalesce(true);
        this.jobPanel_.setJob(null);
        Box urlBox = Box.createVerticalBox();
        Box txtLine = Box.createHorizontalBox();
        txtLine.add(new JLabel("Enter URL of previously submitted TAP Job"));
        txtLine.add(Box.createHorizontalGlue());
        urlBox.add(txtLine);
        urlBox.add(Box.createVerticalStrut(5));
        Box entryLine = Box.createHorizontalBox();
        entryLine.add(new JLabel("URL: "));
        entryLine.add(this.urlField_);
        urlBox.add(entryLine);
        urlBox.add(Box.createVerticalStrut(5));
        Box ubuttLine = Box.createHorizontalBox();
        ubuttLine.add(Box.createHorizontalGlue());
        ubuttLine.add(new JButton(clearAct));
        ubuttLine.add(Box.createHorizontalStrut(5));
        ubuttLine.add(new JButton(jobAct));
        urlBox.add(ubuttLine);
        Box controlBox = Box.createHorizontalBox();
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(new JButton(this.resumeAct_));
        controlBox.add(Box.createHorizontalStrut(10));
        controlBox.add(new JButton(this.loadResultAct_));
        controlBox.add(Box.createHorizontalGlue());
        this.mainBox_ = new JPanel(new BorderLayout());
        this.mainBox_.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Previously Submitted Job"));
        urlBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        controlBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)urlBox, "North");
        this.add((Component)this.mainBox_, "Center");
        this.add((Component)controlBox, "South");
        this.setStatus(null);
    }

    public TableLoader createTableLoader() {
        boolean deleteOnExit = false;
        final UwsJob job = this.jobPanel_.getJob();
        if (job == null) {
            return null;
        }
        UwsJobInfo info = job.getLastInfo();
        String phase = info == null ? null : info.getPhase();
        UwsStage stage = UwsStage.forPhase(phase);
        String summary = "Resumed TAP Query";
        if ("COMPLETED".equals(phase)) {
            return new TableLoader(){

                @Override
                public TableSequence loadTables(StarTableFactory tfact) throws IOException {
                    StarTable table = TapQuery.getResult(job, ResumeTapQueryPanel.this.tld_.getContentCoding(), tfact.getStoragePolicy());
                    return Tables.singleTableSequence(table);
                }

                @Override
                public String getLabel() {
                    return "Resumed TAP Query";
                }
            };
        }
        if (stage == UwsStage.UNSTARTED || stage == UwsStage.RUNNING) {
            final boolean unstarted = stage == UwsStage.UNSTARTED;
            job.setDeleteOnExit(false);
            return new TableLoader(){

                @Override
                public TableSequence loadTables(StarTableFactory tfact) throws IOException {
                    StarTable table;
                    if (unstarted) {
                        job.start();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResumeTapQueryPanel.this.tld_.addRunningQuery(job);
                        }
                    });
                    try {
                        table = TapQuery.waitForResult(job, ResumeTapQueryPanel.this.tld_.getContentCoding(), tfact.getStoragePolicy(), 4000L);
                    }
                    catch (InterruptedException e) {
                        throw (IOException)new InterruptedIOException("Interrupted").initCause(e);
                    }
                    return Tables.singleTableSequence(table);
                }

                @Override
                public String getLabel() {
                    return "Resumed TAP Query";
                }
            };
        }
        assert (false);
        return null;
    }

    public void reload() {
        String urlTxt = this.urlField_.getText();
        if (urlTxt != null) {
            try {
                this.viewJob(new UwsJob(new URL(urlTxt)));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private void viewJob(final UwsJob job) {
        String urlTxt = job.getJobUrl().toString();
        this.setStatus("Examining Job " + urlTxt + "...");
        this.fetcher_ = new Thread("read UWS phase " + urlTxt){

            @Override
            public void run() {
                final 9 fetcher = this;
                try {
                    UwsJobInfo info = job.readInfo();
                }
                catch (IOException e) {
                    final String msg = e instanceof FileNotFoundException ? "No such job" : e.toString();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ResumeTapQueryPanel.this.fetcher_ == fetcher) {
                                ResumeTapQueryPanel.this.setStatus("Job not available: " + msg);
                            }
                        }
                    });
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (fetcher == ResumeTapQueryPanel.this.fetcher_) {
                            ResumeTapQueryPanel.this.setStatus(null);
                            ResumeTapQueryPanel.this.setJob(job);
                        }
                    }
                });
            }
        };
        this.fetcher_.setDaemon(true);
        this.fetcher_.start();
    }

    private void setJobState(UwsJob job, UwsJobInfo info) {
        if (job == this.jobPanel_.getJob()) {
            this.jobPanel_.setJobInfo(info);
            String phase = info == null ? null : info.getPhase();
            UwsStage stage = UwsStage.forPhase(phase);
            if ("COMPLETED".equals(phase)) {
                this.loadResultAct_.setEnabled(true);
                this.resumeAct_.setEnabled(false);
                this.phaseTimer_.stop();
            } else if (stage == UwsStage.UNSTARTED || stage == UwsStage.RUNNING) {
                this.resumeAct_.setEnabled(true);
                this.loadResultAct_.setEnabled(false);
            } else {
                this.loadResultAct_.setEnabled(false);
                this.resumeAct_.setEnabled(false);
            }
        }
    }

    private void setStatus(String msg) {
        this.mainBox_.removeAll();
        if (msg == null) {
            this.mainBox_.add((Component)this.jobPanel_, "Center");
        } else {
            Box errBox = Box.createHorizontalBox();
            errBox.add(Box.createHorizontalGlue());
            errBox.add(new JLabel(msg));
            errBox.add(Box.createHorizontalGlue());
            this.mainBox_.add((Component)errBox, "Center");
        }
        this.mainBox_.revalidate();
        this.mainBox_.repaint();
    }

    private void setJob(UwsJob job) {
        if (this.jobPanel_.getJob() != null) {
            this.phaseTimer_.stop();
        }
        this.jobPanel_.setJob(job);
        UwsJobInfo info = job == null ? null : job.getLastInfo();
        this.setJobState(job, info);
        if (this.jobPanel_.getJob() != null) {
            this.phaseTimer_.start();
        }
    }
}

