/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import uk.ac.starlink.registry.BasicCapability;
import uk.ac.starlink.registry.BasicRegistryClient;
import uk.ac.starlink.registry.BasicResource;
import uk.ac.starlink.registry.RegistryRequestFactory;
import uk.ac.starlink.registry.SoapClient;
import uk.ac.starlink.registry.SoapRequest;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryQuery;

public class Ri1RegistryQuery
implements RegistryQuery {
    private final BasicRegistryClient regClient_;
    private final String text_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    private static final String SEARCHABLE_REG_QUERY = "capability/@standardID = 'ivo://ivoa.net/std/Registry' AND capability/@xsi:type LIKE '%:Search' AND full LIKE 'true'";
    public static int RECORD_BUFFER_SIZE = 50;
    public static final ValueInfo REGISTRY_INFO = new DefaultValueInfo("Registry Location", URL.class, "URL of registry queried");
    public static final ValueInfo TEXT_INFO = new DefaultValueInfo("Registry Query", String.class, "Text of query made to the registry");
    public static final String AG_REG;
    public static final String AG_REG2;
    public static final String VAO_REG;
    public static final String EUROVO_REG;
    public static final String[] REGISTRIES;

    public Ri1RegistryQuery(SoapClient soapClient, String text) {
        this.text_ = text;
        this.regClient_ = new BasicRegistryClient(soapClient);
    }

    public Ri1RegistryQuery(String endpoint, String text) {
        this(new SoapClient(Ri1RegistryQuery.toUrl(endpoint)), text);
    }

    @Override
    public Iterator<RegResource> getQueryIterator() throws IOException {
        logger_.info(this.text_);
        final Iterator bIt = this.regClient_.getResourceIterator(this.getSoapRequest());
        return new Iterator<RegResource>(){

            @Override
            public boolean hasNext() {
                return bIt.hasNext();
            }

            @Override
            public RegResource next() {
                return new BasicRegResource((BasicResource)bIt.next());
            }

            @Override
            public void remove() {
                bIt.remove();
            }
        };
    }

    @Override
    public RegResource[] getQueryResources() throws IOException {
        logger_.info(this.text_);
        List bList = this.regClient_.getResourceList(this.getSoapRequest());
        RegResource[] resources = new RegResource[bList.size()];
        for (int i = 0; i < bList.size(); ++i) {
            resources[i] = new BasicRegResource((BasicResource)bList.get(i));
        }
        return resources;
    }

    @Override
    public String getText() {
        return this.text_;
    }

    @Override
    public URL getRegistry() {
        return this.regClient_.getEndpoint();
    }

    @Override
    public DescribedValue[] getMetadata() {
        return new DescribedValue[]{new DescribedValue(REGISTRY_INFO, this.getRegistry()), new DescribedValue(TEXT_INFO, this.getText())};
    }

    private SoapRequest getSoapRequest() throws IOException {
        return RegistryRequestFactory.adqlsSearch(this.text_);
    }

    public static String[] getSearchableRegistries(String regUrl) throws IOException {
        Ri1RegistryQuery regQuery = new Ri1RegistryQuery(regUrl, SEARCHABLE_REG_QUERY);
        TreeSet<String> acurlSet = new TreeSet<String>();
        Iterator<RegResource> it = regQuery.getQueryIterator();
        while (it.hasNext()) {
            RegResource res = it.next();
            RegCapabilityInterface[] caps = res.getCapabilities();
            for (int ic = 0; ic < caps.length; ++ic) {
                String acurl;
                RegCapabilityInterface cap = caps[ic];
                String xsiType = cap.getXsiType();
                if (xsiType == null || !xsiType.endsWith(":Search") || (acurl = cap.getAccessUrl()) == null) continue;
                acurlSet.add(acurl);
            }
        }
        return acurlSet.toArray(new String[0]);
    }

    static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Not a URL: " + url).initCause(e);
        }
    }

    public String toString() {
        return this.text_;
    }

    public static String getAdqlWhere(Capability cap) {
        StringBuffer abuf = new StringBuffer();
        int nterm = 0;
        if (abuf.length() > 0) {
            abuf.append(" OR ");
        }
        abuf.append("( capability/@standardID = '").append(cap.getStandardId()).append("' )");
        return ++nterm > 1 ? "( " + abuf.toString() + " )" : abuf.toString();
    }

    static {
        String[] stringArray = new String[4];
        AG_REG = "http://registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0";
        stringArray[0] = "http://registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0";
        AG_REG2 = "http://alt.registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0";
        stringArray[1] = "http://alt.registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0";
        VAO_REG = "http://vao.stsci.edu/directory/ristandardservice.asmx";
        stringArray[2] = "http://vao.stsci.edu/directory/ristandardservice.asmx";
        EUROVO_REG = "http://registry.euro-vo.org/services/RegistrySearch";
        stringArray[3] = "http://registry.euro-vo.org/services/RegistrySearch";
        REGISTRIES = stringArray;
    }

    private static class BasicRegCapability
    implements RegCapabilityInterface {
        private final String accessUrl_;
        private final String standardId_;
        private final String xsiType_;
        private final String description_;
        private final String version_;

        BasicRegCapability(BasicCapability bcap) {
            this.accessUrl_ = bcap.getAccessUrl();
            this.standardId_ = bcap.getStandardId();
            this.xsiType_ = bcap.getXsiType();
            this.description_ = bcap.getDescription();
            this.version_ = bcap.getVersion();
        }

        @Override
        public String getAccessUrl() {
            return this.accessUrl_;
        }

        @Override
        public String getStandardId() {
            return this.standardId_;
        }

        @Override
        public String getXsiType() {
            return this.xsiType_;
        }

        @Override
        public String getDescription() {
            return this.description_;
        }

        @Override
        public String getVersion() {
            return this.version_;
        }
    }

    private static class BasicRegResource
    implements RegResource {
        private final String title_;
        private final String shortName_;
        private final String identifier_;
        private final String publisher_;
        private final String contact_;
        private final String[] subjects_;
        private final String referenceUrl_;
        private final RegCapabilityInterface[] caps_;

        BasicRegResource(BasicResource bres) {
            this.title_ = bres.getTitle();
            this.shortName_ = bres.getShortName();
            this.identifier_ = bres.getIdentifier();
            this.publisher_ = bres.getPublisher();
            this.contact_ = bres.getContact();
            this.subjects_ = bres.getSubjects();
            this.referenceUrl_ = bres.getReferenceUrl();
            BasicCapability[] bcaps = bres.getCapabilities();
            this.caps_ = new BasicRegCapability[bcaps.length];
            for (int ic = 0; ic < bcaps.length; ++ic) {
                this.caps_[ic] = new BasicRegCapability(bcaps[ic]);
            }
        }

        @Override
        public String getTitle() {
            return this.title_;
        }

        @Override
        public String getShortName() {
            return this.shortName_;
        }

        @Override
        public String getIdentifier() {
            return this.identifier_;
        }

        @Override
        public String getPublisher() {
            return this.publisher_;
        }

        @Override
        public String getContact() {
            return this.contact_;
        }

        @Override
        public String[] getSubjects() {
            return this.subjects_;
        }

        @Override
        public String getReferenceUrl() {
            return this.referenceUrl_;
        }

        @Override
        public RegCapabilityInterface[] getCapabilities() {
            return this.caps_;
        }
    }
}

