/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.gui.AbstractTableLoadDialog;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryStarTable;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.Ri1RegistryQuery;
import uk.ac.starlink.vo.Ri1RegistryQueryPanel;

public class Ri1RegistryTableLoadDialog
extends AbstractTableLoadDialog {
    private Ri1RegistryQueryPanel rqPanel_;
    public static String[] defaultQueries_ = new String[]{Ri1RegistryQuery.getAdqlWhere(Capability.CONE), Ri1RegistryQuery.getAdqlWhere(Capability.SIA), Ri1RegistryQuery.getAdqlWhere(Capability.SSA), Ri1RegistryQuery.getAdqlWhere(Capability.TAP)};

    public Ri1RegistryTableLoadDialog() {
        super("RI1.0 Registry Query", "Imports a table describing the result of querying a registry using the RI1.0 interface; using RegTAP is usually a better idea.");
        this.setIcon(ResourceIcon.TLD_REGISTRY);
    }

    @Override
    protected Component createQueryComponent() {
        this.rqPanel_ = new Ri1RegistryQueryPanel();
        this.rqPanel_.setPresetQueries(defaultQueries_);
        return this.rqPanel_;
    }

    @Override
    public String getName() {
        return "Registry Query";
    }

    @Override
    public String getDescription() {
        return "Returns a table describing the resources in a registry for a given query";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public TableLoader createTableLoader() {
        try {
            final RegistryQuery query = this.rqPanel_.getRegistryQuery();
            return new TableLoader(){

                @Override
                public TableSequence loadTables(StarTableFactory factory) throws IOException {
                    return Tables.singleTableSequence(new RegistryStarTable(query));
                }

                @Override
                public String getLabel() {
                    return query.toString();
                }
            };
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

