/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.DalQuery;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.SkyDalTableLoadDialog;
import uk.ac.starlink.vo.SkyPositionEntry;

public class SiapTableLoadDialog
extends SkyDalTableLoadDialog {
    private final ContentCoding coding_ = ContentCoding.GZIP;
    private DoubleValueField raField_;
    private DoubleValueField decField_;
    private DoubleValueField sizeField_;
    private JComboBox formatSelector_;
    private static final ValueInfo SIZE_INFO = new DefaultValueInfo("Angular Size", Double.class, "Angular size of the search region in RA and Dec");

    public SiapTableLoadDialog() {
        super("Simple Image Access (SIA) Query", "SIA", "Get results of a Simple Image Access Protocol query", Capability.SIA, true, true);
        this.setIcon(ResourceIcon.TLD_SIA);
    }

    @Override
    protected Component createQueryComponent() {
        Component queryPanel = super.createQueryComponent();
        SkyPositionEntry skyEntry = this.getSkyEntry();
        this.raField_ = skyEntry.getRaDegreesField();
        this.decField_ = skyEntry.getDecDegreesField();
        this.sizeField_ = DoubleValueField.makeSizeDegreesField(SIZE_INFO);
        this.sizeField_.getEntryField().setText("0");
        skyEntry.addField(this.sizeField_);
        Box formatLine = Box.createHorizontalBox();
        this.formatSelector_ = new JComboBox<String>(SiapTableLoadDialog.getFormatOptions());
        this.formatSelector_.setEditable(true);
        this.formatSelector_.setSelectedIndex(0);
        formatLine.add(new JLabel("Image Format: "));
        formatLine.add(new ShrinkWrapper(this.formatSelector_));
        formatLine.add(Box.createHorizontalGlue());
        this.getControlBox().add(Box.createVerticalStrut(5));
        this.getControlBox().add(formatLine);
        return queryPanel;
    }

    @Override
    public TableLoader createTableLoader() {
        String serviceUrl = this.getServiceUrl();
        this.checkUrl(serviceUrl);
        double ra = this.raField_.getValue();
        double dec = this.decField_.getValue();
        double size = this.sizeField_.getValue();
        final DalQuery query = new DalQuery(serviceUrl, "SIA", ra, dec, size, this.coding_);
        Object format = this.formatSelector_.getSelectedItem();
        if (format != null && format.toString().trim().length() > 0) {
            query.addArgument("FORMAT", format.toString());
        }
        final ArrayList<DescribedValue> metadata = new ArrayList<DescribedValue>();
        metadata.addAll(Arrays.asList(this.raField_.getDescribedValue(), this.decField_.getDescribedValue(), this.sizeField_.getDescribedValue()));
        metadata.addAll(Arrays.asList(this.getResourceMetadata(serviceUrl)));
        final String summary = this.getQuerySummary(serviceUrl, size);
        return new TableLoader(){

            @Override
            public TableSequence loadTables(StarTableFactory factory) throws IOException {
                StarTable st = query.execute(factory);
                st.getParameters().addAll(metadata);
                return Tables.singleTableSequence(st);
            }

            @Override
            public String getLabel() {
                return summary;
            }
        };
    }

    public static String[] getFormatOptions() {
        return new String[]{"image/fits", "GRAPHIC", "ALL", ""};
    }
}

