/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.DalLoader;
import uk.ac.starlink.vo.DalTableLoadDialog;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryPanel;
import uk.ac.starlink.vo.SkyPositionEntry;

public abstract class SkyDalTableLoadDialog
extends DalTableLoadDialog
implements DalLoader {
    private final String protoName_;
    private SkyPositionEntry skyEntry_;

    protected SkyDalTableLoadDialog(String name, String protoName, String description, Capability capability, boolean showCapabilities, boolean autoQuery) {
        super(name, protoName, description, capability, showCapabilities, autoQuery);
        this.protoName_ = protoName;
    }

    @Override
    protected Component createQueryComponent() {
        final Component superPanel = super.createQueryComponent();
        JPanel queryPanel = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                superPanel.setEnabled(enabled);
                SkyDalTableLoadDialog.this.skyEntry_.setEnabled(enabled);
            }
        };
        queryPanel.add(superPanel, "Center");
        this.skyEntry_ = new SkyPositionEntry("J2000");
        this.skyEntry_.addActionListener(this.getSubmitAction());
        this.getControlBox().add(this.skyEntry_);
        return queryPanel;
    }

    public boolean acceptSkyPosition(double raDegrees, double decDegrees) {
        if (this.isComponentShowing()) {
            this.getSkyEntry().setPosition(raDegrees, decDegrees, false);
            return true;
        }
        return false;
    }

    public SkyPositionEntry getSkyEntry() {
        return this.skyEntry_;
    }

    public String getQuerySummary(String serviceUrl, double sizeDeg) {
        String objName = this.getSkyEntry().getResolveField().getText();
        RegistryPanel regPanel = this.getRegistryPanel();
        RegResource[] resources = regPanel.getSelectedResources();
        RegCapabilityInterface[] caps = regPanel.getSelectedCapabilities();
        String shortName = null;
        if (resources.length == 1 && caps.length == 1 && serviceUrl.equals(caps[0].getAccessUrl()) && (shortName = resources[0].getShortName()) != null) {
            shortName = shortName.replace('/', '_');
        }
        if (shortName == null || shortName.trim().length() == 0) {
            shortName = this.protoName_;
        }
        String size = sizeDeg > 0.0 ? (sizeDeg > 1.0 ? (int)sizeDeg + "d" : (sizeDeg * 60.0 >= 1.0 ? (int)(sizeDeg * 60.0) + "m" : (int)(sizeDeg * 60.0 * 60.0) + "s")) : null;
        StringBuffer sbuf = new StringBuffer();
        if (objName != null && objName.trim().length() > 0) {
            sbuf.append(objName).append('-');
        }
        sbuf.append(shortName);
        if (size != null) {
            sbuf.append('-');
            sbuf.append(size);
        }
        return sbuf.toString();
    }
}

