/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.ResolverException;
import uk.ac.starlink.vo.ResolverInfo;
import uk.ac.starlink.vo.ValueFieldPanel;

public class SkyPositionEntry
extends JPanel {
    private final Action resolveAction_;
    private final JTextField resolveField_;
    private final DoubleValueField raField_;
    private final DoubleValueField decField_;
    private final ValueFieldPanel qPanel_;
    private final List fieldList_;
    private final JComponent[] enablables_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public SkyPositionEntry(String coordSysLabel) {
        super(new BorderLayout());
        JLabel decSysLabel;
        JLabel raSysLabel;
        Box box = Box.createVerticalBox();
        this.add((Component)box, "Center");
        ArrayList<JLabel> enList = new ArrayList<JLabel>();
        Box resolveBox = Box.createHorizontalBox();
        this.resolveField_ = new JTextField(20);
        this.resolveAction_ = new ResolveAction();
        JLabel resolveLabel = new JLabel("Object Name: ");
        enList.add(resolveLabel);
        resolveBox.add(resolveLabel);
        resolveBox.add(this.resolveField_);
        resolveBox.add(Box.createHorizontalStrut(5));
        resolveBox.add(new JButton(this.resolveAction_));
        resolveBox.add(Box.createHorizontalGlue());
        this.add((Component)resolveBox, "North");
        this.raField_ = DoubleValueField.makeRADegreesField();
        this.decField_ = DoubleValueField.makeDecDegreesField();
        if (coordSysLabel == null || coordSysLabel.trim().length() == 0) {
            raSysLabel = null;
            decSysLabel = null;
        } else {
            String sysLabel = "(" + coordSysLabel + ")";
            raSysLabel = new JLabel(sysLabel);
            decSysLabel = new JLabel(sysLabel);
            enList.add(raSysLabel);
            enList.add(decSysLabel);
        }
        this.qPanel_ = new ValueFieldPanel();
        this.qPanel_.addField(this.raField_, raSysLabel);
        this.qPanel_.addField(this.decField_, decSysLabel);
        box.add(this.qPanel_);
        this.fieldList_ = new ArrayList();
        this.fieldList_.add(this.raField_);
        this.fieldList_.add(this.decField_);
        this.enablables_ = enList.toArray(new JComponent[0]);
    }

    public void addField(DoubleValueField field) {
        this.qPanel_.addField(field);
        this.fieldList_.add(field);
    }

    public DoubleValueField getRaDegreesField() {
        return this.raField_;
    }

    public DoubleValueField getDecDegreesField() {
        return this.decField_;
    }

    public JTextField getResolveField() {
        return this.resolveField_;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.resolveField_.setEnabled(enabled);
        this.resolveAction_.setEnabled(enabled);
        Iterator it = this.fieldList_.iterator();
        while (it.hasNext()) {
            ((DoubleValueField)it.next()).setEnabled(enabled);
        }
        for (int i = 0; i < this.enablables_.length; ++i) {
            this.enablables_[i].setEnabled(enabled);
        }
    }

    public void addActionListener(ActionListener listener) {
        Iterator it = this.fieldList_.iterator();
        while (it.hasNext()) {
            ((DoubleValueField)it.next()).getEntryField().addActionListener(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        Iterator it = this.fieldList_.iterator();
        while (it.hasNext()) {
            ((DoubleValueField)it.next()).getEntryField().removeActionListener(listener);
        }
    }

    public void addCaretListener(CaretListener listener) {
        Iterator it = this.fieldList_.iterator();
        while (it.hasNext()) {
            ((DoubleValueField)it.next()).getEntryField().addCaretListener(listener);
        }
    }

    public void removeCaretListener(CaretListener listener) {
        Iterator it = this.fieldList_.iterator();
        while (it.hasNext()) {
            ((DoubleValueField)it.next()).getEntryField().removeCaretListener(listener);
        }
    }

    private void setResolvedObject(ResolverInfo info) {
        this.setDegrees(this.raField_, info.getRaDegrees());
        this.setDegrees(this.decField_, info.getDecDegrees());
    }

    public void setPosition(double raDegrees, double decDegrees, boolean clearResolver) {
        this.setDegrees(this.raField_, raDegrees);
        this.setDegrees(this.decField_, decDegrees);
        if (clearResolver) {
            this.resolveField_.setText(null);
        }
    }

    private void setDegrees(DoubleValueField field, double degValue) {
        JComboBox convSel = field.getConverterSelector();
        for (int i = 0; i < convSel.getItemCount(); ++i) {
            Object item = convSel.getItemAt(i);
            if (!"degrees".equals(item.toString())) continue;
            convSel.setSelectedItem(item);
            field.getEntryField().setText(Double.toString(degValue));
            return;
        }
        logger_.warning("Oops - no degrees option");
    }

    private class ResolveAction
    extends AbstractAction {
        ResolveAction() {
            super("Resolve");
            SkyPositionEntry.this.resolveField_.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final String name = SkyPositionEntry.this.resolveField_.getText();
            if (name != null && name.trim().length() == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.setEnabled(false);
            new Thread("Name Resolver: " + name){

                @Override
                public void run() {
                    ResolverInfo info = null;
                    ResolverException error = null;
                    try {
                        info = ResolverInfo.resolve(name);
                    }
                    catch (ResolverException e) {
                        error = e;
                    }
                    final ResolverInfo info1 = info;
                    final ResolverException error1 = error;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (info1 != null) {
                                SkyPositionEntry.this.setResolvedObject(info1);
                            } else {
                                ErrorDialog.showError(SkyPositionEntry.this, "Name Resolution Error", error1);
                            }
                            ResolveAction.this.setEnabled(true);
                        }
                    });
                }
            }.start();
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            SkyPositionEntry.this.resolveField_.setEnabled(enabled);
        }
    }
}

