/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.util.gui.ArrayTableColumn;
import uk.ac.starlink.util.gui.ArrayTableModel;
import uk.ac.starlink.util.gui.ArrayTableSorter;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.vo.AndButton;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.HasContentIcon;
import uk.ac.starlink.vo.HintPanel;
import uk.ac.starlink.vo.MaskTreeModel;
import uk.ac.starlink.vo.MetaPanel;
import uk.ac.starlink.vo.RegRole;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.ResultHandler;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapLanguageFeature;
import uk.ac.starlink.vo.TapMetaReader;
import uk.ac.starlink.vo.TapMetaTreeModel;
import uk.ac.starlink.vo.TapServiceKit;
import uk.ac.starlink.vo.UrlHandler;

public class TableSetPanel
extends JPanel {
    private final JTree tTree_;
    private final CountTableTreeCellRenderer renderer_ = new CountTableTreeCellRenderer();
    private final JTextField keywordField_;
    private final AndButton keyAndButt_;
    private final JCheckBox useNameButt_;
    private final JCheckBox useDescripButt_;
    private final TreeSelectionModel selectionModel_;
    private final JTable colTable_;
    private final JTable foreignTable_;
    private final ArrayTableModel colTableModel_;
    private final ArrayTableModel foreignTableModel_;
    private final ResourceMetaPanel servicePanel_;
    private final SchemaMetaPanel schemaPanel_;
    private final TableMetaPanel tablePanel_;
    private final HintPanel hintPanel_;
    private final JTabbedPane detailTabber_;
    private final int itabService_;
    private final int itabSchema_;
    private final int itabTable_;
    private final int itabCol_;
    private final int itabForeign_;
    private final int itabHint_;
    private final JComponent treeContainer_;
    private TapServiceKit serviceKit_;
    private SchemaMeta[] schemas_;
    private ColumnMeta[] selectedColumns_;
    private static final ArrayTableColumn[] colMetaColumns_ = TableSetPanel.createColumnMetaColumns();
    public static final String TABLE_SELECTION_PROPERTY = "selectedTable";
    public static final String COLUMNS_SELECTION_PROPERTY = "selectedColumns";
    public static final String SCHEMAS_PROPERTY = "schemas";
    private static final int TREE_EXPAND_THRESHOLD = 100;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TableSetPanel(UrlHandler urlHandler) {
        super(new BorderLayout());
        this.tTree_ = new JTree();
        this.tTree_.setRootVisible(true);
        this.tTree_.setShowsRootHandles(false);
        this.tTree_.setExpandsSelectedPaths(true);
        this.tTree_.setCellRenderer(this.renderer_);
        this.selectionModel_ = this.tTree_.getSelectionModel();
        this.selectionModel_.setSelectionMode(1);
        this.selectionModel_.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TableSetPanel.this.updateForTableSelection();
                TableMeta oldSel = TapMetaTreeModel.getTable(evt.getOldLeadSelectionPath());
                TableMeta newSel = TapMetaTreeModel.getTable(evt.getNewLeadSelectionPath());
                assert (newSel == TableSetPanel.this.getSelectedTable());
                TableSetPanel.this.firePropertyChange(TableSetPanel.TABLE_SELECTION_PROPERTY, oldSel, newSel);
            }
        });
        this.keywordField_ = new JTextField();
        this.keywordField_.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                TableSetPanel.this.updateTree(false);
            }
        });
        JLabel keywordLabel = new JLabel(" Find: ");
        String keywordTip = "Enter one or more search terms to restrict the content of the metadata display tree";
        this.keywordField_.setToolTipText(keywordTip);
        keywordLabel.setToolTipText(keywordTip);
        this.keyAndButt_ = new AndButton(false);
        this.keyAndButt_.setMargin(new Insets(0, 0, 0, 0));
        this.keyAndButt_.setToolTipText("Choose to match either all (And) or any (Or) of the entered search terms against table metadata");
        this.useNameButt_ = new JCheckBox("Name", true);
        this.useNameButt_.setToolTipText("Select to match search terms against table/schema names");
        this.useDescripButt_ = new JCheckBox("Descrip", false);
        this.useDescripButt_.setToolTipText("Select to match search terms against table/schema descriptions");
        ActionListener findParamListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!TableSetPanel.this.useNameButt_.isSelected() && !TableSetPanel.this.useDescripButt_.isSelected()) {
                    (evt.getSource() == TableSetPanel.this.useNameButt_ ? TableSetPanel.this.useDescripButt_ : TableSetPanel.this.useNameButt_).setSelected(true);
                }
                TableSetPanel.this.updateTree(false);
            }
        };
        this.keyAndButt_.addAndListener(findParamListener);
        this.useNameButt_.addActionListener(findParamListener);
        this.useDescripButt_.addActionListener(findParamListener);
        this.colTableModel_ = new ArrayTableModel(colMetaColumns_, new ColumnMeta[0]);
        this.colTable_ = new JTable(this.colTableModel_);
        this.colTable_.setColumnSelectionAllowed(false);
        new ArrayTableSorter(this.colTableModel_).install(this.colTable_.getTableHeader());
        ListSelectionModel colSelModel = this.colTable_.getSelectionModel();
        colSelModel.setSelectionMode(2);
        colSelModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TableSetPanel.this.columnSelectionChanged();
            }
        });
        this.selectedColumns_ = new ColumnMeta[0];
        this.foreignTableModel_ = new ArrayTableModel(TableSetPanel.createForeignMetaColumns(), new ColumnMeta[0]);
        this.foreignTable_ = new JTable(this.foreignTableModel_);
        this.foreignTable_.setColumnSelectionAllowed(false);
        this.foreignTable_.setRowSelectionAllowed(false);
        new ArrayTableSorter(this.foreignTableModel_).install(this.foreignTable_.getTableHeader());
        this.tablePanel_ = new TableMetaPanel();
        this.schemaPanel_ = new SchemaMetaPanel();
        this.servicePanel_ = new ResourceMetaPanel(urlHandler);
        this.hintPanel_ = new HintPanel(urlHandler);
        this.detailTabber_ = new JTabbedPane();
        int itab = 0;
        this.detailTabber_.addTab("Service", TableSetPanel.metaScroller(this.servicePanel_));
        this.itabService_ = itab++;
        this.detailTabber_.addTab("Schema", TableSetPanel.metaScroller(this.schemaPanel_));
        this.itabSchema_ = itab++;
        this.detailTabber_.addTab("Table", TableSetPanel.metaScroller(this.tablePanel_));
        this.itabTable_ = itab++;
        this.detailTabber_.addTab("Columns", new JScrollPane(this.colTable_));
        this.itabCol_ = itab++;
        this.detailTabber_.addTab("FKeys", new JScrollPane(this.foreignTable_));
        this.itabForeign_ = itab++;
        this.detailTabber_.addTab("Hints", new JScrollPane(this.hintPanel_));
        this.itabHint_ = itab++;
        this.detailTabber_.setSelectedIndex(this.itabSchema_);
        Box findParamLine = Box.createHorizontalBox();
        JPanel treePanel = new JPanel(new BorderLayout());
        this.treeContainer_ = new JPanel(new BorderLayout());
        this.treeContainer_.add((Component)new JScrollPane(this.tTree_), "Center");
        treePanel.add((Component)this.treeContainer_, "Center");
        Box keywordLine = Box.createHorizontalBox();
        keywordLine.add(keywordLabel);
        keywordLine.add(this.keywordField_);
        findParamLine.add(this.useNameButt_);
        findParamLine.add(this.useDescripButt_);
        findParamLine.add(Box.createHorizontalGlue());
        findParamLine.add(this.keyAndButt_);
        Box findBox = Box.createVerticalBox();
        findBox.add(keywordLine);
        findBox.add(findParamLine);
        findBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        treePanel.add((Component)findBox, "North");
        JSplitPane metaSplitter = new JSplitPane(1);
        metaSplitter.setBorder(BorderFactory.createEmptyBorder());
        JPanel detailPanel = new JPanel(new BorderLayout());
        detailPanel.add((Component)this.detailTabber_, "Center");
        detailPanel.add((Component)TableSetPanel.createHorizontalStrut(500), "South");
        treePanel.add((Component)TableSetPanel.createHorizontalStrut(200), "South");
        metaSplitter.setLeftComponent(treePanel);
        metaSplitter.setRightComponent(detailPanel);
        this.add((Component)metaSplitter, "Center");
        this.setSchemas(null);
    }

    public void setServiceKit(final TapServiceKit serviceKit) {
        if (this.serviceKit_ != null) {
            this.serviceKit_.shutdown();
        }
        this.serviceKit_ = serviceKit;
        this.setSchemas(null);
        this.setResourceInfo(null);
        if (serviceKit == null) {
            this.servicePanel_.setId(null, null);
        } else {
            final String ivoid = serviceKit.getIvoid();
            this.servicePanel_.setId(serviceKit.getEndpointSet().getIdentity(), ivoid);
            serviceKit.acquireResource(new ResultHandler<Map<String, String>>(){

                @Override
                public boolean isActive() {
                    return serviceKit == TableSetPanel.this.serviceKit_;
                }

                @Override
                public void showWaiting() {
                    logger_.info("Reading resource record for " + ivoid);
                }

                @Override
                public void showResult(Map<String, String> resourceMap) {
                    TableSetPanel.this.setResourceInfo(resourceMap);
                }

                @Override
                public void showError(IOException error) {
                    TableSetPanel.this.setResourceInfo(null);
                }
            });
            serviceKit.acquireRoles(new ResultHandler<RegRole[]>(){

                @Override
                public boolean isActive() {
                    return serviceKit == TableSetPanel.this.serviceKit_;
                }

                @Override
                public void showWaiting() {
                    logger_.info("Reading res_role records for " + ivoid);
                }

                @Override
                public void showResult(RegRole[] roles) {
                    TableSetPanel.this.setResourceRoles(roles);
                }

                @Override
                public void showError(IOException error) {
                    TableSetPanel.this.setResourceRoles(null);
                }
            });
            serviceKit.acquireSchemas(new ResultHandler<SchemaMeta[]>(){
                private JProgressBar progBar;

                @Override
                public boolean isActive() {
                    return serviceKit == TableSetPanel.this.serviceKit_;
                }

                @Override
                public void showWaiting() {
                    logger_.info("Reading up-front table metadata");
                    this.progBar = TableSetPanel.this.showFetchProgressBar();
                }

                @Override
                public void showResult(SchemaMeta[] result) {
                    this.stopProgress();
                    logger_.info("Read " + this.getMetaDescrip());
                    TableSetPanel.this.setSchemas(result);
                }

                @Override
                public void showError(IOException error) {
                    this.stopProgress();
                    logger_.log(Level.WARNING, "Error reading " + this.getMetaDescrip(), error);
                    TableSetPanel.this.showFetchFailure(error, serviceKit.getMetaReader());
                }

                private void stopProgress() {
                    if (this.progBar != null) {
                        this.progBar.setIndeterminate(false);
                        this.progBar.setValue(0);
                        this.progBar = null;
                    }
                }

                private String getMetaDescrip() {
                    TapMetaReader metaRdr = serviceKit.getMetaReader();
                    StringBuffer sbuf = new StringBuffer().append("up-front table metadata");
                    if (metaRdr != null) {
                        sbuf.append(" from ").append(metaRdr.getSource()).append(" using ").append(metaRdr.getMeans());
                    }
                    return sbuf.toString();
                }
            });
        }
    }

    public TapServiceKit getServiceKit() {
        return this.serviceKit_;
    }

    public SchemaMeta[] getSchemas() {
        return this.schemas_;
    }

    private void setSchemas(SchemaMeta[] schemas) {
        String countTxt;
        if (schemas != null) {
            this.checkSchemasPopulated(schemas);
        }
        SchemaMeta[] oldSchemas = this.schemas_;
        this.schemas_ = schemas;
        TapMetaTreeModel treeModel = new TapMetaTreeModel(this.schemas_ == null ? new SchemaMeta[]{} : this.schemas_);
        this.tTree_.setModel(new MaskTreeModel(treeModel, true));
        this.keywordField_.setText(null);
        this.selectionModel_.setSelectionPath(null);
        this.updateTree(true);
        if (schemas == null) {
            countTxt = "no metadata";
        } else {
            int nTable = 0;
            for (SchemaMeta schema : schemas) {
                nTable += schema.getTables().length;
            }
            countTxt = schemas.length + " schemas, " + nTable + " tables";
        }
        this.servicePanel_.setSize(countTxt);
        this.replaceTreeComponent(null);
        this.updateForTableSelection();
        this.firePropertyChange(SCHEMAS_PROPERTY, oldSchemas, schemas);
        this.repaint();
    }

    public void setCapability(TapCapability capability) {
        this.servicePanel_.setCapability(capability);
    }

    public void setHasExamples(boolean hasExamples) {
        URL exampleUrl = hasExamples && this.serviceKit_ != null ? this.serviceKit_.getEndpointSet().getExamplesEndpoint() : null;
        String exurl = exampleUrl == null ? null : exampleUrl.toString();
        this.servicePanel_.setExamplesUrl(exurl);
        this.hintPanel_.setExamplesUrl(exurl);
    }

    private void setResourceInfo(Map<String, String> map) {
        String rootName = null;
        if (map != null) {
            if (rootName == null || rootName.trim().length() == 0) {
                rootName = map.get("short_name");
            }
            if (rootName == null || rootName.trim().length() == 0) {
                rootName = map.get("res_title");
            }
        }
        this.renderer_.rootName_ = rootName;
        this.tTree_.repaint();
        this.servicePanel_.setResourceInfo(map == null ? new HashMap() : map);
        this.detailTabber_.setIconAt(this.itabService_, this.activeIcon(map != null));
    }

    private void setResourceRoles(RegRole[] roles) {
        this.servicePanel_.setResourceRoles(roles == null ? new RegRole[]{} : roles);
    }

    private JProgressBar showFetchProgressBar() {
        JProgressBar progBar = new JProgressBar();
        progBar.setIndeterminate(true);
        Box progLine = Box.createHorizontalBox();
        progLine.add(Box.createHorizontalGlue());
        progLine.add(progBar);
        progLine.add(Box.createHorizontalGlue());
        Box workBox = Box.createVerticalBox();
        workBox.add(Box.createVerticalGlue());
        workBox.add(this.createLabelLine("Fetching table metadata"));
        workBox.add(Box.createVerticalStrut(5));
        workBox.add(progLine);
        workBox.add(Box.createVerticalGlue());
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBackground(UIManager.getColor("Tree.background"));
        workPanel.setBorder(BorderFactory.createEtchedBorder());
        workPanel.add((Component)workBox, "Center");
        this.replaceTreeComponent(workPanel);
        return progBar;
    }

    private void showFetchFailure(Throwable error, TapMetaReader metaReader) {
        ArrayList<String> msgList = new ArrayList<String>();
        msgList.add("Error reading TAP service table metadata");
        if (metaReader != null) {
            msgList.add("Method: " + metaReader.getMeans());
            msgList.add("Source: " + metaReader.getSource());
        }
        String[] msgLines = msgList.toArray(new String[0]);
        ErrorDialog.showError((Component)this, "Table Metadata Error", error, msgLines);
        Box errLine = Box.createHorizontalBox();
        errLine.setAlignmentX(0.0f);
        errLine.add(new JLabel("Error: "));
        String errtxt = error.getMessage();
        if (errtxt == null || errtxt.trim().length() == 0) {
            errtxt = error.toString();
        }
        JTextField errField = new JTextField(errtxt);
        errField.setEditable(false);
        errField.setBorder(BorderFactory.createEmptyBorder());
        errLine.add(new ShrinkWrapper(errField));
        Box linesBox = Box.createVerticalBox();
        linesBox.add(Box.createVerticalGlue());
        linesBox.add(this.createLabelLine("No table metadata"));
        linesBox.add(Box.createVerticalStrut(15));
        for (String line : msgLines) {
            linesBox.add(this.createLabelLine(line));
        }
        linesBox.add(Box.createVerticalStrut(15));
        linesBox.add(errLine);
        linesBox.add(Box.createVerticalGlue());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)linesBox, "Center");
        JScrollPane scroller = new JScrollPane(panel);
        this.replaceTreeComponent(scroller);
    }

    private JComponent createLabelLine(String text) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.0f);
        return label;
    }

    private void replaceTreeComponent(JComponent content) {
        this.treeContainer_.removeAll();
        this.treeContainer_.add((Component)(content != null ? content : new JScrollPane(this.tTree_)), "Center");
        this.treeContainer_.revalidate();
        this.treeContainer_.repaint();
    }

    private void checkSchemasPopulated(SchemaMeta[] schemas) {
        for (SchemaMeta smeta : schemas) {
            if (smeta.getTables() != null) continue;
            logger_.warning("Schema metadata object(s) not populated with tables, probably will cause trouble; use a different TapMetaReader?");
            return;
        }
    }

    public TableMeta getSelectedTable() {
        return TapMetaTreeModel.getTable(this.selectionModel_.getSelectionPath());
    }

    public ColumnMeta[] getSelectedColumns() {
        return this.selectedColumns_;
    }

    private void updateForTableSelection() {
        TreePath path = this.selectionModel_.getSelectionPath();
        final TableMeta table = TapMetaTreeModel.getTable(path);
        SchemaMeta schema = TapMetaTreeModel.getSchema(path);
        if (table == null || !this.serviceKit_.onColumns(table, new Runnable(){

            @Override
            public void run() {
                if (table == TableSetPanel.this.getSelectedTable()) {
                    ColumnMeta[] cols = table.getColumns();
                    TableSetPanel.this.displayColumns(table, cols);
                    TableSetPanel.this.tablePanel_.setColumns(cols);
                }
            }
        })) {
            this.displayColumns(table, new ColumnMeta[0]);
        }
        if (table == null || !this.serviceKit_.onForeignKeys(table, new Runnable(){

            @Override
            public void run() {
                if (table == TableSetPanel.this.getSelectedTable()) {
                    ForeignMeta[] fkeys = table.getForeignKeys();
                    TableSetPanel.this.displayForeignKeys(table, fkeys);
                    TableSetPanel.this.tablePanel_.setForeignKeys(fkeys);
                }
            }
        })) {
            this.displayForeignKeys(table, new ForeignMeta[0]);
        }
        this.schemaPanel_.setSchema(schema);
        this.detailTabber_.setIconAt(this.itabSchema_, this.activeIcon(schema != null));
        this.tablePanel_.setTable(table);
        this.detailTabber_.setIconAt(this.itabTable_, this.activeIcon(table != null));
    }

    private void columnSelectionChanged() {
        Object[] oldCols = this.selectedColumns_;
        HashSet<ColumnMeta> curSet = new HashSet<ColumnMeta>();
        ListSelectionModel selModel = this.colTable_.getSelectionModel();
        if (!selModel.isSelectionEmpty()) {
            int imin = selModel.getMinSelectionIndex();
            int imax = selModel.getMaxSelectionIndex();
            for (int i = imin; i <= imax; ++i) {
                if (!selModel.isSelectedIndex(i)) continue;
                curSet.add((ColumnMeta)this.colTableModel_.getItems()[i]);
            }
        }
        ArrayList<ColumnMeta> newList = new ArrayList<ColumnMeta>();
        for (ColumnMeta columnMeta : oldCols) {
            ColumnMeta oldCol = TableSetPanel.getNamedEntry(curSet, columnMeta.getName());
            if (oldCol == null) continue;
            newList.add(oldCol);
        }
        for (ColumnMeta col : curSet) {
            if (TableSetPanel.getNamedEntry(newList, col.getName()) != null) continue;
            newList.add(col);
        }
        assert (new HashSet(newList).equals(curSet));
        this.selectedColumns_ = newList.toArray(new ColumnMeta[0]);
        if (!Arrays.equals(this.selectedColumns_, oldCols)) {
            this.firePropertyChange(COLUMNS_SELECTION_PROPERTY, oldCols, this.selectedColumns_);
        }
    }

    private void displayColumns(TableMeta table, ColumnMeta[] cols) {
        String[] extras;
        assert (table == this.getSelectedTable());
        if (cols != null && cols.length > 0) {
            LinkedHashMap extrasMap = new LinkedHashMap();
            for (ColumnMeta col : cols) {
                for (Map.Entry<String, Object> entry : col.getExtras().entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (!extrasMap.containsKey(key)) {
                        extrasMap.put(key, new ArrayList());
                    }
                    ((List)extrasMap.get(key)).add(value);
                }
            }
            extras = extrasMap.keySet().toArray(new String[0]);
            ArrayList<ArrayTableColumn> colList = new ArrayList<ArrayTableColumn>();
            colList.addAll(Arrays.asList(colMetaColumns_));
            for (Map.Entry entry : extrasMap.entrySet()) {
                colList.add(ExtraColumn.createInstance((String)entry.getKey(), (List)entry.getValue()));
            }
            if (!new HashSet<ArrayTableColumn>(Arrays.asList(this.colTableModel_.getColumns())).equals(new HashSet(colList))) {
                this.colTableModel_.setColumns(colList.toArray(new ArrayTableColumn[0]));
            }
        } else {
            extras = new String[]{};
        }
        this.tablePanel_.setColumnExtras(extras);
        this.colTableModel_.setItems(cols);
        this.detailTabber_.setIconAt(this.itabCol_, this.activeIcon(cols != null && cols.length > 0));
        if (table != null) {
            this.configureColumnWidths(this.colTable_);
        }
        this.columnSelectionChanged();
    }

    private void displayForeignKeys(TableMeta table, ForeignMeta[] fkeys) {
        assert (table == this.getSelectedTable());
        this.foreignTableModel_.setItems(fkeys);
        this.detailTabber_.setIconAt(this.itabForeign_, this.activeIcon(fkeys != null && fkeys.length > 0));
        if (table != null) {
            this.configureColumnWidths(this.foreignTable_);
        }
    }

    private void configureColumnWidths(final JTable jtable) {
        Runnable configer = new Runnable(){

            @Override
            public void run() {
                StarJTable.configureColumnWidths(jtable, 360, 9999);
            }
        };
        if (this.detailTabber_.getSize().width > 0) {
            configer.run();
        } else {
            SwingUtilities.invokeLater(configer);
        }
    }

    private void updateTree(boolean dataChanged) {
        TreePath[] newExpanded;
        WordMatchMask mask;
        TreeModel treeModel = this.tTree_.getModel();
        if (!(treeModel instanceof MaskTreeModel)) {
            return;
        }
        MaskTreeModel mModel = (MaskTreeModel)treeModel;
        String text = this.keywordField_.getText();
        if (text == null || text.trim().length() == 0) {
            mask = null;
        } else {
            String[] searchTerms = text.split("\\s+");
            assert (searchTerms.length > 0);
            boolean isAnd = this.keyAndButt_.isAnd();
            boolean useName = this.useNameButt_.isSelected();
            boolean useDescrip = this.useDescripButt_.isSelected();
            NodeStringer stringer = NodeStringer.createInstance(useName, useDescrip);
            mask = new WordMatchMask(searchTerms, stringer, isAnd);
        }
        Object root = mModel.getRoot();
        TreePath[] selections = this.tTree_.getSelectionPaths();
        ArrayList<TreePath> expandedList = new ArrayList<TreePath>();
        Enumeration<TreePath> tpEn = this.tTree_.getExpandedDescendants(new TreePath(root));
        while (tpEn.hasMoreElements()) {
            expandedList.add(tpEn.nextElement());
        }
        TreePath[] oldExpanded = expandedList.toArray(new TreePath[0]);
        int oldCount = mModel.getNodeCount();
        mModel.setMask(mask);
        int newCount = mModel.getNodeCount();
        int ne = 100;
        if ((dataChanged || oldCount > ne) && newCount < ne) {
            int nc = mModel.getChildCount(root);
            newExpanded = new TreePath[nc];
            for (int ic = 0; ic < nc; ++ic) {
                Object child = mModel.getChild(root, ic);
                newExpanded[ic] = new TreePath(new Object[]{root, child});
            }
        } else {
            newExpanded = dataChanged || oldCount < ne && newCount > ne ? new TreePath[]{} : oldExpanded;
        }
        for (TreePath expTp : newExpanded) {
            this.tTree_.expandPath(expTp);
        }
        if (mask != null && selections != null) {
            selections = TableSetPanel.sanitiseSelections(selections, mModel);
        }
        if (selections == null || selections.length == 0) {
            TreePath[] treePathArray;
            TreePath tp;
            TreePath tp0 = this.tTree_.getPathForRow(0);
            TreePath tp1 = this.tTree_.getPathForRow(1);
            TreePath treePath = tp = tp1 != null && tp0 != null && mModel.isLeaf(tp1.getLastPathComponent()) && !mModel.isLeaf(tp0.getLastPathComponent()) ? tp1 : tp0;
            if (tp != null) {
                TreePath[] treePathArray2 = new TreePath[1];
                treePathArray = treePathArray2;
                treePathArray2[0] = tp;
            } else {
                treePathArray = new TreePath[]{};
            }
            selections = treePathArray;
        }
        this.tTree_.setSelectionPaths(selections);
    }

    private static ColumnMeta getNamedEntry(Collection<ColumnMeta> list, String name) {
        if (name != null) {
            for (ColumnMeta c : list) {
                if (!name.equals(c.getName())) continue;
                return c;
            }
        }
        return null;
    }

    private static TreePath[] sanitiseSelections(TreePath[] selections, TreeModel model) {
        ArrayList<TreePath> okPaths = new ArrayList<TreePath>();
        Object root = model.getRoot();
        for (TreePath path : selections) {
            TreePath okPath;
            if (path.getPathComponent(0) != root) {
                assert (false);
                continue;
            }
            int nel = path.getPathCount();
            ArrayList<Object> els = new ArrayList<Object>(nel);
            els.add(root);
            for (int i = 1; i < nel; ++i) {
                Object pathEl = path.getPathComponent(i);
                if (model.getIndexOfChild(els.get(i - 1), pathEl) < 0) break;
                els.add(pathEl);
            }
            if ((okPath = new TreePath(els.toArray(new Object[0]))).getPathCount() <= 1 || okPaths.contains(okPath)) continue;
            okPaths.add(okPath);
        }
        return okPaths.toArray(new TreePath[0]);
    }

    private Icon activeIcon(boolean isActive) {
        return HasContentIcon.getIcon(isActive);
    }

    private static ColumnMeta getCol(Object item) {
        return (ColumnMeta)item;
    }

    private static ForeignMeta getForeign(Object item) {
        return (ForeignMeta)item;
    }

    private static String arrayLength(Object[] array) {
        return array == null ? null : Integer.toString(array.length);
    }

    private static ArrayTableColumn[] createColumnMetaColumns() {
        return new ArrayTableColumn[]{new ArrayTableColumn("Name", String.class){

            @Override
            public Object getValue(Object item) {
                return TableSetPanel.getCol(item).getName();
            }
        }, new ArrayTableColumn("DataType", String.class){

            @Override
            public Object getValue(Object item) {
                return TableSetPanel.getCol(item).getDataType();
            }
        }, new ArrayTableColumn("Indexed", Boolean.class){

            @Override
            public Object getValue(Object item) {
                return Arrays.asList(TableSetPanel.getCol(item).getFlags()).indexOf("indexed") >= 0;
            }
        }, new ArrayTableColumn("Unit", String.class){

            @Override
            public Object getValue(Object item) {
                return TableSetPanel.getCol(item).getUnit();
            }
        }, new ArrayTableColumn("Description", String.class){

            @Override
            public Object getValue(Object item) {
                return TableSetPanel.getCol(item).getDescription();
            }
        }, new ArrayTableColumn("UCD", String.class){

            @Override
            public Object getValue(Object item) {
                return TableSetPanel.getCol(item).getUcd();
            }
        }, new ArrayTableColumn("Utype", String.class){

            @Override
            public Object getValue(Object item) {
                return TableSetPanel.getCol(item).getUtype();
            }
        }, new ArrayTableColumn("Flags", String.class){

            @Override
            public Object getValue(Object item) {
                String[] flags = TableSetPanel.getCol(item).getFlags();
                if (flags != null && flags.length > 0) {
                    StringBuffer sbuf = new StringBuffer();
                    for (int i = 0; i < flags.length; ++i) {
                        if (i > 0) {
                            sbuf.append(' ');
                        }
                        sbuf.append(flags[i]);
                    }
                    return sbuf.toString();
                }
                return null;
            }
        }};
    }

    private static ArrayTableColumn[] createForeignMetaColumns() {
        return new ArrayTableColumn[]{new ArrayTableColumn("Target Table", String.class){

            @Override
            public Object getValue(Object item) {
                return TableSetPanel.getForeign(item).getTargetTable();
            }
        }, new ArrayTableColumn("Links", String.class){

            @Override
            public Object getValue(Object item) {
                ForeignMeta.Link[] links = TableSetPanel.getForeign(item).getLinks();
                StringBuffer sbuf = new StringBuffer();
                for (int i = 0; i < links.length; ++i) {
                    ForeignMeta.Link link = links[i];
                    if (i > 0) {
                        sbuf.append("; ");
                    }
                    sbuf.append(link.getFrom()).append("->").append(link.getTarget());
                }
                return sbuf.toString();
            }
        }, new ArrayTableColumn("Description", String.class){

            @Override
            public Object getValue(Object item) {
                return TableSetPanel.getForeign(item).getDescription();
            }
        }, new ArrayTableColumn("Utype", String.class){

            @Override
            public Object getValue(Object item) {
                return TableSetPanel.getForeign(item).getUtype();
            }
        }};
    }

    private static JScrollPane metaScroller(MetaPanel panel) {
        return new JScrollPane(panel, 20, 31);
    }

    private static JComponent createHorizontalStrut(int width) {
        JPanel c = new JPanel();
        c.setPreferredSize(new Dimension(width, 0));
        return c;
    }

    private static class ResourceMetaPanel
    extends MetaPanel {
        private final JTextComponent ivoidField_;
        private final JTextComponent servurlField_;
        private final JTextComponent nameField_ = this.addLineField("Short Name");
        private final JTextComponent titleField_ = this.addLineField("Title");
        private final JTextComponent refurlField_;
        private final JTextComponent examplesurlField_;
        private final JTextComponent sizeField_;
        private final JTextComponent publisherField_;
        private final JTextComponent creatorField_;
        private final JTextComponent contactField_;
        private final JTextComponent descripField_;
        private final JTextComponent dmField_;
        private final JTextComponent geoField_;
        private final JTextComponent udfField_;

        ResourceMetaPanel(UrlHandler urlHandler) {
            this.ivoidField_ = this.addLineField("IVO ID");
            this.servurlField_ = this.addLineField("Service URL");
            this.refurlField_ = this.addUrlField("Reference URL", urlHandler);
            this.examplesurlField_ = this.addUrlField("Examples URL", urlHandler);
            this.sizeField_ = this.addLineField("Size");
            this.publisherField_ = this.addMultiLineField("Publisher");
            this.creatorField_ = this.addMultiLineField("Creator");
            this.contactField_ = this.addMultiLineField("Contact");
            this.descripField_ = this.addMultiLineField("Description");
            this.dmField_ = this.addMultiLineField("Data Models");
            this.geoField_ = this.addMultiLineField("Geometry Functions");
            this.udfField_ = this.addHtmlField("User-Defined Functions");
        }

        public void setId(String serviceLabel, String ivoid) {
            this.setFieldText(this.servurlField_, serviceLabel);
            this.setFieldText(this.ivoidField_, ivoid);
        }

        public void setSize(String sizeTxt) {
            this.setFieldText(this.sizeField_, sizeTxt);
        }

        public void setResourceInfo(Map<String, String> info) {
            this.setFieldText(this.nameField_, info.remove("short_name"));
            this.setFieldText(this.titleField_, info.remove("res_title"));
            this.setFieldText(this.refurlField_, info.remove("reference_url"));
            this.setFieldText(this.descripField_, info.remove("res_description"));
        }

        public void setResourceRoles(RegRole[] roles) {
            this.setFieldText(this.publisherField_, ResourceMetaPanel.getRoleText(roles, "publisher"));
            this.setFieldText(this.creatorField_, ResourceMetaPanel.getRoleText(roles, "creator"));
            this.setFieldText(this.contactField_, ResourceMetaPanel.getRoleText(roles, "contact"));
            URL logoUrl = ResourceMetaPanel.getLogoUrl(roles);
            this.setLogo(logoUrl == null ? null : new ImageIcon(logoUrl));
        }

        public void setExamplesUrl(String examplesUrl) {
            this.setFieldText(this.examplesurlField_, examplesUrl);
        }

        public void setCapability(TapCapability tcap) {
            this.setFieldText(this.dmField_, ResourceMetaPanel.getDataModelText(tcap));
            this.setFieldText(this.geoField_, ResourceMetaPanel.getGeoFuncText(tcap));
            this.setFieldText(this.udfField_, ResourceMetaPanel.getUdfHtml(tcap));
        }

        private static String getDataModelText(TapCapability tcap) {
            if (tcap == null) {
                return null;
            }
            String[] dms = tcap.getDataModels();
            if (dms == null || dms.length == 0) {
                return null;
            }
            StringBuffer sbuf = new StringBuffer();
            if (dms != null) {
                for (String dm : dms) {
                    if (sbuf.length() != 0) {
                        sbuf.append('\n');
                    }
                    sbuf.append(dm);
                }
            }
            return sbuf.toString();
        }

        private static String getGeoFuncText(TapCapability tcap) {
            if (tcap == null) {
                return null;
            }
            TapLanguage[] langs = ResourceMetaPanel.getAdqlLanguages(tcap);
            if (langs.length == 0) {
                return null;
            }
            if (langs.length == 1) {
                return ResourceMetaPanel.getGeoFuncText(langs[0]);
            }
            StringBuffer sbuf = new StringBuffer();
            for (TapLanguage lang : langs) {
                String geoTxt = ResourceMetaPanel.getGeoFuncText(lang);
                if (geoTxt == null || geoTxt.length() <= 0) continue;
                if (sbuf.length() != 0) {
                    sbuf.append('\n');
                }
                sbuf.append(lang.getName()).append('\n').append("--------\n").append(geoTxt);
            }
            return sbuf.toString();
        }

        private static String getRoleText(RegRole[] roles, String baseRole) {
            StringBuffer sbuf = new StringBuffer();
            for (RegRole role : roles) {
                boolean hasEmail;
                String name = role.getName();
                String email = role.getEmail();
                boolean hasName = name != null && name.trim().length() > 0;
                boolean bl = hasEmail = email != null && email.trim().length() > 0;
                if (!baseRole.equalsIgnoreCase(role.getBaseRole()) || !hasName && !hasEmail) continue;
                if (sbuf.length() > 0) {
                    sbuf.append('\n');
                }
                if (hasName) {
                    sbuf.append(name.trim());
                }
                if (hasName && hasEmail) {
                    sbuf.append(' ');
                }
                if (!hasEmail) continue;
                sbuf.append('<').append(email.trim()).append('>');
            }
            return sbuf.toString();
        }

        private static URL getLogoUrl(RegRole[] roles) {
            for (RegRole role : roles) {
                String logo = role.getLogo();
                if (logo == null || logo.trim().length() <= 0) continue;
                try {
                    return new URL(logo);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            return null;
        }

        private static String getUdfHtml(TapCapability tcap) {
            if (tcap == null) {
                return null;
            }
            TapLanguage[] langs = ResourceMetaPanel.getAdqlLanguages(tcap);
            if (langs.length == 0) {
                return null;
            }
            if (langs.length == 1) {
                return ResourceMetaPanel.getUdfHtml(langs[0]);
            }
            StringBuffer sbuf = new StringBuffer();
            for (TapLanguage lang : langs) {
                String lname = lang.getName();
                String udfHtml = ResourceMetaPanel.getUdfHtml(lang);
                if (udfHtml == null || udfHtml.length() <= 0) continue;
                sbuf.append("<dt>").append(ResourceMetaPanel.escapeHtml(lname == null ? "??" : lname)).append("</dt>\n").append("<dd>").append(udfHtml).append("</dd>\n");
            }
            return sbuf.length() > 0 ? "<dl>\n" + sbuf + "</dl>" : null;
        }

        private static String getGeoFuncText(TapLanguage lang) {
            TapLanguageFeature[] geoFeats = lang.getFeaturesMap().get("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo");
            if (geoFeats == null || geoFeats.length == 0) {
                return null;
            }
            ArrayList<String> geoFuncs = new ArrayList<String>();
            for (TapLanguageFeature feat : geoFeats) {
                geoFuncs.add(feat.getForm());
            }
            Collections.sort(geoFuncs);
            StringBuffer sbuf = new StringBuffer();
            for (String func : geoFuncs) {
                if (sbuf.length() != 0) {
                    sbuf.append(", ");
                }
                sbuf.append(func);
            }
            return sbuf.toString();
        }

        private static String getUdfHtml(TapLanguage lang) {
            TapLanguageFeature[] udfFeats = lang.getFeaturesMap().get("ivo://ivoa.net/std/TAPRegExt#features-udf");
            if (udfFeats == null || udfFeats.length == 0) {
                return null;
            }
            StringBuffer sbuf = new StringBuffer();
            for (TapLanguageFeature feat : udfFeats) {
                String form = feat.getForm();
                String descrip = feat.getDescription();
                sbuf.append("<dt>").append("<strong><code>").append(ResourceMetaPanel.escapeHtml(form == null ? "??" : form)).append("</code></strong>").append("</dt>\n");
                if (descrip == null) continue;
                sbuf.append("<dd>").append(ResourceMetaPanel.escapeHtml(descrip)).append("</dd>\n");
            }
            return sbuf.length() > 0 ? "<dl>\n" + sbuf + "</dl>" : null;
        }

        private static TapLanguage[] getAdqlLanguages(TapCapability tcap) {
            TapLanguage[] langs;
            ArrayList<TapLanguage> adqlList = new ArrayList<TapLanguage>();
            if (tcap != null && (langs = tcap.getLanguages()) != null) {
                for (TapLanguage lang : langs) {
                    if (!"adql".equalsIgnoreCase(lang.getName())) continue;
                    adqlList.add(lang);
                }
            }
            return adqlList.toArray(new TapLanguage[0]);
        }

        private static String escapeHtml(String txt) {
            return txt.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        }
    }

    private static class SchemaMetaPanel
    extends MetaPanel {
        private final JTextComponent nameField_ = this.addLineField("Name");
        private final JTextComponent ntableField_ = this.addLineField("Tables");
        private final JTextComponent descripField_ = this.addMultiLineField("Description");
        private SchemaMeta schema_;

        SchemaMetaPanel() {
        }

        public void setSchema(SchemaMeta schema) {
            if (schema != this.schema_) {
                this.schema_ = schema;
                this.setFieldText(this.nameField_, schema == null ? null : schema.getName());
                this.setFieldText(this.descripField_, schema == null ? null : schema.getDescription());
                Object[] tables = schema == null ? null : schema.getTables();
                this.setFieldText(this.ntableField_, TableSetPanel.arrayLength(tables));
            }
        }
    }

    private static class TableMetaPanel
    extends MetaPanel {
        private final JTextComponent nameField_ = this.addLineField("Name");
        private final JTextComponent ncolField_ = this.addLineField("Columns");
        private final JTextComponent nfkField_ = this.addLineField("Foreign Keys");
        private final JTextComponent descripField_ = this.addMultiLineField("Description");
        private final JTextComponent tableExtrasField_ = this.addHtmlField("Non-Standard Table Metadata");
        private final JTextComponent colExtrasField_ = this.addHtmlField("Non-Standard Column Metadata");
        private TableMeta table_;

        TableMetaPanel() {
        }

        public void setTable(TableMeta table) {
            if (table != this.table_) {
                this.table_ = table;
                this.setFieldText(this.nameField_, table == null ? null : table.getName());
                this.setFieldText(this.descripField_, table == null ? null : table.getDescription());
                this.setFieldText(this.tableExtrasField_, table == null ? null : TableMetaPanel.mapToHtml(table.getExtras()));
                this.setColumns(table == null ? null : table.getColumns());
                this.setForeignKeys(table == null ? null : table.getForeignKeys());
            }
        }

        public void setColumns(ColumnMeta[] cols) {
            this.setFieldText(this.ncolField_, TableSetPanel.arrayLength(cols));
        }

        public void setColumnExtras(String[] extras) {
            StringBuffer sbuf = new StringBuffer();
            if (extras != null) {
                for (String extra : extras) {
                    sbuf.append(extra).append("<br />\n");
                }
            }
            this.setFieldText(this.colExtrasField_, sbuf.toString());
        }

        public void setForeignKeys(ForeignMeta[] fkeys) {
            this.setFieldText(this.nfkField_, TableSetPanel.arrayLength(fkeys));
        }
    }

    private static class ExtraColumn
    extends ArrayTableColumn {
        private final String key_;
        private final Class clazz_;

        ExtraColumn(String key, Class clazz) {
            super(key, clazz);
            this.key_ = key;
            this.clazz_ = clazz;
        }

        @Override
        public Object getValue(Object item) {
            Object value = TableSetPanel.getCol(item).getExtras().get(this.key_);
            if (value == null) {
                return null;
            }
            if (this.clazz_.isInstance(value)) {
                return value;
            }
            if (String.class.equals((Object)this.clazz_)) {
                return value.toString();
            }
            return null;
        }

        public int hashCode() {
            int code = 772261;
            code = 23 * code + this.key_.hashCode();
            code = 23 * code + this.clazz_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof ExtraColumn) {
                ExtraColumn other = (ExtraColumn)o;
                return this.key_.equals(other.key_) && this.clazz_.equals(other.clazz_);
            }
            return false;
        }

        static ExtraColumn createInstance(String name, List<Object> values) {
            Class<?> clazz = null;
            for (Object obj : values) {
                if (obj == null) continue;
                Class<?> c = obj.getClass();
                if (clazz == null) {
                    clazz = c;
                    continue;
                }
                if (clazz.equals(c)) continue;
                return new ExtraColumn(name, String.class);
            }
            return new ExtraColumn(name, clazz == null ? String.class : clazz);
        }
    }

    private static class WordMatchMask
    implements MaskTreeModel.Mask {
        private final Set<String> lwords_;
        private final NodeStringer stringer_;
        private final boolean isAnd_;

        WordMatchMask(String[] words, NodeStringer stringer, boolean isAnd) {
            this.lwords_ = new HashSet<String>(words.length);
            for (String word : words) {
                this.lwords_.add(word.toLowerCase());
            }
            this.stringer_ = stringer;
            this.isAnd_ = isAnd;
        }

        @Override
        public boolean isIncluded(Object node) {
            for (String nodeTxt : this.stringer_.getStrings(node)) {
                if (nodeTxt == null) continue;
                String nodetxt = nodeTxt.toLowerCase();
                if (!(this.isAnd_ ? this.matchesAllWords(nodetxt) : this.matchesAnyWord(nodetxt))) continue;
                return true;
            }
            return false;
        }

        private boolean matchesAnyWord(String txt) {
            for (String lword : this.lwords_) {
                if (txt.indexOf(lword) < 0) continue;
                return true;
            }
            return false;
        }

        private boolean matchesAllWords(String txt) {
            for (String lword : this.lwords_) {
                if (txt.indexOf(lword) >= 0) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int code = 324223;
            code = 23 * code + ((Object)this.lwords_).hashCode();
            code = 23 * code + this.stringer_.hashCode();
            code = 23 * code + (this.isAnd_ ? 11 : 17);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof WordMatchMask) {
                WordMatchMask other = (WordMatchMask)o;
                return ((Object)this.lwords_).equals(other.lwords_) && this.stringer_.equals(other.stringer_) && this.isAnd_ == other.isAnd_;
            }
            return false;
        }
    }

    private static abstract class NodeStringer {
        private final boolean useName_;
        private final boolean useDescription_;

        private NodeStringer(boolean useName, boolean useDescription) {
            this.useName_ = useName;
            this.useDescription_ = useDescription;
        }

        public abstract List<String> getStrings(Object var1);

        public int hashCode() {
            int code = 5523;
            code = 23 * code + (this.useName_ ? 11 : 13);
            code = 23 * code + (this.useDescription_ ? 23 : 29);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof NodeStringer) {
                NodeStringer other = (NodeStringer)o;
                return this.useName_ == other.useName_ && this.useDescription_ == other.useDescription_;
            }
            return false;
        }

        public static NodeStringer createInstance(final boolean useName, final boolean useDescrip) {
            if (useName && !useDescrip) {
                final List<String> emptyList = Arrays.asList(new String[0]);
                return new NodeStringer(useName, useDescrip){

                    @Override
                    public List<String> getStrings(Object node) {
                        return node == null ? emptyList : Collections.singletonList(node.toString());
                    }
                };
            }
            return new NodeStringer(useName, useDescrip){

                @Override
                public List<String> getStrings(Object node) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (node != null) {
                        if (useName) {
                            list.add(node.toString());
                        }
                        if (useDescrip) {
                            String descrip = null;
                            if (node instanceof TableMeta) {
                                descrip = ((TableMeta)node).getDescription();
                            } else if (node instanceof SchemaMeta) {
                                descrip = ((SchemaMeta)node).getDescription();
                            }
                            if (descrip != null) {
                                list.add(descrip);
                            }
                        }
                    }
                    return list;
                }
            };
        }
    }

    private static class CountTableTreeCellRenderer
    extends DefaultTreeCellRenderer {
        String rootName_;

        private CountTableTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int irow, boolean hasFocus) {
            boolean hasMask;
            Component comp = super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, irow, hasFocus);
            if (value instanceof SchemaMeta[]) {
                SchemaMeta[] schemas = (SchemaMeta[])value;
                this.setIcon(ResourceIcon.NODE_SERVICE);
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(this.rootName_ == null ? "TAP Service" : this.rootName_);
                int ntTotal = 0;
                for (SchemaMeta schema : schemas) {
                    TableMeta[] tables = schema.getTables();
                    if (tables == null) continue;
                    ntTotal += tables.length;
                }
                sbuf.append(" (");
                TreeModel model = tree.getModel();
                boolean bl = hasMask = model instanceof MaskTreeModel && ((MaskTreeModel)model).getMask() != null;
                if (hasMask) {
                    int ntPresent = 0;
                    for (SchemaMeta schema : schemas) {
                        ntPresent += model.getChildCount(schema);
                    }
                    sbuf.append(ntPresent).append("/");
                }
                sbuf.append(ntTotal).append(")");
                this.setText(sbuf.toString());
            }
            if (value instanceof SchemaMeta) {
                TableMeta[] tables = ((SchemaMeta)value).getTables();
                if (tables != null) {
                    int ntTotal = tables.length;
                    TreeModel model = tree.getModel();
                    int ntPresent = model.isLeaf(value) ? -1 : model.getChildCount(value);
                    hasMask = model instanceof MaskTreeModel && ((MaskTreeModel)model).getMask() != null;
                    StringBuffer sbuf = new StringBuffer();
                    sbuf.append(this.getText()).append(" (");
                    if (hasMask) {
                        sbuf.append(ntPresent).append("/");
                    }
                    sbuf.append(ntTotal).append(")");
                    this.setText(sbuf.toString());
                }
            } else if (value instanceof TableMeta) {
                this.setIcon(ResourceIcon.NODE_TABLE);
            }
            return comp;
        }
    }
}

