/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.vo.OutputFormat;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapLanguageFeature;
import uk.ac.starlink.vo.TapLimit;

public abstract class TapCapability {
    public static final String TAPREGEXT_STD_URI = "ivo://ivoa.net/std/TAPRegExt";
    public static final String UDF_FEATURE_TYPE = "ivo://ivoa.net/std/TAPRegExt#features-udf";
    public static final String ADQLGEO_FEATURE_TYPE = "ivo://ivoa.net/std/TAPRegExt#features-adqlgeo";

    public abstract String[] getUploadMethods();

    public abstract TapLanguage[] getLanguages();

    public abstract OutputFormat[] getOutputFormats();

    public abstract String[] getDataModels();

    public abstract TapLimit[] getOutputLimits();

    public abstract TapLimit[] getUploadLimits();

    public abstract TapLimit[] getExecutionLimits();

    public abstract TapLimit[] getRetentionLimits();

    public static TapCapability readTapCapability(URL url) throws IOException, SAXException {
        try {
            return TapCapability.attemptReadTapCapability(url);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("Parser setup failed").initCause(e);
        }
        catch (XPathExpressionException e) {
            throw (IOException)new IOException("XPath programming error?").initCause(e);
        }
    }

    private static TapCapability attemptReadTapCapability(URL url) throws ParserConfigurationException, XPathExpressionException, IOException, SAXException {
        String capXpath;
        Document capsDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new BufferedInputStream(url.openStream()));
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node capNode = (Node)xpath.evaluate(capXpath = "capability[@standardID='ivo://ivoa.net/std/TAP']", capsDoc.getDocumentElement(), XPathConstants.NODE);
        if (capNode == null) {
            throw new IOException("No element \"" + capXpath + "\"" + " at " + url);
        }
        NodeList upNodeList = (NodeList)xpath.evaluate("uploadMethod/@ivo-id", capNode, XPathConstants.NODESET);
        ArrayList<String> upList = new ArrayList<String>();
        for (int i = 0; i < upNodeList.getLength(); ++i) {
            upList.add(upNodeList.item(i).getNodeValue());
        }
        final String[] uploadMethods = upList.toArray(new String[0]);
        NodeList dmNodeList = (NodeList)xpath.evaluate("dataModel/@ivo-id", capNode, XPathConstants.NODESET);
        ArrayList<String> dmList = new ArrayList<String>();
        for (int i = 0; i < dmNodeList.getLength(); ++i) {
            dmList.add(dmNodeList.item(i).getNodeValue());
        }
        final String[] dataModels = dmList.toArray(new String[0]);
        NodeList langNodeList = (NodeList)xpath.evaluate("language", capNode, XPathConstants.NODESET);
        ArrayList<TapLanguage> langList = new ArrayList<TapLanguage>();
        for (int il = 0; il < langNodeList.getLength(); ++il) {
            Node lang = langNodeList.item(il);
            if (!(lang instanceof Element)) continue;
            langList.add(TapCapability.getLanguage((Element)lang));
        }
        final TapLanguage[] languages = langList.toArray(new TapLanguage[0]);
        NodeList ofmtNodeList = (NodeList)xpath.evaluate("outputFormat", capNode, XPathConstants.NODESET);
        ArrayList<OutputFormat> ofmtList = new ArrayList<OutputFormat>();
        for (int i = 0; i < ofmtNodeList.getLength(); ++i) {
            Node ofmt = ofmtNodeList.item(i);
            if (!(ofmt instanceof Element)) continue;
            ofmtList.add(TapCapability.getOutputFormat((Element)ofmt));
        }
        final OutputFormat[] outputFormats = ofmtList.toArray(new OutputFormat[0]);
        final TapLimit[] outputLimits = TapCapability.getLimits((NodeList)xpath.evaluate("outputLimit/*", capNode, XPathConstants.NODESET), null);
        final TapLimit[] uploadLimits = TapCapability.getLimits((NodeList)xpath.evaluate("uploadLimit/*", capNode, XPathConstants.NODESET), null);
        final TapLimit[] retentionLimits = TapCapability.getLimits((NodeList)xpath.evaluate("retentionPeriod/*", capNode, XPathConstants.NODESET), "seconds");
        final TapLimit[] executionLimits = TapCapability.getLimits((NodeList)xpath.evaluate("executionDuration/*", capNode, XPathConstants.NODESET), "seconds");
        return new TapCapability(){

            @Override
            public String[] getUploadMethods() {
                return uploadMethods;
            }

            @Override
            public TapLanguage[] getLanguages() {
                return languages;
            }

            @Override
            public OutputFormat[] getOutputFormats() {
                return outputFormats;
            }

            @Override
            public String[] getDataModels() {
                return dataModels;
            }

            @Override
            public TapLimit[] getOutputLimits() {
                return outputLimits;
            }

            @Override
            public TapLimit[] getUploadLimits() {
                return uploadLimits;
            }

            @Override
            public TapLimit[] getExecutionLimits() {
                return executionLimits;
            }

            @Override
            public TapLimit[] getRetentionLimits() {
                return retentionLimits;
            }

            public String toString() {
                return "uploadMethods: " + Arrays.asList(uploadMethods) + "; " + "languages: " + Arrays.asList(languages) + "; " + "outputFormats: " + Arrays.asList(outputFormats) + "; " + "dataModels: " + Arrays.asList(dataModels) + "; " + "outputLimits: " + Arrays.asList(outputLimits) + "; " + "uploadLimits: " + Arrays.asList(uploadLimits) + "; " + "execLimits: " + Arrays.asList(executionLimits) + "; " + "retentLimits: " + Arrays.asList(retentionLimits);
            }
        };
    }

    private static TapLimit[] getLimits(NodeList nodeList, String fixedUnit) {
        ArrayList<TapLimit> limitList = new ArrayList<TapLimit>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            String tagName = el.getTagName();
            Boolean isHard = null;
            if ("hard".equals(tagName)) {
                isHard = Boolean.TRUE;
            } else if ("default".equals(tagName)) {
                isHard = Boolean.FALSE;
            }
            if (isHard == null) continue;
            String unit = fixedUnit == null ? el.getAttribute("unit") : fixedUnit;
            String text = DOMUtils.getTextContent(el);
            try {
                long value = Long.parseLong(text.trim());
                limitList.add(new TapLimit(value, isHard, unit));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return limitList.toArray(new TapLimit[0]);
    }

    private static TapLanguage getLanguage(Element langEl) {
        String langName = null;
        String langDesc = null;
        ArrayList<String> versionList = new ArrayList<String>();
        ArrayList<String> versionIdList = new ArrayList<String>();
        final LinkedHashMap<String, TapLanguageFeature[]> featureMap = new LinkedHashMap<String, TapLanguageFeature[]>();
        for (Node langChild = langEl.getFirstChild(); langChild != null; langChild = langChild.getNextSibling()) {
            if (!(langChild instanceof Element)) continue;
            Element childEl = (Element)langChild;
            String childName = childEl.getTagName();
            if ("name".equals(childName)) {
                langName = DOMUtils.getTextContent(childEl);
                continue;
            }
            if ("description".equals(childName)) {
                langDesc = DOMUtils.getTextContent(childEl);
                continue;
            }
            if ("version".equals(childName)) {
                versionIdList.add(childEl.getAttribute("ivo-id"));
                versionList.add(DOMUtils.getTextContent(childEl));
                continue;
            }
            if (!"languageFeatures".equals(childName)) continue;
            String featType = childEl.getAttribute("type");
            ArrayList<2> featList = new ArrayList<2>();
            NodeList featNodeList = childEl.getElementsByTagName("feature");
            for (int ifeat = 0; ifeat < featNodeList.getLength(); ++ifeat) {
                Element featEl = (Element)featNodeList.item(ifeat);
                Element formEl = DOMUtils.getChildElementByName(featEl, "form");
                Element descEl = DOMUtils.getChildElementByName(featEl, "description");
                final String form = formEl == null ? null : DOMUtils.getTextContent(formEl);
                final String desc = descEl == null ? null : DOMUtils.getTextContent(descEl);
                featList.add(new TapLanguageFeature(){

                    @Override
                    public String getForm() {
                        return form;
                    }

                    @Override
                    public String getDescription() {
                        return desc;
                    }

                    public String toString() {
                        return form;
                    }
                });
            }
            TapLanguageFeature[] features = featList.toArray(new TapLanguageFeature[0]);
            featureMap.put(featType, features);
        }
        final String name = langName;
        final String description = langDesc;
        final String[] versions = versionList.toArray(new String[0]);
        final String[] versionIds = versionIdList.toArray(new String[0]);
        return new TapLanguage(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String[] getVersions() {
                return versions;
            }

            @Override
            public String[] getVersionIds() {
                return versionIds;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public Map<String, TapLanguageFeature[]> getFeaturesMap() {
                return featureMap;
            }

            public String toString() {
                return name + "-" + Arrays.asList(versions);
            }
        };
    }

    private static OutputFormat getOutputFormat(Element ofmtEl) {
        final String ivoid = ofmtEl.getAttribute("ivo-id");
        String ofmtMime = null;
        ArrayList<String> aliasList = new ArrayList<String>();
        for (Node ofmtChild = ofmtEl.getFirstChild(); ofmtChild != null; ofmtChild = ofmtChild.getNextSibling()) {
            if (!(ofmtChild instanceof Element)) continue;
            Element childEl = (Element)ofmtChild;
            String childName = childEl.getTagName();
            if ("mime".equals(childName)) {
                ofmtMime = DOMUtils.getTextContent(childEl);
                continue;
            }
            if (!"alias".equals(childName)) continue;
            aliasList.add(DOMUtils.getTextContent(childEl));
        }
        final String mime = ofmtMime;
        final String[] aliases = aliasList.toArray(new String[0]);
        return new OutputFormat(){

            @Override
            public String getMime() {
                return mime;
            }

            @Override
            public String[] getAliases() {
                return aliases;
            }

            @Override
            public String getIvoid() {
                return ivoid;
            }

            public String toString() {
                if (aliases.length > 0) {
                    return aliases[0];
                }
                if (mime != null) {
                    return mime;
                }
                return ivoid;
            }
        };
    }

    public static void main(String[] args) throws IOException, SAXException {
        System.out.println(TapCapability.readTapCapability(new URL(args[0])));
    }
}

