/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapLanguageFeature;
import uk.ac.starlink.vo.TapLimit;

public class TapCapabilityPanel
extends JPanel {
    private TapCapability capability_;
    private final JComboBox langSelector_ = new JComboBox();
    private final JTextField uploadField_;
    private final JComboBox maxrecSelector_;
    private static final VersionedLanguage ADQL = TapCapabilityPanel.createDefaultAdqlLanguage();

    public TapCapabilityPanel() {
        super(new BorderLayout());
        this.langSelector_.setToolTipText("Selects which supported query language/version to use");
        this.uploadField_ = new JTextField();
        this.uploadField_.setEditable(false);
        this.uploadField_.setToolTipText("Indicates whether the service supports table uploads and if so what limits apply");
        this.maxrecSelector_ = new JComboBox();
        this.maxrecSelector_.setEditable(true);
        this.maxrecSelector_.setToolTipText("Indicates and allows to set MAXREC, the maximum row count for result tables");
        Box line = Box.createHorizontalBox();
        line.add(TapCapabilityPanel.createJLabel("Query Language: ", this.langSelector_));
        line.add(new ShrinkWrapper(this.langSelector_));
        line.add(Box.createHorizontalStrut(10));
        line.add(TapCapabilityPanel.createJLabel("Max Rows: ", this.maxrecSelector_));
        line.add(new ShrinkWrapper(this.maxrecSelector_));
        line.add(Box.createHorizontalStrut(10));
        line.add(TapCapabilityPanel.createJLabel("Uploads: ", this.uploadField_));
        line.add(this.uploadField_);
        line.add(Box.createHorizontalGlue());
        this.add((Component)line, "North");
        this.setCapability(null);
    }

    public void setCapability(TapCapability capability) {
        DefaultComboBoxModel<String> maxrecModel;
        this.capability_ = capability;
        if (capability == null) {
            this.langSelector_.setModel(new DefaultComboBoxModel());
            this.uploadField_.setText(null);
            this.langSelector_.setEnabled(false);
            maxrecModel = new DefaultComboBoxModel<String>(new String[1]);
        } else if (capability.getLanguages().length == 0) {
            VersionedLanguage[] vlangs = new VersionedLanguage[]{ADQL};
            this.langSelector_.setModel(new DefaultComboBoxModel<VersionedLanguage>(vlangs));
            this.langSelector_.setSelectedIndex(0);
            this.uploadField_.setText(null);
            this.langSelector_.setEnabled(false);
            maxrecModel = new DefaultComboBoxModel<String>(new String[1]);
        } else {
            VersionedLanguage[] vlangs = TapCapabilityPanel.getVersionedLanguages(capability);
            this.langSelector_.setModel(new DefaultComboBoxModel<VersionedLanguage>(vlangs));
            this.langSelector_.setSelectedItem(TapCapabilityPanel.getDefaultLanguage(vlangs));
            this.langSelector_.setEnabled(true);
            if (TapCapabilityPanel.canUpload(capability)) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(this.getUploadLimitString("row")).append(sbuf.length() > 0 ? "/" : "").append(this.getUploadLimitString("byte"));
                String limitString = sbuf.toString();
                this.uploadField_.setText(limitString.length() > 0 ? limitString : "available");
            } else {
                this.uploadField_.setText("unavailable");
            }
            TapLimit[] outLimits = capability.getOutputLimits();
            maxrecModel = new DefaultComboBoxModel();
            maxrecModel.addElement("");
            for (int il = 0; il < outLimits.length; ++il) {
                TapLimit limit = outLimits[il];
                if (!"row".equals(limit.getUnit())) continue;
                final String slimit = limit.getValue() + " (" + (limit.isHard() ? "max" : "default") + ")";
                TapLimit tlimit = new TapLimit(limit.getValue(), limit.isHard(), limit.getUnit()){

                    @Override
                    public String toString() {
                        return slimit;
                    }
                };
                maxrecModel.addElement((String)((Object)tlimit));
                if (tlimit.isHard()) continue;
                maxrecModel.setSelectedItem(tlimit);
            }
        }
        this.maxrecSelector_.setModel(maxrecModel);
    }

    public TapCapability getCapability() {
        return this.capability_;
    }

    public TapLanguage getQueryLanguage() {
        Object selected = this.langSelector_.getSelectedItem();
        VersionedLanguage vlang = selected instanceof VersionedLanguage ? (VersionedLanguage)selected : ADQL;
        return vlang.lang_;
    }

    public String getQueryLanguageName() {
        Object selected = this.langSelector_.getSelectedItem();
        VersionedLanguage vlang = selected instanceof VersionedLanguage ? (VersionedLanguage)selected : ADQL;
        return vlang.toString();
    }

    public long getMaxrec() {
        Object oMaxrec = this.maxrecSelector_.getSelectedItem();
        if (oMaxrec instanceof TapLimit) {
            TapLimit limit = (TapLimit)oMaxrec;
            return limit.isHard() ? limit.getValue() : -1L;
        }
        if (oMaxrec instanceof String) {
            try {
                return Long.parseLong((String)oMaxrec);
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public long getUploadLimit(String units) {
        TapLimit[] limits;
        TapLimit[] tapLimitArray = limits = this.capability_ == null ? null : this.capability_.getUploadLimits();
        if (limits == null) {
            return -1L;
        }
        for (int i = 0; i < limits.length; ++i) {
            TapLimit limit = limits[i];
            if (!limit.isHard() || !units.equals(limit.getUnit())) continue;
            return limit.getValue();
        }
        return -1L;
    }

    private String getUploadLimitString(String units) {
        long value = this.getUploadLimit(units);
        if (value < 0L) {
            return "";
        }
        int kilo = 1000;
        int mega = 1000 * kilo;
        int giga = 1000 * mega;
        String snum = value >= (long)(giga * 10) ? value / (long)giga + "G" : ((double)value >= 1.0E7 ? value / (long)mega + "M" : ((double)value >= 10000.0 ? value / (long)kilo + "k" : Long.toString(value)));
        String u = "row".equals(units) ? "row" : ("byte".equals(units) ? "b" : "");
        return snum + u;
    }

    public static boolean canUpload(TapCapability tcap) {
        String[] upMethods = tcap == null ? null : tcap.getUploadMethods();
        return upMethods != null && Arrays.asList(upMethods).contains("ivo://ivoa.net/std/TAPRegExt#upload-inline");
    }

    private static JLabel createJLabel(String text, JComponent comp) {
        JLabel label = new JLabel(text);
        label.setToolTipText(comp.getToolTipText());
        return label;
    }

    private static VersionedLanguage getDefaultLanguage(VersionedLanguage[] vlangs) {
        for (VersionedLanguage vlang : vlangs) {
            if (!"adql".equalsIgnoreCase(vlang.lang_.getName()) || !"2.0".equals(vlang.version_)) continue;
            return vlang;
        }
        for (VersionedLanguage vlang : vlangs) {
            if (!"adql".equalsIgnoreCase(vlang.lang_.getName())) continue;
            return vlang;
        }
        return vlangs.length > 0 ? vlangs[0] : ADQL;
    }

    private static VersionedLanguage[] getVersionedLanguages(TapCapability tcap) {
        ArrayList<VersionedLanguage> vlangList = new ArrayList<VersionedLanguage>();
        for (TapLanguage lang : tcap.getLanguages()) {
            for (String vers : lang.getVersions()) {
                vlangList.add(new VersionedLanguage(lang, vers));
            }
        }
        return vlangList.toArray(new VersionedLanguage[0]);
    }

    private static VersionedLanguage createDefaultAdqlLanguage() {
        String version = null;
        TapLanguage lang = new TapLanguage(){

            @Override
            public String getName() {
                return "ADQL";
            }

            @Override
            public String getDescription() {
                return "Astronomical Data Query Language";
            }

            @Override
            public String[] getVersionIds() {
                return new String[]{"ivo://ivoa.net/std/ADQL#v2.0"};
            }

            @Override
            public String[] getVersions() {
                return new String[]{"2.0"};
            }

            @Override
            public Map<String, TapLanguageFeature[]> getFeaturesMap() {
                return new HashMap<String, TapLanguageFeature[]>();
            }
        };
        return new VersionedLanguage(lang, version);
    }

    private static class VersionedLanguage {
        final TapLanguage lang_;
        final String version_;

        VersionedLanguage(TapLanguage lang, String version) {
            this.lang_ = lang;
            this.version_ = version;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer().append(this.lang_.getName());
            if (this.version_ != null) {
                sbuf.append('-').append(this.version_);
            }
            return sbuf.toString();
        }
    }
}

