/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.starlink.vo.AdqlExample;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.UrlHandler;

public class TapExampleLine
extends JPanel {
    private final UrlHandler urlHandler_;
    private final JLabel titleLabel_;
    private final JTextField nameField_;
    private final Action infoAct_;
    private AdqlExample example_;

    public TapExampleLine(UrlHandler urlHandler) {
        this.urlHandler_ = urlHandler;
        this.titleLabel_ = new JLabel();
        this.nameField_ = new JTextField();
        this.nameField_.setEditable(false);
        this.nameField_.setBorder(BorderFactory.createEmptyBorder());
        this.infoAct_ = new AbstractAction("Info"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TapExampleLine.this.urlHandler_.clickUrl(TapExampleLine.this.example_.getInfoUrl());
            }
        };
        this.infoAct_.putValue("SmallIcon", ResourceIcon.EXTLINK);
        this.setLayout(new BoxLayout(this, 2));
        Box textBox = Box.createHorizontalBox();
        textBox.setBorder(BorderFactory.createEtchedBorder());
        textBox.add(Box.createHorizontalStrut(5));
        textBox.add(this.titleLabel_);
        textBox.add(this.nameField_);
        JButton infoButt = new JButton(this.infoAct_);
        infoButt.setHorizontalTextPosition(10);
        this.add(textBox);
        this.add(Box.createHorizontalGlue());
        this.add(Box.createHorizontalStrut(5));
        this.add(infoButt);
        this.setExample(null, null);
    }

    public void setExample(AdqlExample example, String groupName) {
        this.example_ = example;
        this.titleLabel_.setText(groupName == null ? null : groupName + ": ");
        this.titleLabel_.setEnabled(example != null);
        this.nameField_.setText(example == null ? null : example.getName());
        this.nameField_.setCaretPosition(0);
        this.nameField_.setToolTipText(example == null ? null : example.getDescription());
        boolean hasInfo = example != null && example.getInfoUrl() != null;
        this.infoAct_.setEnabled(this.urlHandler_ != null && hasInfo);
        String descrip = "Display example information in web browser";
        if (hasInfo) {
            descrip = descrip + " (" + example.getInfoUrl() + ")";
        }
        this.infoAct_.putValue("ShortDescription", descrip);
    }

    public AdqlExample getExample() {
        return this.example_;
    }
}

