/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.CadcTapMetaReader;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.MetaNameFixer;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetTapMetaReader;
import uk.ac.starlink.vo.TapMetaReader;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapSchemaInterrogator;
import uk.ac.starlink.vo.TapSchemaTapMetaReader;
import uk.ac.starlink.vo.VizierTapMetaReader;
import uk.ac.starlink.vo.Vosi11TapMetaReader;

public abstract class TapMetaPolicy {
    private final String name_;
    private final String description_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    public static final TapMetaPolicy AUTO = new TapMetaPolicy("Auto", "Chooses a suitable place to get table metadata. Some services may have custom protocols. Otherwise, use the VOSI tables endpoint when there are a moderate number of tables, or TAP_SCHEMA queries if there are many"){

        @Override
        public TapMetaReader createMetaReader(EndpointSet endpointSet, ContentCoding coding) {
            return TapMetaPolicy.createAutoMetaReader(endpointSet, coding, 5000);
        }
    };
    public static final TapMetaPolicy TABLESET = new TapMetaPolicy("TableSet", "Reads all metadata in one go from the vs:TableSet document at the VOSI tables endpoint of the TAP service"){

        @Override
        public TapMetaReader createMetaReader(EndpointSet endpointSet, ContentCoding coding) {
            MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
            URL tablesUrl = endpointSet.getTablesEndpoint();
            return new TableSetTapMetaReader(tablesUrl, fixer, coding);
        }
    };
    public static final TapMetaPolicy TAPSCHEMA_C = TapMetaPolicy.createTapSchemaPolicy("TAP_SCHEMA_C", false, true);
    public static final TapMetaPolicy TAPSCHEMA_CF;
    public static final TapMetaPolicy TAPSCHEMA;
    public static final TapMetaPolicy VIZIER;
    public static final TapMetaPolicy CADC;
    public static final TapMetaPolicy VOSI11_MAX;
    public static final TapMetaPolicy VOSI11_MIN;
    public static final TapMetaPolicy VOSI11_NULL;
    private static final TapMetaPolicy[] KNOWN_VALUES;

    protected TapMetaPolicy(String name, String description) {
        this.name_ = name;
        this.description_ = description;
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public abstract TapMetaReader createMetaReader(EndpointSet var1, ContentCoding var2);

    public static TapMetaPolicy[] getStandardInstances() {
        return (TapMetaPolicy[])KNOWN_VALUES.clone();
    }

    public static TapMetaPolicy getDefaultInstance() {
        return AUTO;
    }

    static void sortSchemas(SchemaMeta[] smetas) {
        Arrays.sort(smetas, new Comparator<SchemaMeta>(){

            @Override
            public int compare(SchemaMeta s1, SchemaMeta s2) {
                return this.getSchemaName(s1).compareTo(this.getSchemaName(s2));
            }

            private String getSchemaName(SchemaMeta smeta) {
                String name = smeta.getName();
                return name == null ? "" : name;
            }
        });
    }

    static void sortTables(TableMeta[] tmetas) {
        Arrays.sort(tmetas, new Comparator<TableMeta>(){

            @Override
            public int compare(TableMeta t1, TableMeta t2) {
                return this.getTableName(t1).compareTo(this.getTableName(t2));
            }

            private String getTableName(TableMeta tmeta) {
                String name = tmeta.getName();
                return name == null ? "" : name;
            }
        });
    }

    private static TapMetaPolicy createVosi11Policy(String name, final Vosi11TapMetaReader.DetailMode dmode) {
        String descrip = new StringBuffer().append("Reads metadata from the VOSI-1.1 /tables endpoint;\n").append(dmode.getDescription()).toString();
        return new TapMetaPolicy(name, descrip){

            @Override
            public TapMetaReader createMetaReader(EndpointSet endpointSet, ContentCoding coding) {
                URL tablesUrl = endpointSet.getTablesEndpoint();
                MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
                return new Vosi11TapMetaReader(tablesUrl, fixer, coding, dmode);
            }
        };
    }

    private static TapMetaPolicy createTapSchemaPolicy(String name, final boolean popTables, final boolean preloadKeys) {
        StringBuffer sbuf = new StringBuffer().append("Reads metadata by making synchronous queries ").append("on the TAP_SCHEMA tables; ");
        if (popTables) {
            assert (!preloadKeys);
            sbuf.append("metadata for all tables is read at once");
        } else if (preloadKeys) {
            sbuf.append("foreign keys are all read at once, ").append("columns are read as required");
        } else {
            sbuf.append("columns and foreign keys are read as required");
        }
        return new TapMetaPolicy(name, sbuf.toString()){

            @Override
            public TapMetaReader createMetaReader(EndpointSet endpointSet, ContentCoding coding) {
                int maxrec = 99999;
                boolean popSchemas = true;
                MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
                return new TapSchemaTapMetaReader(endpointSet, maxrec, coding, popSchemas, popTables, fixer, preloadKeys);
            }
        };
    }

    private static TapMetaReader createAutoMetaReader(EndpointSet endpointSet, ContentCoding coding, int maxrow) {
        MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
        long ncol = TapMetaPolicy.readRowCount(endpointSet, TapSchemaInterrogator.COLUMN_QUERIER.getTableName());
        if (ncol >= 0L && ncol > (long)maxrow) {
            boolean preloadFkeys;
            logger_.info("Many columns in TAP service (" + ncol + " > " + maxrow + "); " + "use TAP_SCHEMA queries for " + endpointSet.getIdentity());
            String linkTableName = TapSchemaInterrogator.LINK_QUERIER.getTableName();
            long nlink = TapMetaPolicy.readRowCount(endpointSet, linkTableName);
            boolean bl = preloadFkeys = nlink < 0L || nlink <= (long)maxrow;
            if (nlink >= 0L) {
                String msg = new StringBuffer().append(preloadFkeys ? "Not many" : "Many").append(" rows in ").append(linkTableName).append(" (").append(nlink).append(preloadFkeys ? " <= " : " > ").append(maxrow).append(");").append(preloadFkeys ? " preload all foreign keys" : " no preload").toString();
                logger_.info(msg);
            }
            int maxrec = (int)Math.min(Integer.MAX_VALUE, Math.max(ncol + 1L, nlink + 1L));
            boolean popSchema = true;
            boolean popTable = false;
            return new TapSchemaTapMetaReader(endpointSet, maxrec, coding, popSchema, popTable, fixer, preloadFkeys);
        }
        logger_.info("Not excessive column count for TAP service (" + ncol + " <= " + maxrow + ")");
        logger_.info("Use VOSI tables endpoint for " + endpointSet.getIdentity());
        return new TableSetTapMetaReader(endpointSet.getTablesEndpoint(), fixer, coding);
    }

    private static long readRowCount(EndpointSet endpointSet, String tableName) {
        Number nrow;
        String adql = "SELECT COUNT(*) AS nrow FROM " + tableName;
        try {
            nrow = TapQuery.scalarQuery(endpointSet, adql, Number.class);
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "Row count for " + tableName + " failed: " + e, e);
            return -1L;
        }
        if (nrow == null) {
            logger_.log(Level.WARNING, "No row count result for " + tableName);
            return -1L;
        }
        return nrow.longValue();
    }

    static {
        KNOWN_VALUES = new TapMetaPolicy[]{AUTO, TABLESET, TAPSCHEMA_C, TAPSCHEMA_CF = TapMetaPolicy.createTapSchemaPolicy("TAP_SCHEMA_CF", false, false), TAPSCHEMA = TapMetaPolicy.createTapSchemaPolicy("TAP_SCHEMA", true, false), VIZIER = new TapMetaPolicy("VizieR", "Uses TAPVizieR's non-standard two-stage VOSI tables endpoint"){

            @Override
            public TapMetaReader createMetaReader(EndpointSet endpointSet, ContentCoding coding) {
                URL tablesetUrl = endpointSet.getTablesEndpoint();
                MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
                return new VizierTapMetaReader(tablesetUrl, fixer, coding);
            }
        }, CADC = new TapMetaPolicy("CADC", "Uses CADC's non-standard multi-stage VOSI tables endpoint"){

            @Override
            public TapMetaReader createMetaReader(EndpointSet endpointSet, ContentCoding coding) {
                URL tablesetUrl = endpointSet.getTablesEndpoint();
                CadcTapMetaReader.Config config = CadcTapMetaReader.Config.POPULATE_SCHEMAS;
                return new CadcTapMetaReader(tablesetUrl, config, coding);
            }
        }, VOSI11_MAX = TapMetaPolicy.createVosi11Policy("VOSI11-1step", Vosi11TapMetaReader.DetailMode.MAX), VOSI11_MIN = TapMetaPolicy.createVosi11Policy("VOSI11-2step", Vosi11TapMetaReader.DetailMode.MIN), VOSI11_NULL = TapMetaPolicy.createVosi11Policy("VOSI11", Vosi11TapMetaReader.DetailMode.NULL)};
    }
}

