/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.storage.DiscardByteStore;
import uk.ac.starlink.table.storage.LimitByteStore;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.HeadBufferInputStream;
import uk.ac.starlink.vo.DalResultStreamer;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.Endpoints;
import uk.ac.starlink.vo.HttpStreamParam;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.vo.UwsJobInfo;
import uk.ac.starlink.vo.UwsStage;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.VOTableWriter;

public class TapQuery {
    private final EndpointSet endpointSet_;
    private final String adql_;
    private final Map<String, String> stringMap_;
    private final Map<String, HttpStreamParam> streamMap_;
    private final long uploadLimit_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    public static final DataFormat DFLT_UPLOAD_SER = DataFormat.TABLEDATA;

    private TapQuery(EndpointSet endpointSet, String adql, Map<String, String> extraParams, long uploadLimit) {
        this.endpointSet_ = endpointSet;
        this.adql_ = adql;
        this.uploadLimit_ = uploadLimit;
        this.stringMap_ = new LinkedHashMap<String, String>();
        this.stringMap_.put("REQUEST", "doQuery");
        this.stringMap_.put("LANG", "ADQL");
        this.stringMap_.put("QUERY", adql);
        if (extraParams != null) {
            this.stringMap_.putAll(extraParams);
        }
        this.streamMap_ = new LinkedHashMap<String, HttpStreamParam>();
    }

    public TapQuery(EndpointSet endpointSet, String adql, Map<String, String> extraParams) {
        this(endpointSet, adql, extraParams, -1L);
    }

    public TapQuery(EndpointSet endpointSet, String adql, Map<String, String> extraParams, Map<String, StarTable> uploadMap, long uploadLimit, VOTableWriter vowriter) throws IOException {
        this(endpointSet, adql, extraParams, uploadLimit);
        StringBuffer ubuf = new StringBuffer();
        if (uploadMap != null) {
            if (vowriter == null) {
                vowriter = new VOTableWriter(DFLT_UPLOAD_SER, true, VOTableVersion.V12);
            }
            for (Map.Entry<String, StarTable> upload : uploadMap.entrySet()) {
                String tname = upload.getKey();
                String tlabel = TapQuery.toParamLabel(tname);
                StarTable table = upload.getValue();
                if (ubuf.length() != 0) {
                    ubuf.append(';');
                }
                ubuf.append(tname).append(',').append("param:").append(tlabel);
                HttpStreamParam streamParam = TapQuery.createUploadStreamParam(table, uploadLimit, vowriter);
                this.streamMap_.put(tlabel, streamParam);
                logger_.info("Preparing upload parameter " + tlabel + " using VOTable serializer " + vowriter);
            }
        }
        if (ubuf.length() > 0) {
            this.stringMap_.put("UPLOAD", ubuf.toString());
        }
    }

    public TapQuery(URL serviceUrl, String adql, Map<String, String> extraParams) {
        this(Endpoints.createDefaultTapEndpointSet(serviceUrl), adql, extraParams);
    }

    public String getAdql() {
        return this.adql_;
    }

    public EndpointSet getEndpointSet() {
        return this.endpointSet_;
    }

    public Map<String, String> getStringParams() {
        return this.stringMap_;
    }

    public Map<String, HttpStreamParam> getStreamParams() {
        return this.streamMap_;
    }

    public StarTable executeSync(StoragePolicy storage, ContentCoding coding) throws IOException {
        return TapQuery.readResultVOTable(this.createSyncConnection(coding), coding, storage);
    }

    public boolean executeSync(TableSink sink, ContentCoding coding) throws IOException, SAXException {
        return TapQuery.streamResultVOTable(this.createSyncConnection(coding), coding, sink);
    }

    public HttpURLConnection createSyncConnection(ContentCoding coding) throws IOException {
        URL url = this.endpointSet_.getSyncEndpoint();
        if (url == null) {
            throw new IOException("No known sync endpoint?");
        }
        return UwsJob.postForm(url, coding, this.stringMap_, this.streamMap_);
    }

    public UwsJob submitAsync() throws IOException {
        URL url = this.endpointSet_.getAsyncEndpoint();
        if (url == null) {
            throw new IOException("No known async endpoint?");
        }
        try {
            return UwsJob.createJob(url.toString(), this.stringMap_, this.streamMap_);
        }
        catch (UwsJob.UnexpectedResponseException e) {
            throw TapQuery.asIOException(e, "Synchronous might work?");
        }
    }

    public static URL waitForResultUrl(UwsJob uwsJob, long pollMillis) throws IOException, InterruptedException {
        UwsJobInfo info = uwsJob.waitForFinish(pollMillis);
        String phase = info.getPhase();
        assert (UwsStage.forPhase(phase) == UwsStage.FINISHED);
        if ("COMPLETED".equals(phase)) {
            return new URL(uwsJob.getJobUrl() + "/results/result");
        }
        if ("ABORTED".equals(phase)) {
            throw new IOException("TAP query did not complete (" + phase + ")");
        }
        if ("ERROR".equals(phase)) {
            String errText = null;
            URL errUrl = new URL(uwsJob.getJobUrl() + "/error");
            logger_.info("Read error VOTable from " + errUrl);
            try {
                errText = TapQuery.readErrorInfo(errUrl.openStream());
            }
            catch (Throwable e) {
                throw (IOException)new IOException("TAP Execution error (can't get detail)").initCause(e);
            }
            throw new IOException("TAP execution error: " + errText);
        }
        throw new IOException("Unknown UWS execution phase " + phase);
    }

    public static StarTable waitForResult(UwsJob uwsJob, ContentCoding coding, StoragePolicy storage, long pollMillis) throws IOException, InterruptedException {
        URL resultUrl;
        try {
            resultUrl = TapQuery.waitForResultUrl(uwsJob, pollMillis);
        }
        catch (UwsJob.UnexpectedResponseException e) {
            throw TapQuery.asIOException(e, null);
        }
        return TapQuery.readResultVOTable(coding.openConnection(resultUrl), coding, storage);
    }

    public static StarTable getResult(UwsJob uwsJob, ContentCoding coding, StoragePolicy storage) throws IOException {
        URL url = new URL(uwsJob.getJobUrl() + "/results/result");
        return TapQuery.readResultVOTable(coding.openConnection(url), coding, storage);
    }

    public static <T> T scalarQuery(EndpointSet endpointSet, String adql, Class<T> clazz) throws IOException {
        TapQuery tq = new TapQuery(endpointSet, adql, null);
        StarTable result = tq.executeSync(StoragePolicy.PREFER_MEMORY, ContentCoding.NONE);
        int ncol = result.getColumnCount();
        if (ncol != 1) {
            throw new IOException("Unexpected column count: " + ncol + " != 1");
        }
        long nrow = (result = Tables.randomTable(result)).getRowCount();
        if (nrow == 0L) {
            return null;
        }
        if (nrow == 1L) {
            Object cell = result.getCell(0L, 0);
            if (cell == null || clazz.isInstance(cell)) {
                T tcell = clazz.cast(cell);
                return tcell;
            }
            throw new IOException("Unexpected type " + cell.getClass().getName() + " not " + clazz.getName());
        }
        throw new IOException("Unexpected row count: " + nrow + " > 0 ");
    }

    private static String readErrorInfo(InputStream in) throws IOException {
        try {
            Document errDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new BufferedInputStream(in));
            XPath xpath = XPathFactory.newInstance().newXPath();
            return xpath.evaluate("VOTABLE/RESOURCE[@type='results']/INFO[@name='QUERY_STATUS']/text()", errDoc);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("Error doc parse failure").initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Error doc parse failure").initCause(e);
        }
        catch (XPathException e) {
            throw (IOException)new IOException("Error doc parse failure").initCause(e);
        }
    }

    private static IOException asIOException(UwsJob.UnexpectedResponseException error, String extra) {
        InputStream bodyIn;
        HttpURLConnection hconn = error.getConnection();
        try {
            bodyIn = hconn.getInputStream();
        }
        catch (IOException e) {
            bodyIn = hconn.getErrorStream();
        }
        String errMsg = null;
        if (bodyIn != null) {
            try {
                errMsg = TapQuery.readErrorInfo(bodyIn);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (errMsg == null || errMsg.length() == 0) {
            errMsg = error.getMessage();
        }
        if (extra != null && extra.length() > 0) {
            errMsg = errMsg + " -  " + extra;
        }
        return (IOException)new IOException(errMsg).initCause(error);
    }

    private static String toParamLabel(String tname) {
        return "upload_" + tname.replaceAll("[^a-zA-Z0-9]", "");
    }

    private static HttpStreamParam createUploadStreamParam(final StarTable table, long uploadLimit, final VOTableWriter vowriter) throws IOException {
        final LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
        headerMap.put("Content-Type", "application/x-votable+xml");
        if (uploadLimit < 0L) {
            return new HttpStreamParam(){

                @Override
                public Map<String, String> getHttpHeaders() {
                    return headerMap;
                }

                @Override
                public void writeContent(OutputStream out) throws IOException {
                    vowriter.writeStarTable(table, out);
                }

                @Override
                public long getContentLength() {
                    return -1L;
                }
            };
        }
        LimitByteStore hbuf = new LimitByteStore(new DiscardByteStore(), uploadLimit);
        OutputStream tout = hbuf.getOutputStream();
        vowriter.writeStarTable(table, tout);
        tout.close();
        final long count = hbuf.getLength();
        assert (count <= uploadLimit);
        return new HttpStreamParam(){

            @Override
            public Map<String, String> getHttpHeaders() {
                return headerMap;
            }

            @Override
            public void writeContent(OutputStream out) throws IOException {
                vowriter.writeStarTable(table, out);
            }

            @Override
            public long getContentLength() {
                return count;
            }
        };
    }

    public static StarTable readResultVOTable(URLConnection conn, ContentCoding coding, StoragePolicy storage) throws IOException {
        TableElement tableEl;
        String status;
        VOElement voEl;
        int headSize = 2048;
        HeadBufferInputStream in = new HeadBufferInputStream(TapQuery.getVOTableStream(conn, coding), headSize);
        try {
            voEl = new VOElementFactory(storage).makeVOElement((InputStream)in, conn.getURL().toString());
        }
        catch (SAXException e) {
            StringBuffer sbuf = new StringBuffer().append("TAP response is not a VOTable");
            byte[] buf = in.getHeadBuffer();
            int nb = Math.min(in.getReadCount(), buf.length);
            if (nb > 0) {
                sbuf.append(" - ").append(new String(buf, 0, nb, "UTF-8"));
                if (nb == buf.length) {
                    sbuf.append(" ...");
                }
            }
            throw (IOException)new IOException(sbuf.toString()).initCause(e);
        }
        finally {
            in.close();
        }
        VOElement[] resourceEls = voEl.getChildrenByName("RESOURCE");
        VOElement resultsEl = null;
        for (int ie = 0; ie < resourceEls.length; ++ie) {
            VOElement el = resourceEls[ie];
            if (!"results".equals(el.getAttribute("type"))) continue;
            resultsEl = el;
        }
        if (resultsEl == null) {
            if (resourceEls.length == 1) {
                resultsEl = resourceEls[0];
                logger_.warning("TAP response document RESOURCE element not marked type='results'");
            } else {
                throw new IOException("No RESOURCE with type='results'");
            }
        }
        VOElement[] infoEls = resultsEl.getChildrenByName("INFO");
        VOElement statusEl = null;
        for (int ie = 0; statusEl == null && ie < infoEls.length; ++ie) {
            VOElement el = infoEls[ie];
            if (!"QUERY_STATUS".equals(el.getAttribute("name"))) continue;
            statusEl = el;
        }
        String string = status = statusEl != null ? statusEl.getAttribute("value") : null;
        if ("ERROR".equals(status)) {
            throw new IOException(DOMUtils.getTextContent(statusEl));
        }
        if (!"OK".equals(status)) {
            logger_.warning("Missing/incorrect <INFO name='QUERY_STATUS'> element in TAP response");
        }
        if ((tableEl = (TableElement)resultsEl.getChildByName("TABLE")) == null) {
            throw new IOException("No TABLE in results resource");
        }
        return new VOStarTable(tableEl);
    }

    public static boolean streamResultVOTable(URLConnection conn, ContentCoding coding, TableSink sink) throws IOException, SAXException {
        InputStream in = TapQuery.getVOTableStream(conn, coding);
        boolean overflow = DalResultStreamer.streamResultTable(new InputSource(in), sink);
        return overflow;
    }

    public static InputStream getVOTableStream(URLConnection conn, ContentCoding coding) throws IOException {
        conn = TapQuery.followRedirects(conn);
        try {
            return coding.getInputStream(conn);
        }
        catch (IOException e) {
            byte[] buf;
            int count;
            InputStream errStrm = coding.getErrorStream(conn);
            if (TapQuery.isVOTableType(conn.getContentType()) && errStrm != null) {
                return errStrm;
            }
            StringBuffer sbuf = new StringBuffer().append("Non-VOTable service error response");
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)conn;
                sbuf.append(" ").append(hconn.getResponseCode()).append(": ").append(hconn.getResponseMessage());
            }
            if (errStrm != null && (count = errStrm.read(buf = new byte[2048])) > 0) {
                sbuf.append(" - ").append(new String(buf, 0, count, "UTF-8"));
                if (errStrm.read() >= 0) {
                    sbuf.append(" ...");
                }
            }
            try {
                errStrm.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw (IOException)new IOException(sbuf.toString()).initCause(e);
        }
    }

    private static boolean isVOTableType(String contentType) {
        if (contentType == null) {
            return true;
        }
        String ctype = contentType.trim().toLowerCase();
        return ctype.indexOf("xml") >= 0 || ctype.indexOf("votable") >= 0;
    }

    public static URLConnection followRedirects(URLConnection conn) throws IOException {
        if (!(conn instanceof HttpURLConnection)) {
            return conn;
        }
        HttpURLConnection hconn = (HttpURLConnection)conn;
        HashSet<URL> urlSet = new HashSet<URL>();
        urlSet.add(hconn.getURL());
        while (hconn.getResponseCode() == 303) {
            URL url1;
            URL url0 = hconn.getURL();
            String loc = hconn.getHeaderField("Location");
            if (loc == null || loc.trim().length() == 0) {
                throw new IOException("No Location field for 303 response from " + url0);
            }
            try {
                url1 = new URL(loc);
            }
            catch (MalformedURLException e) {
                throw (IOException)new IOException("Bad Location field for 303 response from " + url0).initCause(e);
            }
            if (!urlSet.add(url1)) {
                throw new IOException("Recursive 303 redirect at " + url1);
            }
            logger_.info("HTTP 303 redirect to " + url1);
            URLConnection conn1 = url1.openConnection();
            if (!(conn1 instanceof HttpURLConnection)) {
                return conn1;
            }
            String acceptEncoding = hconn.getRequestProperty("Accept-Encoding");
            hconn = (HttpURLConnection)conn1;
            if (acceptEncoding == null) continue;
            hconn.setRequestProperty("Accept-Encoding", acceptEncoding);
        }
        return hconn;
    }
}

