/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import adql.db.exception.UnresolvedIdentifiersException;
import adql.parser.ParseException;
import adql.parser.TokenMgrError;
import adql.query.TextPosition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import uk.ac.starlink.util.gui.ComboBoxBumper;
import uk.ac.starlink.vo.AbstractAdqlExample;
import uk.ac.starlink.vo.AdqlExample;
import uk.ac.starlink.vo.AdqlValidator;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.DaliExample;
import uk.ac.starlink.vo.DataModelAdqlExample;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.ResultHandler;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetPanel;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapCapabilityPanel;
import uk.ac.starlink.vo.TapExampleLine;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapServiceKit;
import uk.ac.starlink.vo.UrlHandler;

public class TapQueryPanel
extends JPanel {
    private final TableSetPanel tmetaPanel_;
    private final TapCapabilityPanel tcapPanel_;
    private final Action examplesAct_;
    private final Action parseErrorAct_;
    private final JPopupMenu examplesMenu_;
    private final JMenu daliExampleMenu_;
    private final JTabbedPane textTabber_;
    private final JComponent controlBox_;
    private final TapExampleLine exampleLine_;
    private final CaretListener caretForwarder_;
    private final List<CaretListener> caretListeners_;
    private final Map<ParseTextArea, UndoManager> undoerMap_;
    private final AdqlTextAction clearAct_;
    private final AdqlTextAction interpolateColumnsAct_;
    private final AdqlTextAction interpolateTableAct_;
    private final Action undoAct_;
    private final Action redoAct_;
    private final Action addTabAct_;
    private final Action copyTabAct_;
    private final Action removeTabAct_;
    private final Action titleTabAct_;
    private final DelegateAction prevExampleAct_;
    private final DelegateAction nextExampleAct_;
    private TapServiceKit serviceKit_;
    private Throwable parseError_;
    private AdqlValidator.ValidatorTable[] extraTables_;
    private AdqlValidator validator_;
    private ParseTextArea textPanel_;
    private int iCustomExampleMenu_;
    private int iTab_;
    private UndoManager undoer_;
    private static final KeyStroke[] UNDO_KEYS = new KeyStroke[]{KeyStroke.getKeyStroke(90, 2), KeyStroke.getKeyStroke(90, 4)};
    private static final KeyStroke[] REDO_KEYS = new KeyStroke[]{KeyStroke.getKeyStroke(90, 3), KeyStroke.getKeyStroke(90, 5), KeyStroke.getKeyStroke(89, 2)};
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TapQueryPanel(UrlHandler urlHandler) {
        super(new BorderLayout());
        this.tmetaPanel_ = new TableSetPanel(urlHandler);
        this.tmetaPanel_.addPropertyChangeListener("schemas", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TapQueryPanel.this.validator_ = null;
                TapQueryPanel.this.validateAdql();
            }
        });
        this.tcapPanel_ = new TapCapabilityPanel();
        this.textTabber_ = new JTabbedPane();
        this.textTabber_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TapQueryPanel.this.updateTextTab();
            }
        });
        this.undoerMap_ = new HashMap<ParseTextArea, UndoManager>();
        UndoManager undoer0 = new UndoManager();
        undoer0.setLimit(0);
        this.undoerMap_.put(null, undoer0);
        this.undoer_ = undoer0;
        this.undoAct_ = new AbstractAction("Undo", ResourceIcon.ADQL_UNDO){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    TapQueryPanel.this.undoer_.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
                TapQueryPanel.this.updateUndoState();
            }
        };
        this.undoAct_.putValue("ShortDescription", "Undo most recent edit to text");
        this.undoAct_.putValue("AcceleratorKey", UNDO_KEYS[0]);
        this.redoAct_ = new AbstractAction("Redo", ResourceIcon.ADQL_REDO){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    TapQueryPanel.this.undoer_.redo();
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
                TapQueryPanel.this.updateUndoState();
            }
        };
        this.redoAct_.putValue("ShortDescription", "Redo most recently undone edit to text");
        this.redoAct_.putValue("AcceleratorKey", REDO_KEYS[0]);
        this.addTabAct_ = new AbstractAction("Add Tab", ResourceIcon.ADQL_ADDTAB){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TapQueryPanel.this.addTextTab();
            }
        };
        this.addTabAct_.putValue("ShortDescription", "Add a new ADQL entry tab");
        this.copyTabAct_ = new AbstractAction("Copy Tab", ResourceIcon.ADQL_COPYTAB){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String text = TapQueryPanel.this.textPanel_ == null ? null : TapQueryPanel.this.textPanel_.getText();
                TapQueryPanel.this.addTextTab();
                TapQueryPanel.this.textPanel_.setText(text);
            }
        };
        this.copyTabAct_.putValue("ShortDescription", "Add a new ADQL entry tab, with initial content copied from the currently visible one");
        this.removeTabAct_ = new AbstractAction("Remove Tab", ResourceIcon.ADQL_REMOVETAB){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (TapQueryPanel.this.textTabber_.getTabCount() > 1) {
                    TapQueryPanel.this.undoerMap_.remove(TapQueryPanel.this.textPanel_);
                    TapQueryPanel.this.textTabber_.removeTabAt(TapQueryPanel.this.textTabber_.getSelectedIndex());
                }
                TapQueryPanel.this.updateTextTab();
            }
        };
        this.removeTabAct_.putValue("ShortDescription", "Delete the currently visible ADQL entry tab");
        this.titleTabAct_ = new AbstractAction("Title Tab", ResourceIcon.ADQL_TITLETAB){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String title;
                Object response;
                int itab = TapQueryPanel.this.textTabber_.getSelectedIndex();
                if (itab >= 0 && (response = JOptionPane.showInputDialog(TapQueryPanel.this, "Tab Title", "Re-title Edit Tab", 3, null, null, TapQueryPanel.this.textTabber_.getTitleAt(itab))) instanceof String && (title = ((String)response).trim()).length() > 0) {
                    TapQueryPanel.this.textTabber_.setTitleAt(itab, title);
                }
            }
        };
        this.titleTabAct_.putValue("ShortDescription", "Re-title the currently visible ADQL entry tab");
        this.parseErrorAct_ = new AbstractAction("Parse Errors", ResourceIcon.ADQL_ERROR){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TapQueryPanel.this.showParseError();
            }
        };
        this.parseErrorAct_.putValue("ShortDescription", "Show details of error parsing current query text");
        this.clearAct_ = new AdqlTextAction("Clear", true);
        this.clearAct_.putValue("SmallIcon", ResourceIcon.ADQL_CLEAR);
        this.clearAct_.putValue("ShortDescription", "Delete currently visible ADQL text from editor");
        this.clearAct_.setAdqlText("");
        this.clearAct_.setEnabled(false);
        this.caretListeners_ = new ArrayList<CaretListener>();
        this.caretForwarder_ = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                TapQueryPanel.this.clearAct_.setEnabled(TapQueryPanel.this.textPanel_.getDocument().getLength() > 0);
                TapQueryPanel.this.validateAdql();
                for (CaretListener l : TapQueryPanel.this.caretListeners_) {
                    l.caretUpdate(evt);
                }
            }
        };
        this.interpolateTableAct_ = new AdqlTextAction("Insert Table", false);
        this.interpolateTableAct_.putValue("SmallIcon", ResourceIcon.ADQL_INSERTTABLE);
        this.interpolateTableAct_.putValue("ShortDescription", "Insert name of currently selected table into ADQL text panel");
        this.tmetaPanel_.addPropertyChangeListener("selectedTable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableMeta tmeta = TapQueryPanel.this.tmetaPanel_.getSelectedTable();
                String txt = tmeta == null ? null : tmeta.getName();
                TapQueryPanel.this.interpolateTableAct_.setAdqlText(txt);
            }
        });
        this.interpolateColumnsAct_ = new AdqlTextAction("Insert Columns", false);
        this.interpolateColumnsAct_.putValue("SmallIcon", ResourceIcon.ADQL_INSERTCOLS);
        this.interpolateColumnsAct_.putValue("ShortDescription", "Insert names of currently selected columns into ADQL text panel");
        this.tmetaPanel_.addPropertyChangeListener("selectedColumns", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ColumnMeta[] cmetas = TapQueryPanel.this.tmetaPanel_.getSelectedColumns();
                StringBuffer sbuf = new StringBuffer();
                for (int i = 0; i < cmetas.length; ++i) {
                    if (i > 0) {
                        sbuf.append(", ");
                    }
                    sbuf.append(cmetas[i].getName());
                }
                String txt = sbuf.length() == 0 ? null : sbuf.toString();
                TapQueryPanel.this.interpolateColumnsAct_.setAdqlText(txt);
            }
        });
        this.daliExampleMenu_ = new JMenu("Service-Provided");
        this.setDaliExamples(null);
        this.examplesMenu_ = new JPopupMenu("Examples");
        this.examplesMenu_.add(this.createExampleMenu("Basic", AbstractAdqlExample.createSomeExamples()));
        this.iCustomExampleMenu_ = this.examplesMenu_.getSubElements().length;
        this.examplesMenu_.add(this.daliExampleMenu_);
        this.examplesMenu_.add(this.createExampleMenu("TAP_SCHEMA", AbstractAdqlExample.createTapSchemaExamples()));
        this.examplesMenu_.add(this.createExampleMenu("ObsTAP", DataModelAdqlExample.createObsTapExamples()));
        this.examplesMenu_.add(this.createExampleMenu("RegTAP", DataModelAdqlExample.createRegTapExamples()));
        this.examplesAct_ = new AbstractAction("Examples"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object src = evt.getSource();
                if (src instanceof Component) {
                    Component comp = (Component)src;
                    TapQueryPanel.this.configureExamples();
                    TapQueryPanel.this.examplesMenu_.show(comp, 0, 0);
                }
            }
        };
        this.examplesAct_.putValue("ShortDescription", "Choose from example ADQL queries");
        this.exampleLine_ = new TapExampleLine(urlHandler);
        this.prevExampleAct_ = new DelegateAction(null, ComboBoxBumper.DEC_ICON, "Previous example in group");
        this.nextExampleAct_ = new DelegateAction(null, ComboBoxBumper.INC_ICON, "Next example in group");
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                TapQueryPanel.this.exampleLine_.setExample(null, null);
                TapQueryPanel.this.prevExampleAct_.setDelegate(null);
                TapQueryPanel.this.nextExampleAct_.setDelegate(null);
            }
        });
        Box exampleBox = Box.createHorizontalBox();
        exampleBox.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        exampleBox.add(new JButton(this.examplesAct_));
        exampleBox.add(Box.createHorizontalStrut(5));
        exampleBox.add(TapQueryPanel.createIconButton(this.prevExampleAct_));
        exampleBox.add(Box.createHorizontalStrut(2));
        exampleBox.add(TapQueryPanel.createIconButton(this.nextExampleAct_));
        exampleBox.add(Box.createHorizontalStrut(5));
        exampleBox.add(this.exampleLine_);
        this.addTextTab();
        this.setParseError(null);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        for (Action act : this.getEditActions()) {
            toolbar.add(act);
        }
        this.controlBox_ = Box.createHorizontalBox();
        Box buttLine = Box.createHorizontalBox();
        buttLine.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 0));
        buttLine.add(this.controlBox_);
        buttLine.add(Box.createHorizontalGlue());
        buttLine.add(toolbar);
        JPanel adqlPanel = new JPanel(new BorderLayout());
        adqlPanel.add((Component)buttLine, "North");
        adqlPanel.add((Component)this.textTabber_, "Center");
        adqlPanel.add((Component)exampleBox, "South");
        JPanel qPanel = new JPanel(new BorderLayout());
        qPanel.add((Component)this.tcapPanel_, "North");
        qPanel.add((Component)adqlPanel, "Center");
        JSplitPane splitter = new JSplitPane(0);
        JPanel servicePanel = new JPanel(new BorderLayout());
        servicePanel.add((Component)this.tmetaPanel_, "Center");
        adqlPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "ADQL Text"));
        servicePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Metadata"));
        this.tcapPanel_.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Service Capabilities"));
        splitter.setTopComponent(servicePanel);
        splitter.setBottomComponent(qPanel);
        servicePanel.setPreferredSize(new Dimension(500, 500));
        adqlPanel.setPreferredSize(new Dimension(500, 200));
        splitter.setResizeWeight(0.6);
        this.add((Component)splitter, "Center");
    }

    public TapCapabilityPanel getCapabilityPanel() {
        return this.tcapPanel_;
    }

    public String getAdql() {
        return this.textPanel_.getText().replaceFirst("\\s*\\Z", "");
    }

    public void setServiceKit(final TapServiceKit serviceKit) {
        this.serviceKit_ = serviceKit;
        this.validator_ = null;
        this.tmetaPanel_.setServiceKit(serviceKit);
        if (serviceKit != null) {
            serviceKit.acquireCapability(new ResultHandler<TapCapability>(){

                @Override
                public boolean isActive() {
                    return TapQueryPanel.this.serviceKit_ == serviceKit;
                }

                @Override
                public void showWaiting() {
                    TapQueryPanel.this.tcapPanel_.setCapability(null);
                    TapQueryPanel.this.tmetaPanel_.setCapability(null);
                    TapQueryPanel.this.validator_ = null;
                }

                @Override
                public void showResult(TapCapability tcap) {
                    TapQueryPanel.this.tcapPanel_.setCapability(tcap);
                    TapQueryPanel.this.tmetaPanel_.setCapability(tcap);
                    TapQueryPanel.this.validator_ = null;
                }

                @Override
                public void showError(IOException error) {
                    logger_.log(Level.WARNING, "Failed to acquire TAP service capability information: " + error, error);
                }
            });
            serviceKit.acquireExamples(new ResultHandler<DaliExample[]>(){

                @Override
                public boolean isActive() {
                    return TapQueryPanel.this.serviceKit_ == serviceKit;
                }

                @Override
                public void showWaiting() {
                    TapQueryPanel.this.setDaliExamples(null);
                }

                @Override
                public void showResult(DaliExample[] daliExamples) {
                    TapQueryPanel.this.setDaliExamples(daliExamples);
                }

                @Override
                public void showError(IOException error) {
                    logger_.info("No TAP examples: " + error);
                    TapQueryPanel.this.setDaliExamples(new DaliExample[0]);
                }
            });
        }
    }

    public void setExtraTables(AdqlValidator.ValidatorTable[] extraTables) {
        this.extraTables_ = extraTables;
        this.validator_ = null;
        this.validateAdql();
    }

    public Action[] getEditActions() {
        return new Action[]{this.addTabAct_, this.copyTabAct_, this.removeTabAct_, this.titleTabAct_, this.clearAct_, this.undoAct_, this.redoAct_, this.interpolateTableAct_, this.interpolateColumnsAct_, this.parseErrorAct_};
    }

    public void addControl(JComponent comp) {
        this.controlBox_.add(comp);
    }

    public void addCaretListener(CaretListener listener) {
        this.caretListeners_.add(listener);
    }

    public void removeCaretListener(CaretListener listener) {
        this.caretListeners_.remove(listener);
    }

    public void addCustomExamples(String menuName, AdqlExample[] examples) {
        this.examplesMenu_.insert(this.createExampleMenu(menuName, examples), this.iCustomExampleMenu_++);
        this.configureExamples();
    }

    private JMenu createExampleMenu(String name, AdqlExample[] examples) {
        final int nex = examples.length;
        final AdqlExampleAction[] exActs = new AdqlExampleAction[nex];
        int i = 0;
        while (i < nex) {
            final int iex = i++;
            final AdqlExample ex = examples[iex];
            final String label = name + " " + (iex + 1) + "/" + nex;
            exActs[iex] = new AdqlExampleAction(ex){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    super.actionPerformed(evt);
                    TapQueryPanel.this.exampleLine_.setExample(ex, label);
                    if (iex > 0) {
                        TapQueryPanel.this.prevExampleAct_.setDelegate(exActs[iex - 1]);
                    }
                    if (iex < nex - 1) {
                        TapQueryPanel.this.nextExampleAct_.setDelegate(exActs[iex + 1]);
                    }
                }
            };
        }
        JMenu menu = new JMenu(name);
        for (AdqlExampleAction act : exActs) {
            menu.add(act);
        }
        return menu;
    }

    private void configureExamples() {
        TableMeta[] tables;
        String lang = this.tcapPanel_.getQueryLanguageName();
        TapCapability tcap = this.tcapPanel_.getCapability();
        SchemaMeta[] schemas = this.tmetaPanel_.getSchemas();
        if (schemas != null) {
            ArrayList<TableMeta> tlist = new ArrayList<TableMeta>();
            for (SchemaMeta schema : schemas) {
                tlist.addAll(Arrays.asList(schema.getTables()));
            }
            tables = tlist.toArray(new TableMeta[0]);
        } else {
            tables = null;
        }
        TableMeta table = this.tmetaPanel_.getSelectedTable();
        TapQueryPanel.configureExamples(this.examplesMenu_, lang, tcap, tables, table);
    }

    private static int configureExamples(MenuElement menu, String lang, TapCapability tcap, TableMeta[] tables, TableMeta table) {
        int nActive = 0;
        for (MenuElement el : menu.getSubElements()) {
            Action act;
            if (el instanceof JMenuItem && (act = ((JMenuItem)el).getAction()) instanceof AdqlExampleAction) {
                AdqlExampleAction exAct = (AdqlExampleAction)act;
                String adql = exAct.getExample().getText(true, lang, tcap, tables, table);
                exAct.setAdqlText(adql);
                if (exAct.isEnabled()) {
                    ++nActive;
                }
            }
            int nSubActive = TapQueryPanel.configureExamples(el, lang, tcap, tables, table);
            if (el instanceof JMenu) {
                ((JMenu)el).setEnabled(nSubActive > 0);
            }
            nActive += nSubActive;
        }
        return nActive;
    }

    private void setDaliExamples(DaliExample[] daliExamples) {
        JMenu menu = this.daliExampleMenu_;
        menu.removeAll();
        menu.setEnabled(daliExamples != null && daliExamples.length > 0);
        if (daliExamples != null) {
            int nex = daliExamples.length;
            AdqlExample[] adqlExamples = new AdqlExample[nex];
            for (int iex = 0; iex < nex; ++iex) {
                final DaliExample daliEx = daliExamples[iex];
                String name = daliEx.getName();
                final String adql = this.getExampleQueryText(daliEx);
                adqlExamples[iex] = new AbstractAdqlExample(name, null){

                    @Override
                    public String getText(boolean lineBreaks, String lang, TapCapability tcap, TableMeta[] tables, TableMeta table) {
                        return adql;
                    }

                    @Override
                    public URL getInfoUrl() {
                        return daliEx.getUrl();
                    }
                };
            }
            JMenu dummyMenu = this.createExampleMenu(menu.getText(), adqlExamples);
            while (dummyMenu.getItemCount() > 0) {
                JMenuItem item = dummyMenu.getItem(0);
                dummyMenu.remove(0);
                menu.add(item);
            }
        }
        this.tmetaPanel_.setHasExamples(daliExamples != null && daliExamples.length > 0);
    }

    public String getExampleQueryText(DaliExample daliEx) {
        String propQuery = daliEx.getProperties().get("query");
        if (propQuery != null) {
            return propQuery;
        }
        String genericQuery = daliEx.getGenericParameters().get("QUERY");
        if (genericQuery != null) {
            return genericQuery;
        }
        return null;
    }

    private void validateAdql() {
        String text = this.textPanel_.getText();
        if (text.trim().length() > 0) {
            AdqlValidator validator = this.getValidator();
            try {
                validator.validate(text);
                this.setParseError(null);
            }
            catch (Throwable e) {
                this.setParseError(e);
            }
        } else {
            this.setParseError(null);
        }
    }

    private void addTextTab() {
        ParseTextArea textPanel = new ParseTextArea();
        textPanel.setEditable(true);
        textPanel.setFont(Font.decode("Monospaced"));
        InputMap inputMap = textPanel.getInputMap();
        for (KeyStroke key : UNDO_KEYS) {
            inputMap.put(key, this.undoAct_);
        }
        for (KeyStroke key : REDO_KEYS) {
            inputMap.put(key, this.redoAct_);
        }
        final UndoManager undoer = new UndoManager();
        textPanel.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undoer.addEdit(evt.getEdit());
                TapQueryPanel.this.updateUndoState();
            }
        });
        this.undoerMap_.put(textPanel, undoer);
        String tabName = Integer.toString(++this.iTab_);
        this.textTabber_.addTab(tabName, new JScrollPane(textPanel));
        this.textTabber_.setSelectedIndex(this.textTabber_.getTabCount() - 1);
        assert (this.textPanel_ == textPanel);
    }

    private void updateTextTab() {
        if (this.textPanel_ != null) {
            this.textPanel_.removeCaretListener(this.caretForwarder_);
        }
        this.textPanel_ = (ParseTextArea)((JScrollPane)this.textTabber_.getSelectedComponent()).getViewport().getView();
        this.textPanel_.addCaretListener(this.caretForwarder_);
        this.undoer_ = this.undoerMap_.get(this.textPanel_);
        Caret caret = this.textPanel_.getCaret();
        final int dot = caret.getDot();
        final int mark = caret.getMark();
        this.caretForwarder_.caretUpdate(new CaretEvent(this.textPanel_){

            @Override
            public int getDot() {
                return dot;
            }

            @Override
            public int getMark() {
                return mark;
            }
        });
        this.updateTabState();
        this.updateUndoState();
        this.validateAdql();
    }

    private void updateUndoState() {
        this.undoAct_.setEnabled(this.undoer_.canUndo());
        this.redoAct_.setEnabled(this.undoer_.canRedo());
    }

    private void updateTabState() {
        this.copyTabAct_.setEnabled(this.textPanel_ != null);
        this.removeTabAct_.setEnabled(this.textPanel_ != null && this.textTabber_.getTabCount() > 1);
        this.titleTabAct_.setEnabled(this.textTabber_.getSelectedIndex() >= 0);
    }

    private AdqlValidator getValidator() {
        if (this.validator_ == null) {
            ArrayList<AdqlValidator.ValidatorTable> vtList = new ArrayList<AdqlValidator.ValidatorTable>();
            SchemaMeta[] schemas = this.tmetaPanel_.getSchemas();
            if (schemas != null) {
                AdqlValidator.ValidatorTable[] serviceTables = this.createValidatorTables(schemas);
                vtList.addAll(Arrays.asList(serviceTables));
            }
            if (this.extraTables_ != null) {
                vtList.addAll(Arrays.asList(this.extraTables_));
            }
            AdqlValidator.ValidatorTable[] vtables = vtList.toArray(new AdqlValidator.ValidatorTable[0]);
            TapLanguage tapLang = this.tcapPanel_.getQueryLanguage();
            this.validator_ = AdqlValidator.createValidator(vtables, tapLang);
        }
        return this.validator_;
    }

    private AdqlValidator.ValidatorTable[] createValidatorTables(SchemaMeta[] schemas) {
        ArrayList<21> vtList = new ArrayList<21>();
        int nNoName = 0;
        for (SchemaMeta smeta : schemas) {
            final String sname = smeta.getName();
            for (TableMeta tmeta : smeta.getTables()) {
                final TableMeta tmeta0 = tmeta;
                final String tname = tmeta0.getName();
                if (tname != null && tname.trim().length() > 0) {
                    vtList.add(new AdqlValidator.ValidatorTable(){

                        @Override
                        public String getSchemaName() {
                            return sname;
                        }

                        @Override
                        public String getTableName() {
                            return tname;
                        }

                        @Override
                        public Collection<String> getColumnNames() {
                            ColumnMeta[] cmetas = tmeta0.getColumns();
                            if (cmetas != null) {
                                HashSet<String> list = new HashSet<String>();
                                for (ColumnMeta cmeta : cmetas) {
                                    list.add(cmeta.getName());
                                }
                                return list;
                            }
                            TapServiceKit serviceKit = TapQueryPanel.this.tmetaPanel_.getServiceKit();
                            if (serviceKit != null) {
                                serviceKit.onColumns(tmeta0, new Runnable(){

                                    @Override
                                    public void run() {
                                        TapQueryPanel.this.validateAdql();
                                    }
                                });
                            }
                            return null;
                        }
                    });
                    continue;
                }
                ++nNoName;
            }
        }
        if (nNoName > 0) {
            logger_.warning("Ignoring " + nNoName + " nameless tables");
        }
        return vtList.toArray(new AdqlValidator.ValidatorTable[0]);
    }

    private void showParseError() {
        if (this.parseError_ != null) {
            String msg = this.parseError_.getMessage();
            JOptionPane.showMessageDialog(this, msg, "ADQL Parse Error", 0);
        }
    }

    private void setParseError(Throwable parseError) {
        this.parseError_ = parseError;
        this.textPanel_.setParseError(parseError);
        this.parseErrorAct_.setEnabled(parseError != null);
    }

    private static JButton createIconButton(Action act) {
        JButton butt = new JButton(act){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, Integer.MAX_VALUE);
            }
        };
        butt.setMargin(new Insets(2, 2, 2, 2));
        return butt;
    }

    private class ParseTextArea
    extends JTextArea {
        private Rectangle[] errorRects_;
        private final Color highlighter_;

        public ParseTextArea() {
            super(new PlainDocument());
            this.highlighter_ = new Color(0x40FF0000, true);
            this.errorRects_ = new Rectangle[0];
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color col0 = g.getColor();
            g.setColor(this.highlighter_);
            if (this.errorRects_.length > 0) {
                for (int ir = 0; ir < this.errorRects_.length; ++ir) {
                    Rectangle erect = this.errorRects_[ir];
                    g.fillRect(erect.x, erect.y, erect.width, erect.height);
                }
            }
            g.setColor(col0);
        }

        public void setParseError(Throwable perr) {
            Object[] ers = this.toRectangles(perr);
            if (!Arrays.equals(this.errorRects_, ers)) {
                this.errorRects_ = ers;
                this.repaint();
            }
        }

        private Rectangle[] toRectangles(Throwable perr) {
            ArrayList<Rectangle> rectList = new ArrayList<Rectangle>();
            if (perr instanceof UnresolvedIdentifiersException) {
                UnresolvedIdentifiersException uerr = (UnresolvedIdentifiersException)perr;
                Rectangle rect = this.toRectangle(uerr);
                if (rect != null) {
                    rectList.add(rect);
                }
                for (ParseException pe : uerr) {
                    rectList.addAll(Arrays.asList(this.toRectangles(pe)));
                }
            } else if (perr instanceof ParseException) {
                Rectangle rect = this.toRectangle((ParseException)perr);
                if (rect != null) {
                    rectList.add(rect);
                }
            } else if (perr instanceof TokenMgrError) {
                Rectangle rect = this.toRectangle((TokenMgrError)perr);
                if (rect != null) {
                    rectList.add(rect);
                }
            } else if (perr != null) {
                logger_.log(Level.WARNING, "Unexpected parse exception: " + perr, perr);
            }
            return rectList.toArray(new Rectangle[0]);
        }

        private Rectangle toRectangle(ParseException perr) {
            TextPosition tpos;
            TextPosition textPosition = tpos = perr == null ? null : perr.getPosition();
            if (tpos == null) {
                return null;
            }
            Rectangle r0 = this.toRectangle(tpos.beginLine, tpos.beginColumn);
            Rectangle r1 = this.toRectangle(tpos.endLine, tpos.endColumn);
            if (r0 == null || r1 == null) {
                return null;
            }
            r0.add(r1);
            return r0;
        }

        private Rectangle toRectangle(TokenMgrError tmerr) {
            int iline = tmerr.getErrorLine();
            int icol = tmerr.getErrorColumn();
            Rectangle r0 = this.toRectangle(iline, icol);
            if (icol > 0) {
                r0.add(this.toRectangle(iline, icol - 1));
            }
            return r0;
        }

        private Rectangle toRectangle(int iline, int icol) {
            if (iline >= 0 && icol >= 0) {
                Element line = this.getDocument().getDefaultRootElement().getElement(iline - 1);
                int pos = line.getStartOffset() + (icol - 1);
                try {
                    return this.modelToView(pos);
                }
                catch (BadLocationException e) {
                    return null;
                }
            }
            return null;
        }
    }

    private class DelegateAction
    extends AbstractAction {
        private Action act_;

        DelegateAction(String name, Icon icon, String descrip) {
            super(name);
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", descrip);
            this.setDelegate(null);
        }

        public void setDelegate(Action act) {
            this.act_ = act;
            this.setEnabled(this.act_ != null);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.act_.actionPerformed(evt);
        }
    }

    private class AdqlExampleAction
    extends AdqlTextAction {
        private final AdqlExample example_;

        public AdqlExampleAction(AdqlExample example) {
            super(example.getName(), true);
            this.putValue("ShortDescription", example.getDescription());
            this.example_ = example;
        }

        public AdqlExample getExample() {
            return this.example_;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
        }
    }

    private class AdqlTextAction
    extends AbstractAction {
        private final boolean replace_;
        private String text_;

        public AdqlTextAction(String name, boolean replace) {
            super(name);
            this.replace_ = replace;
            this.setAdqlText(null);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.replace_) {
                TapQueryPanel.this.textPanel_.setText(this.text_);
                TapQueryPanel.this.textPanel_.setCaretPosition(0);
            } else {
                TapQueryPanel.this.textPanel_.insert(this.text_, TapQueryPanel.this.textPanel_.getCaretPosition());
            }
            TapQueryPanel.this.textPanel_.requestFocusInWindow();
        }

        public void setAdqlText(String text) {
            this.text_ = text;
            this.setEnabled(text != null);
        }
    }
}

