/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.MetaNameFixer;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapMetaReader;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapSchemaInterrogator;

public class TapSchemaTapMetaReader
implements TapMetaReader {
    private final TapSchemaInterrogator tsi_;
    private final boolean populateSchemas_;
    private final boolean populateTables_;
    private final MetaNameFixer fixer_;
    private final boolean addOrphanTables_;
    private final Object fkeyReadLock_;
    private Map<String, List<ForeignMeta>> fkeyMap_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TapSchemaTapMetaReader(EndpointSet endpointSet, int maxrec, ContentCoding coding, boolean populateSchemas, boolean populateTables, MetaNameFixer fixer, boolean preloadFkeys) {
        this.tsi_ = new TapSchemaInterrogator(endpointSet, maxrec, coding){

            @Override
            protected StarTable executeQuery(TapQuery tq) throws IOException {
                logger_.info(tq.getAdql());
                return super.executeQuery(tq);
            }
        };
        this.populateSchemas_ = populateSchemas;
        this.populateTables_ = populateTables;
        this.fixer_ = fixer == null ? MetaNameFixer.NONE : fixer;
        this.fkeyReadLock_ = preloadFkeys ? new Object() : null;
        this.addOrphanTables_ = true;
    }

    @Override
    public String getSource() {
        return this.tsi_.getEndpointSet().getIdentity();
    }

    @Override
    public String getMeans() {
        ArrayList<String> preList = new ArrayList<String>();
        preList.add("schemas");
        if (this.populateSchemas_) {
            preList.add("tables");
            if (this.populateTables_) {
                preList.add("columns");
                preList.add("fkeys");
            }
        }
        if (!preList.contains("fkeys") && this.fkeyReadLock_ != null) {
            preList.add("fkeys");
        }
        StringBuffer ibuf = new StringBuffer();
        for (String item : preList) {
            if (ibuf.length() != 0) {
                ibuf.append(", ");
            }
            ibuf.append(item);
        }
        return "TAP_SCHEMA queries; preload " + ibuf.toString();
    }

    @Override
    public SchemaMeta[] readSchemas() throws IOException {
        SchemaMeta[] schemas = this.tsi_.readSchemas(this.populateSchemas_, this.populateTables_, this.addOrphanTables_);
        this.fixer_.fixSchemas(schemas);
        return schemas;
    }

    @Override
    public TableMeta[] readTables(SchemaMeta schema) throws IOException {
        String whereClause = "schema_name = '" + schema.getName() + "'";
        List<TableMeta> tableList = this.tsi_.readList(TapSchemaInterrogator.TABLE_QUERIER, whereClause);
        if (this.populateTables_) {
            Map<String, List<ForeignMeta.Link>> lMap = this.tsi_.readMap(TapSchemaInterrogator.LINK_QUERIER, "NATURAL JOIN TAP_SCHEMA.keys JOIN TAP_SCHEMA.tables ON from_table = table_name " + whereClause);
            Map<String, List<ForeignMeta>> fMap = this.tsi_.readMap(TapSchemaInterrogator.FKEY_QUERIER, "JOIN TAP_SCHEMA.tables ON from_table = table_name " + whereClause);
            for (List<ForeignMeta> flist : fMap.values()) {
                for (ForeignMeta fmeta : flist) {
                    this.tsi_.populateForeignKey(fmeta, lMap);
                }
            }
            this.checkEmpty(lMap, "Foreign links");
            Map<String, List<ColumnMeta>> cMap = this.tsi_.readMap(TapSchemaInterrogator.COLUMN_QUERIER, "NATURAL JOIN TAP_SCHEMA.tables " + whereClause);
            for (TableMeta tmeta : tableList) {
                this.tsi_.populateTable(tmeta, fMap, cMap);
            }
            this.checkEmpty(fMap, "Foreign keys");
            this.checkEmpty(cMap, "Columns");
        }
        TableMeta[] tables = tableList.toArray(new TableMeta[0]);
        this.fixer_.fixTables(tables, schema);
        return tables;
    }

    @Override
    public ColumnMeta[] readColumns(TableMeta table) throws IOException {
        String whereClause = "WHERE table_name = '" + this.fixer_.getOriginalTableName(table) + "'";
        ColumnMeta[] columns = this.tsi_.readList(TapSchemaInterrogator.COLUMN_QUERIER, whereClause).toArray(new ColumnMeta[0]);
        this.fixer_.fixColumns(columns);
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForeignMeta[] readForeignKeys(TableMeta table) throws IOException {
        List<ForeignMeta> fkeyList;
        String tname = this.fixer_.getOriginalTableName(table);
        if (this.fkeyReadLock_ != null) {
            Object object = this.fkeyReadLock_;
            synchronized (object) {
                if (this.fkeyMap_ == null) {
                    Map<String, List<ForeignMeta.Link>> lMap = this.tsi_.readMap(TapSchemaInterrogator.LINK_QUERIER, null);
                    Map<String, List<ForeignMeta>> fMap = this.tsi_.readMap(TapSchemaInterrogator.FKEY_QUERIER, null);
                    for (List<ForeignMeta> flist : fMap.values()) {
                        for (ForeignMeta fmeta : flist) {
                            this.tsi_.populateForeignKey(fmeta, lMap);
                        }
                    }
                    this.checkEmpty(lMap, "Links");
                    this.fkeyMap_ = fMap;
                }
            }
            fkeyList = this.fkeyMap_.get(tname);
        } else {
            String whereClause = "WHERE from_table = '" + tname + "'";
            Map<String, List<ForeignMeta.Link>> lMap = this.tsi_.readMap(TapSchemaInterrogator.LINK_QUERIER, "NATURAL JOIN TAP_SCHEMA.keys " + whereClause);
            fkeyList = this.tsi_.readList(TapSchemaInterrogator.FKEY_QUERIER, whereClause);
            for (ForeignMeta fmeta : fkeyList) {
                this.tsi_.populateForeignKey(fmeta, lMap);
            }
            this.checkEmpty(lMap, "Foreign links");
        }
        return fkeyList == null ? new ForeignMeta[]{} : fkeyList.toArray(new ForeignMeta[0]);
    }

    private <T> void checkEmpty(Map<String, List<T>> map, String objType) {
        int nEntry = map.size();
        if (nEntry > 0) {
            logger_.warning("Schema interrogation: " + nEntry + " orphaned " + objType + " entries");
            logger_.info("Orphaned " + objType + "s: " + map.keySet());
        }
    }
}

