/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.vo.AndButton;
import uk.ac.starlink.vo.GlotsServiceFinder;
import uk.ac.starlink.vo.TapServiceFinder;
import uk.ac.starlink.vo.TapServiceTreeModel;

public class TapServiceFinderPanel
extends JPanel {
    private final JTextField keywordField_;
    private final AndButton andButton_;
    private final JTree sTree_;
    private final Action startAct_;
    private final Action cancelAct_;
    private final List<ActionListener> listeners_ = new ArrayList<ActionListener>();
    private final Map<TapServiceFinder.Target, JCheckBox> targetSelMap_;
    private final ExecutorService serviceReaderExecutor_ = Executors.newCachedThreadPool();
    private TapServiceFinder serviceFinder_;
    private Future<TapServiceFinder.Service[]> serviceReader_;
    private Thread activeWorker_;
    private TapServiceFinder.Service selectedService_;
    public static final String TAP_SERVICE_PROPERTY = "TAP_SERVICE_PROPERTY";

    public TapServiceFinderPanel() {
        super(new BorderLayout());
        this.startAct_ = new AbstractAction("Find Services"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (this.isEnabled()) {
                    TapServiceFinderPanel.this.setWorker(TapServiceFinderPanel.this.createQueryWorker(TapServiceFinderPanel.this.createConstraint()));
                }
            }
        };
        this.cancelAct_ = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TapServiceFinderPanel.this.setWorker(null);
            }
        };
        this.keywordField_ = new JTextField();
        this.keywordField_.addActionListener(this.startAct_);
        this.andButton_ = new AndButton(true);
        Box targetLine = Box.createHorizontalBox();
        targetLine.add(new JLabel("Match Fields: "));
        TapServiceFinder.Target[] targets = TapServiceFinder.Target.values();
        this.targetSelMap_ = new LinkedHashMap<TapServiceFinder.Target, JCheckBox>();
        for (TapServiceFinder.Target target : targets) {
            JCheckBox checkBox = new JCheckBox(target.getDisplayName());
            checkBox.setSelected(true);
            checkBox.setToolTipText("Match keywords against " + target.getDisplayName());
            targetLine.add(Box.createHorizontalStrut(5));
            targetLine.add(checkBox);
            this.targetSelMap_.put(target, checkBox);
        }
        targetLine.add(Box.createHorizontalGlue());
        this.sTree_ = new JTree();
        this.sTree_.setRootVisible(true);
        this.sTree_.setShowsRootHandles(false);
        this.sTree_.setCellRenderer(TapServiceTreeModel.createCellRenderer());
        final TreeSelectionModel selModel = this.sTree_.getSelectionModel();
        selModel.setSelectionMode(4);
        this.sTree_.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TapServiceFinderPanel.this.doctorSelection(selModel, evt);
            }
        });
        this.sTree_.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TapServiceFinder.Service oldService = TapServiceFinderPanel.this.selectedService_;
                TapServiceFinderPanel.this.selectedService_ = TapServiceTreeModel.getService(evt.getNewLeadSelectionPath());
                TapServiceFinderPanel.this.firePropertyChange(TapServiceFinderPanel.TAP_SERVICE_PROPERTY, oldService, TapServiceFinderPanel.this.selectedService_);
            }
        });
        this.sTree_.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2 && TapServiceFinderPanel.this.sTree_.getRowForLocation(evt.getX(), evt.getY()) >= 0) {
                    ActionEvent actEvt = new ActionEvent(this, 0, "click2");
                    for (ActionListener l : TapServiceFinderPanel.this.listeners_) {
                        l.actionPerformed(actEvt);
                    }
                }
            }
        });
        Box keywordLine = Box.createHorizontalBox();
        keywordLine.add(new JLabel("Keywords: "));
        keywordLine.add(this.keywordField_);
        keywordLine.add(Box.createHorizontalStrut(5));
        keywordLine.add(this.andButton_);
        Box buttLine = Box.createHorizontalBox();
        buttLine.add(Box.createHorizontalGlue());
        buttLine.add(new JButton(this.cancelAct_));
        buttLine.add(Box.createHorizontalStrut(5));
        buttLine.add(new JButton(this.startAct_));
        Box entryBox = Box.createVerticalBox();
        entryBox.add(keywordLine);
        entryBox.add(targetLine);
        entryBox.add(buttLine);
        entryBox.add(Box.createVerticalStrut(5));
        JScrollPane treePanel = new JScrollPane(this.sTree_);
        this.add((Component)entryBox, "North");
        this.add((Component)treePanel, "Center");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                if (TapServiceFinderPanel.this.serviceFinder_ == null) {
                    TapServiceFinderPanel.this.setServiceFinder(new GlotsServiceFinder());
                }
                TapServiceFinderPanel.this.removeAncestorListener(this);
            }

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.setTreeModel(null);
        this.setWorker(null);
    }

    public TapServiceFinder.Service getSelectedService() {
        return this.selectedService_;
    }

    public String getIvoid(URL serviceUrl) {
        TapServiceFinder.Service[] services = this.getServices();
        if (services != null && serviceUrl != null) {
            String surl = serviceUrl.toString();
            for (TapServiceFinder.Service service : services) {
                String ivoid;
                if (!surl.equals(service.getServiceUrl()) || (ivoid = service.getId()) == null) continue;
                return ivoid;
            }
        }
        return null;
    }

    public void addActionListener(ActionListener l) {
        this.listeners_.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners_.remove(l);
    }

    private TapServiceFinder.Service[] getServices() {
        Future<TapServiceFinder.Service[]> serviceReader = this.serviceReader_;
        if (serviceReader != null) {
            try {
                return serviceReader.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                return null;
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (TimeoutException e) {
                return null;
            }
        }
        return null;
    }

    public void setServiceFinder(final TapServiceFinder finder) {
        if (this.serviceReader_ != null) {
            this.serviceReader_.cancel(true);
        }
        this.serviceFinder_ = finder;
        this.serviceReader_ = this.serviceReaderExecutor_.submit(new Callable<TapServiceFinder.Service[]>(){

            @Override
            public TapServiceFinder.Service[] call() throws IOException {
                return finder.readAllServices();
            }
        });
        this.setWorker(this.createQueryWorker(this.createConstraint()));
    }

    public TapServiceFinder getServiceFinder() {
        return this.serviceFinder_;
    }

    private void setTreeModel(TreeModel treeModel) {
        this.sTree_.setModel(treeModel == null ? new TapServiceTreeModel(null) : treeModel);
    }

    private TapServiceFinder.Constraint createConstraint() {
        String wordTxt = this.keywordField_.getText();
        if (wordTxt == null || wordTxt.trim().length() == 0) {
            return null;
        }
        final String[] words = wordTxt.trim().split("\\s+");
        ArrayList<TapServiceFinder.Target> targetList = new ArrayList<TapServiceFinder.Target>();
        for (TapServiceFinder.Target target : this.targetSelMap_.keySet()) {
            if (!this.targetSelMap_.get((Object)target).isSelected()) continue;
            targetList.add(target);
        }
        final TapServiceFinder.Target[] targets = targetList.toArray(new TapServiceFinder.Target[0]);
        if (targets.length == 0) {
            return null;
        }
        final boolean isAnd = this.andButton_.isAnd();
        return new TapServiceFinder.Constraint(){

            @Override
            public String[] getKeywords() {
                return words;
            }

            @Override
            public TapServiceFinder.Target[] getTargets() {
                return targets;
            }

            @Override
            public boolean isAndKeywords() {
                return isAnd;
            }
        };
    }

    private Thread createQueryWorker(final TapServiceFinder.Constraint constraint) {
        return new Thread("TAP subject query"){
            private final Thread thisWorker;
            {
                super(x0);
                this.thisWorker = this;
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void submit(final Runnable r) {
                if (this.isActive()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (this.isActive()) {
                                r.run();
                            }
                        }
                    });
                }
            }

            private void showError(final String title, final Throwable err) {
                this.submit(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.showError(TapServiceFinderPanel.this, title, err);
                    }
                });
            }

            private boolean isActive() {
                return this == TapServiceFinderPanel.this.activeWorker_;
            }
        };
    }

    private void setWorker(Thread worker) {
        this.activeWorker_ = worker;
        if (worker != null) {
            worker.setDaemon(true);
            worker.start();
        }
        boolean hasWorker = this.activeWorker_ != null;
        this.cancelAct_.setEnabled(hasWorker);
        this.startAct_.setEnabled(!hasWorker);
    }

    private void doctorSelection(TreeSelectionModel selModel, TreeSelectionEvent evt) {
        TreePath newPath = evt.getNewLeadSelectionPath();
        if (newPath == null) {
            return;
        }
        TreePath servicePath = TapServiceTreeModel.getServicePath(newPath);
        HashSet<TreePath> currentPaths = new HashSet<TreePath>();
        TreePath[] cps = selModel.getSelectionPaths();
        if (cps != null) {
            currentPaths.addAll(Arrays.asList(cps));
        }
        HashSet<TreePath> pathsToAdd = new HashSet<TreePath>();
        HashSet<TreePath> pathsToRemove = new HashSet<TreePath>();
        if (servicePath != null && servicePath.equals(newPath)) {
            for (TreePath p : selModel.getSelectionPaths()) {
                TreePath sp1 = TapServiceTreeModel.getServicePath(p);
                if (sp1 == null || sp1.equals(servicePath)) continue;
                pathsToRemove.add(p);
            }
        } else if (servicePath != null) {
            if (!currentPaths.contains(servicePath)) {
                pathsToAdd.add(servicePath);
            }
            for (TreePath p : currentPaths) {
                if (!servicePath.equals(TapServiceTreeModel.getServicePath(p)) || p.equals(servicePath) || p.equals(newPath)) continue;
                pathsToRemove.add(p);
            }
        }
        if (pathsToAdd.size() > 0) {
            selModel.addSelectionPaths(pathsToAdd.toArray(new TreePath[0]));
        }
        if (pathsToRemove.size() > 0) {
            selModel.removeSelectionPaths(pathsToRemove.toArray(new TreePath[0]));
        }
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        TapServiceFinderPanel tsp = new TapServiceFinderPanel();
        tsp.keywordField_.setText("brown dwarf");
        tsp.andButton_.setAnd(true);
        tsp.setPreferredSize(new Dimension(420, 200));
        frm.getContentPane().add(tsp);
        frm.pack();
        frm.setVisible(true);
    }

    static /* synthetic */ Future access$1000(TapServiceFinderPanel x0) {
        return x0.serviceReader_;
    }
}

