/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.DaliExample;
import uk.ac.starlink.vo.DaliExampleReader;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.Endpoints;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.LinkedBlockingStack;
import uk.ac.starlink.vo.RegRole;
import uk.ac.starlink.vo.ResultHandler;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapMetaPolicy;
import uk.ac.starlink.vo.TapMetaReader;
import uk.ac.starlink.vo.TapQuery;

public class TapServiceKit {
    private final EndpointSet endpointSet_;
    private final String ivoid_;
    private final TapMetaPolicy metaPolicy_;
    private final ContentCoding coding_;
    private final Map<Populator, Collection<Runnable>> runningMap_;
    private final ExecutorService metaExecutor_;
    private volatile FutureTask<TapMetaReader> rdrFuture_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TapServiceKit(EndpointSet endpointSet, String ivoid, TapMetaPolicy metaPolicy, ContentCoding coding, int queueLimit) {
        this.endpointSet_ = endpointSet;
        this.ivoid_ = ivoid;
        this.metaPolicy_ = metaPolicy;
        this.coding_ = coding;
        this.metaExecutor_ = TapServiceKit.createExecutorService(queueLimit);
        this.runningMap_ = new HashMap<Populator, Collection<Runnable>>();
    }

    public EndpointSet getEndpointSet() {
        return this.endpointSet_;
    }

    public String getIvoid() {
        return this.ivoid_;
    }

    public boolean onTables(final SchemaMeta smeta, Runnable callback) {
        return this.onData(callback, new Populator<TableMeta>(TableMeta.class, "tables", (Object)smeta){

            @Override
            public boolean hasData() {
                return smeta.getTables() != null;
            }

            public TableMeta[] readData(TapMetaReader rdr) throws IOException {
                return rdr.readTables(smeta);
            }

            public void updateData(TableMeta[] tmetas) {
                smeta.setTables(tmetas);
            }
        });
    }

    public boolean onColumns(final TableMeta tmeta, Runnable callback) {
        return this.onData(callback, new Populator<ColumnMeta>(ColumnMeta.class, "columns", (Object)tmeta){

            @Override
            public boolean hasData() {
                return tmeta.getColumns() != null;
            }

            public ColumnMeta[] readData(TapMetaReader rdr) throws IOException {
                return rdr.readColumns(tmeta);
            }

            public void updateData(ColumnMeta[] cmetas) {
                tmeta.setColumns(cmetas);
            }
        });
    }

    public boolean onForeignKeys(final TableMeta tmeta, Runnable callback) {
        return this.onData(callback, new Populator<ForeignMeta>(ForeignMeta.class, "foreign keys", (Object)tmeta){

            @Override
            public boolean hasData() {
                return tmeta.getForeignKeys() != null;
            }

            public ForeignMeta[] readData(TapMetaReader rdr) throws IOException {
                return rdr.readForeignKeys(tmeta);
            }

            public void updateData(ForeignMeta[] fmetas) {
                tmeta.setForeignKeys(fmetas);
            }
        });
    }

    public void acquireSchemas(ResultHandler<SchemaMeta[]> handler) {
        this.acquireData(handler, new DataCallable<SchemaMeta[]>(){

            @Override
            public SchemaMeta[] call() throws IOException {
                TapMetaReader rdr = TapServiceKit.this.acquireMetaReader();
                try {
                    return rdr.readSchemas();
                }
                catch (IOException e) {
                    throw (IOException)new IOException(rdr.getSource() + " error: " + e).initCause(e);
                }
            }
        });
    }

    public void acquireCapability(ResultHandler<TapCapability> handler) {
        this.acquireData(handler, new DataCallable<TapCapability>(){

            @Override
            public TapCapability call() throws IOException {
                URL curl = TapServiceKit.this.endpointSet_.getCapabilitiesEndpoint();
                if (curl == null) {
                    throw new IOException("No capabilities endpoint");
                }
                logger_.info("Reading capability metadata from " + curl);
                try {
                    return TapCapability.readTapCapability(curl);
                }
                catch (SAXException e) {
                    throw (IOException)new IOException("Capability parse error: " + e).initCause(e);
                }
            }
        });
    }

    public void acquireResource(ResultHandler<Map<String, String>> handler) {
        this.acquireData(handler, new DataCallable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws IOException {
                return TapServiceKit.readResourceInfo(TapServiceKit.this.getRegTapEndpointSet(), TapServiceKit.this.ivoid_);
            }
        });
    }

    public void acquireRoles(ResultHandler<RegRole[]> handler) {
        this.acquireData(handler, new DataCallable<RegRole[]>(){

            @Override
            public RegRole[] call() throws IOException {
                return RegRole.readRoles(TapServiceKit.this.getRegTapEndpointSet(), TapServiceKit.this.ivoid_, TapServiceKit.this.coding_);
            }
        });
    }

    public void acquireExamples(ResultHandler<DaliExample[]> handler) {
        final URL examplesUrl = this.endpointSet_.getExamplesEndpoint();
        if (examplesUrl != null) {
            this.acquireData(handler, new DataCallable<DaliExample[]>(){

                @Override
                public DaliExample[] call() throws IOException {
                    return new DaliExampleReader().readExamples(examplesUrl);
                }
            });
        } else {
            logger_.warning("No examples endpoint");
        }
    }

    public EndpointSet getRegTapEndpointSet() {
        return Endpoints.getRegTapEndpointSet();
    }

    public void shutdown() {
        this.metaExecutor_.shutdownNow();
    }

    public TapMetaReader getMetaReader() {
        if (this.rdrFuture_ != null && this.rdrFuture_.isDone()) {
            try {
                return this.rdrFuture_.get(0L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TapMetaReader acquireMetaReader() {
        boolean runNow;
        TapServiceKit tapServiceKit = this;
        synchronized (tapServiceKit) {
            if (this.rdrFuture_ == null) {
                runNow = true;
                this.rdrFuture_ = new FutureTask<TapMetaReader>(new Callable<TapMetaReader>(){

                    @Override
                    public TapMetaReader call() {
                        return TapServiceKit.this.metaPolicy_.createMetaReader(TapServiceKit.this.endpointSet_, TapServiceKit.this.coding_);
                    }
                });
            } else {
                runNow = false;
            }
        }
        if (runNow) {
            this.rdrFuture_.run();
        }
        try {
            return this.rdrFuture_.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ErrorMetaReader("interrupted", e);
        }
        catch (ExecutionException e) {
            return new ErrorMetaReader(e.getCause().getMessage(), e);
        }
    }

    private boolean onData(final Runnable callback, final Populator<?> populator) {
        if (populator.hasData()) {
            callback.run();
            return true;
        }
        try {
            this.metaExecutor_.submit(new Runnable(){

                @Override
                public void run() {
                    if (populator.populateCompleted_) {
                        SwingUtilities.invokeLater(callback);
                    } else {
                        TapServiceKit.this.populateAndCallback(populator, callback);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            logger_.log(Level.INFO, "Will not read TAP metadata this time (" + populator.getDataDescription() + ")", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateAndCallback(final Populator<?> populator, Runnable callback) {
        Collection<Runnable> callbacks;
        Map<Populator, Collection<Runnable>> map = this.runningMap_;
        synchronized (map) {
            if (this.runningMap_.containsKey(populator)) {
                this.runningMap_.get(populator).add(callback);
                return;
            }
            ArrayList<Runnable> callbacks2 = new ArrayList<Runnable>();
            callbacks2.add(callback);
            this.runningMap_.put(populator, callbacks2);
        }
        populator.populate(this.acquireMetaReader());
        populator.populateCompleted_ = true;
        Map<Populator, Collection<Runnable>> map2 = this.runningMap_;
        synchronized (map2) {
            callbacks = this.runningMap_.remove(populator);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                assert (populator.hasData());
                for (Runnable cb : callbacks) {
                    cb.run();
                }
            }
        });
    }

    private <T> void acquireData(final ResultHandler<T> handler, final DataCallable<T> callable) {
        if (!handler.isActive()) {
            return;
        }
        handler.showWaiting();
        this.metaExecutor_.submit(new Runnable(){

            @Override
            public void run() {
                Object data;
                if (!handler.isActive()) {
                    return;
                }
                try {
                    data = callable.call();
                }
                catch (IOException error) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (handler.isActive()) {
                                handler.showError(error);
                            }
                        }
                    });
                    return;
                }
                final Object data0 = data;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (handler.isActive()) {
                            handler.showResult(data0);
                        }
                    }
                });
            }
        });
    }

    private static Map<String, String> readResourceInfo(EndpointSet regEndpointSet, String ivoid) throws IOException {
        String[] items = new String[]{"short_name", "res_title", "res_description", "reference_url"};
        StringBuffer adql = new StringBuffer().append("SELECT");
        for (int i = 0; i < items.length; ++i) {
            adql.append(i == 0 ? " " : ", ").append(items[i]);
        }
        adql.append(" FROM rr.resource").append(" WHERE ivoid='").append(ivoid).append("'");
        TapQuery tq = new TapQuery(regEndpointSet, adql.toString(), null);
        StarTable result = tq.executeSync(StoragePolicy.PREFER_MEMORY, ContentCoding.NONE);
        result = Tables.randomTable(result);
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        int ncol = result.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            Object value = result.getCell(0L, icol);
            if (!(value instanceof String)) continue;
            resultMap.put(items[icol], (String)value);
        }
        return resultMap;
    }

    private static ExecutorService createExecutorService(int queueLimit) {
        BoundedBlockingStack<Runnable> queue = new BoundedBlockingStack<Runnable>(queueLimit);
        RejectedExecutionHandler rejectHandler = new RejectedExecutionHandler(){
            private final RejectedExecutionHandler dfltHandler = new ThreadPoolExecutor.AbortPolicy();

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                BlockingQueue<Runnable> q = e.getQueue();
                if (q instanceof BoundedBlockingStack) {
                    if (!e.isShutdown()) {
                        ((BoundedBlockingStack)q).removeTail();
                        logger_.log(Level.INFO, "Discard metadata request");
                        e.execute(r);
                    }
                } else {
                    assert (false);
                    this.dfltHandler.rejectedExecution(r, e);
                }
            }
        };
        int corePoolSize = 1;
        int maxPoolSize = 1;
        ThreadFactory thFact = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, "TAP metadata query");
                th.setDaemon(true);
                return th;
            }
        };
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, 30L, TimeUnit.SECONDS, queue, thFact, rejectHandler);
    }

    private static class BoundedBlockingStack<E>
    extends LinkedBlockingStack<E> {
        private final int capacity_;
        private final Lock lock_;

        BoundedBlockingStack(int capacity) {
            this.capacity_ = capacity;
            this.lock_ = this.getLock();
        }

        @Override
        public boolean add(E o) {
            this.lock_.lock();
            try {
                if (this.remainingCapacity() > 0) {
                    boolean bl = super.add(o);
                    return bl;
                }
                throw new IllegalStateException("Queue full");
            }
            finally {
                this.lock_.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(E o) {
            this.lock_.lock();
            try {
                boolean bl = this.remainingCapacity() > 0 && super.offer(o);
                return bl;
            }
            finally {
                this.lock_.unlock();
            }
        }

        @Override
        public int remainingCapacity() {
            return Math.max(0, this.capacity_ - this.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E removeTail() {
            this.lock_.lock();
            try {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Object item = it.next();
                    if (it.hasNext()) continue;
                    it.remove();
                    Object e = item;
                    return e;
                }
                E e = null;
                return e;
            }
            finally {
                this.lock_.unlock();
            }
        }
    }

    private static class ErrorMetaReader
    implements TapMetaReader {
        final Exception error_;
        final String msg_;

        ErrorMetaReader(String msg, Exception error) {
            this.error_ = error;
            this.msg_ = msg;
        }

        @Override
        public String getSource() {
            return "No source (" + this.error_ + ")";
        }

        @Override
        public String getMeans() {
            return "No method (" + this.error_ + ")";
        }

        @Override
        public SchemaMeta[] readSchemas() throws IOException {
            throw this.rethrown();
        }

        @Override
        public TableMeta[] readTables(SchemaMeta schema) throws IOException {
            throw this.rethrown();
        }

        @Override
        public ColumnMeta[] readColumns(TableMeta table) throws IOException {
            throw this.rethrown();
        }

        @Override
        public ForeignMeta[] readForeignKeys(TableMeta table) throws IOException {
            throw this.rethrown();
        }

        private IOException rethrown() {
            return (IOException)new IOException("No metadata reader: " + this.msg_).initCause(this.error_);
        }
    }

    private static abstract class Populator<T> {
        private final Class<T> clazz_;
        private final String metasType_;
        private final Object id_;
        volatile boolean populateCompleted_;

        Populator(Class<T> clazz, String metasType, Object id) {
            this.clazz_ = clazz;
            this.metasType_ = metasType;
            this.id_ = id;
        }

        abstract boolean hasData();

        abstract T[] readData(TapMetaReader var1) throws IOException;

        abstract void updateData(T[] var1);

        void populate(TapMetaReader rdr) {
            final Object[] data = this.getData(rdr);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Populator.this.updateData(data);
                }
            });
        }

        private T[] getData(TapMetaReader rdr) {
            try {
                return this.readData(rdr);
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Failed to read TAP metadata " + this.getDataDescription(), e);
                Object[] emptyArray = (Object[])Array.newInstance(this.clazz_, 0);
                return emptyArray;
            }
        }

        public String getDataDescription() {
            return this.metasType_ + " for " + this.id_;
        }

        public int hashCode() {
            return this.id_.hashCode();
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass()) && this.id_.equals(((Populator)o).id_);
        }
    }

    private static interface DataCallable<T>
    extends Callable {
        public T call() throws IOException;
    }
}

