/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.gui.AbstractTableLoadDialog;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.util.gui.ExampleSelectField;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.DalLoader;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.Endpoints;
import uk.ac.starlink.vo.KeywordServiceQueryFactory;
import uk.ac.starlink.vo.OutputFormat;
import uk.ac.starlink.vo.QuickLookWindow;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegistryPanel;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.ResumeTapQueryPanel;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapCapabilityPanel;
import uk.ac.starlink.vo.TapMetaPolicy;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapQueryPanel;
import uk.ac.starlink.vo.TapServiceFinder;
import uk.ac.starlink.vo.TapServiceFinderPanel;
import uk.ac.starlink.vo.TapServiceKit;
import uk.ac.starlink.vo.UrlHandler;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.vo.UwsJobListPanel;
import uk.ac.starlink.votable.VOTableWriter;

public class TapTableLoadDialog
extends AbstractTableLoadDialog
implements DalLoader {
    private final Map<String, TapQueryPanel> tqMap_ = new HashMap<String, TapQueryPanel>();
    private JTabbedPane tabber_;
    private JComponent tqContainer_;
    private TapQueryPanel tqPanel_;
    private UwsJobListPanel jobsPanel_;
    private ResumeTapQueryPanel resumePanel_;
    private CaretListener adqlListener_;
    private Action reloadAct_;
    private JMenu editMenu_;
    private ProxyAction[] proxyActs_;
    private ComboBoxModel runModeModel_;
    private TapMetaPolicy metaPolicy_ = TapMetaPolicy.getDefaultInstance();
    private String ofmtName_;
    private VOTableWriter vowriter_;
    private StarTableFactory tfact_;
    private ContentCoding coding_ = ContentCoding.GZIP;
    private SearchPanel searchPanel_;
    private ExampleSelectField urlField_;
    private int searchTabIndex_;
    private int tqTabIndex_;
    private int jobsTabIndex_;
    private int resumeTabIndex_;
    private int iseq_;
    private static final Pattern UPLOAD_REGEX = Pattern.compile("TAP_UPLOAD\\.([^ ()*+-,/;<=>&?|\t\n\r]*)", 2);
    private static final Pattern TNAME_REGEX = Pattern.compile("(FROM|JOIN)\\s+(\\S*)", 2);
    private static final int META_QUEUE_LIMIT = 10;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TapTableLoadDialog() {
        super("Table Access Protocol (TAP) Query", "Query remote databases using SQL-like language");
        this.setIcon(ResourceIcon.TLD_TAP);
    }

    @Override
    public void configure(StarTableFactory tfact, Action submitAct) {
        submitAct.putValue("Name", "Run Query");
        this.tfact_ = tfact;
        super.configure(tfact, submitAct);
    }

    @Override
    protected Component createQueryComponent() {
        this.urlField_ = new ExampleSelectField("Select service from panel above or enter service URL here");
        this.searchPanel_ = new SearchPanel();
        Box urlLine = Box.createHorizontalBox();
        urlLine.add(new JLabel("TAP URL: "));
        urlLine.add(this.urlField_);
        Box sfootBox = Box.createVerticalBox();
        sfootBox.add(urlLine);
        Border lineBorder = BorderFactory.createLineBorder(Color.BLACK);
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        JPanel searchContainer = new JPanel(new BorderLayout());
        this.searchPanel_.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(lineBorder, gapBorder), "Locate TAP Service"));
        sfootBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(lineBorder, gapBorder), "Selected TAP Service"));
        searchContainer.add((Component)this.searchPanel_, "Center");
        searchContainer.add((Component)sfootBox, "South");
        this.jobsPanel_ = new UwsJobListPanel(){

            @Override
            public void addJob(UwsJob job, boolean select) {
                super.addJob(job, select);
                TapTableLoadDialog.this.tabber_.setEnabledAt(TapTableLoadDialog.this.jobsTabIndex_, true);
            }

            @Override
            public void removeJob(UwsJob job) {
                super.removeJob(job);
                if (this.getJobs().length == 0) {
                    TapTableLoadDialog.this.tabber_.setEnabledAt(TapTableLoadDialog.this.jobsTabIndex_, false);
                    TapTableLoadDialog.this.tabber_.setSelectedIndex(TapTableLoadDialog.this.tqTabIndex_);
                }
            }
        };
        this.resumePanel_ = new ResumeTapQueryPanel(this);
        this.tabber_ = new JTabbedPane();
        this.tabber_.add("Select Service", searchContainer);
        this.searchTabIndex_ = this.tabber_.getTabCount() - 1;
        this.tqContainer_ = new JPanel(new BorderLayout());
        String tqTitle = "Use Service";
        this.tabber_.add(tqTitle, this.tqContainer_);
        this.tqTabIndex_ = this.tabber_.getTabCount() - 1;
        this.tabber_.add("Resume Job", this.resumePanel_);
        this.resumeTabIndex_ = this.tabber_.getTabCount() - 1;
        this.tabber_.add("Running Jobs", this.jobsPanel_);
        this.jobsTabIndex_ = this.tabber_.getTabCount() - 1;
        this.tabber_.setEnabledAt(this.jobsTabIndex_, false);
        AbstractAction tqpanelAct = new AbstractAction(tqTitle){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TapTableLoadDialog.this.tabber_.setSelectedIndex(TapTableLoadDialog.this.tqTabIndex_);
            }
        };
        tqpanelAct.putValue("ShortDescription", "Go to " + tqTitle + " tab to prepare and execute TAP query");
        Box buttLine = Box.createHorizontalBox();
        buttLine.add(Box.createHorizontalGlue());
        buttLine.add(new JButton(tqpanelAct));
        sfootBox.add(Box.createVerticalStrut(5));
        sfootBox.add(buttLine);
        this.runModeModel_ = new DefaultComboBoxModel<TapRunMode>(this.createRunModes());
        this.adqlListener_ = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                TapTableLoadDialog.this.updateReady();
            }
        };
        this.reloadAct_ = new AbstractAction("Reload"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int itab = TapTableLoadDialog.this.tabber_.getSelectedIndex();
                if (itab == TapTableLoadDialog.this.searchTabIndex_) {
                    TapTableLoadDialog.this.searchPanel_.reload();
                } else if (itab == TapTableLoadDialog.this.tqTabIndex_) {
                    TapTableLoadDialog.this.tqPanel_.setServiceKit(TapTableLoadDialog.this.createServiceKit());
                } else if (itab == TapTableLoadDialog.this.resumeTabIndex_) {
                    TapTableLoadDialog.this.resumePanel_.reload();
                } else if (itab == TapTableLoadDialog.this.jobsTabIndex_) {
                    TapTableLoadDialog.this.jobsPanel_.reload();
                }
            }
        };
        this.reloadAct_.putValue("SmallIcon", ResourceIcon.RELOAD);
        this.reloadAct_.putValue("ShortDescription", "Reload information displayed in this panel from the server; exact behaviour depends on which panel is visible");
        ArrayList<JMenu> menuList = new ArrayList<JMenu>(Arrays.asList(super.getMenus()));
        this.editMenu_ = new JMenu("Edit");
        this.editMenu_.setMnemonic(69);
        menuList.add(this.editMenu_);
        this.setMenus(menuList.toArray(new JMenu[0]));
        ArrayList<ProxyAction> pacts = new ArrayList<ProxyAction>();
        for (Action templateAct : this.createTapQueryPanel().getEditActions()) {
            ProxyAction proxyAct = new ProxyAction(templateAct);
            pacts.add(proxyAct);
            this.editMenu_.add(proxyAct);
        }
        this.proxyActs_ = pacts.toArray(new ProxyAction[0]);
        this.updateQueryPanel();
        ArrayList<Action> actList = new ArrayList<Action>(Arrays.asList(super.getToolbarActions()));
        actList.add(this.reloadAct_);
        this.setToolbarActions(actList.toArray(new Action[0]));
        this.tabber_.setPreferredSize(new Dimension(700, 650));
        this.tabber_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TapTableLoadDialog.this.updateForTab();
            }
        });
        this.updateForTab();
        return this.tabber_;
    }

    protected StarTable getUploadTable(String upLabel) {
        throw new IllegalArgumentException("Upload tables not supported");
    }

    @Override
    public TableLoader createTableLoader() {
        int itab = this.tabber_.getSelectedIndex();
        if (itab == this.tqTabIndex_) {
            return this.createQueryPanelLoader();
        }
        if (itab == this.resumeTabIndex_) {
            return this.resumePanel_.createTableLoader();
        }
        return null;
    }

    public void addRunningQuery(UwsJob tapJob) {
        this.jobsPanel_.addJob(tapJob, true);
        this.tabber_.setSelectedIndex(this.jobsTabIndex_);
    }

    public void setMetaPolicy(TapMetaPolicy metaPolicy) {
        if (this.metaPolicy_ != metaPolicy) {
            TapServiceKit serviceKit;
            this.metaPolicy_ = metaPolicy;
            if (this.tqPanel_ != null && (serviceKit = this.createServiceKit()) != null) {
                this.tqPanel_.setServiceKit(serviceKit);
            }
        }
    }

    public void setPreferredOutputFormat(String ofmtName) {
        this.ofmtName_ = ofmtName;
    }

    public void setServiceFinder(TapServiceFinder finder) {
        TapServiceFinderPanel finderPanel = this.searchPanel_.finderPanel_;
        if (!finder.equals(finderPanel.getServiceFinder())) {
            finderPanel.setServiceFinder(finder);
        }
    }

    public void setVOTableWriter(VOTableWriter vowriter) {
        this.vowriter_ = vowriter;
    }

    public void setContentCoding(ContentCoding coding) {
        this.coding_ = coding;
    }

    public ContentCoding getContentCoding() {
        return this.coding_;
    }

    public Action getReloadAction() {
        return this.reloadAct_;
    }

    @Override
    public boolean acceptResourceIdList(String[] ivoids, String msg) {
        return this.isComponentShowing() && this.searchPanel_.acceptResourceIdList(ivoids, msg);
    }

    public EndpointSet getEndpointSet() {
        String surl = this.urlField_.getText();
        if (surl == null || surl.trim().length() == 0) {
            return null;
        }
        try {
            return Endpoints.createDefaultTapEndpointSet(new URL(surl));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void setServiceUrl(String url) {
        this.urlField_.setText(url);
    }

    protected TapRunMode[] createRunModes() {
        return new TapRunMode[]{TapRunMode.SYNC, TapRunMode.ASYNC, TapRunMode.LOOK};
    }

    private TableLoader createQueryPanelLoader() {
        TapQuery tq0;
        String ofmtSpec;
        TapCapability tcap;
        long maxrec;
        EndpointSet endpointSet = this.getEndpointSet();
        if (endpointSet == null) {
            return null;
        }
        String adql = this.tqPanel_.getAdql();
        LinkedHashMap<String, StarTable> uploadMap = new LinkedHashMap<String, StarTable>();
        final String summary = this.createLoadLabel(adql);
        TapCapabilityPanel tcapPanel = this.tqPanel_.getCapabilityPanel();
        long rowUploadLimit = tcapPanel.getUploadLimit("row");
        long byteUploadLimit = tcapPanel.getUploadLimit("byte");
        Set<String> uploadLabels = TapTableLoadDialog.getUploadLabels(adql);
        for (String upLabel : uploadLabels) {
            StarTable upTable = this.getUploadTable(upLabel);
            if (upTable != null) {
                long nrow = upTable.getRowCount();
                if (rowUploadLimit >= 0L && nrow > rowUploadLimit) {
                    throw new IllegalArgumentException("Table " + upLabel + " too many rows for upload " + " (" + nrow + ">" + rowUploadLimit + ")");
                }
                uploadMap.put(upLabel, upTable);
                continue;
            }
            throw new IllegalArgumentException("No known table \"" + upLabel + "\" for upload");
        }
        LinkedHashMap<String, String> extraParams = new LinkedHashMap<String, String>();
        String language = tcapPanel.getQueryLanguageName();
        if (language != null && language.trim().length() > 0) {
            extraParams.put("LANG", language);
        }
        if ((maxrec = tcapPanel.getMaxrec()) > 0L) {
            extraParams.put("MAXREC", Long.toString(maxrec));
        }
        if ((tcap = tcapPanel.getCapability()) != null && (ofmtSpec = TapTableLoadDialog.getOutputFormatSpecifier(this.ofmtName_, tcap.getOutputFormats())) != null) {
            extraParams.put("FORMAT", ofmtSpec);
        }
        final TapRunMode runMode = (TapRunMode)((Object)this.runModeModel_.getSelectedItem());
        final DescribedValue[] metas = new DescribedValue[]{};
        try {
            tq0 = new TapQuery(endpointSet, adql, extraParams, uploadMap, byteUploadLimit, this.vowriter_);
        }
        catch (IOException e) {
            ErrorDialog.showError(this.getQueryComponent(), "Query Construction", e);
            return null;
        }
        final TapQuery tq = tq0;
        if (runMode.isLoader_) {
            return new TableLoader(){

                @Override
                public TableSequence loadTables(StarTableFactory tfact) throws IOException {
                    if (runMode.isSync_) {
                        assert (runMode == TapRunMode.SYNC);
                        StarTable table = tq.executeSync(tfact.getStoragePolicy(), TapTableLoadDialog.this.coding_);
                        table.getParameters().addAll(Arrays.asList(metas));
                        return Tables.singleTableSequence(table);
                    }
                    assert (runMode == TapRunMode.ASYNC);
                    final UwsJob tapJob = tq.submitAsync();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TapTableLoadDialog.this.addRunningQuery(tapJob);
                        }
                    });
                    return TapTableLoadDialog.this.createTableSequence(tfact, tapJob, metas);
                }

                @Override
                public String getLabel() {
                    return summary;
                }
            };
        }
        assert (runMode == TapRunMode.LOOK);
        assert (runMode.isSync_);
        QuickLookWindow qlw = new QuickLookWindow(tq, this.tfact_, this.coding_);
        qlw.setVisible(true);
        qlw.executeQuery();
        return null;
    }

    protected TableSequence createTableSequence(StarTableFactory tfact, UwsJob tapJob, DescribedValue[] tapMeta) throws IOException {
        StarTable table;
        tapJob.setDeleteOnExit(true);
        tapJob.start();
        try {
            table = TapQuery.waitForResult(tapJob, this.coding_, tfact.getStoragePolicy(), 4000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (IOException)new IOException("Interrupted").initCause(e);
        }
        table.getParameters().addAll(Arrays.asList(tapMeta));
        return Tables.singleTableSequence(table);
    }

    protected TapQueryPanel createTapQueryPanel() {
        return new TapQueryPanel(new UrlHandler(){

            @Override
            public void clickUrl(URL url) {
                logger_.warning("Click: " + url);
            }
        });
    }

    @Override
    public boolean isReady() {
        if (this.tqPanel_ == null || this.tabber_.getSelectedIndex() != this.tqTabIndex_) {
            return false;
        }
        String adql = this.tqPanel_.getAdql();
        return super.isReady() && adql != null && adql.trim().length() > 0;
    }

    @Override
    public RegistryPanel getRegistryPanel() {
        return this.searchPanel_.regPanel_;
    }

    private String createLoadLabel(String adql) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("TAP_").append(++this.iseq_);
        if (adql != null) {
            Matcher matcher = TNAME_REGEX.matcher(adql);
            boolean more = false;
            while (matcher.find()) {
                String tname = matcher.group(2);
                tname = tname.replaceAll("/+", "_").replaceAll("\"", "");
                sbuf.append(more ? (char)',' : '_').append(tname);
                more = true;
            }
        }
        return sbuf.toString();
    }

    private static Set<String> getUploadLabels(String adql) {
        HashSet<String> labelSet = new HashSet<String>();
        Matcher matcher = UPLOAD_REGEX.matcher(adql);
        while (matcher.find()) {
            labelSet.add(matcher.group(1));
        }
        return labelSet;
    }

    private TapServiceKit createServiceKit() {
        EndpointSet endpointSet = this.getEndpointSet();
        return endpointSet == null ? null : new TapServiceKit(endpointSet, this.searchPanel_.getIvoid(endpointSet.getIdentity()), this.metaPolicy_, this.coding_, 10);
    }

    private void setSelectedService(TapServiceKit serviceKit) {
        if (this.tqPanel_ != null) {
            this.tqContainer_.remove(this.tqPanel_);
            this.tqPanel_.removeCaretListener(this.adqlListener_);
            this.tqPanel_ = null;
        }
        if (serviceKit != null) {
            String serviceUrl = serviceKit.getEndpointSet().getIdentity();
            this.urlField_.chooseText(serviceUrl);
            if (!this.tqMap_.containsKey(serviceUrl)) {
                TapQueryPanel tqPanel = this.createTapQueryPanel();
                if (this.runModeModel_ != null && this.runModeModel_.getSize() > 1) {
                    Box modeLine = Box.createHorizontalBox();
                    modeLine.add(new JLabel("Mode: "));
                    modeLine.add(new ShrinkWrapper(new JComboBox(this.runModeModel_)));
                    modeLine.add(Box.createHorizontalStrut(5));
                    tqPanel.addControl(modeLine);
                }
                tqPanel.setServiceKit(serviceKit);
                this.tqMap_.put(serviceUrl, tqPanel);
            }
            this.tqPanel_ = this.tqMap_.get(serviceUrl);
            this.tqPanel_.addCaretListener(this.adqlListener_);
            this.tqContainer_.add((Component)this.tqPanel_, "Center");
        }
        this.updateQueryPanel();
        this.updateReady();
    }

    private void updateQueryPanel() {
        HashMap<String, Action> actMap = new HashMap<String, Action>();
        if (this.tqPanel_ != null) {
            for (Action action : this.tqPanel_.getEditActions()) {
                actMap.put((String)action.getValue("Name"), action);
            }
        }
        for (Action action : this.proxyActs_) {
            ((ProxyAction)action).setTarget((Action)actMap.get(((ProxyAction)action).getValue("Name")));
        }
    }

    private void updateForTab() {
        int itab = this.tabber_.getSelectedIndex();
        if (itab == this.tqTabIndex_) {
            TapServiceKit serviceKit = this.createServiceKit();
            if (serviceKit == null) {
                this.tabber_.setSelectedIndex(this.searchTabIndex_);
                JOptionPane.showMessageDialog(this.urlField_, "No TAP service URL", "No Service Selected", 0);
            } else {
                this.setSelectedService(serviceKit);
            }
        }
        this.reloadAct_.setEnabled(itab == this.searchTabIndex_ || itab == this.tqTabIndex_ || itab == this.resumeTabIndex_ || itab == this.jobsTabIndex_);
        this.editMenu_.setEnabled(itab == this.tqTabIndex_);
        this.updateReady();
    }

    private static String getOutputFormatSpecifier(String ofmtName, OutputFormat[] ofmts) {
        if (ofmtName != null && ofmts != null) {
            for (OutputFormat ofmt : ofmts) {
                String[] aliases = ofmt.getAliases();
                String[] stringArray = aliases = aliases == null ? new String[]{} : aliases;
                if (!ofmtName.equalsIgnoreCase(ofmt.getIvoid()) && !ofmtName.equalsIgnoreCase(ofmt.getMime()) && Arrays.asList(aliases).indexOf(ofmtName) < 0) continue;
                return aliases.length > 0 ? aliases[0] : ofmt.getMime();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String tapUrl = args.length > 0 ? args[0] : null;
        final TapTableLoadDialog tld = new TapTableLoadDialog(){

            @Override
            protected TapRunMode[] createRunModes() {
                return new TapRunMode[]{TapRunMode.LOOK};
            }
        };
        StarTableFactory tfact = new StarTableFactory();
        tld.configure(tfact, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                tld.createTableLoader();
            }
        });
        Component qcomp = tld.getQueryComponent();
        if (tapUrl != null) {
            super.setServiceUrl(tapUrl);
        }
        JFrame frm = new JFrame();
        frm.setJMenuBar(new JMenuBar());
        for (JMenu menu : tld.getMenus()) {
            frm.getJMenuBar().add(menu);
        }
        frm.getContentPane().add(qcomp, "Center");
        frm.getContentPane().add((Component)new JButton(tld.getSubmitAction()), "South");
        frm.pack();
        frm.setVisible(true);
    }

    private static class ProxyAction
    extends AbstractAction {
        private final Action template_;
        private final PropertyChangeListener propForwarder_;
        private Action target_;

        ProxyAction(Action template) {
            this.template_ = template;
            this.propForwarder_ = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    for (PropertyChangeListener l : ProxyAction.this.getPropertyChangeListeners()) {
                        l.propertyChange(evt);
                    }
                }
            };
        }

        public void setTarget(Action target) {
            if (this.target_ != null) {
                this.target_.removePropertyChangeListener(this.propForwarder_);
            }
            this.target_ = target;
            if (this.target_ != null) {
                this.target_.addPropertyChangeListener(this.propForwarder_);
            }
            this.setEnabled(this.isEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.target_ != null) {
                this.target_.actionPerformed(evt);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.target_ != null && this.target_.isEnabled();
        }

        @Override
        public Object getValue(String key) {
            return this.template_.getValue(key);
        }
    }

    public static enum TapRunMode {
        SYNC(true, true, "Synchronous", "Execute query in TAP synchronous mode and load result into application"),
        ASYNC(true, false, "Asynchronous", "Execute query in TAP asynchronous mode and load result into application when complete"),
        LOOK(false, true, "Quick Look", "Execute query in TAP synchronous mode and display the result in a popup window");

        private final boolean isLoader_;
        private final boolean isSync_;
        private final String name_;
        private final String description_;

        private TapRunMode(boolean isLoader, boolean isSync, String name, String description) {
            this.isLoader_ = isLoader;
            this.isSync_ = isSync;
            this.name_ = name;
            this.description_ = description;
        }

        public String toString() {
            return this.name_;
        }
    }

    private class SearchPanel
    extends JPanel {
        private final JTabbedPane serviceTabber_;
        private final int itabByTable_;
        private final int itabByService_;
        private final TapServiceFinderPanel finderPanel_;
        private final KeywordServiceQueryFactory qfact_;
        private final RegistryPanel regPanel_;

        SearchPanel() {
            super(new BorderLayout());
            this.finderPanel_ = new TapServiceFinderPanel();
            this.finderPanel_.addPropertyChangeListener("TAP_SERVICE_PROPERTY", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TapServiceFinder.Service service = SearchPanel.this.finderPanel_.getSelectedService();
                    TapTableLoadDialog.this.setServiceUrl(service == null ? null : service.getServiceUrl());
                }
            });
            this.finderPanel_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (TapTableLoadDialog.this.getEndpointSet() != null) {
                        TapTableLoadDialog.this.tabber_.setSelectedIndex(TapTableLoadDialog.this.tqTabIndex_);
                    }
                }
            });
            this.qfact_ = new KeywordServiceQueryFactory(Capability.TAP);
            this.regPanel_ = new RegistryPanel(this.qfact_, false);
            this.regPanel_.displayAdviceMessage(new String[]{"Query registry for TAP services:", "Enter search terms in Keywords field or leave it blank,", "then click " + this.regPanel_.getSubmitQueryAction().getValue("Name") + ". "});
            ListSelectionModel selModel = this.regPanel_.getResourceSelectionModel();
            selModel.setSelectionMode(0);
            selModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    RegCapabilityInterface[] caps = SearchPanel.this.regPanel_.getSelectedCapabilities();
                    TapTableLoadDialog.this.setServiceUrl(caps.length == 1 ? caps[0].getAccessUrl() : null);
                }
            });
            Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            this.finderPanel_.setBorder(gapBorder);
            this.regPanel_.setBorder(gapBorder);
            this.serviceTabber_ = new JTabbedPane();
            this.serviceTabber_.add("By Table Properties", this.finderPanel_);
            this.itabByTable_ = this.serviceTabber_.getTabCount() - 1;
            this.serviceTabber_.add("By Service Properties", this.regPanel_);
            this.itabByService_ = this.serviceTabber_.getTabCount() - 1;
            this.add((Component)this.serviceTabber_, "Center");
        }

        public String getIvoid(String serviceUrl) {
            if (serviceUrl != null) {
                try {
                    return this.finderPanel_.getIvoid(new URL(serviceUrl));
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            return null;
        }

        public void reload() {
            int itab = this.serviceTabber_.getSelectedIndex();
            if (itab == this.itabByTable_) {
                this.finderPanel_.setServiceFinder(this.finderPanel_.getServiceFinder());
            } else if (itab == this.itabByService_) {
                this.regPanel_.getSubmitQueryAction().actionPerformed(new ActionEvent(this, 0, "go"));
            }
        }

        public boolean acceptResourceIdList(String[] ivoids, String msg) {
            RegistryQuery query;
            try {
                query = this.qfact_.getIdListQuery(ivoids);
            }
            catch (MalformedURLException e) {
                logger_.warning("Resource ID list not accepted: bad registry endpoint " + e);
                return false;
            }
            if (query != null) {
                TapTableLoadDialog.this.tabber_.setSelectedIndex(TapTableLoadDialog.this.searchTabIndex_);
                this.serviceTabber_.setSelectedIndex(this.itabByService_);
                this.regPanel_.performQuery(query, msg);
                return true;
            }
            return false;
        }
    }
}

