/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.HttpStreamParam;
import uk.ac.starlink.vo.JobSaxHandler;
import uk.ac.starlink.vo.UwsJobInfo;
import uk.ac.starlink.vo.UwsStage;

public class UwsJob {
    private final URL jobUrl_;
    private UwsJobInfo info_;
    private boolean deleteAttempted_;
    private Thread deleteThread_;
    private List<JobWatcher> watcherList_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    private static final String UTF8 = "UTF-8";
    public static int HTTP_CHUNK_SIZE = 0x100000;
    public static boolean TRIM_TEXT = true;

    public UwsJob(URL jobUrl) {
        this.jobUrl_ = jobUrl;
        this.watcherList_ = new ArrayList<JobWatcher>();
    }

    public URL getJobUrl() {
        return this.jobUrl_;
    }

    public void addJobWatcher(JobWatcher watcher) {
        this.watcherList_.add(watcher);
    }

    public void removeJobWatcher(JobWatcher watcher) {
        this.watcherList_.remove(watcher);
    }

    public UwsJobInfo getLastInfo() {
        return this.info_;
    }

    public void postPhase(String phase) throws IOException {
        this.postUwsParameter("/phase", "PHASE", phase);
    }

    public void postDestruction(String epoch) throws IOException {
        this.postUwsParameter("/destruction", "DESTRUCTION", epoch);
    }

    public void postExecutionDuration(long nsec) throws IOException {
        this.postUwsParameter("/executionduration", "EXECUTIONDURATION", Long.toString(nsec));
    }

    private void postUwsParameter(String relativeLocation, String paramName, String paramValue) throws IOException {
        URL postUrl = new URL(this.jobUrl_ + relativeLocation);
        HttpURLConnection hconn = UwsJob.postForm(postUrl, paramName, paramValue);
        int code = hconn.getResponseCode();
        if (code != 303) {
            throw new IOException("Non-303 response: " + code + " " + hconn.getResponseMessage());
        }
    }

    public void start() throws IOException {
        this.postPhase("RUN");
    }

    public UwsJobInfo waitForFinish(long pollMillis) throws IOException, InterruptedException {
        UwsJobInfo info = this.info_;
        if (info == null) {
            info = this.readInfo();
        }
        block7: while (UwsStage.forPhase(info.getPhase()) != UwsStage.FINISHED) {
            info = this.rereadInfo(info, pollMillis);
            String phase = info.getPhase();
            switch (UwsStage.forPhase(phase)) {
                case UNSTARTED: {
                    throw new IOException("Job not started - phase: " + phase);
                }
                case ILLEGAL: {
                    throw new IOException("Illegal UWS job phase: " + phase);
                }
                case UNKNOWN: {
                    logger_.info("Unknown UWS phase " + phase + " reported" + "; poll again");
                    continue block7;
                }
                case RUNNING: {
                    continue block7;
                }
                case FINISHED: {
                    continue block7;
                }
            }
            throw new AssertionError();
        }
        return info;
    }

    public UwsJobInfo readInfo() throws IOException {
        return this.readInfoQuery("");
    }

    public UwsJobInfo readInfoBlocking(int timeoutSec, UwsJobInfo lastInfo) throws IOException {
        UwsStage lastStage;
        StringBuffer qbuf = new StringBuffer().append("?WAIT=").append(timeoutSec);
        String lastPhase = lastInfo == null ? null : lastInfo.getPhase();
        UwsStage uwsStage = lastStage = lastPhase == null ? null : UwsStage.forPhase(lastPhase);
        if (lastStage == UwsStage.RUNNING || lastStage == UwsStage.UNSTARTED) {
            qbuf.append("&PHASE=").append(lastPhase);
        }
        return this.readInfoQuery(qbuf.toString());
    }

    private UwsJobInfo rereadInfo(UwsJobInfo lastInfo, long pollMillis) throws IOException, InterruptedException {
        boolean useBlocking = UwsJob.hasBlocking(lastInfo);
        while (true) {
            boolean hasWaited = false;
            try {
                if (useBlocking) {
                    logger_.info("Blocking read of UWS job");
                    return this.readInfoBlocking(-1, lastInfo);
                }
                logger_.info("Poll UWS job after " + pollMillis + "ms");
                Thread.sleep(pollMillis);
                hasWaited = true;
                return this.readInfo();
            }
            catch (IOException e) {
                if (e instanceof SocketException || e instanceof UnknownHostException) {
                    String msg = "Connection failure - keep trying (" + e + ")";
                    logger_.log(Level.WARNING, msg, e);
                    if (hasWaited) continue;
                    Thread.sleep(pollMillis);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private UwsJobInfo readInfoQuery(String queryPart) throws IOException {
        UwsJobInfo[] infos;
        URL url = new URL(this.jobUrl_ + queryPart);
        logger_.info("Read UWS job: " + url);
        try {
            infos = JobSaxHandler.readJobInfos(url);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Parse error in UWS job document at " + url).initCause(e);
        }
        if (infos != null && infos.length > 0) {
            UwsJobInfo info = infos[0];
            this.gotInfo(info);
            return info;
        }
        throw new IOException("No UWS job document at " + url);
    }

    private void gotInfo(UwsJobInfo info) {
        boolean phaseChanged;
        UwsJobInfo info0 = this.info_;
        String phase0 = info0 == null ? null : info0.getPhase();
        String phase1 = info == null ? null : info.getPhase();
        this.info_ = info;
        if (TRIM_TEXT) {
            phase0 = phase0 == null ? null : phase0.trim();
            phase1 = phase1 == null ? null : phase1.trim();
        }
        logger_.info("UWS job phase: " + phase1);
        boolean bl = phase1 == null ? phase0 != null : (phaseChanged = !phase1.equals(phase0));
        if (phaseChanged) {
            for (JobWatcher watcher : this.watcherList_) {
                watcher.jobUpdated(this, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete() throws IOException {
        int response;
        HttpURLConnection hconn = UwsJob.openHttpConnection(this.jobUrl_);
        logger_.info("DELETE " + this.jobUrl_);
        hconn.setRequestMethod("DELETE");
        hconn.setInstanceFollowRedirects(false);
        try {
            hconn.connect();
            response = hconn.getResponseCode();
        }
        finally {
            UwsJob uwsJob = this;
            synchronized (uwsJob) {
                this.deleteAttempted_ = true;
            }
        }
        int tapDeleteCode = 303;
        if (response != tapDeleteCode) {
            throw new IOException("Response " + response + " not " + tapDeleteCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptDelete() {
        UwsJob uwsJob = this;
        synchronized (uwsJob) {
            if (this.deleteAttempted_) {
                return;
            }
            this.deleteAttempted_ = true;
            this.setDeleteOnExit(false);
        }
        try {
            this.postDelete();
            logger_.info("UWS job " + this.jobUrl_ + " deleted");
        }
        catch (IOException e) {
            logger_.warning("UWS job deletion failed for " + this.jobUrl_ + " - " + e.toString());
        }
    }

    public synchronized void setDeleteOnExit(boolean delete) {
        if (delete && this.deleteThread_ == null && !this.deleteAttempted_) {
            this.deleteThread_ = new Thread("UWS job deletion"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    UwsJob uwsJob = UwsJob.this;
                    synchronized (uwsJob) {
                        UwsJob.this.deleteThread_ = null;
                    }
                    UwsJob.this.attemptDelete();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.deleteThread_);
        } else if (!delete && this.deleteThread_ != null) {
            Runtime.getRuntime().removeShutdownHook(this.deleteThread_);
            this.deleteThread_ = null;
        }
    }

    public boolean getDeleteOnExit() {
        return this.deleteThread_ != null;
    }

    public String getJobId() {
        return this.jobUrl_.getPath().replaceAll("^.*/", "");
    }

    public String toString() {
        return this.getJobId();
    }

    public static UwsJob createJob(String jobListUrl, Map<String, String> stringParamMap, Map<String, HttpStreamParam> streamParamMap) throws IOException {
        HttpURLConnection hconn = UwsJob.postForm(new URL(jobListUrl), ContentCoding.NONE, stringParamMap, streamParamMap);
        int code = hconn.getResponseCode();
        if (code != 303) {
            String msg = "Non-303 response (" + hconn.getResponseCode() + " " + hconn.getResponseMessage() + ")";
            throw new UnexpectedResponseException(msg, hconn);
        }
        String location = hconn.getHeaderField("Location");
        if (location == null) {
            throw new IOException("No Location field in 303 response");
        }
        logger_.info("Created UWS job at: " + location);
        return new UwsJob(new URL(location));
    }

    private static HttpURLConnection postForm(URL url, String name, String value) throws IOException {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put(name, value);
        return UwsJob.postUnipartForm(url, ContentCoding.NONE, paramMap);
    }

    public static HttpURLConnection postForm(URL url, ContentCoding coding, Map<String, String> stringParams, Map<String, HttpStreamParam> streamParams) throws IOException {
        if (logger_.isLoggable(Level.CONFIG)) {
            logger_.config("Doing something like: " + UwsJob.getCurlPostEquivalent(url, coding, stringParams, streamParams));
        }
        return streamParams == null || streamParams.isEmpty() ? UwsJob.postUnipartForm(url, coding, stringParams) : UwsJob.postMultipartForm(url, coding, stringParams, streamParams, null);
    }

    public static HttpURLConnection postUnipartForm(URL url, ContentCoding coding, Map<String, String> paramMap) throws IOException {
        HttpURLConnection hconn = UwsJob.openHttpConnection(url);
        byte[] postBytes = UwsJob.toPostedBytes(paramMap);
        hconn.setRequestMethod("POST");
        hconn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        coding.prepareRequest(hconn);
        hconn.setInstanceFollowRedirects(false);
        hconn.setDoOutput(true);
        logger_.info("POST to " + url);
        logger_.config("POST content: " + (postBytes.length < 200 ? new String(postBytes, "utf-8") : new String(postBytes, 0, 200, "utf-8") + "..."));
        hconn.connect();
        OutputStream hout = hconn.getOutputStream();
        hout.write(postBytes);
        hout.close();
        return hconn;
    }

    public static HttpURLConnection postMultipartForm(URL url, ContentCoding coding, Map<String, String> stringMap, Map<String, HttpStreamParam> streamMap, String boundary) throws IOException {
        String pName;
        if (boundary == null) {
            boundary = "<<<--------------MULTIPART-BOUNDARY------->>>";
        }
        if (boundary.length() > 70) {
            throw new IllegalArgumentException("Boundary >70 chars (see RFC 2046 sec 5.1.1)");
        }
        HttpURLConnection hconn = UwsJob.openHttpConnection(url);
        hconn.setRequestMethod("POST");
        hconn.setRequestProperty("Content-Type", "multipart/form-data; boundary=\"" + boundary + "\"");
        coding.prepareRequest(hconn);
        hconn.setInstanceFollowRedirects(false);
        hconn.setDoOutput(true);
        logger_.info("POST params to " + url);
        OutputStream hout = HTTP_CHUNK_SIZE > 0 ? UwsJob.createChunkedHttpStream(hconn, HTTP_CHUNK_SIZE) : UwsJob.createStoredHttpStream(hconn, StoragePolicy.getDefaultPolicy());
        hout = new BufferedOutputStream(hout);
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            pName = entry.getKey();
            String pValue = entry.getValue();
            logger_.config("POST " + pName + "=" + pValue);
            UwsJob.writeBoundary(hout, boundary, false);
            UwsJob.writeHttpLine(hout, "Content-Type: text/plain; charset=UTF-8");
            UwsJob.writeHttpLine(hout, "Content-Disposition: form-data; name=\"" + pName + "\"");
            UwsJob.writeHttpLine(hout, "");
            hout.write(UwsJob.toTextPlain(pValue, UTF8));
        }
        for (Map.Entry<String, Object> entry : streamMap.entrySet()) {
            pName = entry.getKey();
            HttpStreamParam pStreamer = (HttpStreamParam)entry.getValue();
            logger_.config("POST " + pName + " (streamed data)");
            UwsJob.writeBoundary(hout, boundary, false);
            UwsJob.writeHttpLine(hout, "Content-Disposition: form-data; name=\"" + pName + "\"" + "; filename=\"" + pName + "\"");
            for (Map.Entry<String, String> header : pStreamer.getHttpHeaders().entrySet()) {
                UwsJob.writeHttpLine(hout, header.getKey() + ": " + header.getValue());
            }
            UwsJob.writeHttpLine(hout, "");
            pStreamer.writeContent(hout);
        }
        UwsJob.writeBoundary(hout, boundary, true);
        hout.close();
        return hconn;
    }

    public static String getCurlPostEquivalent(URL url, ContentCoding coding, Map<String, String> stringParams, Map<String, HttpStreamParam> streamParams) {
        StringBuffer sbuf = new StringBuffer().append("curl").append(" --url ").append(url).append(" --location ");
        if (coding == ContentCoding.GZIP) {
            sbuf.append(" --compress");
        }
        for (Map.Entry<String, String> entry : stringParams.entrySet()) {
            sbuf.append(" --form ").append(entry.getKey()).append('=').append(UwsJob.shellEscape(entry.getValue()));
        }
        for (String key : streamParams.keySet()) {
            sbuf.append(" --form ").append(key).append("=").append("@<..data..>");
        }
        return sbuf.toString();
    }

    private static String shellEscape(String txt) {
        if (!(txt = txt.trim().replaceAll("\\s+", " ")).matches(".*[ $?'\"].*")) {
            return txt;
        }
        if (txt.indexOf("'") < 0) {
            return "'" + txt + "'";
        }
        if (txt.indexOf(34) < 0) {
            return '\"' + txt + '\"';
        }
        return "'" + txt.replaceAll("'", "'\"'\"'") + "'";
    }

    private static HttpURLConnection openHttpConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try {
            return (HttpURLConnection)connection;
        }
        catch (ClassCastException e) {
            throw (IOException)new IOException("Not an HTTP URL? " + url).initCause(e);
        }
    }

    public static byte[] toPostedBytes(Map<String, String> paramMap) {
        StringBuffer sbuf = new StringBuffer();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            if (sbuf.length() != 0) {
                sbuf.append('&');
            }
            try {
                sbuf.append(URLEncoder.encode(entry.getKey(), UTF8)).append('=').append(URLEncoder.encode(entry.getValue(), UTF8));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)"No UTF-8??");
            }
        }
        int nc = sbuf.length();
        byte[] bbuf = new byte[nc];
        for (int i = 0; i < nc; ++i) {
            char c = sbuf.charAt(i);
            assert (c == (c & 0x7F));
            bbuf[i] = (byte)sbuf.charAt(i);
        }
        return bbuf;
    }

    static byte[] toTextPlain(String text, String charset) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String[] lines = Pattern.compile("$", 8).split(text);
        Pattern contentPattern = Pattern.compile("(.+)");
        for (int i = 0; i < lines.length; ++i) {
            String lineContent;
            String lineWithDelim = lines[i];
            Matcher contentMatcher = contentPattern.matcher(lineWithDelim);
            String string = lineContent = contentMatcher.find() ? contentMatcher.group(1) : "";
            if (lineContent.length() < lineWithDelim.length()) {
                bos.write(13);
                bos.write(10);
            }
            bos.write(lineContent.getBytes(charset));
        }
        return bos.toByteArray();
    }

    static void writeHttpLine(OutputStream out, String line) throws IOException {
        int leng = line.length();
        byte[] buf = new byte[leng + 2];
        for (int i = 0; i < leng; ++i) {
            char c = line.charAt(i);
            if (c < ' ' || c > '~') {
                throw new IOException("Bad character for HTTP 0x" + Integer.toHexString(c));
            }
            buf[i] = (byte)c;
        }
        buf[leng + 0] = 13;
        buf[leng + 1] = 10;
        out.write(buf);
    }

    private static void writeBoundary(OutputStream out, String delim, boolean isEnd) throws IOException {
        out.write(13);
        out.write(10);
        StringBuffer sbuf = new StringBuffer().append("--").append(delim);
        if (isEnd) {
            sbuf.append("--");
        }
        String line = sbuf.toString();
        UwsJob.writeHttpLine(out, line);
    }

    private static OutputStream createChunkedHttpStream(HttpURLConnection hconn, int chunkSize) throws IOException {
        hconn.setChunkedStreamingMode(chunkSize);
        hconn.connect();
        return hconn.getOutputStream();
    }

    private static OutputStream createStoredHttpStream(final HttpURLConnection hconn, StoragePolicy storage) {
        final ByteStore hbuf = storage.makeByteStore();
        return new FilterOutputStream(hbuf.getOutputStream()){

            @Override
            public void close() throws IOException {
                super.close();
                long hleng = hbuf.getLength();
                if (hleng > Integer.MAX_VALUE) {
                    throw new IOException("Uploads are too big");
                }
                hconn.setFixedLengthStreamingMode((int)hleng);
                hconn.connect();
                OutputStream hcout = hconn.getOutputStream();
                hbuf.copy(hcout);
                hcout.close();
            }
        };
    }

    private static boolean hasBlocking(UwsJobInfo info) {
        int[] majMin = UwsJob.getVersion(info);
        if (majMin != null) {
            int maj = majMin[0];
            int min = majMin[1];
            return maj == 1 && min >= 1 || maj > 1;
        }
        return false;
    }

    private static int[] getVersion(UwsJobInfo info) {
        if (info == null) {
            return null;
        }
        String version = info.getUwsVersion();
        if (version == null) {
            return new int[]{1, 0};
        }
        Matcher matcher = Pattern.compile("^\\s*([0-9]+)\\.([0-9]+).*$").matcher(version);
        if (matcher.matches()) {
            try {
                return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))};
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static interface JobWatcher {
        public void jobUpdated(UwsJob var1, UwsJobInfo var2);
    }

    public static class UnexpectedResponseException
    extends IOException {
        private final HttpURLConnection hconn_;

        private UnexpectedResponseException(String msg, HttpURLConnection hconn) {
            super(msg);
            this.hconn_ = hconn;
        }

        public HttpURLConnection getConnection() {
            return this.hconn_;
        }
    }
}

