/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public enum UwsStage {
    UNSTARTED(new String[]{"PENDING", "HELD"}),
    RUNNING(new String[]{"QUEUED", "EXECUTING", "SUSPENDED"}),
    FINISHED(new String[]{"COMPLETED", "ERROR", "ABORTED"}),
    UNKNOWN(new String[]{"UNKNOWN"}),
    ILLEGAL(new String[0]);

    private final Collection<String> phaseList_;

    private UwsStage(String[] phases) {
        this.phaseList_ = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(phases)));
    }

    public Collection<String> getPhaseList() {
        return this.phaseList_;
    }

    public static UwsStage forPhase(String phase) {
        UwsStage[] stages = UwsStage.values();
        for (int i = 0; i < stages.length; ++i) {
            if (!stages[i].phaseList_.contains(phase)) continue;
            return stages[i];
        }
        return ILLEGAL;
    }
}

