/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.MetaNameFixer;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetSaxHandler;
import uk.ac.starlink.vo.TapMetaPolicy;
import uk.ac.starlink.vo.TapMetaReader;

public class VizierTapMetaReader
implements TapMetaReader {
    private final URL url_;
    private final MetaNameFixer fixer_;
    private final ContentCoding coding_;
    private final AdqlSyntax syntax_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public VizierTapMetaReader(URL tablesetUrl, MetaNameFixer fixer, ContentCoding coding) {
        this.url_ = tablesetUrl;
        this.fixer_ = fixer == null ? MetaNameFixer.NONE : fixer;
        this.coding_ = coding;
        this.syntax_ = AdqlSyntax.getInstance();
    }

    @Override
    public SchemaMeta[] readSchemas() throws IOException {
        SchemaMeta[] schemas;
        for (SchemaMeta schema : schemas = this.readSchemas(this.url_)) {
            for (TableMeta table : schema.getTables()) {
                ColumnMeta[] cols = table.getColumns();
                if (cols == null || cols.length != 0) continue;
                table.setColumns(null);
            }
        }
        this.fixer_.fixSchemas(schemas);
        TapMetaPolicy.sortSchemas(schemas);
        for (SchemaMeta schema : schemas) {
            TapMetaPolicy.sortTables(schema.getTables());
        }
        return schemas;
    }

    @Override
    public ColumnMeta[] readColumns(TableMeta table) throws IOException {
        ColumnMeta[] columns = this.readSingleTable(table).getColumns();
        this.fixer_.fixColumns(columns);
        return columns;
    }

    @Override
    public ForeignMeta[] readForeignKeys(TableMeta table) throws IOException {
        ForeignMeta[] fkeys = this.readSingleTable(table).getForeignKeys();
        return fkeys;
    }

    @Override
    public TableMeta[] readTables(SchemaMeta schema) {
        throw new UnsupportedOperationException("Schemas contain tables; shouldn't need this method");
    }

    private TableMeta readSingleTable(TableMeta table) throws IOException {
        TableMeta[] tables;
        String[] cstNames = this.syntax_.getCatalogSchemaTable(table.getName());
        String tName = cstNames != null ? cstNames[2] : this.fixer_.getOriginalTableName(table);
        URL turl = new URL(this.url_ + "/" + this.syntax_.unquote(tName));
        SchemaMeta[] schemas = this.readSchemas(turl);
        if (schemas.length == 1 && (tables = schemas[0].getTables()) != null && tables.length == 1) {
            return tables[0];
        }
        throw new IOException("Table metadata not found at " + turl);
    }

    private SchemaMeta[] readSchemas(URL url) throws IOException {
        SchemaMeta[] schemas;
        logger_.info("Reading table metadata from " + url);
        try {
            schemas = TableSetSaxHandler.readTableSet(url, this.coding_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Invalid TableSet XML document").initCause(e);
        }
        return schemas;
    }

    @Override
    public String getSource() {
        return this.url_.toString();
    }

    @Override
    public String getMeans() {
        return "VizieR-variant 2-stage VOSI TableSet";
    }
}

