/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.MetaNameFixer;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetSaxHandler;
import uk.ac.starlink.vo.TapMetaPolicy;
import uk.ac.starlink.vo.TapMetaReader;

public class Vosi11TapMetaReader
implements TapMetaReader {
    private final URL url_;
    private final MetaNameFixer fixer_;
    private final ContentCoding coding_;
    private final DetailMode detailMode_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public Vosi11TapMetaReader(URL tablesetUrl, MetaNameFixer fixer, ContentCoding coding, DetailMode detailMode) {
        this.url_ = tablesetUrl;
        fixer = fixer == null ? MetaNameFixer.NONE : fixer;
        this.fixer_ = fixer;
        this.coding_ = coding;
        this.detailMode_ = detailMode;
    }

    @Override
    public String getMeans() {
        String note = this.detailMode_.note_;
        return "VOSI-1.1-PR" + (note == null ? "" : ", " + note);
    }

    @Override
    public String getSource() {
        return this.url_.toString();
    }

    @Override
    public SchemaMeta[] readSchemas() throws IOException {
        SchemaMeta[] schemas = this.populateHandler(null, this.detailMode_).getSchemas(true);
        if (this.fixer_ != null) {
            this.fixer_.fixSchemas(schemas);
        }
        TapMetaPolicy.sortSchemas(schemas);
        int nTable = 0;
        int nDetail = 0;
        for (SchemaMeta schema : schemas) {
            TableMeta[] tables = schema.getTables();
            if (tables == null) continue;
            TapMetaPolicy.sortTables(tables);
            for (TableMeta table : tables) {
                boolean hasDetail;
                ++nTable;
                ColumnMeta[] cols = table.getColumns();
                ForeignMeta[] fkeys = table.getForeignKeys();
                boolean bl = hasDetail = cols != null && cols.length > 0 || fkeys != null && fkeys.length > 0;
                if (!hasDetail) {
                    table.setColumns(null);
                    table.setForeignKeys(null);
                    continue;
                }
                ++nDetail;
            }
        }
        if (this.detailMode_ == DetailMode.MAX && nDetail == 0) {
            logger_.info("Table column/fkey metadata absent despite " + this.detailMode_.query_ + " - will acquire per-table as required");
        } else if (this.detailMode_ == DetailMode.MIN && nDetail > 0) {
            logger_.info("Table column/fkey metadata present despite " + this.detailMode_.query_ + " - no further metadata requests required");
        }
        return schemas;
    }

    @Override
    public TableMeta[] readTables(SchemaMeta schema) {
        String msg = "You shouldn't need to call this method (if you've got the schemas you've got the tables)";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public ColumnMeta[] readColumns(TableMeta table) throws IOException {
        return this.readSingleTable(table).getColumns();
    }

    @Override
    public ForeignMeta[] readForeignKeys(TableMeta table) throws IOException {
        return this.readSingleTable(table).getForeignKeys();
    }

    private TableMeta readSingleTable(TableMeta table) throws IOException {
        String tname = this.fixer_.getOriginalTableName(table);
        String subPath = "/" + tname;
        TableSetSaxHandler tsHandler = this.populateHandler(subPath, null);
        ArrayList<TableMeta> tlist = new ArrayList<TableMeta>();
        tlist.addAll(Arrays.asList(tsHandler.getNakedTables()));
        for (SchemaMeta schema : tsHandler.getSchemas(false)) {
            TableMeta[] tables = schema.getTables();
            if (tables == null) continue;
            tlist.addAll(Arrays.asList(tables));
        }
        TableMeta[] tables = tlist.toArray(new TableMeta[0]);
        int nt = tables.length;
        if (nt == 1) {
            return tables[0];
        }
        throw new IOException((nt == 0 ? "No table element" : "Multiple table elements") + " at " + this.url_ + subPath);
    }

    private TableSetSaxHandler populateHandler(String subPath, DetailMode detailMode) throws IOException {
        String query;
        String surl = this.url_.toString();
        if (subPath != null && subPath.length() > 0) {
            surl = surl + "/" + subPath;
        }
        String string = query = detailMode == null ? null : detailMode.query_;
        if (query != null) {
            surl = surl + "?" + query;
        }
        URL url = new URL(surl);
        logger_.info("Reading table metadata from " + url);
        try {
            return TableSetSaxHandler.populateHandler(url, this.coding_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Invalid TableSet XML document").initCause(e);
        }
    }

    public static enum DetailMode {
        MIN("detail=min", "minimal detail requested", "if supported, all metadata is read at once"),
        MAX("detail=max", "full detail requested", "if supported, column and foreign-key metadata is only read as required"),
        NULL(null, null, "service decides whether column and foreign key metadata is read all at once or on demand");

        private final String query_;
        private final String note_;
        private final String descrip_;

        private DetailMode(String query, String note, String descrip) {
            this.query_ = query;
            this.note_ = note;
            this.descrip_ = descrip;
        }

        public String getDescription() {
            return this.descrip_;
        }
    }
}

