/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.ivoa.registry.RegistryAccessException;
import net.ivoa.registry.RegistryFormatException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AssessWSDL {
    protected URL wsdlurl = null;
    protected Document wsdl = null;
    protected DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    public final String targetNamespace;
    public static final String defaultSearchTargetNamespace = "http://www.ivoa.net/wsdl/RegistrySearch/v1.0";
    static XPath xpengine = null;
    static XPathExpression definitionsxp = null;
    static XPathExpression inclxp = null;
    static XPathExpression kwsxp = null;
    static XPathExpression maxxp = null;
    static XPathExpression toxp = null;
    static XPathExpression importxp = null;
    static XPathExpression theimportxp = null;
    XPathExpression wschemaxp = null;
    XPathExpression schemaxp = null;
    static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    public static final int VARIANT_UNRECOGNIZED = 0;
    public static final int VARIANT_ACCEPTS_MAX = 1;
    public static final int VARIANT_ACCEPTS_TO = 2;

    public AssessWSDL(String wsdl) throws MalformedURLException {
        this(new URL(wsdl), defaultSearchTargetNamespace);
    }

    public AssessWSDL(File wsdl) throws MalformedURLException {
        this("file:" + wsdl.toString());
    }

    public AssessWSDL(URL wsdl) {
        this(wsdl, defaultSearchTargetNamespace);
    }

    public AssessWSDL(URL wsdl, String targetNamespace) {
        this.wsdlurl = wsdl;
        this.targetNamespace = targetNamespace;
        this.dbf.setAttribute(NAMESPACES_FEATURE_ID, Boolean.TRUE);
    }

    public URL getWSDLURL() {
        return this.wsdlurl;
    }

    protected XPath getXPathEngine() {
        if (this.schemaxp == null || this.wschemaxp == null || xpengine == null) {
            try {
                if (xpengine == null) {
                    xpengine = XPathFactory.newInstance().newXPath();
                    NSCntxt nsc = new NSCntxt();
                    nsc.addMapping("w", "http://schemas.xmlsoap.org/wsdl/");
                    nsc.addMapping("x", "http://www.w3.org/2001/XMLSchema");
                    xpengine.setNamespaceContext(nsc);
                    definitionsxp = xpengine.compile("w:definitions");
                    inclxp = xpengine.compile("x:include");
                    kwsxp = xpengine.compile("x:element[@name='KeywordSearch']");
                    maxxp = xpengine.compile("x:complexType/x:sequence/x:element[@name='max']");
                    toxp = xpengine.compile("x:complexType/x:sequence/x:element[@name='to']");
                    theimportxp = xpengine.compile("w:import[@namespace='http://www.ivoa.net/wsdl/RegistrySearch/v1.0']");
                    importxp = xpengine.compile("w:import");
                }
                if (this.schemaxp == null) {
                    this.schemaxp = xpengine.compile("x:schema[@targetNamespace='" + this.targetNamespace + "']");
                }
                if (this.wschemaxp == null) {
                    this.wschemaxp = xpengine.compile("w:types/x:schema[@targetNamespace='" + this.targetNamespace + "']");
                }
            }
            catch (XPathExpressionException ex) {
                throw new InternalError("programmer error: bad XPath syntax: " + ex.getMessage());
            }
        }
        return xpengine;
    }

    public void recacheWSDLDoc() throws IOException, ParserConfigurationException, SAXException {
        InputStream fromurl = this.wsdlurl.openStream();
        Document doc = this.dbf.newDocumentBuilder().parse(new InputSource(fromurl));
        try {
            fromurl.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.wsdl = doc;
    }

    public void cacheWSDLDoc() throws RegistryAccessException {
        if (this.wsdl == null) {
            try {
                this.recacheWSDLDoc();
            }
            catch (IOException ex) {
                throw new RegistryAccessException("Failed to read WSDL: " + ex.getMessage());
            }
            catch (ParserConfigurationException ex) {
                throw new InternalError("configuration error: can't create XML parser: " + ex.getMessage());
            }
            catch (SAXException ex) {
                throw new RegistryFormatException("error parsing WSDL: " + ex.getMessage());
            }
        }
    }

    public Document getDocument() throws RegistryAccessException {
        this.cacheWSDLDoc();
        return this.wsdl;
    }

    public int determineKeywordSearchInterfaceVariant() throws RegistryAccessException {
        int variant;
        block21: {
            Document doc = this.getDocument();
            variant = 0;
            Object xpe = null;
            this.getXPathEngine();
            try {
                Element defs = null;
                defs = (Element)definitionsxp.evaluate(doc, XPathConstants.NODE);
                if (defs == null) {
                    return variant;
                }
                if (this.targetNamespace.equals(defs.getAttribute("targetNamespace"))) {
                    Element schema = (Element)this.wschemaxp.evaluate(defs, XPathConstants.NODE);
                    if (schema == null) {
                        return variant;
                    }
                    Element ksel = (Element)kwsxp.evaluate(schema, XPathConstants.NODE);
                    if (ksel == null) {
                        Object oinc = inclxp.evaluate(schema, XPathConstants.NODESET);
                        NodeList incls = (NodeList)oinc;
                        if (incls == null) {
                            return variant;
                        }
                        int ni = incls.getLength();
                        for (int i = 0; i < ni && ksel == null; ++i) {
                            Element incl = (Element)incls.item(i);
                            ksel = this.findKwsInInclude(incl.getAttribute("schemaLocation"));
                        }
                    }
                    if (ksel == null) {
                        return variant;
                    }
                    if (maxxp.evaluate(ksel, XPathConstants.NODE) != null) {
                        variant |= 1;
                    }
                    if (toxp.evaluate(ksel, XPathConstants.NODE) != null) {
                        variant |= 2;
                    }
                    break block21;
                }
                NodeList imports = (NodeList)theimportxp.evaluate(defs, XPathConstants.NODESET);
                if (imports == null || imports.getLength() == 0) {
                    imports = (NodeList)importxp.evaluate(defs, XPathConstants.NODESET);
                }
                Element imp = null;
                String ns = null;
                String url = null;
                if (imports == null) {
                    return variant;
                }
                int l = imports.getLength();
                for (int i = 0; i < l; ++i) {
                    AssessWSDL nxtwsdl;
                    imp = (Element)imports.item(i);
                    ns = imp.getAttribute("namespace");
                    if (ns == null) continue;
                    if (this.targetNamespace.equals(ns)) {
                        url = imp.getAttribute("location");
                        if (url == null) continue;
                        if (this.targetNamespace.equals(url)) {
                            variant |= 1;
                            break;
                        }
                        try {
                            nxtwsdl = new AssessWSDL(new URL(url), this.targetNamespace);
                            variant |= nxtwsdl.determineKeywordSearchInterfaceVariant();
                            break;
                        }
                        catch (MalformedURLException ex) {
                            throw new RegistryFormatException("bad URL for standard search WSDL: " + url);
                        }
                    }
                    if (ns.startsWith("http://www.ivoa.net/xml")) continue;
                    url = imp.getAttribute("schemaLocation");
                    try {
                        nxtwsdl = new AssessWSDL(new URL(url), this.targetNamespace);
                        variant |= nxtwsdl.determineKeywordSearchInterfaceVariant();
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        continue;
                    }
                    catch (RegistryAccessException ex) {
                        // empty catch block
                    }
                }
            }
            catch (XPathExpressionException ex) {
                throw new InternalError("programmer error: bad XPath syntax?: " + ex.getMessage());
            }
        }
        return variant;
    }

    Element findKwsInInclude(String locurl) {
        try {
            Document doc = this.dbf.newDocumentBuilder().parse(new InputSource(locurl));
            Element schel = (Element)this.schemaxp.evaluate(doc, XPathConstants.NODE);
            if (schel == null) {
                return null;
            }
            Element out = (Element)kwsxp.evaluate(schel, XPathConstants.NODE);
            return out;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int keywordSearchVariant(URL url) throws RegistryAccessException {
        AssessWSDL aw = new AssessWSDL(url);
        return aw.determineKeywordSearchInterfaceVariant();
    }

    public static void main(String[] args) {
        String wsdlurl = null;
        wsdlurl = args.length > 0 ? args[0] : defaultSearchTargetNamespace;
        try {
            int variant = AssessWSDL.keywordSearchVariant(new URL(wsdlurl));
            if ((variant & 1) > 0) {
                System.out.println("max is accepted.");
            }
            if ((variant & 2) > 0) {
                System.out.println("to is accepted.");
            }
            if (variant == 0) {
                System.out.println("unrecognized interface");
            }
        }
        catch (Exception ex) {
            System.err.println("Failed to assess WSDL: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    static class NSCntxt
    implements NamespaceContext {
        HashMap<String, String> p2u = new HashMap(5);
        HashMap<String, Set<String>> u2p = new HashMap(5);

        NSCntxt() {
            this.addMapping("xml", "http://www.w3.org/XML/1998/namespace");
            this.addMapping("xmlns", "http://www.w3.org/2000/xmlns/");
            this.addMapping("", "");
        }

        public void addMapping(String prefix, String ns) {
            this.p2u.put(prefix, ns);
            Set<String> prefixes = this.u2p.get(ns);
            if (prefixes == null) {
                prefixes = new HashSet<String>(1);
                this.u2p.put(ns, prefixes);
            }
            prefixes.add(prefix);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("null prefix");
            }
            String out = this.p2u.get(prefix);
            if (out == null) {
                return "";
            }
            return out;
        }

        @Override
        public String getPrefix(String uri) {
            Set<String> out = this.u2p.get(uri);
            if (out == null || out.size() == 0) {
                return null;
            }
            return out.iterator().next();
        }

        public Iterator getPrefixes(String ns) {
            Set<String> out = this.u2p.get(ns);
            if (out == null) {
                out = new HashSet<String>(1);
            }
            return out.iterator();
        }
    }
}

