/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public class ChoiceParameter<T>
extends Parameter<T> {
    private final Map<T, String> optionMap_ = new LinkedHashMap<T, String>();
    private boolean usageSet_;

    public ChoiceParameter(String name, Class<T> clazz, T[] options) {
        super(name, clazz, true);
        if (options != null) {
            for (int iopt = 0; iopt < options.length; ++iopt) {
                this.addOption(options[iopt]);
            }
        }
    }

    public ChoiceParameter(String name, Class<T> clazz) {
        this(name, clazz, null);
    }

    public ChoiceParameter(String name, T[] options) {
        this(name, options.getClass().getComponentType(), options);
    }

    @Override
    public T stringToObject(Environment env, String sval) throws TaskException {
        for (T option : this.optionMap_.keySet()) {
            if (!sval.equalsIgnoreCase(this.getName(option))) continue;
            return option;
        }
        StringBuffer sbuf = new StringBuffer().append("Unknown value ").append(sval).append(" - must be one of ");
        Iterator<T> it = this.optionMap_.keySet().iterator();
        while (it.hasNext()) {
            sbuf.append(this.getName(it.next()));
            if (!it.hasNext()) continue;
            sbuf.append(", ");
        }
        throw new ParameterValueException((Parameter)this, sbuf.toString());
    }

    @Override
    public String objectToString(Environment env, T objVal) {
        return this.optionMap_.containsKey(objVal) ? this.optionMap_.get(objVal) : this.stringifyOption(objVal);
    }

    public void addOption(T option, String name) {
        this.optionMap_.put(option, name);
    }

    public void addOption(T option) {
        this.addOption(option, this.stringifyOption(option));
    }

    public void clearOptions() {
        this.optionMap_.clear();
    }

    @Override
    public String getUsage() {
        if (this.usageSet_) {
            return super.getUsage();
        }
        StringBuffer sbuf = new StringBuffer();
        Iterator<T> it = this.optionMap_.keySet().iterator();
        while (it.hasNext()) {
            sbuf.append(this.getName(it.next()));
            if (!it.hasNext()) continue;
            sbuf.append('|');
        }
        return sbuf.toString();
    }

    @Override
    public void setUsage(String usage) {
        this.usageSet_ = true;
        super.setUsage(usage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDefaultOption(T option) {
        if (option == null) {
            if (!this.isNullPermitted()) throw new IllegalArgumentException("null value not allowed");
            this.setStringDefault(null);
            return;
        } else {
            if (!this.optionMap_.containsKey(option)) throw new IllegalArgumentException("No such option: " + option);
            this.setStringDefault(this.getName(option));
        }
    }

    public String[] getOptionNames() {
        ArrayList<String> optNameList = new ArrayList<String>();
        for (T option : this.optionMap_.keySet()) {
            optNameList.add(this.getName(option));
        }
        return optNameList.toArray(new String[0]);
    }

    public T[] getOptions() {
        return this.toArray(this.getOptionValueList());
    }

    public Collection<T> getOptionValueList() {
        return this.optionMap_.keySet();
    }

    public String getName(T option) {
        String name = this.optionMap_.get(option);
        return name == null ? this.stringifyOption(option) : name;
    }

    public String stringifyOption(T option) {
        return String.valueOf(option);
    }

    public T getOption(String name) {
        for (T option : this.optionMap_.keySet()) {
            if (!name.equalsIgnoreCase(this.getName(option))) continue;
            return option;
        }
        return null;
    }
}

