/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.util.DataSource;

public class InputStreamParameter
extends Parameter<InputStream> {
    public InputStreamParameter(String name) {
        super(name, InputStream.class, true);
        this.setUsage("<location>");
    }

    @Override
    public InputStream stringToObject(Environment env, String sval) throws ParameterValueException {
        if (!sval.equals("-") && !new File(sval).exists()) {
            try {
                new URL(sval);
            }
            catch (MalformedURLException e) {
                String msg = "Value " + sval + " is not a file, URL or \"-\"";
                throw new ParameterValueException((Parameter)this, msg);
            }
        }
        try {
            return DataSource.getInputStream(sval);
        }
        catch (IOException e) {
            throw new ParameterValueException((Parameter)this, e.getMessage());
        }
    }
}

