/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class ObjectFactoryParameter<T>
extends Parameter<T> {
    private final ObjectFactory<T> factory_;
    private Object objValue_;

    public ObjectFactoryParameter(String name, ObjectFactory<T> factory) {
        super(name, factory.getFactoryClass(), false);
        this.factory_ = factory;
    }

    public ObjectFactory<T> getObjectFactory() {
        return this.factory_;
    }

    @Override
    public T stringToObject(Environment env, String sval) throws ParameterValueException {
        try {
            return this.factory_.createObject(sval);
        }
        catch (LoadException e) {
            throw new ParameterValueException((Parameter)this, (Throwable)e);
        }
    }

    @Override
    public String getUsage() {
        StringBuffer sbuf = new StringBuffer();
        String[] nickNames = this.factory_.getNickNames();
        for (int i = 0; i < nickNames.length; ++i) {
            if (i > 0) {
                sbuf.append('|');
            }
            sbuf.append(nickNames[i]);
        }
        return sbuf.toString();
    }
}

