/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.InvokeUtils;
import uk.ac.starlink.task.LineEnvironment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.UsageException;

public class SingleTaskInvoker {
    private String taskName_;
    private final Task task_;

    public SingleTaskInvoker(Task task, String taskName) {
        this.task_ = task;
        this.taskName_ = taskName;
    }

    public int invoke(String[] args) {
        String arg;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean debug = false;
        Iterator it = argList.iterator();
        while (it.hasNext() && (arg = (String)it.next()).charAt(0) == '-') {
            if ("-help".equals(arg)) {
                it.remove();
                System.out.println(this.getUsage());
                return 0;
            }
            if (!"-debug".equals(arg)) continue;
            it.remove();
            debug = true;
        }
        try {
            String[] taskArgs = argList.toArray(new String[0]);
            LineEnvironment env = new LineEnvironment(taskArgs, this.task_.getParameters());
            this.task_.createExecutable(env).execute();
        }
        catch (Exception e) {
            if (debug) {
                System.err.println();
                e.printStackTrace(System.err);
            }
            System.err.println();
            InvokeUtils.summariseError(e, System.err);
            if (!(e instanceof ParameterValueException) && !(e instanceof IOException)) {
                if (e instanceof UsageException) {
                    System.err.println();
                    System.err.println(this.getUsage());
                } else if (e instanceof AbortException) {
                    System.err.println();
                    System.err.println("User abort");
                } else if (!debug) {
                    System.err.println();
                    e.printStackTrace(System.err);
                }
            }
            return 1;
        }
        return 0;
    }

    public String getUsage() {
        StringBuffer ubuf = new StringBuffer();
        ubuf.append("Usage: ").append(this.taskName_);
        String padding = ubuf.toString().replaceAll(".", " ") + " ";
        ubuf.append(" [-help]").append(" [-debug]");
        Parameter[] params = InvokeUtils.sortParameters(this.task_.getParameters());
        for (int i = 0; i < params.length; ++i) {
            ubuf.append('\n').append(padding);
            Parameter param = params[i];
            boolean optional = param.isNullPermitted() || param.getStringDefault() != null;
            ubuf.append(optional ? "[" : "").append(param.getName()).append('=').append(param.getUsage()).append(optional ? "]" : "");
        }
        return ubuf.toString();
    }
}

