/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBTable;
import adql.db.DefaultDBTable;
import adql.db.FunctionDef;
import adql.db.STCS;
import adql.db.SearchColumnList;
import adql.db.SearchTableList;
import adql.db.exception.UnresolvedColumnException;
import adql.db.exception.UnresolvedFunctionException;
import adql.db.exception.UnresolvedIdentifiersException;
import adql.db.exception.UnresolvedTableException;
import adql.parser.ParseException;
import adql.parser.QueryChecker;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.ClauseSelect;
import adql.query.ColumnReference;
import adql.query.IdentifierField;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.from.ADQLTable;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.StringConstant;
import adql.query.operand.UnknownType;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.DefaultUDF;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.search.SearchColumnHandler;
import adql.search.SimpleReplaceHandler;
import adql.search.SimpleSearchHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBChecker
implements QueryChecker {
    protected SearchTableList lstTables;
    protected String[] allowedGeo = null;
    protected String[] allowedCoordSys = null;
    protected String coordSysRegExp = null;
    protected FunctionDef[] allowedUdfs = null;

    public DBChecker() {
        this(null, null);
    }

    public DBChecker(Collection<? extends DBTable> tables) {
        this(tables, null);
    }

    public DBChecker(Collection<? extends DBTable> tables, Collection<? extends FunctionDef> allowedUdfs) {
        this.setTables(tables);
        if (allowedUdfs != null) {
            FunctionDef[] tmp = new FunctionDef[allowedUdfs.size()];
            int cnt = 0;
            for (FunctionDef functionDef : allowedUdfs) {
                if (functionDef == null || functionDef.name.trim().length() <= 0) continue;
                tmp[cnt++] = functionDef;
            }
            this.allowedUdfs = new FunctionDef[cnt];
            System.arraycopy(tmp, 0, this.allowedUdfs, 0, cnt);
            tmp = null;
            Arrays.sort(this.allowedUdfs);
        }
    }

    public DBChecker(Collection<? extends DBTable> tables, Collection<String> allowedGeoFcts, Collection<String> allowedCoordSys) throws ParseException {
        this(tables, null, allowedGeoFcts, allowedCoordSys);
    }

    public DBChecker(Collection<? extends DBTable> tables, Collection<? extends FunctionDef> allowedUdfs, Collection<String> allowedGeoFcts, Collection<String> allowedCoordSys) throws ParseException {
        this(tables, allowedUdfs);
        this.allowedGeo = DBChecker.specialSort(allowedGeoFcts);
        this.allowedCoordSys = DBChecker.specialSort(allowedCoordSys);
        this.coordSysRegExp = STCS.buildCoordSysRegExp(this.allowedCoordSys);
    }

    protected static final String[] specialSort(Collection<String> items) {
        if (items == null) {
            return null;
        }
        String[] tmp = new String[items.size()];
        int cnt = 0;
        for (String item : items) {
            if (item == null || item.trim().length() <= 0) continue;
            tmp[cnt++] = item;
        }
        Object[] copy = new String[cnt];
        System.arraycopy(tmp, 0, copy, 0, cnt);
        Arrays.sort(copy);
        return copy;
    }

    public final void setTables(Collection<? extends DBTable> tables) {
        this.lstTables = tables == null ? new SearchTableList() : (tables instanceof SearchTableList ? (SearchTableList)tables : new SearchTableList(tables));
    }

    @Override
    public final void check(ADQLQuery query) throws ParseException {
        this.check(query, null);
    }

    protected void check(ADQLQuery query, Stack<SearchColumnList> fathersList) throws UnresolvedIdentifiersException {
        UnresolvedIdentifiersException errors = new UnresolvedIdentifiersException();
        SearchColumnList availableColumns = this.checkDBItems(query, fathersList, errors);
        if (this.allowedUdfs != null) {
            this.checkUDFs(query, errors);
        }
        this.checkGeometries(query, errors);
        this.checkTypes(query, errors);
        this.checkSubQueries(query, fathersList, availableColumns, errors);
        if (errors.getNbErrors() > 0) {
            throw errors;
        }
    }

    protected SearchColumnList checkDBItems(ADQLQuery query, Stack<SearchColumnList> fathersList, UnresolvedIdentifiersException errors) {
        SearchColumnList availableColumns;
        Map<DBTable, ADQLTable> mapTables = this.resolveTables(query, fathersList, errors);
        try {
            availableColumns = query.getFrom().getDBColumns();
        }
        catch (ParseException pe) {
            errors.addException(pe);
            availableColumns = new SearchColumnList();
        }
        this.resolveColumns(query, fathersList, mapTables, availableColumns, errors);
        return availableColumns;
    }

    protected Map<DBTable, ADQLTable> resolveTables(ADQLQuery query, Stack<SearchColumnList> fathersList, UnresolvedIdentifiersException errors) {
        HashMap<DBTable, ADQLTable> mapTables = new HashMap<DBTable, ADQLTable>();
        SimpleSearchHandler sHandler = new SearchTableHandler();
        sHandler.search(query.getFrom());
        for (ADQLObject result : sHandler) {
            try {
                ADQLTable table = (ADQLTable)result;
                DBTable dbTable = null;
                if (table.isSubQuery()) {
                    this.check(table.getSubQuery(), fathersList);
                    dbTable = DBChecker.generateDBTable(table.getSubQuery(), table.getAlias());
                } else {
                    dbTable = this.resolveTable(table);
                    if (table.hasAlias()) {
                        dbTable = dbTable.copy(null, table.getAlias());
                    }
                }
                table.setDBLink(dbTable);
                mapTables.put(dbTable, table);
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
        sHandler = new SearchWildCardHandler();
        sHandler.search(query.getSelect());
        for (ADQLObject result : sHandler) {
            try {
                ArrayList<ADQLTable> tables;
                SelectAllColumns wildcard = (SelectAllColumns)result;
                ADQLTable table = wildcard.getAdqlTable();
                DBTable dbTable = null;
                if (table.getTableName() != null && table.getSchemaName() == null && (tables = query.getFrom().getTablesByAlias(table.getTableName(), table.isCaseSensitive(IdentifierField.TABLE))).size() == 1) {
                    dbTable = tables.get(0).getDBLink();
                }
                if (dbTable == null) {
                    dbTable = this.resolveTable(table);
                }
                wildcard.setAdqlTable(mapTables.get(dbTable));
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
        return mapTables;
    }

    protected DBTable resolveTable(ADQLTable table) throws ParseException {
        ArrayList<DBTable> tables = this.lstTables.search(table);
        if (tables.size() == 1) {
            return tables.get(0);
        }
        if (tables.size() > 1) {
            throw new UnresolvedTableException(table, (tables.get(0).getADQLSchemaName() == null ? "" : tables.get(0).getADQLSchemaName() + ".") + tables.get(0).getADQLName(), (tables.get(1).getADQLSchemaName() == null ? "" : tables.get(1).getADQLSchemaName() + ".") + tables.get(1).getADQLName());
        }
        throw new UnresolvedTableException(table);
    }

    protected void resolveColumns(ADQLQuery query, Stack<SearchColumnList> fathersList, Map<DBTable, ADQLTable> mapTables, SearchColumnList list, UnresolvedIdentifiersException errors) {
        SimpleSearchHandler sHandler = new SearchColumnHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            try {
                ADQLColumn adqlColumn = (ADQLColumn)result;
                DBColumn dbColumn = this.resolveColumn(adqlColumn, list, fathersList);
                adqlColumn.setDBLink(dbColumn);
                adqlColumn.setAdqlTable(mapTables.get(dbColumn.getTable()));
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
        sHandler = new SearchColReferenceHandler();
        sHandler.search(query);
        ClauseSelect select = query.getSelect();
        for (ADQLObject result : sHandler) {
            try {
                ColumnReference colRef = (ColumnReference)result;
                DBColumn dbColumn = this.checkColumnReference(colRef, select, list);
                colRef.setDBLink(dbColumn);
                if (dbColumn == null) continue;
                colRef.setAdqlTable(mapTables.get(dbColumn.getTable()));
            }
            catch (ParseException pe) {
                errors.addException(pe);
            }
        }
    }

    protected DBColumn resolveColumn(ADQLColumn column, SearchColumnList dbColumns, Stack<SearchColumnList> fathersList) throws ParseException {
        ArrayList<DBColumn> foundColumns = dbColumns.search(column);
        if (foundColumns.size() == 1) {
            return foundColumns.get(0);
        }
        if (foundColumns.size() > 1) {
            if (column.getTableName() == null) {
                throw new UnresolvedColumnException(column, foundColumns.get(0).getTable() == null ? "<NULL>" : foundColumns.get(0).getTable().getADQLName() + "." + foundColumns.get(0).getADQLName(), foundColumns.get(1).getTable() == null ? "<NULL>" : foundColumns.get(1).getTable().getADQLName() + "." + foundColumns.get(1).getADQLName());
            }
            throw new UnresolvedTableException(column, foundColumns.get(0).getTable() == null ? "<NULL>" : foundColumns.get(0).getTable().getADQLName(), foundColumns.get(1).getTable() == null ? "<NULL>" : foundColumns.get(1).getTable().getADQLName());
        }
        if (fathersList == null || fathersList.isEmpty()) {
            throw new UnresolvedColumnException(column);
        }
        Stack<SearchColumnList> subStack = new Stack<SearchColumnList>();
        subStack.addAll(fathersList.subList(0, fathersList.size() - 1));
        return this.resolveColumn(column, fathersList.peek(), subStack);
    }

    protected DBColumn checkColumnReference(ColumnReference colRef, ClauseSelect select, SearchColumnList dbColumns) throws ParseException {
        if (colRef.isIndex()) {
            int index = colRef.getColumnIndex();
            if (index > 0 && index <= select.size()) {
                SelectItem item = (SelectItem)select.get(index - 1);
                if (item.getOperand() instanceof ADQLColumn) {
                    return ((ADQLColumn)item.getOperand()).getDBLink();
                }
                return null;
            }
            throw new ParseException("Column index out of bounds: " + index + " (must be between 1 and " + select.size() + ") !", colRef.getPosition());
        }
        ADQLColumn col = new ADQLColumn(colRef.getColumnName());
        col.setCaseSensitive(colRef.isCaseSensitive());
        col.setPosition(colRef.getPosition());
        if (col.getTableName() == null) {
            ArrayList<SelectItem> founds = select.searchByAlias(colRef.getColumnName(), colRef.isCaseSensitive());
            if (founds.size() == 1) {
                return null;
            }
            if (founds.size() > 1) {
                throw new UnresolvedColumnException(col, founds.get(0).getAlias(), founds.get(1).getAlias());
            }
        }
        return this.resolveColumn(col, dbColumns, null);
    }

    public static DBTable generateDBTable(ADQLQuery subQuery, String tableName) throws ParseException {
        DBColumn[] columns;
        DefaultDBTable dbTable = new DefaultDBTable(tableName);
        for (DBColumn dbCol : columns = subQuery.getResultingColumns()) {
            dbTable.addColumn(dbCol.copy(dbCol.getADQLName(), dbCol.getADQLName(), dbTable));
        }
        return dbTable;
    }

    protected void checkUDFs(ADQLQuery query, UnresolvedIdentifiersException errors) {
        SearchUDFHandler sHandler = new SearchUDFHandler();
        sHandler.search(query);
        if (this.allowedUdfs.length == 0) {
            for (ADQLObject result : sHandler) {
                errors.addException(new UnresolvedFunctionException((UserDefinedFunction)result));
            }
        } else {
            int match;
            UserDefinedFunction udf;
            ArrayList<UserDefinedFunction> toResolveLater = new ArrayList<UserDefinedFunction>();
            BinarySearch<FunctionDef, UserDefinedFunction> binSearch = new BinarySearch<FunctionDef, UserDefinedFunction>(){

                @Override
                protected int compare(UserDefinedFunction searchItem, FunctionDef arrayItem) {
                    return arrayItem.compareTo(searchItem) * -1;
                }
            };
            for (ADQLObject result : sHandler) {
                udf = (UserDefinedFunction)result;
                match = binSearch.search(udf, this.allowedUdfs);
                if (match < 0) {
                    if (this.isAllParamTypesResolved(udf)) {
                        errors.addException(new UnresolvedFunctionException(udf));
                        continue;
                    }
                    toResolveLater.add(udf);
                    continue;
                }
                if (!(udf instanceof DefaultUDF)) continue;
                ((DefaultUDF)udf).setDefinition(this.allowedUdfs[match]);
            }
            for (int i = 0; i < toResolveLater.size(); ++i) {
                udf = (UserDefinedFunction)toResolveLater.get(i);
                match = binSearch.search(udf, this.allowedUdfs);
                if (match < 0) {
                    errors.addException(new UnresolvedFunctionException(udf));
                    continue;
                }
                if (!(udf instanceof DefaultUDF)) continue;
                ((DefaultUDF)udf).setDefinition(this.allowedUdfs[match]);
            }
            new ReplaceDefaultUDFHandler(errors).searchAndReplace(query);
        }
    }

    protected final boolean isAllParamTypesResolved(ADQLFunction fct) {
        for (ADQLOperand op : fct.getParameters()) {
            if (op.isNumeric() != op.isString()) continue;
            return false;
        }
        return true;
    }

    protected void checkGeometries(ADQLQuery query, UnresolvedIdentifiersException errors) {
        BinarySearch<String, String> binSearch = new BinarySearch<String, String>(){

            @Override
            protected int compare(String searchItem, String arrayItem) {
                return searchItem.compareToIgnoreCase(arrayItem);
            }
        };
        if (this.allowedGeo != null) {
            this.resolveGeometryFunctions(query, binSearch, errors);
        }
        if (this.allowedCoordSys != null) {
            this.resolveCoordinateSystems(query, errors);
        }
        if (this.allowedGeo == null || this.allowedGeo.length > 0 && binSearch.search("REGION", this.allowedGeo) >= 0) {
            this.resolveSTCSExpressions(query, binSearch, errors);
        }
    }

    protected void resolveGeometryFunctions(ADQLQuery query, BinarySearch<String, String> binSearch, UnresolvedIdentifiersException errors) {
        SearchGeometryHandler sHandler = new SearchGeometryHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            String fctName = result.getName();
            this.checkGeometryFunction(fctName, (ADQLFunction)result, binSearch, errors);
        }
    }

    protected void checkGeometryFunction(String fctName, ADQLFunction fct, BinarySearch<String, String> binSearch, UnresolvedIdentifiersException errors) {
        int match = -1;
        if (this.allowedGeo.length != 0) {
            match = binSearch.search(fctName, (String[])this.allowedGeo);
        }
        if (match < 0) {
            errors.addException(new UnresolvedFunctionException("The geometrical function \"" + fctName + "\" is not available in this implementation!", fct));
        }
    }

    protected void resolveCoordinateSystems(ADQLQuery query, UnresolvedIdentifiersException errors) {
        SearchCoordSysHandler sHandler = new SearchCoordSysHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            this.checkCoordinateSystem((StringConstant)result, errors);
        }
    }

    protected void checkCoordinateSystem(StringConstant adqlCoordSys, UnresolvedIdentifiersException errors) {
        String coordSysStr = adqlCoordSys.getValue();
        try {
            this.checkCoordinateSystem(STCS.parseCoordSys(coordSysStr), adqlCoordSys, errors);
        }
        catch (ParseException pe) {
            errors.addException(new ParseException(pe.getMessage(), adqlCoordSys.getPosition()));
        }
    }

    protected void checkCoordinateSystem(STCS.CoordSys coordSys, ADQLOperand operand, UnresolvedIdentifiersException errors) {
        if (this.coordSysRegExp != null && coordSys != null && !coordSys.toFullSTCS().matches(this.coordSysRegExp)) {
            StringBuffer buf = new StringBuffer();
            if (this.allowedCoordSys != null) {
                for (String cs : this.allowedCoordSys) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(cs);
                }
            }
            if (buf.length() == 0) {
                buf.append("No coordinate system is allowed!");
            } else {
                buf.insert(0, "Allowed coordinate systems are: ");
            }
            errors.addException(new ParseException("Coordinate system \"" + (operand instanceof StringConstant ? ((StringConstant)operand).getValue() : coordSys.toString()) + "\" (= \"" + coordSys.toFullSTCS() + "\") not allowed in this implementation. " + buf.toString(), operand.getPosition()));
        }
    }

    protected void resolveSTCSExpressions(ADQLQuery query, BinarySearch<String, String> binSearch, UnresolvedIdentifiersException errors) {
        SearchRegionHandler sHandler = new SearchRegionHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            try {
                String stcs = ((StringConstant)((RegionFunction)result).getParameter(0)).getValue();
                STCS.Region region = STCS.parseRegion(stcs);
                this.checkRegion(region, (RegionFunction)result, binSearch, errors);
            }
            catch (ParseException pe) {
                errors.addException(new ParseException(pe.getMessage(), result.getPosition()));
            }
        }
    }

    protected void checkRegion(STCS.Region r, RegionFunction fct, BinarySearch<String, String> binSearch, UnresolvedIdentifiersException errors) {
        if (r == null) {
            return;
        }
        if (r.coordSys != null) {
            this.checkCoordinateSystem(r.coordSys, fct, errors);
        }
        if (this.allowedGeo != null) {
            if (this.allowedGeo.length == 0) {
                errors.addException(new UnresolvedFunctionException("The region type \"" + (Object)((Object)r.type) + "\" is not available in this implementation!", fct));
            } else {
                this.checkGeometryFunction(r.type == STCS.RegionType.POSITION ? "POINT" : r.type.toString(), fct, binSearch, errors);
            }
        }
        if (r.regions != null) {
            for (STCS.Region innerR : r.regions) {
                this.checkRegion(innerR, fct, binSearch, errors);
            }
        }
    }

    protected void checkTypes(ADQLQuery query, UnresolvedIdentifiersException errors) {
        SearchUnknownTypeHandler sHandler = new SearchUnknownTypeHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            UnknownType unknown = (UnknownType)result;
            switch (unknown.getExpectedType()) {
                case 'G': 
                case 'g': {
                    if (unknown.isGeometry()) break;
                    errors.addException(new ParseException("Type mismatch! A geometry was expected instead of \"" + unknown.toADQL() + "\".", result.getPosition()));
                    break;
                }
                case 'N': 
                case 'n': {
                    if (unknown.isNumeric()) break;
                    errors.addException(new ParseException("Type mismatch! A numeric value was expected instead of \"" + unknown.toADQL() + "\".", result.getPosition()));
                    break;
                }
                case 'S': 
                case 's': {
                    if (unknown.isString()) break;
                    errors.addException(new ParseException("Type mismatch! A string value was expected instead of \"" + unknown.toADQL() + "\".", result.getPosition()));
                }
            }
        }
    }

    protected void checkSubQueries(ADQLQuery query, Stack<SearchColumnList> fathersList, SearchColumnList availableColumns, UnresolvedIdentifiersException errors) {
        SearchSubQueryHandler sHandler = new SearchSubQueryHandler();
        sHandler.search(query);
        if (sHandler.getNbMatch() > 0) {
            if (fathersList == null) {
                fathersList = new Stack();
            }
            fathersList.push(availableColumns);
            for (ADQLObject result : sHandler) {
                try {
                    this.check((ADQLQuery)result, fathersList);
                }
                catch (UnresolvedIdentifiersException uie) {
                    Iterator<ParseException> itPe = uie.getErrors();
                    while (itPe.hasNext()) {
                        errors.addException(itPe.next());
                    }
                }
            }
            fathersList.pop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class BinarySearch<T, S> {
        private int s;
        private int e;
        private int m;
        private int comp;

        protected BinarySearch() {
        }

        public int search(S searchItem, T[] array) {
            this.s = 0;
            this.e = array.length - 1;
            while (this.s < this.e) {
                this.m = this.s + (this.e - this.s) / 2;
                this.comp = this.compare(searchItem, array[this.m]);
                if (this.comp > 0) {
                    this.s = this.m + 1;
                    continue;
                }
                this.e = this.m;
            }
            if (this.s != this.e || this.compare(searchItem, array[this.s]) != 0) {
                return -1;
            }
            return this.s;
        }

        protected abstract int compare(S var1, T var2);
    }

    private static class SearchRegionHandler
    extends SimpleSearchHandler {
        private SearchRegionHandler() {
        }

        protected boolean match(ADQLObject obj) {
            if (obj instanceof RegionFunction) {
                return ((RegionFunction)obj).getParameter(0) instanceof StringConstant;
            }
            return false;
        }
    }

    private static class SearchCoordSysHandler
    extends SimpleSearchHandler {
        private SearchCoordSysHandler() {
        }

        protected boolean match(ADQLObject obj) {
            if (obj instanceof PointFunction || obj instanceof BoxFunction || obj instanceof CircleFunction || obj instanceof PolygonFunction) {
                return ((GeometryFunction)obj).getCoordinateSystem() instanceof StringConstant;
            }
            return false;
        }

        protected void addMatch(ADQLObject matchObj, ADQLIterator it) {
            this.results.add(((GeometryFunction)matchObj).getCoordinateSystem());
        }
    }

    private static class SearchUnknownTypeHandler
    extends SimpleSearchHandler {
        private SearchUnknownTypeHandler() {
        }

        protected boolean match(ADQLObject obj) {
            if (obj instanceof UnknownType) {
                char expected = ((UnknownType)obj).getExpectedType();
                return expected == 'G' || expected == 'g' || expected == 'S' || expected == 's' || expected == 'N' || expected == 'n';
            }
            return false;
        }
    }

    private static class SearchGeometryHandler
    extends SimpleSearchHandler {
        private SearchGeometryHandler() {
        }

        protected boolean match(ADQLObject obj) {
            return obj instanceof GeometryFunction;
        }
    }

    private static class ReplaceDefaultUDFHandler
    extends SimpleReplaceHandler {
        private final UnresolvedIdentifiersException errors;

        public ReplaceDefaultUDFHandler(UnresolvedIdentifiersException errorsContainer) {
            this.errors = errorsContainer;
        }

        protected boolean match(ADQLObject obj) {
            return obj.getClass().getName().equals(DefaultUDF.class.getName()) && ((DefaultUDF)obj).getDefinition() != null && ((DefaultUDF)obj).getDefinition().getUDFClass() != null;
        }

        protected ADQLObject getReplacer(ADQLObject objToReplace) throws UnsupportedOperationException {
            try {
                Class<? extends UserDefinedFunction> udfClass = ((DefaultUDF)objToReplace).getDefinition().getUDFClass();
                Constructor<? extends UserDefinedFunction> constructor = udfClass.getConstructor(ADQLOperand[].class);
                return constructor.newInstance(new Object[]{((DefaultUDF)objToReplace).getParameters()});
            }
            catch (Exception ex) {
                this.errors.addException(new UnresolvedFunctionException("Impossible to represent the function \"" + ((DefaultUDF)objToReplace).getName() + "\": the following error occured while creating this representation: \"" + (ex instanceof InvocationTargetException ? "[" + ex.getCause().getClass().getSimpleName() + "] " + ex.getCause().getMessage() : ex.getMessage()) + "\"", (DefaultUDF)objToReplace));
                return objToReplace;
            }
        }
    }

    private static class SearchUDFHandler
    extends SimpleSearchHandler {
        private SearchUDFHandler() {
        }

        protected boolean match(ADQLObject obj) {
            return obj instanceof UserDefinedFunction;
        }
    }

    private static class SearchSubQueryHandler
    extends SimpleSearchHandler {
        private SearchSubQueryHandler() {
        }

        protected void addMatch(ADQLObject matchObj, ADQLIterator it) {
            if (it != null) {
                super.addMatch(matchObj, it);
            }
        }

        protected boolean goInto(ADQLObject obj) {
            return super.goInto(obj) && !(obj instanceof FromContent);
        }

        protected boolean match(ADQLObject obj) {
            return obj instanceof ADQLQuery;
        }
    }

    private static class SearchColReferenceHandler
    extends SimpleSearchHandler {
        private SearchColReferenceHandler() {
        }

        public boolean match(ADQLObject obj) {
            return obj instanceof ColumnReference;
        }
    }

    private static class SearchWildCardHandler
    extends SimpleSearchHandler {
        private SearchWildCardHandler() {
        }

        public boolean match(ADQLObject obj) {
            return obj instanceof SelectAllColumns && ((SelectAllColumns)obj).getAdqlTable() != null;
        }
    }

    private static class SearchTableHandler
    extends SimpleSearchHandler {
        private SearchTableHandler() {
        }

        public boolean match(ADQLObject obj) {
            return obj instanceof ADQLTable;
        }
    }
}

