/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBTable;
import adql.db.DBType;

public class DefaultDBColumn
implements DBColumn {
    protected String dbName;
    protected DBType type;
    protected DBTable table;
    protected String adqlName = null;

    public DefaultDBColumn(String dbName, DBTable table) {
        this(dbName, dbName, null, table);
    }

    public DefaultDBColumn(String dbName, DBType type, DBTable table) {
        this(dbName, dbName, type, table);
    }

    public DefaultDBColumn(String dbName, String adqlName, DBTable table) {
        this(dbName, adqlName, null, table);
    }

    public DefaultDBColumn(String dbName, String adqlName, DBType type, DBTable table) {
        if (dbName == null || dbName.length() == 0) {
            throw new NullPointerException("Missing DB name!");
        }
        this.dbName = dbName;
        this.adqlName = adqlName == null ? dbName : adqlName;
        this.type = type;
        this.table = table;
    }

    public final String getADQLName() {
        return this.adqlName;
    }

    public final void setADQLName(String adqlName) {
        if (adqlName != null) {
            this.adqlName = adqlName;
        }
    }

    public final DBType getDatatype() {
        return this.type;
    }

    public final void setDatatype(DBType type) {
        this.type = type;
    }

    public final String getDBName() {
        return this.dbName;
    }

    public final DBTable getTable() {
        return this.table;
    }

    public final void setTable(DBTable table) {
        this.table = table;
    }

    public DBColumn copy(String dbName, String adqlName, DBTable dbTable) {
        return new DefaultDBColumn(dbName, adqlName, this.type, dbTable);
    }
}

