/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBCommonColumn;
import adql.db.DBTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDBTable
implements DBTable {
    protected String dbCatalogName;
    protected String dbSchemaName;
    protected String dbName;
    protected String adqlCatalogName = null;
    protected String adqlSchemaName = null;
    protected String adqlName = null;
    protected Map<String, DBColumn> columns = new LinkedHashMap<String, DBColumn>();

    public DefaultDBTable(String dbName) {
        this(dbName, null);
    }

    public DefaultDBTable(String dbName, String adqlName) {
        String[] names = DefaultDBTable.splitTableName(dbName);
        if (names[2] == null || names[2].length() == 0) {
            throw new NullPointerException("Missing DB name !");
        }
        this.dbName = names[2];
        this.dbSchemaName = names[1];
        this.dbCatalogName = names[0];
        names = DefaultDBTable.splitTableName(adqlName);
        if (names[2] == null || names[2].length() == 0) {
            this.adqlName = this.dbName;
            this.adqlSchemaName = this.dbSchemaName;
            this.adqlCatalogName = this.dbCatalogName;
        } else {
            this.adqlName = names[2];
            this.adqlSchemaName = names[1];
            this.adqlCatalogName = names[0];
        }
    }

    public DefaultDBTable(String dbCatName, String dbSchemName, String dbName) {
        this(dbCatName, null, dbSchemName, null, dbName, null);
    }

    public DefaultDBTable(String dbCatName, String adqlCatName, String dbSchemName, String adqlSchemName, String dbName, String adqlName) {
        if (dbName == null || dbName.length() == 0) {
            throw new NullPointerException("Missing DB name !");
        }
        this.dbName = dbName;
        this.adqlName = adqlName == null ? dbName : adqlName;
        this.dbSchemaName = dbSchemName;
        this.adqlSchemaName = adqlSchemName == null ? dbSchemName : adqlSchemName;
        this.dbCatalogName = dbCatName;
        this.adqlCatalogName = adqlCatName == null ? dbCatName : adqlCatName;
    }

    @Override
    public final String getDBName() {
        return this.dbName;
    }

    @Override
    public final String getDBSchemaName() {
        return this.dbSchemaName;
    }

    @Override
    public final String getDBCatalogName() {
        return this.dbCatalogName;
    }

    @Override
    public final String getADQLName() {
        return this.adqlName;
    }

    public void setADQLName(String name) {
        this.adqlName = name != null ? name : this.dbName;
    }

    @Override
    public final String getADQLSchemaName() {
        return this.adqlSchemaName;
    }

    public void setADQLSchemaName(String name) {
        this.adqlSchemaName = name != null ? name : this.dbSchemaName;
    }

    @Override
    public final String getADQLCatalogName() {
        return this.adqlCatalogName;
    }

    public void setADQLCatalogName(String name) {
        this.adqlName = name != null ? null : this.dbName;
    }

    @Override
    public DBColumn getColumn(String colName, boolean byAdqlName) {
        if (byAdqlName) {
            return this.columns.get(colName);
        }
        for (DBColumn col : this.columns.values()) {
            if (!col.getDBName().equals(colName)) continue;
            return col;
        }
        return null;
    }

    public boolean hasColumn(String colName, boolean byAdqlName) {
        return this.getColumn(colName, byAdqlName) != null;
    }

    @Override
    public Iterator<DBColumn> iterator() {
        return this.columns.values().iterator();
    }

    public void addColumn(DBColumn column) {
        if (column != null) {
            this.columns.put(column.getADQLName(), column);
        }
    }

    public void addAllColumns(Collection<DBColumn> colList) {
        if (colList != null) {
            for (DBColumn column : colList) {
                this.addColumn(column);
            }
        }
    }

    public static final String[] splitTableName(String table) {
        String[] splitRes = new String[]{null, null, null};
        if (table == null || table.trim().length() == 0) {
            return splitRes;
        }
        String[] names = table.trim().split("\\.");
        switch (names.length) {
            case 1: {
                splitRes[2] = table.trim();
                break;
            }
            case 2: {
                splitRes[2] = names[1].trim();
                splitRes[1] = names[0].trim();
                break;
            }
            case 3: {
                splitRes[2] = names[2].trim();
                splitRes[1] = names[1].trim();
                splitRes[0] = names[0].trim();
                break;
            }
            default: {
                splitRes[2] = names[names.length - 1].trim();
                splitRes[1] = names[names.length - 2].trim();
                StringBuffer buff = new StringBuffer(names[0].trim());
                for (int i = 1; i < names.length - 2; ++i) {
                    buff.append('.').append(names[i].trim());
                }
                splitRes[0] = buff.toString();
            }
        }
        return splitRes;
    }

    public static final String joinTableName(String[] nameParts) {
        int i;
        if (nameParts == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        boolean empty = true;
        int n = i = nameParts.length <= 3 ? 0 : nameParts.length - 3;
        while (i < nameParts.length) {
            String part;
            if (!empty) {
                str.append('.');
            }
            String string = part = nameParts[i] == null ? null : nameParts[i].trim();
            if (part != null && part.length() > 0) {
                str.append(part);
                empty = false;
            }
            ++i;
        }
        return str.toString();
    }

    @Override
    public DBTable copy(String dbName, String adqlName) {
        dbName = dbName == null ? DefaultDBTable.joinTableName(new String[]{this.dbCatalogName, this.dbSchemaName, this.dbName}) : dbName;
        adqlName = adqlName == null ? DefaultDBTable.joinTableName(new String[]{this.adqlCatalogName, this.adqlSchemaName, this.adqlName}) : adqlName;
        DefaultDBTable copy = new DefaultDBTable(dbName, adqlName);
        for (DBColumn col : this) {
            if (col instanceof DBCommonColumn) {
                copy.addColumn(new DBCommonColumn((DBCommonColumn)col, col.getDBName(), col.getADQLName()));
                continue;
            }
            copy.addColumn(col.copy(col.getDBName(), col.getADQLName(), copy));
        }
        return copy;
    }
}

