/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBType;
import adql.parser.ParseException;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.UserDefinedFunction;
import java.lang.reflect.Constructor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionDef
implements Comparable<FunctionDef> {
    protected static final String regularIdentifierRegExp = "[a-zA-Z]+[0-9a-zA-Z_]*";
    protected static final String typeRegExp = "([a-zA-Z]+[ 0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?";
    protected static final String fctParamsRegExp = "\\s*[^,]+\\s*(,\\s*[^,]+\\s*)*";
    protected static final String fctParamRegExp = "\\s*([a-zA-Z]+[0-9a-zA-Z_]*)\\s+([a-zA-Z]+[ 0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?\\s*";
    protected static final String fctDefRegExp = "\\s*([a-zA-Z]+[0-9a-zA-Z_]*)\\s*\\(([a-zA-Z0-9,() \r\n\t]*)\\)(\\s*->\\s*(([a-zA-Z]+[ 0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?))?\\s*";
    protected static final Pattern fctPattern = Pattern.compile("\\s*([a-zA-Z]+[0-9a-zA-Z_]*)\\s*\\(([a-zA-Z0-9,() \r\n\t]*)\\)(\\s*->\\s*(([a-zA-Z]+[ 0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?))?\\s*");
    protected static final Pattern paramPattern = Pattern.compile("\\s*([a-zA-Z]+[0-9a-zA-Z_]*)\\s+([a-zA-Z]+[ 0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?\\s*");
    public final String name;
    public String description = null;
    public final DBType returnType;
    protected final boolean isString;
    protected final boolean isNumeric;
    protected final boolean isGeometry;
    protected final boolean isUnknown;
    public final int nbParams;
    protected final FunctionParam[] params;
    private final String serializedForm;
    private final String compareForm;
    private Class<? extends UserDefinedFunction> udfClass = null;

    public FunctionDef(String fctName) {
        this(fctName, null, null);
    }

    public FunctionDef(String fctName, DBType returnType) {
        this(fctName, returnType, null);
    }

    public FunctionDef(String fctName, FunctionParam[] params) {
        this(fctName, null, params);
    }

    public FunctionDef(String fctName, DBType returnType, FunctionParam[] params) {
        if (fctName == null) {
            throw new NullPointerException("Missing name! Can not create this function definition.");
        }
        this.name = fctName;
        this.params = params == null || params.length == 0 ? null : params;
        this.nbParams = params == null ? 0 : params.length;
        this.returnType = returnType != null ? returnType : new DBType(DBType.DBDatatype.UNKNOWN);
        this.isUnknown = this.returnType.isUnknown();
        this.isNumeric = this.isUnknown || this.returnType.isNumeric();
        this.isString = this.isUnknown || this.returnType.isString();
        this.isGeometry = this.isUnknown || this.returnType.isGeometry();
        StringBuffer bufSer = new StringBuffer(this.name);
        StringBuffer bufCmp = new StringBuffer(this.name.toLowerCase());
        bufSer.append('(');
        for (int i = 0; i < this.nbParams; ++i) {
            bufSer.append(params[i].name).append(' ').append(params[i].type);
            bufCmp.append(params[i].type.isNumeric() ? (char)'1' : '0').append(params[i].type.isString() ? (char)'1' : '0').append(params[i].type.isGeometry() ? (char)'1' : '0');
            if (i + 1 >= this.nbParams) continue;
            bufSer.append(", ");
        }
        bufSer.append(')');
        if (returnType != null) {
            bufSer.append(" -> ").append(returnType);
        }
        this.serializedForm = bufSer.toString();
        this.compareForm = bufCmp.toString();
    }

    public final boolean isNumeric() {
        return this.isNumeric;
    }

    public final boolean isString() {
        return this.isString;
    }

    public final boolean isGeometry() {
        return this.isGeometry;
    }

    public final boolean isUnknown() {
        return this.isUnknown;
    }

    public final int getNbParams() {
        return this.nbParams;
    }

    public final FunctionParam getParam(int indParam) throws ArrayIndexOutOfBoundsException {
        if (indParam < 0 || indParam >= this.nbParams) {
            throw new ArrayIndexOutOfBoundsException(indParam);
        }
        return this.params[indParam];
    }

    public final Class<? extends UserDefinedFunction> getUDFClass() {
        return this.udfClass;
    }

    public final <T extends UserDefinedFunction> void setUDFClass(Class<T> udfClass) throws IllegalArgumentException {
        try {
            Constructor<T> constructor;
            if (udfClass != null && (constructor = udfClass.getConstructor(ADQLOperand[].class)) == null) {
                throw new IllegalArgumentException("The given class (" + udfClass.getName() + ") does not provide any constructor with a single parameter of type ADQLOperand[]!");
            }
            this.udfClass = udfClass;
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("A security problem occurred while trying to get constructor from the class " + udfClass.getName() + ": " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The given class (" + udfClass.getName() + ") does not provide any constructor with a single parameter of type ADQLOperand[]!");
        }
    }

    public static FunctionDef parse(String strDefinition) throws ParseException {
        if (strDefinition == null) {
            throw new NullPointerException("Missing string definition to build a FunctionDef!");
        }
        Matcher m = fctPattern.matcher(strDefinition);
        if (m.matches()) {
            String fctName = m.group(1);
            DBType returnType = null;
            if (m.group(3) != null && (returnType = FunctionDef.parseType(m.group(5), m.group(7) == null ? -1 : Integer.parseInt(m.group(7)))) == null) {
                returnType = new DBType(DBType.DBDatatype.UNKNOWN);
                returnType.type.setCustomType(m.group(4));
            }
            String paramsList = m.group(2);
            FunctionParam[] params = null;
            if (paramsList != null && paramsList.trim().length() > 0) {
                if (!paramsList.matches(fctParamsRegExp)) {
                    throw new ParseException("Wrong parameters syntax! Expected syntax: \"(<regular_identifier> <type_name> (, <regular_identifier> <type_name>)*)\", where <regular_identifier>=\"[a-zA-Z]+[a-zA-Z0-9_]*\", <type_name> should be one of the types described in the UPLOAD section of the TAP documentation. Examples of good syntax: \"()\", \"(param INTEGER)\", \"(param1 INTEGER, param2 DOUBLE)\"");
                }
                String[] paramsSplit = paramsList.split(",");
                params = new FunctionParam[paramsSplit.length];
                for (int i = 0; i < params.length; ++i) {
                    DBType paramType;
                    m = paramPattern.matcher(paramsSplit[i]);
                    if (m.matches()) {
                        paramType = FunctionDef.parseType(m.group(2), m.group(4) == null ? -1 : Integer.parseInt(m.group(4)));
                        if (paramType == null) {
                            paramType = new DBType(DBType.DBDatatype.UNKNOWN);
                            paramType.type.setCustomType(m.group(2) + (m.group(3) == null ? "" : m.group(3)));
                        }
                    } else {
                        throw new ParseException("Wrong syntax for the " + (i + 1) + "-th parameter: \"" + paramsSplit[i].trim() + "\"! Expected syntax: \"(<regular_identifier> <type_name> (, <regular_identifier> <type_name>)*)\", where <regular_identifier>=\"[a-zA-Z]+[a-zA-Z0-9_]*\", <type_name> should be one of the types described in the UPLOAD section of the TAP documentation. Examples of good syntax: \"()\", \"(param INTEGER)\", \"(param1 INTEGER, param2 DOUBLE)\"");
                    }
                    params[i] = new FunctionParam(m.group(1), paramType);
                }
            }
            return new FunctionDef(fctName, returnType, params);
        }
        throw new ParseException("Wrong function definition syntax! Expected syntax: \"<regular_identifier>(<parameters>?) <return_type>?\", where <regular_identifier>=\"[a-zA-Z]+[a-zA-Z0-9_]*\", <return_type>=\" -> <type_name>\", <parameters>=\"(<regular_identifier> <type_name> (, <regular_identifier> <type_name>)*)\", <type_name> should be one of the types described in the UPLOAD section of the TAP documentation. Examples of good syntax: \"foo()\", \"foo() -> VARCHAR\", \"foo(param INTEGER)\", \"foo(param1 INTEGER, param2 DOUBLE) -> DOUBLE\"");
    }

    private static DBType parseType(String datatype, int length) {
        if (datatype == null) {
            return null;
        }
        datatype = datatype.trim().replaceAll(" +", " ");
        try {
            DBType.DBDatatype dbDatatype = DBType.DBDatatype.valueOf(datatype.toUpperCase());
            length = length <= 0 ? -1 : length;
            switch (dbDatatype) {
                case CHAR: 
                case VARCHAR: 
                case BINARY: 
                case VARBINARY: {
                    return new DBType(dbDatatype, length);
                }
            }
            return new DBType(dbDatatype);
        }
        catch (IllegalArgumentException iae) {
            datatype = datatype.toLowerCase();
            if (datatype.equals("bool") || datatype.equals("boolean") || datatype.equals("short") || datatype.equals("int2") || datatype.equals("smallserial") || datatype.equals("serial2")) {
                return new DBType(DBType.DBDatatype.SMALLINT);
            }
            if (datatype.equals("int") || datatype.equals("int4") || datatype.equals("serial") || datatype.equals("serial4")) {
                return new DBType(DBType.DBDatatype.INTEGER);
            }
            if (datatype.equals("long") || datatype.equals("number") || datatype.equals("int8") || datatype.equals("bigserial") || datatype.equals("bigserial8")) {
                return new DBType(DBType.DBDatatype.BIGINT);
            }
            if (datatype.equals("float") || datatype.equals("float4")) {
                return new DBType(DBType.DBDatatype.REAL);
            }
            if (datatype.equals("numeric") || datatype.equals("float8") || datatype.equals("double precision")) {
                return new DBType(DBType.DBDatatype.DOUBLE);
            }
            if (datatype.equals("bit") || datatype.equals("byte") || datatype.equals("raw")) {
                return new DBType(DBType.DBDatatype.BINARY, length);
            }
            if (datatype.equals("unsignedByte") || datatype.equals("bit varying") || datatype.equals("varbit")) {
                return new DBType(DBType.DBDatatype.VARBINARY, length);
            }
            if (datatype.equals("character")) {
                return new DBType(DBType.DBDatatype.CHAR, length);
            }
            if (datatype.equals("string") || datatype.equals("varchar2") || datatype.equals("character varying")) {
                return new DBType(DBType.DBDatatype.VARCHAR, length);
            }
            if (datatype.equals("bytea")) {
                return new DBType(DBType.DBDatatype.BLOB);
            }
            if (datatype.equals("text")) {
                return new DBType(DBType.DBDatatype.CLOB);
            }
            if (datatype.equals("date") || datatype.equals("time") || datatype.equals("timetz") || datatype.equals("timestamptz")) {
                return new DBType(DBType.DBDatatype.TIMESTAMP);
            }
            if (datatype.equals("position")) {
                return new DBType(DBType.DBDatatype.POINT);
            }
            if (datatype.equals("polygon") || datatype.equals("box") || datatype.equals("circle")) {
                return new DBType(DBType.DBDatatype.REGION);
            }
            return null;
        }
    }

    public String toString() {
        return this.serializedForm;
    }

    @Override
    public int compareTo(FunctionDef def) {
        return this.compareForm.compareTo(def.compareForm);
    }

    @Override
    public int compareTo(ADQLFunction fct) {
        if (fct == null) {
            throw new NullPointerException("Missing ADQL function with which comparing this function definition!");
        }
        int comp = this.name.compareToIgnoreCase(fct.getName());
        if (comp == 0) {
            for (int i = 0; comp == 0 && i < this.nbParams && i < fct.getNbParameters(); ++i) {
                if (fct.getParameter(i).isNumeric() && fct.getParameter(i).isString() && fct.getParameter(i).isGeometry()) {
                    comp = 0;
                    continue;
                }
                if (this.params[i].type.isNumeric() == fct.getParameter(i).isNumeric()) {
                    if (this.params[i].type.isString() == fct.getParameter(i).isString()) {
                        if (this.params[i].type.isGeometry() == fct.getParameter(i).isGeometry()) {
                            comp = 0;
                            continue;
                        }
                        comp = this.params[i].type.isGeometry() ? 1 : -1;
                        continue;
                    }
                    comp = this.params[i].type.isString() ? 1 : -1;
                    continue;
                }
                comp = this.params[i].type.isNumeric() ? 1 : -1;
            }
            if (comp == 0 && this.nbParams != fct.getNbParameters()) {
                comp = this.nbParams - fct.getNbParameters();
            }
        }
        return comp;
    }

    public static final class FunctionParam {
        public final String name;
        public final DBType type;

        public FunctionParam(String paramName, DBType paramType) {
            if (paramName == null) {
                throw new NullPointerException("Missing name! The function parameter can not be created.");
            }
            this.name = paramName;
            this.type = paramType == null ? new DBType(DBType.DBDatatype.UNKNOWN) : paramType;
        }
    }
}

