/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.parser.ADQLQueryFactory;
import adql.parser.ParseException;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NumericConstant;
import adql.query.operand.StringConstant;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class STCS {
    private static final String coordSysRegExp = Frame.regexp + "?\\s*" + RefPos.regexp + "?\\s*" + Flavor.regexp + "?";
    private static final String onlyCoordSysRegExp = "^\\s*" + coordSysRegExp + "\\s*$";
    private static final String defaultCoordSysRegExp = "^\\s*" + (Object)((Object)Frame.DEFAULT) + "?\\s*" + (Object)((Object)RefPos.DEFAULT) + "?\\s*" + (Object)((Object)Flavor.DEFAULT) + "?\\s*$";
    private static final String allowedCoordSysRegExp = "^\\s*" + STCS.buildAllowedRegExp(Frame.regexp) + "\\s+" + STCS.buildAllowedRegExp(RefPos.regexp) + "\\s+" + STCS.buildAllowedRegExp(Flavor.regexp) + "\\s*$";
    private static final Pattern allowedCoordSysPattern = Pattern.compile(allowedCoordSysRegExp);
    private static final String COORD_SYS_SYNTAX = "\"[" + Frame.regexp + "] [" + RefPos.regexp + "] [" + Flavor.regexp + "]\" ; an empty string is also allowed and will be interpreted as the coordinate system locally used";

    private STCS() {
    }

    private static String buildAllowedRegExp(String rootRegExp) {
        return "(" + rootRegExp + "|\\*|(\\(\\s*" + rootRegExp + "\\s*(\\|\\s*" + rootRegExp + "\\s*)*\\)))";
    }

    private static String buildRegexp(Class<?> enumType) throws IllegalArgumentException {
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException("An enum class was expected, but a " + enumType.getName() + " has been given!");
        }
        ?[] constants = enumType.getEnumConstants();
        if (constants == null || constants.length == 0) {
            return "\\s*";
        }
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < constants.length; ++i) {
            buf.append(constants[i]);
            if (i + 1 >= constants.length) continue;
            buf.append('|');
        }
        return buf.append(')').toString();
    }

    public static CoordSys parseCoordSys(String stcs) throws ParseException {
        return new STCSParser().parseCoordSys(stcs);
    }

    public static String toSTCS(CoordSys coordSys) {
        if (coordSys == null) {
            return "";
        }
        return coordSys.toSTCS();
    }

    public static String buildCoordSysRegExp(String[] allowedCoordSys) throws ParseException {
        if (allowedCoordSys == null) {
            return onlyCoordSysRegExp;
        }
        if (allowedCoordSys.length == 0) {
            return defaultCoordSysRegExp;
        }
        StringBuffer finalRegExp = new StringBuffer("^\\s*(");
        int nbCoordSys = 0;
        for (int i = 0; i < allowedCoordSys.length; ++i) {
            if (allowedCoordSys[i] == null) continue;
            if (nbCoordSys > 0) {
                finalRegExp.append('|');
            }
            ++nbCoordSys;
            Matcher m = allowedCoordSysPattern.matcher(allowedCoordSys[i].toUpperCase());
            if (m.matches()) {
                finalRegExp.append('(');
                for (int g = 0; g < 3; ++g) {
                    if (m.group(2 + 6 * g) != null) {
                        finalRegExp.append('(').append(STCS.defaultChoice(g, m.group(2 + 6 * g))).append(m.group(2 + 6 * g)).append(')');
                    } else if (m.group(3 + 6 * g) != null) {
                        finalRegExp.append('(').append(STCS.defaultChoice(g, m.group(3 + 6 * g))).append(m.group(3 + 6 * g).replaceAll("\\s", "").substring(1));
                    } else {
                        switch (g) {
                            case 0: {
                                finalRegExp.append(Frame.regexp);
                                break;
                            }
                            case 1: {
                                finalRegExp.append(RefPos.regexp);
                                break;
                            }
                            case 2: {
                                finalRegExp.append(Flavor.regexp);
                            }
                        }
                        finalRegExp.append('?');
                    }
                    finalRegExp.append("\\s*");
                }
                finalRegExp.append(')');
                continue;
            }
            throw new ParseException("Wrong allowed coordinate system syntax for the " + (i + 1) + "-th item: \"" + allowedCoordSys[i] + "\"! Expected: \"frameRegExp refposRegExp flavorRegExp\" ; where each xxxRegExp = (xxx | '*' | '('xxx ('|' xxx)*')'), frame=\"" + Frame.regexp + "\", refpos=\"" + RefPos.regexp + "\" and flavor=\"" + Flavor.regexp + "\" ; an empty string is also allowed and will be interpreted as '*' (so all possible values).");
        }
        finalRegExp.append(")\\s*$");
        return nbCoordSys > 0 ? finalRegExp.toString() : defaultCoordSysRegExp;
    }

    private static String defaultChoice(int g, String value) {
        switch (g) {
            case 0: {
                return value.contains(Frame.DEFAULT.toString()) ? "" : (Object)((Object)Frame.DEFAULT) + "|";
            }
            case 1: {
                return value.contains(RefPos.DEFAULT.toString()) ? "" : (Object)((Object)RefPos.DEFAULT) + "|";
            }
            case 2: {
                return value.contains(Flavor.DEFAULT.toString()) ? "" : (Object)((Object)Flavor.DEFAULT) + "|";
            }
        }
        return "";
    }

    public static Region parseRegion(String stcsRegion) throws ParseException {
        if (stcsRegion == null || stcsRegion.trim().length() == 0) {
            throw new ParseException("Missing STC-S expression to parse!");
        }
        return new STCSParser().parseRegion(stcsRegion);
    }

    public static String toSTCS(Region region) {
        if (region == null) {
            throw new NullPointerException("Missing region to serialize into STC-S!");
        }
        return region.toSTCS();
    }

    public static String toSTCS(GeometryFunction region) throws ParseException {
        if (region == null) {
            throw new NullPointerException("Missing region to serialize into STC-S!");
        }
        return new Region(region).toSTCS();
    }

    private static class STCSParser {
        private static final String numericRegExp = "(\\+|-)?(\\d+(\\.\\d*)?|\\.\\d+)([Ee](\\+|-)?\\d+)?";
        private int pos;
        private String stcs;
        private String token;
        private StringBuffer buffer;

        public CoordSys parseCoordSys(String stcs) throws ParseException {
            this.init(stcs);
            CoordSys coordsys = null;
            try {
                coordsys = this.coordSys();
                this.end(COORD_SYS_SYNTAX);
                return coordsys;
            }
            catch (EOEException ex) {
                ex.printStackTrace();
                return new CoordSys();
            }
        }

        public Region parseRegion(String stcs) throws ParseException {
            this.init(stcs);
            Region region = this.region();
            this.end("\"POSITION <coordsys> <coordPair>\", \"CIRCLE <coordSys> <coordPair> <numeric>\", \"BOX <coordSys> <coordPair> <coordPair>\", \"POLYGON <coordSys> <coordPair> <coordPair> <coordPair> [<coordPair> ...]\", \"UNION <coordSys> ( <region> <region> [<region> ...] )\", \"INTERSECTION [<coordSys>] ( <region> <region> [<region> ...] )\" or \"NOT ( <region> )\"");
            return region;
        }

        private void init(String newStcs) {
            this.stcs = newStcs == null ? "" : newStcs;
            this.token = null;
            this.buffer = new StringBuffer();
            this.pos = 0;
        }

        private void end(String expectedSyntax) throws ParseException {
            this.skipSpaces();
            if (this.stcs.length() > 0 && this.pos < this.stcs.length()) {
                throw new ParseException("Incorrect syntax: \"" + this.stcs.substring(this.pos) + "\" was unexpected! Expected syntax: " + expectedSyntax + ".", new TextPosition(1, this.pos, 1, this.stcs.length()));
            }
            this.buffer = null;
            this.stcs = null;
            this.token = null;
        }

        private void skipSpaces() {
            while (this.pos < this.stcs.length() && Character.isWhitespace(this.stcs.charAt(this.pos))) {
                ++this.pos;
            }
        }

        private String nextToken() throws EOEException {
            this.skipSpaces();
            while (this.pos < this.stcs.length() && !Character.isWhitespace(this.stcs.charAt(this.pos)) && this.stcs.charAt(this.pos) != '(' && this.stcs.charAt(this.pos) != ')') {
                this.buffer.append(this.stcs.charAt(this.pos++));
            }
            if (this.buffer.length() == 0) {
                throw new EOEException();
            }
            this.token = this.buffer.toString();
            this.buffer.delete(0, this.token.length());
            return this.token;
        }

        private double numeric() throws ParseException {
            if (this.nextToken().matches(numericRegExp)) {
                return Double.parseDouble(this.token);
            }
            throw new ParseException("a numeric was expected!", new TextPosition(1, this.pos - this.token.length(), 1, this.pos));
        }

        private double[] coordPair() throws ParseException {
            this.skipSpaces();
            int startPos = this.pos;
            try {
                return new double[]{this.numeric(), this.numeric()};
            }
            catch (ParseException pe) {
                if (pe instanceof EOEException) {
                    throw pe;
                }
                throw new ParseException("a coordinates pair (2 numerics separated by one or more spaces) was expected!", new TextPosition(1, startPos, 1, this.pos));
            }
        }

        private CoordSys coordSys() throws ParseException {
            this.skipSpaces();
            String oldToken = this.token;
            int startPos = this.pos;
            Frame fr = null;
            RefPos rp = null;
            Flavor fl = null;
            try {
                this.nextToken();
                fr = this.frame();
                if (fr != null) {
                    startPos = this.pos;
                    oldToken = this.token;
                    this.nextToken();
                }
                if ((rp = this.refpos()) != null) {
                    startPos = this.pos;
                    oldToken = this.token;
                    this.nextToken();
                }
                if ((fl = this.flavor()) == null) {
                    this.pos = startPos;
                    this.token = oldToken;
                }
            }
            catch (EOEException ex) {
                // empty catch block
            }
            try {
                return new CoordSys(fr, rp, fl);
            }
            catch (IllegalArgumentException iae) {
                throw new ParseException(iae.getMessage(), new TextPosition(1, startPos, 1, this.pos));
            }
        }

        private Frame frame() {
            try {
                return Frame.valueOf(this.token.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        private RefPos refpos() {
            try {
                return RefPos.valueOf(this.token.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        private Flavor flavor() {
            try {
                return Flavor.valueOf(this.token.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        private Region region() throws ParseException {
            this.skipSpaces();
            int startPos = this.pos;
            this.token = this.nextToken().toUpperCase();
            if (this.token.equals("POSITION")) {
                try {
                    CoordSys coordSys = this.coordSys();
                    double[] coords = this.coordPair();
                    return new Region(coordSys, coords);
                }
                catch (Exception e) {
                    throw this.buildException(e, "\"POSITION <coordSys> <coordPair>\", where coordPair=\"<numeric> <numeric>\" and coordSys=" + COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("CIRCLE")) {
                try {
                    CoordSys coordSys = this.coordSys();
                    double[] coords = this.coordPair();
                    double radius = this.numeric();
                    return new Region(coordSys, coords, radius);
                }
                catch (Exception e) {
                    throw this.buildException(e, "\"CIRCLE <coordSys> <coordPair> <radius>\", where coordPair=\"<numeric> <numeric>\", radius=\"<numeric>\" and coordSys=" + COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("BOX")) {
                try {
                    CoordSys coordSys = this.coordSys();
                    double[] coords = this.coordPair();
                    double width = this.numeric();
                    double height = this.numeric();
                    return new Region(coordSys, coords, width, height);
                }
                catch (Exception e) {
                    throw this.buildException(e, "\"BOX <coordSys> <coordPair> <width> <height>\", where coordPair=\"<numeric> <numeric>\", width and height=\"<numeric>\" and coordSys=" + COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("POLYGON")) {
                try {
                    double[] coords;
                    CoordSys coordSys = this.coordSys();
                    ArrayList<Double> coordinates = new ArrayList<Double>(6);
                    for (int i = 0; i < 3; ++i) {
                        coords = this.coordPair();
                        coordinates.add(coords[0]);
                        coordinates.add(coords[1]);
                    }
                    boolean moreCoord = true;
                    do {
                        int posBackup = this.pos;
                        try {
                            coords = this.coordPair();
                            coordinates.add(coords[0]);
                            coordinates.add(coords[1]);
                        }
                        catch (ParseException pe) {
                            moreCoord = false;
                            this.pos = posBackup;
                        }
                    } while (moreCoord);
                    double[][] allCoords = new double[coordinates.size() / 2][2];
                    for (int i = 0; i < coordinates.size() && i + 1 < coordinates.size(); i += 2) {
                        allCoords[i / 2] = new double[]{(Double)coordinates.get(i), (Double)coordinates.get(i + 1)};
                    }
                    return new Region(coordSys, allCoords);
                }
                catch (Exception e) {
                    throw this.buildException(e, "\"POLYGON <coordSys> <coordPair> <coordPair> <coordPair> [<coordPair> ...]\", where coordPair=\"<numeric> <numeric>\" and coordSys=" + COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("UNION") || this.token.equals("INTERSECTION")) {
                RegionType type = this.token.equals("UNION") ? RegionType.UNION : RegionType.INTERSECTION;
                try {
                    CoordSys coordSys = this.coordSys();
                    ArrayList<Region> regions = new ArrayList<Region>(2);
                    this.skipSpaces();
                    if (this.stcs.charAt(this.pos) != '(') {
                        throw this.buildException(new ParseException("a opening parenthesis - ( - was expected!", new TextPosition(1, this.pos, 1, this.pos + 1)), "\"" + (Object)((Object)type) + " <coordSys> ( <region> <region> [<region> ...] )\", where coordSys=" + COORD_SYS_SYNTAX, startPos);
                    }
                    ++this.pos;
                    regions.add(this.region());
                    regions.add(this.region());
                    this.skipSpaces();
                    while (this.stcs.charAt(this.pos) != ')') {
                        regions.add(this.region());
                        this.skipSpaces();
                    }
                    ++this.pos;
                    return new Region(type, coordSys, regions.toArray(new Region[regions.size()]));
                }
                catch (Exception e) {
                    if (e instanceof ParseException && e.getMessage().startsWith("Incorrect syntax: \"")) {
                        throw (ParseException)e;
                    }
                    throw this.buildException(e, "\"" + (Object)((Object)type) + " <coordSys> ( <region> <region> [<region> ...] )\", where coordSys=" + COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("NOT")) {
                try {
                    this.skipSpaces();
                    if (this.stcs.charAt(this.pos) != '(') {
                        throw this.buildException(new ParseException("an opening parenthesis - ( - was expected!", new TextPosition(1, this.pos, 1, this.pos + 1)), "\"NOT ( <region> )\"", startPos);
                    }
                    ++this.pos;
                    Region region = this.region();
                    this.skipSpaces();
                    if (this.stcs.charAt(this.pos) != ')') {
                        throw this.buildException(new ParseException("a closing parenthesis - ) - was expected!", new TextPosition(1, this.pos, 1, this.pos + 1)), "\"NOT ( <region> )\"", startPos);
                    }
                    ++this.pos;
                    return new Region(region);
                }
                catch (Exception e) {
                    if (e instanceof ParseException && e.getMessage().startsWith("Incorrect syntax: ")) {
                        throw (ParseException)e;
                    }
                    throw this.buildException(e, "\"NOT ( <region> )\"", startPos);
                }
            }
            throw new ParseException("Unknown STC region type: \"" + this.token + "\"!", new TextPosition(1, startPos, 1, this.pos));
        }

        private ParseException buildException(Exception ex, String expectedSyntax, int startPos) {
            if (ex instanceof EOEException) {
                return new ParseException("Unexpected End Of Expression! Expected syntax: " + expectedSyntax + ".", new TextPosition(1, startPos, 1, this.pos));
            }
            if (ex instanceof ParseException) {
                return new ParseException("Incorrect syntax: " + ex.getMessage() + " Expected syntax: " + expectedSyntax + ".", ((ParseException)ex).getPosition() != null ? ((ParseException)ex).getPosition() : new TextPosition(1, startPos, 1, this.pos));
            }
            return new ParseException(ex.getMessage(), new TextPosition(1, startPos, 1, this.pos));
        }

        private static class EOEException
        extends ParseException {
            private static final long serialVersionUID = 1L;

            public EOEException() {
                super("Unexpected End Of Expression!");
            }
        }
    }

    public static class Region {
        public final RegionType type;
        public final CoordSys coordSys;
        public final double[][] coordinates;
        public final double width;
        public final double height;
        public final double radius;
        public final Region[] regions;
        private String stcs = null;
        private String fullStcs = null;
        private GeometryFunction geometry = null;

        public Region(CoordSys coordSys, double[] coordinates) {
            this(coordSys, new double[][]{coordinates});
        }

        public Region(CoordSys coordSys, double[][] coordinates) {
            if (coordinates == null || coordinates.length == 0) {
                throw new NullPointerException("Missing coordinates!");
            }
            if (coordinates[0].length != 2) {
                throw new IllegalArgumentException("Wrong number of coordinates! Expected at least 2 pairs of coordinates (so coordinates[0], coordinates[1] and coordinates[n].length = 2).");
            }
            this.type = coordinates.length > 1 ? RegionType.POLYGON : RegionType.POSITION;
            this.coordSys = coordSys == null ? new CoordSys() : coordSys;
            this.coordinates = coordinates;
            this.width = Double.NaN;
            this.height = Double.NaN;
            this.radius = Double.NaN;
            this.regions = null;
        }

        public Region(CoordSys coordSys, double[] coordinates, double radius) {
            if (coordinates == null || coordinates.length == 0) {
                throw new NullPointerException("Missing coordinates!");
            }
            if (coordinates.length != 2) {
                throw new IllegalArgumentException("Wrong number of coordinates! Expected exactly 2 values.");
            }
            this.type = RegionType.CIRCLE;
            this.coordSys = coordSys == null ? new CoordSys() : coordSys;
            this.coordinates = new double[][]{coordinates};
            this.radius = radius;
            this.width = Double.NaN;
            this.height = Double.NaN;
            this.regions = null;
        }

        public Region(CoordSys coordSys, double[] coordinates, double width, double height) {
            if (coordinates == null || coordinates.length == 0) {
                throw new NullPointerException("Missing coordinates!");
            }
            if (coordinates.length != 2) {
                throw new IllegalArgumentException("Wrong number of coordinates! Expected exactly 2 values.");
            }
            this.type = RegionType.BOX;
            this.coordSys = coordSys == null ? new CoordSys() : coordSys;
            this.coordinates = new double[][]{coordinates};
            this.width = width;
            this.height = height;
            this.radius = Double.NaN;
            this.regions = null;
        }

        public Region(RegionType unionOrIntersection, CoordSys coordSys, Region[] regions) {
            if (unionOrIntersection == null) {
                throw new NullPointerException("Missing type of region (UNION or INTERSECTION here)!");
            }
            if (unionOrIntersection != RegionType.UNION && unionOrIntersection != RegionType.INTERSECTION) {
                throw new IllegalArgumentException("Wrong region type: \"" + (Object)((Object)unionOrIntersection) + "\"! This constructor lets create only an UNION or INTERSECTION region.");
            }
            if (regions == null || regions.length == 0) {
                throw new NullPointerException("Missing regions to " + (unionOrIntersection == RegionType.UNION ? "unite" : "intersect") + "!");
            }
            if (regions.length < 2) {
                throw new IllegalArgumentException("Wrong number of regions! Expected at least 2 regions.");
            }
            this.type = unionOrIntersection;
            this.coordSys = coordSys == null ? new CoordSys() : coordSys;
            this.regions = regions;
            this.coordinates = null;
            this.radius = Double.NaN;
            this.width = Double.NaN;
            this.height = Double.NaN;
        }

        public Region(Region region) {
            if (region == null) {
                throw new NullPointerException("Missing region to NOT select!");
            }
            this.type = RegionType.NOT;
            this.regions = new Region[]{region};
            this.coordSys = null;
            this.coordinates = null;
            this.radius = Double.NaN;
            this.width = Double.NaN;
            this.height = Double.NaN;
        }

        public Region(GeometryFunction geometry) throws IllegalArgumentException, ParseException {
            if (geometry == null) {
                throw new NullPointerException("Missing geometry to convert into STCS.Region!");
            }
            if (geometry instanceof PointFunction) {
                this.type = RegionType.POSITION;
                this.coordSys = STCS.parseCoordSys(Region.extractString(geometry.getCoordinateSystem()));
                this.coordinates = new double[][]{{Region.extractNumeric(((PointFunction)geometry).getCoord1()), Region.extractNumeric(((PointFunction)geometry).getCoord2())}};
                this.width = Double.NaN;
                this.height = Double.NaN;
                this.radius = Double.NaN;
                this.regions = null;
            } else if (geometry instanceof CircleFunction) {
                this.type = RegionType.CIRCLE;
                this.coordSys = STCS.parseCoordSys(Region.extractString(geometry.getCoordinateSystem()));
                this.coordinates = new double[][]{{Region.extractNumeric(((CircleFunction)geometry).getCoord1()), Region.extractNumeric(((CircleFunction)geometry).getCoord2())}};
                this.radius = Region.extractNumeric(((CircleFunction)geometry).getRadius());
                this.width = Double.NaN;
                this.height = Double.NaN;
                this.regions = null;
            } else if (geometry instanceof BoxFunction) {
                this.type = RegionType.BOX;
                this.coordSys = STCS.parseCoordSys(Region.extractString(geometry.getCoordinateSystem()));
                this.coordinates = new double[][]{{Region.extractNumeric(((BoxFunction)geometry).getCoord1()), Region.extractNumeric(((BoxFunction)geometry).getCoord2())}};
                this.width = Region.extractNumeric(((BoxFunction)geometry).getWidth());
                this.height = Region.extractNumeric(((BoxFunction)geometry).getHeight());
                this.radius = Double.NaN;
                this.regions = null;
            } else if (geometry instanceof PolygonFunction) {
                PolygonFunction poly = (PolygonFunction)geometry;
                this.type = RegionType.POLYGON;
                this.coordSys = STCS.parseCoordSys(Region.extractString(poly.getCoordinateSystem()));
                this.coordinates = new double[(poly.getNbParameters() - 1) / 2][2];
                for (int i = 0; i < this.coordinates.length; ++i) {
                    this.coordinates[i] = new double[]{Region.extractNumeric(poly.getParameter(1 + i * 2)), Region.extractNumeric(poly.getParameter(2 + i * 2))};
                }
                this.width = Double.NaN;
                this.height = Double.NaN;
                this.radius = Double.NaN;
                this.regions = null;
            } else if (geometry instanceof RegionFunction) {
                Region r = STCS.parseRegion(Region.extractString(((RegionFunction)geometry).getParameter(0)));
                this.type = r.type;
                this.coordSys = r.coordSys;
                this.coordinates = r.coordinates;
                this.width = r.width;
                this.height = r.height;
                this.radius = r.radius;
                this.regions = r.regions;
            } else {
                throw new IllegalArgumentException("Unknown region type! Only geometrical function PointFunction, CircleFunction, BoxFunction, PolygonFunction and RegionFunction are allowed.");
            }
        }

        private static String extractString(ADQLOperand op) throws ParseException {
            if (op == null) {
                throw new NullPointerException("Missing operand!");
            }
            if (op instanceof StringConstant) {
                return ((StringConstant)op).getValue();
            }
            throw new ParseException("Can not convert into STC-S a non string argument (including ADQLColumn and Concatenation)!");
        }

        private static double extractNumeric(ADQLOperand op) throws ParseException {
            if (op == null) {
                throw new NullPointerException("Missing operand!");
            }
            if (op instanceof NumericConstant) {
                return Double.parseDouble(((NumericConstant)op).getValue());
            }
            if (op instanceof NegativeOperand) {
                return Region.extractNumeric(((NegativeOperand)op).getOperand()) * -1.0;
            }
            throw new ParseException("Can not convert into STC-S a non numeric argument (including ADQLColumn and Operation)!");
        }

        public String toSTCS() {
            if (this.stcs != null) {
                return this.stcs;
            }
            StringBuffer buf = new StringBuffer(this.type.toString());
            if (this.type != RegionType.NOT) {
                String coordSysStr = this.coordSys.toSTCS();
                if (coordSysStr != null && coordSysStr.length() > 0) {
                    buf.append(' ').append(coordSysStr);
                }
                buf.append(' ');
            }
            switch (this.type) {
                case POSITION: 
                case POLYGON: {
                    Region.appendCoordinates(buf, this.coordinates);
                    break;
                }
                case CIRCLE: {
                    Region.appendCoordinates(buf, this.coordinates);
                    buf.append(' ').append(this.radius);
                    break;
                }
                case BOX: {
                    Region.appendCoordinates(buf, this.coordinates);
                    buf.append(' ').append(this.width).append(' ').append(this.height);
                    break;
                }
                case UNION: 
                case INTERSECTION: 
                case NOT: {
                    buf.append('(');
                    Region.appendRegions(buf, this.regions, false);
                    buf.append(')');
                }
            }
            this.stcs = buf.toString();
            return this.stcs;
        }

        public String toFullSTCS() {
            if (this.fullStcs != null) {
                return this.fullStcs;
            }
            StringBuffer buf = new StringBuffer(this.type.toString());
            if (this.type != RegionType.NOT) {
                String coordSysStr = this.coordSys.toFullSTCS();
                if (coordSysStr != null && coordSysStr.length() > 0) {
                    buf.append(' ').append(coordSysStr);
                }
                buf.append(' ');
            }
            switch (this.type) {
                case POSITION: 
                case POLYGON: {
                    Region.appendCoordinates(buf, this.coordinates);
                    break;
                }
                case CIRCLE: {
                    Region.appendCoordinates(buf, this.coordinates);
                    buf.append(' ').append(this.radius);
                    break;
                }
                case BOX: {
                    Region.appendCoordinates(buf, this.coordinates);
                    buf.append(' ').append(this.width).append(' ').append(this.height);
                    break;
                }
                case UNION: 
                case INTERSECTION: 
                case NOT: {
                    buf.append('(');
                    Region.appendRegions(buf, this.regions, true);
                    buf.append(')');
                }
            }
            this.fullStcs = buf.toString();
            return this.fullStcs;
        }

        private static void appendCoordinates(StringBuffer buf, double[][] coords) {
            for (int i = 0; i < coords.length; ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(coords[i][0]).append(' ').append(coords[i][1]);
            }
        }

        private static void appendRegions(StringBuffer buf, Region[] regions, boolean fullCoordSys) {
            for (int i = 0; i < regions.length; ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                if (fullCoordSys) {
                    buf.append(regions[i].toFullSTCS());
                    continue;
                }
                buf.append(regions[i].toSTCS());
            }
        }

        public String toString() {
            return this.toSTCS();
        }

        public GeometryFunction toGeometry() {
            return this.toGeometry(null);
        }

        public GeometryFunction toGeometry(ADQLQueryFactory factory) {
            if (factory == null) {
                factory = new ADQLQueryFactory();
            }
            try {
                if (this.geometry != null) {
                    return this.geometry;
                }
                StringConstant coordSysObj = factory.createStringConstant(this.coordSys == null ? "" : this.coordSys.toString());
                switch (this.type) {
                    case POSITION: {
                        this.geometry = factory.createPoint(coordSysObj, this.toNumericObj(this.coordinates[0][0], factory), this.toNumericObj(this.coordinates[0][1], factory));
                        return this.geometry;
                    }
                    case CIRCLE: {
                        this.geometry = factory.createCircle(coordSysObj, this.toNumericObj(this.coordinates[0][0], factory), this.toNumericObj(this.coordinates[0][1], factory), this.toNumericObj(this.radius, factory));
                        return this.geometry;
                    }
                    case BOX: {
                        this.geometry = factory.createBox(coordSysObj, this.toNumericObj(this.coordinates[0][0], factory), this.toNumericObj(this.coordinates[0][1], factory), this.toNumericObj(this.width, factory), this.toNumericObj(this.height, factory));
                        return this.geometry;
                    }
                    case POLYGON: {
                        ArrayList<ADQLOperand> coords = new ArrayList<ADQLOperand>(this.coordinates.length * 2);
                        for (int i = 0; i < this.coordinates.length; ++i) {
                            coords.add(this.toNumericObj(this.coordinates[i][0], factory));
                            coords.add(this.toNumericObj(this.coordinates[i][1], factory));
                        }
                        this.geometry = factory.createPolygon(coordSysObj, coords);
                        return this.geometry;
                    }
                }
                this.geometry = factory.createRegion(factory.createStringConstant(this.toString()));
                return this.geometry;
            }
            catch (Exception pe) {
                return null;
            }
        }

        private ADQLOperand toNumericObj(double val, ADQLQueryFactory factory) throws Exception {
            if (val >= 0.0) {
                return factory.createNumericConstant("" + val);
            }
            return factory.createNegativeOperand(factory.createNumericConstant("" + val * -1.0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RegionType {
        POSITION,
        CIRCLE,
        BOX,
        POLYGON,
        UNION,
        INTERSECTION,
        NOT;

    }

    public static class CoordSys {
        public final Frame frame;
        public final RefPos refpos;
        public final Flavor flavor;
        private final boolean isDefault;
        private final String stcs;
        private final String fullStcs;

        public CoordSys() {
            this(null, null, null);
        }

        public CoordSys(Frame fr, RefPos rp, Flavor fl) throws IllegalArgumentException {
            this.frame = fr == null ? Frame.DEFAULT : fr;
            this.refpos = rp == null ? RefPos.DEFAULT : rp;
            Flavor flavor = this.flavor = fl == null ? Flavor.DEFAULT : fl;
            if (this.flavor != Flavor.SPHERICAL2 && (this.frame != Frame.UNKNOWNFRAME || this.refpos != RefPos.UNKNOWNREFPOS)) {
                throw new IllegalArgumentException("a coordinate system expressed with a cartesian flavor MUST have an UNKNOWNFRAME and UNKNOWNREFPOS!");
            }
            this.isDefault = this.frame.isDefault() && this.refpos.isDefault() && this.flavor.isDefault();
            this.stcs = ((!this.frame.isDefault() ? (Object)((Object)this.frame) + " " : "") + (!this.refpos.isDefault() ? (Object)((Object)this.refpos) + " " : "") + (!this.flavor.isDefault() ? this.flavor : "")).trim();
            this.fullStcs = (Object)((Object)this.frame) + " " + (Object)((Object)this.refpos) + " " + (Object)((Object)this.flavor);
        }

        public CoordSys(String coordsys) throws ParseException {
            CoordSys tmp = new STCSParser().parseCoordSys(coordsys);
            this.frame = tmp.frame;
            this.refpos = tmp.refpos;
            this.flavor = tmp.flavor;
            this.isDefault = tmp.isDefault;
            this.stcs = tmp.stcs;
            this.fullStcs = tmp.fullStcs;
        }

        public final boolean isDefault() {
            return this.isDefault;
        }

        public String toSTCS() {
            return this.stcs;
        }

        public String toFullSTCS() {
            return this.fullStcs;
        }

        public String toString() {
            return this.stcs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flavor {
        CARTESIAN2,
        CARTESIAN3,
        SPHERICAL2;

        public static final Flavor DEFAULT;
        public static final String regexp;

        public final boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = SPHERICAL2;
            regexp = STCS.buildRegexp(Flavor.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RefPos {
        BARYCENTER,
        GEOCENTER,
        HELIOCENTER,
        LSR,
        TOPOCENTER,
        RELOCATABLE,
        UNKNOWNREFPOS;

        public static final RefPos DEFAULT;
        public static final String regexp;

        public final boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = UNKNOWNREFPOS;
            regexp = STCS.buildRegexp(RefPos.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Frame {
        ECLIPTIC,
        FK4,
        FK5,
        GALACTIC,
        ICRS,
        UNKNOWNFRAME;

        public static final Frame DEFAULT;
        public static final String regexp;

        public final boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = UNKNOWNFRAME;
            regexp = STCS.buildRegexp(Frame.class);
        }
    }
}

