/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBTable;
import adql.query.IdentifierField;
import adql.query.from.ADQLTable;
import cds.utils.TextualSearchList;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchTableList
extends TextualSearchList<DBTable> {
    private static final long serialVersionUID = 1L;
    private boolean distinct = false;

    public SearchTableList() {
        super(new DBTableKeyExtractor());
    }

    public SearchTableList(Collection<? extends DBTable> collection) {
        super(collection, new DBTableKeyExtractor());
    }

    public SearchTableList(int initialCapacity) {
        super(initialCapacity, new DBTableKeyExtractor());
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public final void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public ArrayList<DBTable> search(String tableName) {
        return this.get(tableName);
    }

    public final ArrayList<DBTable> search(String catalog, String schema, String table) {
        return this.search(catalog, schema, table, (byte)0);
    }

    public ArrayList<DBTable> search(ADQLTable table) {
        return this.search(table.getCatalogName(), table.getSchemaName(), table.getTableName(), table.getCaseSensitive());
    }

    public ArrayList<DBTable> search(String catalog, String schema, String table, byte caseSensitivity) {
        ArrayList<DBTable> tmpResult = this.get(table, IdentifierField.TABLE.isCaseSensitive(caseSensitivity));
        if (schema != null) {
            ArrayList<DBTable> result = new ArrayList<DBTable>();
            for (DBTable match : tmpResult) {
                if (match.getADQLSchemaName() == null || (!IdentifierField.SCHEMA.isCaseSensitive(caseSensitivity) ? !match.getADQLSchemaName().equalsIgnoreCase(schema) : !match.getADQLSchemaName().equals(schema)) || catalog != null && (match.getADQLCatalogName() == null || (IdentifierField.CATALOG.isCaseSensitive(caseSensitivity) ? !match.getADQLCatalogName().equals(catalog) : !match.getADQLCatalogName().equalsIgnoreCase(catalog)))) continue;
                result.add(match);
            }
            return result;
        }
        return tmpResult;
    }

    @Override
    public boolean add(DBTable item) {
        if (this.distinct && this.contains(item)) {
            return false;
        }
        return super.add(item);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DBTableKeyExtractor
    implements TextualSearchList.KeyExtractor<DBTable> {
        private DBTableKeyExtractor() {
        }

        @Override
        public String getKey(DBTable obj) {
            return obj.getADQLName();
        }
    }
}

