/*
 * Decompiled with CFR 0.152.
 */
package adql.db.exception;

import adql.parser.ParseException;
import adql.query.operand.ADQLColumn;

public class UnresolvedColumnException
extends ParseException {
    private static final long serialVersionUID = 1L;
    private final String columnName;

    public UnresolvedColumnException(ADQLColumn c) {
        super(UnresolvedColumnException.buildMessage("Unknown column", c));
        this.initPosition(c);
        this.columnName = c != null ? c.getColumnName() : null;
    }

    public UnresolvedColumnException(ADQLColumn c, String col1, String col2) {
        super(UnresolvedColumnException.buildMessage("Ambiguous column name", c, col1, col2));
        this.initPosition(c);
        this.columnName = c != null ? c.getColumnName() : null;
    }

    protected final void initPosition(ADQLColumn c) {
        this.position = c.getPosition();
    }

    public final String getColumnName() {
        return this.columnName;
    }

    private static final String buildMessage(String msgStart, ADQLColumn c) {
        StringBuffer msg = new StringBuffer();
        msg.append(msgStart).append(" \"").append(c.getFullColumnName()).append("\" !");
        return msg.toString();
    }

    private static final String buildMessage(String msgStart, ADQLColumn c, String col1, String col2) {
        if (col1 != null && col2 != null) {
            StringBuffer msg = new StringBuffer(UnresolvedColumnException.buildMessage(msgStart, c));
            msg.append(" It may be (at least) \"").append(col1).append("\" or \"").append(col2).append("\".");
            return msg.toString();
        }
        return UnresolvedColumnException.buildMessage(msgStart, c);
    }
}

