/*
 * Decompiled with CFR 0.152.
 */
package adql.db.exception;

import adql.db.exception.UnresolvedColumnException;
import adql.db.exception.UnresolvedFunctionException;
import adql.db.exception.UnresolvedTableException;
import adql.parser.ParseException;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedIdentifiersException
extends ParseException
implements Iterable<ParseException> {
    private static final long serialVersionUID = 1L;
    protected ArrayList<ParseException> exceptions = new ArrayList();
    private String unresolvedIdentifiers = null;

    public final void addException(ParseException pe) {
        if (pe != null) {
            this.exceptions.add(pe);
            if (pe instanceof UnresolvedColumnException) {
                String colName = ((UnresolvedColumnException)pe).getColumnName();
                if (colName != null && colName.trim().length() > 0) {
                    this.addIdentifierName(colName + " " + pe.getPosition());
                }
            } else if (pe instanceof UnresolvedTableException) {
                String tableName = ((UnresolvedTableException)pe).getTableName();
                if (tableName != null && tableName.trim().length() > 0) {
                    this.addIdentifierName(tableName + " " + pe.getPosition());
                }
            } else if (pe instanceof UnresolvedFunctionException) {
                String fctName;
                String string = fctName = ((UnresolvedFunctionException)pe).getFunction() == null ? null : ((UnresolvedFunctionException)pe).getFunction().getName() + "(...)";
                if (fctName != null && fctName.trim().length() > 0) {
                    this.addIdentifierName(fctName + " " + pe.getPosition());
                }
            } else if (pe instanceof UnresolvedIdentifiersException) {
                this.addIdentifierName(((UnresolvedIdentifiersException)pe).unresolvedIdentifiers);
            }
        }
    }

    private final void addIdentifierName(String name) {
        if (name != null && name.trim().length() > 0) {
            this.unresolvedIdentifiers = this.unresolvedIdentifiers == null ? "" : this.unresolvedIdentifiers + ", ";
            this.unresolvedIdentifiers = this.unresolvedIdentifiers + name;
        }
    }

    public final int getNbErrors() {
        return this.exceptions.size();
    }

    public final Iterator<ParseException> getErrors() {
        return this.exceptions.iterator();
    }

    @Override
    public final Iterator<ParseException> iterator() {
        return this.getErrors();
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.exceptions.size()).append(" unresolved identifiers").append(this.unresolvedIdentifiers != null ? ": " + this.unresolvedIdentifiers : "").append('!');
        for (ParseException pe : this.exceptions) {
            buf.append("\n  - ").append(pe.getMessage());
        }
        return buf.toString();
    }
}

