/*
 * Decompiled with CFR 0.152.
 */
package adql.db.exception;

import adql.parser.ParseException;
import adql.query.from.ADQLTable;
import adql.query.operand.ADQLColumn;

public class UnresolvedTableException
extends ParseException {
    private static final long serialVersionUID = 1L;
    private final String tableName;

    public UnresolvedTableException(ADQLTable table) {
        super(UnresolvedTableException.buildMessage("Unknown table", table));
        this.initPosition(table);
        this.tableName = table != null ? table.getTableName() : null;
    }

    public UnresolvedTableException(ADQLTable table, String t1, String t2) {
        super(UnresolvedTableException.buildMessage("Ambiguous table name", table, t1, t2));
        this.initPosition(table);
        this.tableName = table != null ? table.getTableName() : null;
    }

    protected final void initPosition(ADQLTable table) {
        this.position = table.getPosition();
    }

    public UnresolvedTableException(ADQLColumn column) {
        super(UnresolvedTableException.buildMessage("Unknown table reference", column));
        this.initPosition(column);
        this.tableName = column != null ? column.getTableName() : null;
    }

    public UnresolvedTableException(ADQLColumn column, String table1, String table2) {
        super(UnresolvedTableException.buildMessage("Ambiguous table reference", column, table1, table2));
        this.initPosition(column);
        this.tableName = column != null ? column.getTableName() : null;
    }

    protected final void initPosition(ADQLColumn column) {
        this.position = column.getPosition();
    }

    private static final String buildMessage(String msgStart, ADQLTable t) {
        StringBuffer msg = new StringBuffer();
        msg.append(msgStart).append(" \"");
        if (t.isSubQuery()) {
            msg.append(t.getAlias()).append("\" !");
        } else {
            msg.append(t.getFullTableName()).append("\"").append(t.hasAlias() ? " (alias " + t.getAlias() + ")" : "").append(" !");
        }
        return msg.toString();
    }

    private static final String buildMessage(String msgStart, ADQLTable t, String t1, String t2) {
        if (t1 != null && t2 != null) {
            StringBuffer msg = new StringBuffer(UnresolvedTableException.buildMessage(msgStart, t));
            msg.append(" It may be (at least) \"").append(t1).append("\" or \"").append(t2).append("\".");
            return msg.toString();
        }
        return UnresolvedTableException.buildMessage(msgStart, t);
    }

    private static final String buildMessage(String msgStart, ADQLColumn c) {
        StringBuffer msg = new StringBuffer();
        msg.append(msgStart);
        msg.append(" \"").append(c.getFullColumnPrefix()).append("\" in \"").append(c.getFullColumnName()).append("\" !");
        return msg.toString();
    }

    private static final String buildMessage(String msgStart, ADQLColumn c, String table1, String table2) {
        if (table1 != null && table2 != null) {
            StringBuffer msg = new StringBuffer(UnresolvedTableException.buildMessage(msgStart, c));
            msg.append(" It may come (at least) from \"").append(table1).append("\" or from \"").append(table2).append("\".");
            return msg.toString();
        }
        return UnresolvedTableException.buildMessage(msgStart, c);
    }

    public final String getTableName() {
        return this.tableName;
    }
}

