/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.db.exception.UnresolvedIdentifiersException;
import adql.parser.ADQLParserConstants;
import adql.parser.ADQLParserTokenManager;
import adql.parser.ADQLQueryFactory;
import adql.parser.IdentifierItems;
import adql.parser.ParseException;
import adql.parser.QueryChecker;
import adql.parser.SimpleCharStream;
import adql.parser.Token;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ClauseADQL;
import adql.query.ClauseConstraints;
import adql.query.ClauseSelect;
import adql.query.ColumnReference;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.Between;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.constraint.ConstraintsGroup;
import adql.query.constraint.In;
import adql.query.constraint.NotConstraint;
import adql.query.from.ADQLJoin;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NumericConstant;
import adql.query.operand.Operation;
import adql.query.operand.OperationType;
import adql.query.operand.StringConstant;
import adql.query.operand.WrappedOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.MathFunctionType;
import adql.query.operand.function.SQLFunction;
import adql.query.operand.function.SQLFunctionType;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.translator.PostgreSQLTranslator;
import adql.translator.TranslationException;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADQLParser
implements ADQLParserConstants {
    private ADQLQueryFactory queryFactory = new ADQLQueryFactory();
    private Stack<ADQLQuery> stackQuery = new Stack();
    private ADQLQuery query = null;
    private QueryChecker queryChecker = null;
    private Token currentIdentifierToken = null;
    public ADQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[98];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[16];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private int trace_indent = 0;
    private boolean trace_enabled = true;

    public ADQLParser() {
        this(new ByteArrayInputStream("".getBytes()));
        this.setDebug(false);
    }

    public ADQLParser(QueryChecker checker, ADQLQueryFactory factory) {
        this();
        this.queryChecker = checker;
        if (factory != null) {
            this.queryFactory = factory;
        }
    }

    public ADQLParser(QueryChecker checker) {
        this(checker, null);
    }

    public ADQLParser(ADQLQueryFactory factory) {
        this((QueryChecker)null, factory);
    }

    public ADQLParser(InputStream stream, QueryChecker checker, ADQLQueryFactory factory) {
        this(stream);
        this.setDebug(false);
        this.setDebug(false);
        this.queryChecker = checker;
        if (factory != null) {
            this.queryFactory = factory;
        }
    }

    public ADQLParser(InputStream stream, QueryChecker checker) {
        this(stream, checker, null);
    }

    public ADQLParser(InputStream stream, ADQLQueryFactory factory) {
        this(stream, (QueryChecker)null, factory);
    }

    public ADQLParser(InputStream stream, String encoding, QueryChecker checker, ADQLQueryFactory factory) {
        this(stream, encoding);
        this.setDebug(false);
        this.queryChecker = checker;
        if (factory != null) {
            this.queryFactory = factory;
        }
    }

    public ADQLParser(InputStream stream, String encoding, QueryChecker checker) {
        this(stream, encoding, checker, null);
    }

    public ADQLParser(InputStream stream, String encoding, ADQLQueryFactory factory) {
        this(stream, encoding, null, factory);
    }

    public ADQLParser(Reader reader, QueryChecker checker, ADQLQueryFactory factory) {
        this(reader);
        this.setDebug(false);
        this.setDebug(false);
        this.queryChecker = checker;
        if (factory != null) {
            this.queryFactory = factory;
        }
    }

    public ADQLParser(Reader reader, QueryChecker checker) {
        this(reader, checker, null);
    }

    public ADQLParser(Reader reader, ADQLQueryFactory factory) {
        this(reader, null, factory);
    }

    public ADQLParser(ADQLParserTokenManager tm, QueryChecker checker, ADQLQueryFactory factory) {
        this(tm);
        this.setDebug(false);
        this.setDebug(false);
        this.queryChecker = checker;
        if (factory != null) {
            this.queryFactory = factory;
        }
    }

    public ADQLParser(ADQLParserTokenManager tm, QueryChecker checker) {
        this(tm, checker, null);
    }

    public ADQLParser(ADQLParserTokenManager tm, ADQLQueryFactory factory) {
        this(tm, null, factory);
    }

    public final ADQLQuery parseQuery() throws ParseException {
        this.stackQuery.clear();
        this.query = null;
        return this.Query();
    }

    public final ADQLQuery parseQuery(String q) throws ParseException {
        this.stackQuery.clear();
        this.query = null;
        this.ReInit(new ByteArrayInputStream(q.getBytes()));
        return this.Query();
    }

    public final ADQLQuery parseQuery(InputStream stream) throws ParseException {
        this.stackQuery.clear();
        this.query = null;
        this.ReInit(stream);
        return this.Query();
    }

    public final void setDebug(boolean debug) {
        if (debug) {
            this.enable_tracing();
        } else {
            this.disable_tracing();
        }
    }

    public final QueryChecker getQueryChecker() {
        return this.queryChecker;
    }

    public final void setQueryChecker(QueryChecker checker) {
        this.queryChecker = checker;
    }

    public final ADQLQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public final void setQueryFactory(ADQLQueryFactory factory) {
        this.queryFactory = factory != null ? factory : new ADQLQueryFactory();
    }

    private final ParseException generateParseException(Exception ex) {
        if (!(ex instanceof ParseException)) {
            ParseException pex = new ParseException("[" + ex.getClass().getName() + "] " + ex.getMessage());
            pex.setStackTrace(ex.getStackTrace());
            return pex;
        }
        return (ParseException)ex;
    }

    public static final void main(String[] args) throws Exception {
        String USAGE = "Usage:\n\tadqlParser.jar [-d] [-v] [-e] [-a|-s] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard input. This query must end with a ';' !\n\nParameters:\n\t-v or --verbose : Print the main steps of the parsing\n\t-d or --debug   : Print stack traces when a grave error occurs\n\t-e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n\t-a or --adql    : Display the understood ADQL query\n\t-s or --sql     : Ask the SQL translation of the given ADQL query (SQL compatible with PostgreSQL)\n\nReturn:\n\tBy default: nothing if the query is correct. Otherwise a message explaining why the query is not correct is displayed.\n\tWith the -s option, the SQL translation of the given ADQL query will be returned.\n\tWith the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n\t0\tOK !\n\t1\tParameter error (missing or incorrect parameter)\n\t2\tFile error (incorrect file/url, reading error, ...)\n\t3\tParsing error (syntactic or semantic error)\n\t4\tTranslation error (a problem has occurred during the translation of the given ADQL query in SQL).";
        String urlRegex = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        String file = null;
        Object metaFile = null;
        int mode = -1;
        boolean verbose = false;
        boolean debug = false;
        boolean explain = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-d") || args[i].equalsIgnoreCase("--debug")) {
                debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("--verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-e") || args[i].equalsIgnoreCase("--explain")) {
                explain = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-a") || args[i].equalsIgnoreCase("--adql")) {
                if (mode != -1) {
                    System.err.println("((!)) Too much parameter: you must choose between -s, -c, -a or nothing ((!))\nUsage:\n\tadqlParser.jar [-d] [-v] [-e] [-a|-s] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard input. This query must end with a ';' !\n\nParameters:\n\t-v or --verbose : Print the main steps of the parsing\n\t-d or --debug   : Print stack traces when a grave error occurs\n\t-e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n\t-a or --adql    : Display the understood ADQL query\n\t-s or --sql     : Ask the SQL translation of the given ADQL query (SQL compatible with PostgreSQL)\n\nReturn:\n\tBy default: nothing if the query is correct. Otherwise a message explaining why the query is not correct is displayed.\n\tWith the -s option, the SQL translation of the given ADQL query will be returned.\n\tWith the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n\t0\tOK !\n\t1\tParameter error (missing or incorrect parameter)\n\t2\tFile error (incorrect file/url, reading error, ...)\n\t3\tParsing error (syntactic or semantic error)\n\t4\tTranslation error (a problem has occurred during the translation of the given ADQL query in SQL).");
                    System.exit(1);
                    continue;
                }
                mode = 1;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s") || args[i].equalsIgnoreCase("--sql")) {
                if (mode != -1) {
                    System.err.println("((!)) Too much parameter: you must choose between -s, -c, -a or nothing ((!))\nUsage:\n\tadqlParser.jar [-d] [-v] [-e] [-a|-s] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard input. This query must end with a ';' !\n\nParameters:\n\t-v or --verbose : Print the main steps of the parsing\n\t-d or --debug   : Print stack traces when a grave error occurs\n\t-e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n\t-a or --adql    : Display the understood ADQL query\n\t-s or --sql     : Ask the SQL translation of the given ADQL query (SQL compatible with PostgreSQL)\n\nReturn:\n\tBy default: nothing if the query is correct. Otherwise a message explaining why the query is not correct is displayed.\n\tWith the -s option, the SQL translation of the given ADQL query will be returned.\n\tWith the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n\t0\tOK !\n\t1\tParameter error (missing or incorrect parameter)\n\t2\tFile error (incorrect file/url, reading error, ...)\n\t3\tParsing error (syntactic or semantic error)\n\t4\tTranslation error (a problem has occurred during the translation of the given ADQL query in SQL).");
                    System.exit(1);
                    continue;
                }
                mode = 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("--help")) {
                System.out.println("Usage:\n\tadqlParser.jar [-d] [-v] [-e] [-a|-s] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard input. This query must end with a ';' !\n\nParameters:\n\t-v or --verbose : Print the main steps of the parsing\n\t-d or --debug   : Print stack traces when a grave error occurs\n\t-e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n\t-a or --adql    : Display the understood ADQL query\n\t-s or --sql     : Ask the SQL translation of the given ADQL query (SQL compatible with PostgreSQL)\n\nReturn:\n\tBy default: nothing if the query is correct. Otherwise a message explaining why the query is not correct is displayed.\n\tWith the -s option, the SQL translation of the given ADQL query will be returned.\n\tWith the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n\t0\tOK !\n\t1\tParameter error (missing or incorrect parameter)\n\t2\tFile error (incorrect file/url, reading error, ...)\n\t3\tParsing error (syntactic or semantic error)\n\t4\tTranslation error (a problem has occurred during the translation of the given ADQL query in SQL).");
                System.exit(0);
                continue;
            }
            if (args[i].startsWith("-")) {
                System.err.println("((!)) Unknown parameter: \"" + args[i] + "\" ((!))\n" + "Usage:\n\tadqlParser.jar [-d] [-v] [-e] [-a|-s] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard input. This query must end with a ';' !\n\nParameters:\n\t-v or --verbose : Print the main steps of the parsing\n\t-d or --debug   : Print stack traces when a grave error occurs\n\t-e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n\t-a or --adql    : Display the understood ADQL query\n\t-s or --sql     : Ask the SQL translation of the given ADQL query (SQL compatible with PostgreSQL)\n\nReturn:\n\tBy default: nothing if the query is correct. Otherwise a message explaining why the query is not correct is displayed.\n\tWith the -s option, the SQL translation of the given ADQL query will be returned.\n\tWith the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n\t0\tOK !\n\t1\tParameter error (missing or incorrect parameter)\n\t2\tFile error (incorrect file/url, reading error, ...)\n\t3\tParsing error (syntactic or semantic error)\n\t4\tTranslation error (a problem has occurred during the translation of the given ADQL query in SQL).");
                System.exit(1);
                continue;
            }
            file = args[i].trim();
        }
        try {
            ADQLParser parser = file == null || file.length() == 0 ? new ADQLParser(System.in) : (file.matches("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]") ? new ADQLParser(new URL(file).openStream()) : new ADQLParser(new FileReader(file)));
            parser.setDebug(explain);
            try {
                if (verbose) {
                    System.out.print("((i)) Parsing ADQL query...");
                }
                ADQLQuery q = parser.parseQuery();
                if (verbose) {
                    System.out.println("((i)) CORRECT ADQL QUERY ((i))");
                }
                if (mode == 2) {
                    PostgreSQLTranslator translator = new PostgreSQLTranslator();
                    if (verbose) {
                        System.out.print("((i)) Translating in SQL...");
                    }
                    String sql = translator.translate(q);
                    if (verbose) {
                        System.out.println("ok");
                    }
                    System.out.println(sql);
                } else if (mode == 1) {
                    System.out.println(q.toADQL());
                }
            }
            catch (UnresolvedIdentifiersException uie) {
                System.err.println("((X)) " + uie.getNbErrors() + " unresolved identifiers:");
                for (ParseException pe : uie) {
                    System.err.println("\t - at " + pe.getPosition() + ": " + uie.getMessage());
                }
                if (debug) {
                    uie.printStackTrace(System.err);
                }
                System.exit(3);
            }
            catch (ParseException pe) {
                System.err.println("((X)) Syntax error: " + pe.getMessage() + " ((X))");
                if (debug) {
                    pe.printStackTrace(System.err);
                }
                System.exit(3);
            }
            catch (TranslationException te) {
                if (verbose) {
                    System.out.println("error");
                }
                System.err.println("((X)) Translation error: " + te.getMessage() + " ((X))");
                if (debug) {
                    te.printStackTrace(System.err);
                }
                System.exit(4);
            }
        }
        catch (IOException ioe) {
            System.err.println("\n((X)) Error while reading the file \"" + file + "\": " + ioe.getMessage() + " ((X))");
            if (debug) {
                ioe.printStackTrace(System.err);
            }
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLQuery Query() throws ParseException {
        this.trace_call("Query");
        try {
            ADQLQuery q = null;
            q = this.QueryExpression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    break;
                }
                case 6: {
                    this.jj_consume_token(6);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (this.queryChecker != null) {
                this.queryChecker.check(q);
            }
            ADQLQuery aDQLQuery = q;
            return aDQLQuery;
        }
        finally {
            this.trace_return("Query");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLQuery QueryExpression() throws ParseException {
        this.trace_call("QueryExpression");
        try {
            TextPosition endPos = null;
            try {
                this.query = this.queryFactory.createQuery();
                this.stackQuery.push(this.query);
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            this.Select();
            this.From();
            endPos = this.query.getFrom().getPosition();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    this.Where();
                    endPos = this.query.getWhere().getPosition();
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: {
                    this.GroupBy();
                    endPos = this.query.getGroupBy().getPosition();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: {
                    this.Having();
                    endPos = this.query.getHaving().getPosition();
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 44: {
                    this.OrderBy();
                    endPos = this.query.getOrderBy().getPosition();
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                }
            }
            this.query.setPosition(new TextPosition(this.query.getSelect().getPosition(), endPos));
            ADQLQuery previousQuery = this.stackQuery.pop();
            this.query = this.stackQuery.isEmpty() ? null : this.stackQuery.peek();
            ADQLQuery aDQLQuery = previousQuery;
            return aDQLQuery;
        }
        finally {
            this.trace_return("QueryExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLQuery SubQueryExpression() throws ParseException {
        this.trace_call("SubQueryExpression");
        try {
            ADQLQuery q = null;
            Token start = this.jj_consume_token(2);
            q = this.QueryExpression();
            Token end = this.jj_consume_token(3);
            q.setPosition(new TextPosition(start, end));
            ADQLQuery aDQLQuery = q;
            return aDQLQuery;
        }
        finally {
            this.trace_return("SubQueryExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Select() throws ParseException {
        this.trace_call("Select");
        try {
            ClauseSelect select = this.query.getSelect();
            SelectItem item = null;
            Token t = null;
            Token start = this.jj_consume_token(18);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    t = this.jj_consume_token(19);
                    select.setDistinctColumns(t.image.equalsIgnoreCase("DISTINCT"));
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    this.jj_consume_token(20);
                    t = this.jj_consume_token(101);
                    try {
                        select.setLimit(Integer.parseInt(t.image));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException("[l." + t.beginLine + ";c." + t.beginColumn + "] The TOP limit (\"" + t.image + "\") isn't a regular unsigned integer !");
                    }
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                }
            }
            item = this.SelectItem();
            select.add(item);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(5);
                item = this.SelectItem();
                select.add(item);
            }
            TextPosition lastItemPos = ((SelectItem)this.query.getSelect().get(this.query.getSelect().size() - 1)).getPosition();
            select.setPosition(new TextPosition(start.beginLine, start.beginColumn, lastItemPos.endLine, lastItemPos.endColumn));
        }
        finally {
            this.trace_return("Select");
        }
    }

    /*
     * Unable to fully structure code
     */
    public final SelectItem SelectItem() throws ParseException {
        this.trace_call("SelectItem");
        identifiers = new IdentifierItems(true);
        id = null;
        label = null;
        op = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                starToken = this.jj_consume_token(10);
                item = new SelectAllColumns(this.query);
                item.setPosition(new TextPosition(starToken));
                var7_10 = item;
                return var7_10;
            }
        }
        this.jj_la1[11] = this.jj_gen;
        if (this.jj_2_1(7)) {
            id = this.Identifier();
            this.jj_consume_token(4);
            identifiers.append(id);
            block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 96: 
                case 97: {
                    id = this.Identifier();
                    this.jj_consume_token(4);
                    identifiers.append(id);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 96: 
                        case 97: {
                            id = this.Identifier();
                            this.jj_consume_token(4);
                            identifiers.append(id);
                            break block9;
                        }
                    }
                    this.jj_la1[8] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                }
            }
            starToken = this.jj_consume_token(10);
            try {
                item = new SelectAllColumns(this.queryFactory.createTable(identifiers, null));
                firstPos = identifiers.get((int)0).position;
                item.setPosition(new TextPosition(firstPos.beginLine, firstPos.beginColumn, starToken.endLine, starToken.endColumn < 0 ? -1 : starToken.endColumn + 1));
                var8_15 = item;
                return var8_15;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        ** switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk)
lbl-1000:
        // 1 sources

        {
            case 2: 
            case 8: 
            case 9: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 93: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: {
                op = this.ValueExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        label = this.Identifier();
                        break block15;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                break;
            }
lbl57:
            // 1 sources

            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            item = this.queryFactory.createSelectItem(op, label == null ? null : label.identifier);
            if (label != null) {
                item.setCaseSensitive(label.caseSensitivity);
                item.setPosition(new TextPosition(op.getPosition(), label.position));
            } else {
                item.setPosition(new TextPosition(op.getPosition()));
            }
            ex = item;
            return ex;
        }
        catch (Exception ex) {
            throw this.generateParseException(ex);
        }
        finally {
            this.trace_return("SelectItem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void From() throws ParseException {
        this.trace_call("From");
        try {
            FromContent content = null;
            FromContent content2 = null;
            try {
                this.jj_consume_token(21);
                content = this.TableRef();
                block8: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block8;
                        }
                    }
                    this.jj_consume_token(5);
                    content2 = this.TableRef();
                    TextPosition startPos = content.getPosition();
                    TextPosition endPos = content2.getPosition();
                    content = this.queryFactory.createJoin(ADQLQueryFactory.JoinType.CROSS, content, content2);
                    content.setPosition(new TextPosition(startPos, endPos));
                }
                this.query.setFrom(content);
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("From");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Where() throws ParseException {
        this.trace_call("Where");
        try {
            ClauseConstraints where = this.query.getWhere();
            Token start = this.jj_consume_token(32);
            this.ConditionsList(where);
            TextPosition endPosition = where.getPosition();
            where.setPosition(new TextPosition(start.beginLine, start.beginColumn, endPosition.endLine, endPosition.endColumn));
        }
        finally {
            this.trace_return("Where");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void GroupBy() throws ParseException {
        this.trace_call("GroupBy");
        try {
            ClauseADQL<ColumnReference> groupBy = this.query.getGroupBy();
            ColumnReference colRef = null;
            Token start = this.jj_consume_token(42);
            colRef = this.ColumnRef();
            groupBy.add(colRef);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(5);
                colRef = this.ColumnRef();
                groupBy.add(colRef);
            }
            groupBy.setPosition(new TextPosition(start.beginLine, start.beginColumn, colRef.getPosition().endLine, colRef.getPosition().endColumn));
        }
        finally {
            this.trace_return("GroupBy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Having() throws ParseException {
        this.trace_call("Having");
        try {
            ClauseConstraints having = this.query.getHaving();
            Token start = this.jj_consume_token(43);
            this.ConditionsList(having);
            TextPosition endPosition = having.getPosition();
            having.setPosition(new TextPosition(start.beginLine, start.beginColumn, endPosition.endLine, endPosition.endColumn));
        }
        finally {
            this.trace_return("Having");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void OrderBy() throws ParseException {
        this.trace_call("OrderBy");
        try {
            ClauseADQL<ADQLOrder> orderBy = this.query.getOrderBy();
            ADQLOrder order = null;
            Token start = this.jj_consume_token(44);
            order = this.OrderItem();
            orderBy.add(order);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(5);
                order = this.OrderItem();
                orderBy.add(order);
            }
            orderBy.setPosition(new TextPosition(start, this.token));
        }
        finally {
            this.trace_return("OrderBy");
        }
    }

    public final IdentifierItems.IdentifierItem Identifier() throws ParseException {
        this.trace_call("Identifier");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 97: {
                    Token t = this.jj_consume_token(97);
                    IdentifierItems.IdentifierItem identifierItem = new IdentifierItems.IdentifierItem(t, false);
                    return identifierItem;
                }
                case 96: {
                    Token t = this.jj_consume_token(96);
                    IdentifierItems.IdentifierItem identifierItem = new IdentifierItems.IdentifierItem(t, true);
                    return identifierItem;
                }
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            this.trace_return("Identifier");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IdentifierItems TableName() throws ParseException {
        this.trace_call("TableName");
        try {
            IdentifierItems identifiers = new IdentifierItems(true);
            IdentifierItems.IdentifierItem id = null;
            id = this.Identifier();
            identifiers.append(id);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    id = this.Identifier();
                    identifiers.append(id);
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    id = this.Identifier();
                    identifiers.append(id);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                }
            }
            IdentifierItems identifierItems = identifiers;
            return identifierItems;
        }
        finally {
            this.trace_return("TableName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IdentifierItems ColumnName() throws ParseException {
        this.trace_call("ColumnName");
        try {
            IdentifierItems table = null;
            IdentifierItems identifiers = new IdentifierItems(false);
            IdentifierItems.IdentifierItem id = this.Identifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    table = this.TableName();
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                }
            }
            identifiers.append(id);
            if (table != null) {
                for (int i = 0; i < table.size(); ++i) {
                    identifiers.append(table.get(i));
                }
            }
            IdentifierItems identifierItems = identifiers;
            return identifierItems;
        }
        finally {
            this.trace_return("ColumnName");
        }
    }

    public final ADQLColumn Column() throws ParseException {
        this.trace_call("Column");
        try {
            IdentifierItems identifiers = this.ColumnName();
            try {
                ADQLColumn aDQLColumn = this.queryFactory.createColumn(identifiers);
                return aDQLColumn;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("Column");
        }
    }

    public final ColumnReference ColumnRef() throws ParseException {
        this.trace_call("ColumnRef");
        try {
            IdentifierItems.IdentifierItem identifier = null;
            Token ind = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 96: 
                case 97: {
                    identifier = this.Identifier();
                    break;
                }
                case 101: {
                    ind = this.jj_consume_token(101);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                ColumnReference colRef = null;
                colRef = identifier != null ? this.queryFactory.createColRef(identifier) : this.queryFactory.createColRef(Integer.parseInt(ind.image), new TextPosition(ind));
                ColumnReference columnReference = colRef;
                return columnReference;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ColumnRef");
        }
    }

    public final ADQLOrder OrderItem() throws ParseException {
        this.trace_call("OrderItem");
        try {
            IdentifierItems.IdentifierItem identifier = null;
            Token ind = null;
            Token desc = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 96: 
                case 97: {
                    identifier = this.Identifier();
                    break;
                }
                case 101: {
                    ind = this.jj_consume_token(101);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: 
                case 46: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 45: {
                            this.jj_consume_token(45);
                            break block7;
                        }
                        case 46: {
                            desc = this.jj_consume_token(46);
                            break block7;
                        }
                    }
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                }
            }
            try {
                ADQLOrder order = null;
                if (identifier != null) {
                    order = this.queryFactory.createOrder(identifier, desc != null);
                    order.setPosition(identifier.position);
                } else {
                    order = this.queryFactory.createOrder(Integer.parseInt(ind.image), desc != null);
                    order.setPosition(new TextPosition(ind));
                }
                ADQLOrder aDQLOrder = order;
                return aDQLOrder;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("OrderItem");
        }
    }

    public final FromContent SimpleTableRef() throws ParseException {
        this.trace_call("SimpleTableRef");
        try {
            FromContent content;
            block28: {
                IdentifierItems.IdentifierItem alias = null;
                IdentifierItems identifiers = null;
                ADQLQuery subQuery = null;
                content = null;
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 96: 
                        case 97: {
                            identifiers = this.TableName();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 22: 
                                case 96: 
                                case 97: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 22: {
                                            this.jj_consume_token(22);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[24] = this.jj_gen;
                                        }
                                    }
                                    alias = this.Identifier();
                                    break;
                                }
                                default: {
                                    this.jj_la1[25] = this.jj_gen;
                                }
                            }
                            content = this.queryFactory.createTable(identifiers, alias);
                            if (alias == null) {
                                content.setPosition(new TextPosition(identifiers.get((int)0).position, identifiers.get((int)(identifiers.size() - 1)).position));
                            } else {
                                content.setPosition(new TextPosition(identifiers.get((int)0).position, alias.position));
                            }
                            FromContent fromContent = content;
                            return fromContent;
                        }
                    }
                    this.jj_la1[27] = this.jj_gen;
                    if (!this.jj_2_2(2)) break block28;
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
                subQuery = this.SubQueryExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                alias = this.Identifier();
                content = this.queryFactory.createTable(subQuery, alias);
                if (alias == null) {
                    content.setPosition(new TextPosition(subQuery.getPosition()));
                } else {
                    content.setPosition(new TextPosition(subQuery.getPosition(), alias.position));
                }
                FromContent fromContent = content;
                return fromContent;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    Token start = this.jj_consume_token(2);
                    content = this.JoinedTable();
                    Token end = this.jj_consume_token(3);
                    content.setPosition(new TextPosition(start, end));
                    FromContent fromContent = content;
                    return fromContent;
                }
            }
            this.jj_la1[28] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        finally {
            this.trace_return("SimpleTableRef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FromContent TableRef() throws ParseException {
        this.trace_call("TableRef");
        try {
            FromContent content = this.SimpleTableRef();
            while (this.jj_2_3(2)) {
                content = this.JoinSpecification(content);
            }
            FromContent fromContent = content;
            return fromContent;
        }
        finally {
            this.trace_return("TableRef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FromContent JoinedTable() throws ParseException {
        this.trace_call("JoinedTable");
        try {
            FromContent content = this.SimpleTableRef();
            block6: while (true) {
                content = this.JoinSpecification(content);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        continue block6;
                    }
                }
                break;
            }
            this.jj_la1[29] = this.jj_gen;
            FromContent fromContent = content;
            return fromContent;
        }
        finally {
            this.trace_return("JoinedTable");
        }
    }

    /*
     * Exception decompiling
     */
    public final ADQLJoin JoinSpecification(FromContent leftTable) throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final StringConstant String() throws ParseException {
        this.trace_call("String");
        try {
            Token t;
            Token start = null;
            String str = "";
            block9: while (true) {
                t = this.jj_consume_token(93);
                str = str + t.image.substring(1, t.image.length() - 1).replaceAll("''", "'");
                if (start == null) {
                    start = t;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 93: {
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[41] = this.jj_gen;
            try {
                StringConstant cst = this.queryFactory.createStringConstant(str);
                cst.setPosition(new TextPosition(start, t));
                StringConstant stringConstant = cst;
                return stringConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("String");
        }
    }

    public final NumericConstant UnsignedNumeric() throws ParseException {
        this.trace_call("UnsignedNumeric");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 99: {
                    t = this.jj_consume_token(99);
                    break;
                }
                case 100: {
                    t = this.jj_consume_token(100);
                    break;
                }
                case 101: {
                    t = this.jj_consume_token(101);
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                NumericConstant cst = this.queryFactory.createNumericConstant(t.image);
                cst.setPosition(new TextPosition(t));
                NumericConstant numericConstant = cst;
                return numericConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("UnsignedNumeric");
        }
    }

    public final NumericConstant UnsignedFloat() throws ParseException {
        this.trace_call("UnsignedFloat");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 101: {
                    t = this.jj_consume_token(101);
                    break;
                }
                case 100: {
                    t = this.jj_consume_token(100);
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                NumericConstant cst = this.queryFactory.createNumericConstant(t.image);
                cst.setPosition(new TextPosition(t));
                NumericConstant numericConstant = cst;
                return numericConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("UnsignedFloat");
        }
    }

    public final NumericConstant SignedInteger() throws ParseException {
        this.trace_call("SignedInteger");
        try {
            Token sign = null;
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            sign = this.jj_consume_token(8);
                            break block3;
                        }
                        case 9: {
                            sign = this.jj_consume_token(9);
                            break block3;
                        }
                    }
                    this.jj_la1[44] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                }
            }
            Token number = this.jj_consume_token(101);
            try {
                NumericConstant cst;
                if (sign == null) {
                    cst = this.queryFactory.createNumericConstant(number.image);
                    cst.setPosition(new TextPosition(number));
                } else {
                    cst = this.queryFactory.createNumericConstant(sign.image + number.image);
                    cst.setPosition(new TextPosition(sign, number));
                }
                NumericConstant numericConstant = cst;
                return numericConstant;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("SignedInteger");
        }
    }

    public final ADQLOperand NumericValueExpressionPrimary() throws ParseException {
        this.trace_call("NumericValueExpressionPrimary");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 99: 
                case 100: 
                case 101: {
                    NumericConstant op;
                    NumericConstant numericConstant = op = this.UnsignedNumeric();
                    return numericConstant;
                }
                case 96: 
                case 97: {
                    ADQLColumn column = this.Column();
                    column.setExpectedType('N');
                    ADQLColumn aDQLColumn = column;
                    return aDQLColumn;
                }
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: {
                    SQLFunction op;
                    SQLFunction sQLFunction = op = this.SqlFunction();
                    return sQLFunction;
                }
                case 2: {
                    Token left = this.jj_consume_token(2);
                    ADQLOperand op = this.NumericExpression();
                    Token right = this.jj_consume_token(3);
                    WrappedOperand wop = this.queryFactory.createWrappedOperand(op);
                    wop.setPosition(new TextPosition(left, right));
                    WrappedOperand wrappedOperand = wop;
                    return wrappedOperand;
                }
            }
            try {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("NumericValueExpressionPrimary");
        }
    }

    public final ADQLOperand StringValueExpressionPrimary() throws ParseException {
        this.trace_call("StringValueExpressionPrimary");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: {
                    StringConstant expr;
                    StringConstant stringConstant = expr = this.String();
                    return stringConstant;
                }
                case 96: 
                case 97: {
                    ADQLColumn column = this.Column();
                    column.setExpectedType('S');
                    ADQLColumn aDQLColumn = column;
                    return aDQLColumn;
                }
                case 2: {
                    Token left = this.jj_consume_token(2);
                    ADQLOperand op = this.StringExpression();
                    Token right = this.jj_consume_token(3);
                    WrappedOperand wop = this.queryFactory.createWrappedOperand(op);
                    wop.setPosition(new TextPosition(left, right));
                    WrappedOperand wrappedOperand = wop;
                    return wrappedOperand;
                }
            }
            try {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("StringValueExpressionPrimary");
        }
    }

    public final ADQLOperand ValueExpression() throws ParseException {
        this.trace_call("ValueExpression");
        try {
            ADQLOperand valueExpr = null;
            try {
                if (this.jj_2_4(Integer.MAX_VALUE)) {
                    valueExpr = this.NumericExpression();
                } else if (this.jj_2_5(Integer.MAX_VALUE)) {
                    valueExpr = this.StringExpression();
                } else if (this.jj_2_6(Integer.MAX_VALUE)) {
                    Token left = this.jj_consume_token(2);
                    valueExpr = this.ValueExpression();
                    Token right = this.jj_consume_token(3);
                    valueExpr = this.queryFactory.createWrappedOperand(valueExpr);
                    ((WrappedOperand)valueExpr).setPosition(new TextPosition(left, right));
                } else if (this.jj_2_7(Integer.MAX_VALUE)) {
                    valueExpr = this.UserDefinedFunction();
                } else {
                    block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            valueExpr = this.GeometryValueFunction();
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            if (this.jj_2_8(Integer.MAX_VALUE)) {
                                valueExpr = this.Column();
                                break;
                            }
                            if (this.jj_2_9(Integer.MAX_VALUE)) {
                                valueExpr = this.StringFactor();
                                break;
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 2: 
                                case 8: 
                                case 9: 
                                case 47: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 58: 
                                case 59: 
                                case 60: 
                                case 61: 
                                case 62: 
                                case 64: 
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 76: 
                                case 77: 
                                case 78: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 82: 
                                case 83: 
                                case 84: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 96: 
                                case 97: 
                                case 99: 
                                case 100: 
                                case 101: {
                                    valueExpr = this.Factor();
                                    break block3;
                                }
                            }
                            this.jj_la1[49] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                ADQLOperand aDQLOperand = valueExpr;
                return aDQLOperand;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ValueExpression");
        }
    }

    public final ADQLOperand NumericExpression() throws ParseException {
        this.trace_call("NumericExpression");
        try {
            Token sign = null;
            ADQLOperand rightOp = null;
            ADQLOperand leftOp = this.NumericTerm();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            sign = this.jj_consume_token(8);
                            break;
                        }
                        case 9: {
                            sign = this.jj_consume_token(9);
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    rightOp = this.NumericExpression();
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                }
            }
            if (sign == null) {
                ADQLOperand aDQLOperand = leftOp;
                return aDQLOperand;
            }
            Operation operation = this.queryFactory.createOperation(leftOp, OperationType.getOperator(sign.image), rightOp);
            operation.setPosition(new TextPosition(leftOp.getPosition(), rightOp.getPosition()));
            Operation operation2 = operation;
            return operation2;
        }
        finally {
            this.trace_return("NumericExpression");
        }
    }

    public final ADQLOperand NumericTerm() throws ParseException {
        this.trace_call("NumericTerm");
        try {
            Token sign = null;
            ADQLOperand rightOp = null;
            ADQLOperand leftOp = this.Factor();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 11: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 10: {
                            sign = this.jj_consume_token(10);
                            break;
                        }
                        case 11: {
                            sign = this.jj_consume_token(11);
                            break;
                        }
                        default: {
                            this.jj_la1[52] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    rightOp = this.NumericTerm();
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                }
            }
            if (sign == null) {
                ADQLOperand aDQLOperand = leftOp;
                return aDQLOperand;
            }
            Operation operation = this.queryFactory.createOperation(leftOp, OperationType.getOperator(sign.image), rightOp);
            operation.setPosition(new TextPosition(leftOp.getPosition(), rightOp.getPosition()));
            Operation operation2 = operation;
            return operation2;
        }
        finally {
            this.trace_return("NumericTerm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand Factor() throws ParseException {
        this.trace_call("Factor");
        try {
            ADQLOperand op;
            boolean negative = false;
            Token minusSign = null;
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            this.jj_consume_token(8);
                            break block2;
                        }
                        case 9: {
                            minusSign = this.jj_consume_token(9);
                            negative = true;
                            break block2;
                        }
                    }
                    this.jj_la1[54] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                }
            }
            if (this.jj_2_10(2)) {
                op = this.NumericFunction();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: {
                        op = this.NumericValueExpressionPrimary();
                        break;
                    }
                    default: {
                        this.jj_la1[56] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            if (negative) {
                try {
                    TextPosition position = op.getPosition();
                    op = this.queryFactory.createNegativeOperand(op);
                    NegativeOperand negativeOp = (NegativeOperand)op;
                    if (minusSign != null) {
                        negativeOp.setPosition(new TextPosition(minusSign.beginLine, minusSign.beginColumn, position.endLine, position.endColumn));
                    } else {
                        negativeOp.setPosition(position);
                    }
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
            }
            ADQLFunction aDQLFunction = op;
            return aDQLFunction;
        }
        finally {
            this.trace_return("Factor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand StringExpression() throws ParseException {
        this.trace_call("StringExpression");
        try {
            ADQLOperand rightOp = null;
            ADQLOperand leftOp = this.StringFactor();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(7);
                rightOp = this.StringFactor();
                if (!(leftOp instanceof Concatenation)) {
                    try {
                        ADQLOperand temp = leftOp;
                        leftOp = this.queryFactory.createConcatenation();
                        ((Concatenation)leftOp).add(temp);
                    }
                    catch (Exception ex) {
                        throw this.generateParseException(ex);
                    }
                }
                ((Concatenation)leftOp).add(rightOp);
            }
            if (leftOp instanceof Concatenation) {
                Concatenation concat = (Concatenation)leftOp;
                concat.setPosition(new TextPosition(((ADQLOperand)concat.get(0)).getPosition(), ((ADQLOperand)concat.get(concat.size() - 1)).getPosition()));
            }
            ADQLOperand aDQLOperand = leftOp;
            return aDQLOperand;
        }
        finally {
            this.trace_return("StringExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand StringFactor() throws ParseException {
        this.trace_call("StringFactor");
        try {
            ADQLOperand op;
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: {
                    op = this.ExtractCoordSys();
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    if (this.jj_2_11(2)) {
                        op = this.UserDefinedFunction();
                        ((UserDefinedFunction)op).setExpectedType('S');
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 2: 
                        case 93: 
                        case 96: 
                        case 97: {
                            op = this.StringValueExpressionPrimary();
                            break block1;
                        }
                    }
                    this.jj_la1[59] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            GeometryFunction geometryFunction = op;
            return geometryFunction;
        }
        finally {
            this.trace_return("StringFactor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction.GeometryValue<GeometryFunction> GeometryExpression() throws ParseException {
        this.trace_call("GeometryExpression");
        try {
            ADQLColumn col = null;
            GeometryFunction gf = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 96: 
                case 97: {
                    col = this.Column();
                    break;
                }
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    gf = this.GeometryValueFunction();
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (col != null) {
                col.setExpectedType('G');
                GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(col);
                return geometryValue;
            }
            GeometryFunction.GeometryValue<GeometryFunction> geometryValue = new GeometryFunction.GeometryValue<GeometryFunction>(gf);
            return geometryValue;
        }
        finally {
            this.trace_return("GeometryExpression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ClauseConstraints ConditionsList(ClauseConstraints clause) throws ParseException {
        this.trace_call("ConditionsList");
        try {
            block25: {
                ADQLConstraint constraint = null;
                Token op = null;
                boolean notOp = false;
                try {
                    TextPosition oldPos;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            op = this.jj_consume_token(35);
                            notOp = true;
                            break;
                        }
                        default: {
                            this.jj_la1[61] = this.jj_gen;
                        }
                    }
                    constraint = this.Constraint();
                    if (notOp) {
                        oldPos = constraint.getPosition();
                        constraint = this.queryFactory.createNot(constraint);
                        ((NotConstraint)constraint).setPosition(new TextPosition(op.beginLine, op.beginColumn, oldPos.endLine, oldPos.endColumn));
                    }
                    notOp = false;
                    if (clause instanceof ADQLConstraint) {
                        clause.add(constraint);
                    } else {
                        clause.add(constraint);
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 33: 
                            case 34: {
                                break;
                            }
                            default: {
                                this.jj_la1[62] = this.jj_gen;
                                break block25;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 33: {
                                op = this.jj_consume_token(33);
                                break;
                            }
                            case 34: {
                                op = this.jj_consume_token(34);
                                break;
                            }
                            default: {
                                this.jj_la1[63] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: {
                                this.jj_consume_token(35);
                                notOp = true;
                                break;
                            }
                            default: {
                                this.jj_la1[64] = this.jj_gen;
                            }
                        }
                        constraint = this.Constraint();
                        if (notOp) {
                            oldPos = constraint.getPosition();
                            constraint = this.queryFactory.createNot(constraint);
                            ((NotConstraint)constraint).setPosition(new TextPosition(op.beginLine, op.beginColumn, oldPos.endLine, oldPos.endColumn));
                        }
                        notOp = false;
                        if (clause instanceof ADQLConstraint) {
                            clause.add(op.image, constraint);
                            continue;
                        }
                        clause.add(op.image, constraint);
                    }
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
            }
            if (!clause.isEmpty()) {
                TextPosition start = ((ADQLConstraint)clause.get(0)).getPosition();
                TextPosition end = ((ADQLConstraint)clause.get(clause.size() - 1)).getPosition();
                clause.setPosition(new TextPosition(start, end));
            }
            ClauseConstraints clauseConstraints = clause;
            return clauseConstraints;
        }
        finally {
            this.trace_return("ConditionsList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLConstraint Constraint() throws ParseException {
        this.trace_call("Constraint");
        try {
            ADQLConstraint constraint = null;
            if (this.jj_2_12(Integer.MAX_VALUE)) {
                constraint = this.Predicate();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        Token start = this.jj_consume_token(2);
                        try {
                            constraint = this.queryFactory.createGroupOfConstraints();
                        }
                        catch (Exception ex) {
                            throw this.generateParseException(ex);
                        }
                        this.ConditionsList((ConstraintsGroup)constraint);
                        Token end = this.jj_consume_token(3);
                        ((ConstraintsGroup)constraint).setPosition(new TextPosition(start, end));
                        break;
                    }
                    default: {
                        this.jj_la1[65] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            ADQLConstraint aDQLConstraint = constraint;
            return aDQLConstraint;
        }
        finally {
            this.trace_return("Constraint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final ADQLConstraint Predicate() throws ParseException {
        this.trace_call("Predicate");
        try {
            block29: {
                q = null;
                column = null;
                strExpr1 = null;
                strExpr2 = null;
                notToken = null;
                constraint /* !! */  = null;
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 41: {
                            start = this.jj_consume_token(41);
                            q = this.SubQueryExpression();
                            e = this.queryFactory.createExists(q);
                            e.setPosition(new TextPosition(start.beginLine, start.beginColumn, q.getPosition().endLine, q.getPosition().endColumn));
                            var11_11 = e;
                            return var11_11;
                        }
                    }
                    this.jj_la1[70] = this.jj_gen;
                    if (!this.jj_2_14(0x7FFFFFFF)) break block29;
                }
                catch (Exception ex) {
                    throw this.generateParseException(ex);
                }
                column = this.Column();
                this.jj_consume_token(36);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        notToken = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                    }
                }
                end = this.jj_consume_token(37);
                in = this.queryFactory.createIsNull(notToken != null, column);
                in.setPosition(new TextPosition(column.getPosition().beginLine, column.getPosition().beginColumn, end.endLine, end.endColumn < 0 ? -1 : end.endColumn + 1));
                var12_15 = in;
                return var12_15;
            }
            if (this.jj_2_15(0x7FFFFFFF)) {
                strExpr1 = this.StringExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        notToken = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                    }
                }
                this.jj_consume_token(39);
                strExpr2 = this.StringExpression();
                comp = this.queryFactory.createComparison(strExpr1, notToken == null ? ComparisonOperator.LIKE : ComparisonOperator.NOTLIKE, strExpr2);
                comp.setPosition(new TextPosition(strExpr1.getPosition(), strExpr2.getPosition()));
                var12_16 = comp;
                return var12_16;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 8: 
                case 9: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 93: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: {
                    op = this.ValueExpression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            constraint /* !! */  = this.ComparisonEnd(op);
                            ** break;
                        }
                    }
                    this.jj_la1[68] = this.jj_gen;
                    if (this.jj_2_13(2)) {
                        constraint /* !! */  = this.BetweenEnd(op);
                        ** break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: 
                        case 40: {
                            constraint /* !! */  = this.InEnd(op);
                            ** break;
                        }
                    }
                    this.jj_la1[69] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
lbl78:
            // 3 sources

            var10_10 = constraint /* !! */ ;
            return var10_10;
        }
        finally {
            this.trace_return("Predicate");
        }
    }

    public final Comparison ComparisonEnd(ADQLOperand leftOp) throws ParseException {
        this.trace_call("ComparisonEnd");
        try {
            Token comp;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    comp = this.jj_consume_token(12);
                    break;
                }
                case 13: {
                    comp = this.jj_consume_token(13);
                    break;
                }
                case 14: {
                    comp = this.jj_consume_token(14);
                    break;
                }
                case 15: {
                    comp = this.jj_consume_token(15);
                    break;
                }
                case 16: {
                    comp = this.jj_consume_token(16);
                    break;
                }
                case 17: {
                    comp = this.jj_consume_token(17);
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ADQLOperand rightOp = this.ValueExpression();
            try {
                Comparison comparison = this.queryFactory.createComparison(leftOp, ComparisonOperator.getOperator(comp.image), rightOp);
                comparison.setPosition(new TextPosition(leftOp.getPosition(), rightOp.getPosition()));
                Comparison comparison2 = comparison;
                return comparison2;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ComparisonEnd");
        }
    }

    public final Between BetweenEnd(ADQLOperand leftOp) throws ParseException {
        this.trace_call("BetweenEnd");
        try {
            Token notToken = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    notToken = this.jj_consume_token(35);
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                }
            }
            Token start = this.jj_consume_token(38);
            ADQLOperand min = this.ValueExpression();
            this.jj_consume_token(33);
            ADQLOperand max = this.ValueExpression();
            try {
                Between bet = this.queryFactory.createBetween(notToken != null, leftOp, min, max);
                if (notToken != null) {
                    start = notToken;
                }
                bet.setPosition(new TextPosition(start.beginLine, start.beginColumn, max.getPosition().endLine, max.getPosition().endColumn));
                Between between = bet;
                return between;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("BetweenEnd");
        }
    }

    public final In InEnd(ADQLOperand leftOp) throws ParseException {
        this.trace_call("InEnd");
        try {
            Token not = null;
            ADQLQuery q = null;
            Vector<ADQLOperand> items = new Vector<ADQLOperand>();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    not = this.jj_consume_token(35);
                    break;
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                }
            }
            Token start = this.jj_consume_token(40);
            if (this.jj_2_16(2)) {
                q = this.SubQueryExpression();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        this.jj_consume_token(2);
                        ADQLOperand item = this.ValueExpression();
                        items.add(item);
                        block15: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[75] = this.jj_gen;
                                    break block15;
                                }
                            }
                            this.jj_consume_token(5);
                            item = this.ValueExpression();
                            items.add(item);
                        }
                        this.jj_consume_token(3);
                        break;
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            try {
                In in;
                Token token = start = not != null ? not : start;
                if (q != null) {
                    in = this.queryFactory.createIn(leftOp, q, not != null);
                    in.setPosition(new TextPosition(start.beginLine, start.beginColumn, q.getPosition().endLine, q.getPosition().endColumn));
                } else {
                    ADQLOperand[] list = new ADQLOperand[items.size()];
                    int i = 0;
                    for (ADQLOperand op : items) {
                        list[i++] = op;
                    }
                    in = this.queryFactory.createIn(leftOp, list, not != null);
                    in.setPosition(new TextPosition(start.beginLine, start.beginColumn, list[list.length - 1].getPosition().endLine, list[list.length - 1].getPosition().endColumn));
                }
                In in2 = in;
                return in2;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("InEnd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLFunction SqlFunction() throws ParseException {
        this.trace_call("SqlFunction");
        try {
            Token all = null;
            Token distinct = null;
            ADQLOperand op = null;
            SQLFunction funct = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        Token fct = this.jj_consume_token(51);
                        this.jj_consume_token(2);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: {
                                distinct = this.jj_consume_token(19);
                                break;
                            }
                            default: {
                                this.jj_la1[77] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: {
                                all = this.jj_consume_token(10);
                                break;
                            }
                            case 2: 
                            case 8: 
                            case 9: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 93: 
                            case 96: 
                            case 97: 
                            case 99: 
                            case 100: 
                            case 101: {
                                op = this.ValueExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[78] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Token end = this.jj_consume_token(3);
                        funct = this.queryFactory.createSQLFunction(all != null ? SQLFunctionType.COUNT_ALL : SQLFunctionType.COUNT, op, distinct != null && distinct.image.equalsIgnoreCase("distinct"));
                        funct.setPosition(new TextPosition(fct, end));
                        break;
                    }
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: {
                        Token fct;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 47: {
                                fct = this.jj_consume_token(47);
                                break;
                            }
                            case 48: {
                                fct = this.jj_consume_token(48);
                                break;
                            }
                            case 49: {
                                fct = this.jj_consume_token(49);
                                break;
                            }
                            case 50: {
                                fct = this.jj_consume_token(50);
                                break;
                            }
                            default: {
                                this.jj_la1[79] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(2);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: {
                                distinct = this.jj_consume_token(19);
                                break;
                            }
                            default: {
                                this.jj_la1[80] = this.jj_gen;
                            }
                        }
                        op = this.ValueExpression();
                        Token end = this.jj_consume_token(3);
                        funct = this.queryFactory.createSQLFunction(SQLFunctionType.valueOf(fct.image.toUpperCase()), op, distinct != null && distinct.image.equalsIgnoreCase("distinct"));
                        funct.setPosition(new TextPosition(fct, end));
                        break;
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            SQLFunction sQLFunction = funct;
            return sQLFunction;
        }
        finally {
            this.trace_return("SqlFunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand[] Coordinates() throws ParseException {
        this.trace_call("Coordinates");
        try {
            ADQLOperand[] ops = new ADQLOperand[2];
            ops[0] = this.NumericExpression();
            this.jj_consume_token(5);
            ops[1] = this.NumericExpression();
            ADQLOperand[] aDQLOperandArray = ops;
            return aDQLOperandArray;
        }
        finally {
            this.trace_return("Coordinates");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction GeometryFunction() throws ParseException {
        this.trace_call("GeometryFunction");
        try {
            Token end;
            Token fct = null;
            GeometryFunction gf = null;
            PointFunction p1 = null;
            PointFunction p2 = null;
            ADQLColumn col1 = null;
            ADQLColumn col2 = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: 
                    case 59: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 58: {
                                fct = this.jj_consume_token(58);
                                break;
                            }
                            case 59: {
                                fct = this.jj_consume_token(59);
                                break;
                            }
                            default: {
                                this.jj_la1[82] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(2);
                        GeometryFunction.GeometryValue<GeometryFunction> gvf1 = this.GeometryExpression();
                        this.jj_consume_token(5);
                        GeometryFunction.GeometryValue<GeometryFunction> gvf2 = this.GeometryExpression();
                        end = this.jj_consume_token(3);
                        if (fct.image.equalsIgnoreCase("contains")) {
                            gf = this.queryFactory.createContains(gvf1, gvf2);
                            break;
                        }
                        gf = this.queryFactory.createIntersects(gvf1, gvf2);
                        break;
                    }
                    case 60: {
                        fct = this.jj_consume_token(60);
                        this.jj_consume_token(2);
                        GeometryFunction.GeometryValue<GeometryFunction> gvf1 = this.GeometryExpression();
                        end = this.jj_consume_token(3);
                        gf = this.queryFactory.createArea(gvf1);
                        break;
                    }
                    case 61: {
                        fct = this.jj_consume_token(61);
                        this.jj_consume_token(2);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 55: {
                                p1 = this.Point();
                                gf = this.queryFactory.createCoord1(p1);
                                break;
                            }
                            case 96: 
                            case 97: {
                                col1 = this.Column();
                                col1.setExpectedType('G');
                                gf = this.queryFactory.createCoord1(col1);
                                break;
                            }
                            default: {
                                this.jj_la1[83] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 62: {
                        fct = this.jj_consume_token(62);
                        this.jj_consume_token(2);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 55: {
                                p1 = this.Point();
                                gf = this.queryFactory.createCoord2(p1);
                                break;
                            }
                            case 96: 
                            case 97: {
                                col1 = this.Column();
                                col1.setExpectedType('G');
                                gf = this.queryFactory.createCoord2(col1);
                                break;
                            }
                            default: {
                                this.jj_la1[84] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 64: {
                        GeometryFunction.GeometryValue<PointFunction> gvp2;
                        GeometryFunction.GeometryValue<PointFunction> gvp1;
                        fct = this.jj_consume_token(64);
                        this.jj_consume_token(2);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 55: {
                                p1 = this.Point();
                                break;
                            }
                            case 96: 
                            case 97: {
                                col1 = this.Column();
                                break;
                            }
                            default: {
                                this.jj_la1[85] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (p1 != null) {
                            gvp1 = new GeometryFunction.GeometryValue<PointFunction>(p1);
                        } else {
                            col1.setExpectedType('G');
                            gvp1 = new GeometryFunction.GeometryValue(col1);
                        }
                        this.jj_consume_token(5);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 55: {
                                p2 = this.Point();
                                break;
                            }
                            case 96: 
                            case 97: {
                                col2 = this.Column();
                                break;
                            }
                            default: {
                                this.jj_la1[86] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (p2 != null) {
                            gvp2 = new GeometryFunction.GeometryValue<PointFunction>(p2);
                        } else {
                            col2.setExpectedType('G');
                            gvp2 = new GeometryFunction.GeometryValue(col2);
                        }
                        end = this.jj_consume_token(3);
                        gf = this.queryFactory.createDistance(gvp1, gvp2);
                        break;
                    }
                    default: {
                        this.jj_la1[87] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            gf.setPosition(new TextPosition(fct, end));
            GeometryFunction geometryFunction = gf;
            return geometryFunction;
        }
        finally {
            this.trace_return("GeometryFunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLOperand CoordinateSystem() throws ParseException {
        this.trace_call("CoordinateSystem");
        try {
            ADQLOperand coordSys = null;
            ADQLOperand aDQLOperand = coordSys = this.StringExpression();
            return aDQLOperand;
        }
        finally {
            this.trace_return("CoordinateSystem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeometryFunction GeometryValueFunction() throws ParseException {
        this.trace_call("GeometryValueFunction");
        try {
            Token fct = null;
            Token end = null;
            ADQLOperand op = null;
            GeometryFunction.GeometryValue<GeometryFunction> gvf = null;
            GeometryFunction gf = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 52: {
                        fct = this.jj_consume_token(52);
                        this.jj_consume_token(2);
                        ADQLOperand coordSys = this.CoordinateSystem();
                        this.jj_consume_token(5);
                        ADQLOperand[] coords = this.Coordinates();
                        this.jj_consume_token(5);
                        ADQLOperand width = this.NumericExpression();
                        this.jj_consume_token(5);
                        ADQLOperand height = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        gf = this.queryFactory.createBox(coordSys, coords[0], coords[1], width, height);
                        break;
                    }
                    case 53: {
                        fct = this.jj_consume_token(53);
                        this.jj_consume_token(2);
                        gvf = this.GeometryExpression();
                        end = this.jj_consume_token(3);
                        gf = this.queryFactory.createCentroid(gvf);
                        break;
                    }
                    case 54: {
                        fct = this.jj_consume_token(54);
                        this.jj_consume_token(2);
                        ADQLOperand coordSys = this.CoordinateSystem();
                        this.jj_consume_token(5);
                        ADQLOperand[] coords = this.Coordinates();
                        this.jj_consume_token(5);
                        ADQLOperand width = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        gf = this.queryFactory.createCircle(coordSys, coords[0], coords[1], width);
                        break;
                    }
                    case 55: {
                        gf = this.Point();
                        break;
                    }
                    case 56: {
                        fct = this.jj_consume_token(56);
                        this.jj_consume_token(2);
                        ADQLOperand coordSys = this.CoordinateSystem();
                        Vector<ADQLOperand> vCoords = new Vector<ADQLOperand>();
                        this.jj_consume_token(5);
                        ADQLOperand[] tmp = this.Coordinates();
                        vCoords.add(tmp[0]);
                        vCoords.add(tmp[1]);
                        this.jj_consume_token(5);
                        tmp = this.Coordinates();
                        vCoords.add(tmp[0]);
                        vCoords.add(tmp[1]);
                        this.jj_consume_token(5);
                        tmp = this.Coordinates();
                        vCoords.add(tmp[0]);
                        vCoords.add(tmp[1]);
                        block16: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[88] = this.jj_gen;
                                    break block16;
                                }
                            }
                            this.jj_consume_token(5);
                            tmp = this.Coordinates();
                            vCoords.add(tmp[0]);
                            vCoords.add(tmp[1]);
                        }
                        end = this.jj_consume_token(3);
                        gf = this.queryFactory.createPolygon(coordSys, vCoords);
                        break;
                    }
                    case 57: {
                        fct = this.jj_consume_token(57);
                        this.jj_consume_token(2);
                        op = this.StringExpression();
                        end = this.jj_consume_token(3);
                        gf = this.queryFactory.createRegion(op);
                        break;
                    }
                    default: {
                        this.jj_la1[89] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
            if (fct != null && end != null) {
                gf.setPosition(new TextPosition(fct, end));
            }
            PointFunction pointFunction = gf;
            return pointFunction;
        }
        finally {
            this.trace_return("GeometryValueFunction");
        }
    }

    public final PointFunction Point() throws ParseException {
        this.trace_call("Point");
        try {
            Token start = this.jj_consume_token(55);
            this.jj_consume_token(2);
            ADQLOperand coordSys = this.CoordinateSystem();
            this.jj_consume_token(5);
            ADQLOperand[] coords = this.Coordinates();
            Token end = this.jj_consume_token(3);
            try {
                PointFunction pf = this.queryFactory.createPoint(coordSys, coords[0], coords[1]);
                pf.setPosition(new TextPosition(start, end));
                PointFunction pointFunction = pf;
                return pointFunction;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("Point");
        }
    }

    public final GeometryFunction ExtractCoordSys() throws ParseException {
        this.trace_call("ExtractCoordSys");
        try {
            Token start = this.jj_consume_token(63);
            this.jj_consume_token(2);
            GeometryFunction.GeometryValue<GeometryFunction> gvf = this.GeometryExpression();
            Token end = this.jj_consume_token(3);
            try {
                ExtractCoordSys gf = this.queryFactory.createExtractCoordSys(gvf);
                gf.setPosition(new TextPosition(start, end));
                ExtractCoordSys extractCoordSys = gf;
                return extractCoordSys;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("ExtractCoordSys");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ADQLFunction NumericFunction() throws ParseException {
        this.trace_call("NumericFunction");
        try {
            ADQLFunction fct;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: {
                    fct = this.MathFunction();
                    break;
                }
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: {
                    fct = this.TrigFunction();
                    break;
                }
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 64: {
                    fct = this.GeometryFunction();
                    break;
                }
                case 97: {
                    fct = this.UserDefinedFunction();
                    ((UserDefinedFunction)fct).setExpectedType('N');
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ADQLFunction aDQLFunction = fct;
            return aDQLFunction;
        }
        finally {
            this.trace_return("NumericFunction");
        }
    }

    public final MathFunction MathFunction() throws ParseException {
        this.trace_call("MathFunction");
        try {
            Token fct = null;
            ADQLOperand param1 = null;
            ADQLOperand param2 = null;
            Object integerValue = null;
            try {
                Token end;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 65: {
                        fct = this.jj_consume_token(65);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 66: {
                        fct = this.jj_consume_token(66);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 67: {
                        fct = this.jj_consume_token(67);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 68: {
                        fct = this.jj_consume_token(68);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 69: {
                        fct = this.jj_consume_token(69);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 70: {
                        fct = this.jj_consume_token(70);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 71: {
                        fct = this.jj_consume_token(71);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 72: {
                        fct = this.jj_consume_token(72);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        this.jj_consume_token(5);
                        param2 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 73: {
                        fct = this.jj_consume_token(73);
                        this.jj_consume_token(2);
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 74: {
                        fct = this.jj_consume_token(74);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        this.jj_consume_token(5);
                        param2 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 75: {
                        fct = this.jj_consume_token(75);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 76: {
                        fct = this.jj_consume_token(76);
                        this.jj_consume_token(2);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 2: 
                            case 8: 
                            case 9: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 96: 
                            case 97: 
                            case 99: 
                            case 100: 
                            case 101: {
                                param1 = this.NumericExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[91] = this.jj_gen;
                            }
                        }
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 77: {
                        fct = this.jj_consume_token(77);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                this.jj_consume_token(5);
                                param2 = this.SignedInteger();
                                break;
                            }
                            default: {
                                this.jj_la1[92] = this.jj_gen;
                            }
                        }
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 78: {
                        fct = this.jj_consume_token(78);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        end = this.jj_consume_token(3);
                        break;
                    }
                    case 79: {
                        fct = this.jj_consume_token(79);
                        this.jj_consume_token(2);
                        param1 = this.NumericExpression();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                this.jj_consume_token(5);
                                param2 = this.SignedInteger();
                                break;
                            }
                            default: {
                                this.jj_la1[93] = this.jj_gen;
                            }
                        }
                        end = this.jj_consume_token(3);
                        break;
                    }
                    default: {
                        this.jj_la1[94] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (param1 != null) {
                    MathFunction mf = this.queryFactory.createMathFunction(MathFunctionType.valueOf(fct.image.toUpperCase()), param1, param2);
                    mf.setPosition(new TextPosition(fct, end));
                    MathFunction mathFunction = mf;
                    return mathFunction;
                }
                MathFunction mf = null;
                return mf;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("MathFunction");
        }
    }

    public final MathFunction TrigFunction() throws ParseException {
        this.trace_call("TrigFunction");
        try {
            Token end;
            Token fct = null;
            ADQLOperand param1 = null;
            ADQLOperand param2 = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 80: {
                    fct = this.jj_consume_token(80);
                    this.jj_consume_token(2);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(3);
                    break;
                }
                case 81: {
                    fct = this.jj_consume_token(81);
                    this.jj_consume_token(2);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(3);
                    break;
                }
                case 82: {
                    fct = this.jj_consume_token(82);
                    this.jj_consume_token(2);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(3);
                    break;
                }
                case 83: {
                    fct = this.jj_consume_token(83);
                    this.jj_consume_token(2);
                    param1 = this.NumericExpression();
                    this.jj_consume_token(5);
                    param2 = this.NumericExpression();
                    end = this.jj_consume_token(3);
                    break;
                }
                case 84: {
                    fct = this.jj_consume_token(84);
                    this.jj_consume_token(2);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(3);
                    break;
                }
                case 85: {
                    fct = this.jj_consume_token(85);
                    this.jj_consume_token(2);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(3);
                    break;
                }
                case 86: {
                    fct = this.jj_consume_token(86);
                    this.jj_consume_token(2);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(3);
                    break;
                }
                case 87: {
                    fct = this.jj_consume_token(87);
                    this.jj_consume_token(2);
                    param1 = this.NumericExpression();
                    end = this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[95] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            try {
                if (param1 != null) {
                    MathFunction mf = this.queryFactory.createMathFunction(MathFunctionType.valueOf(fct.image.toUpperCase()), param1, param2);
                    mf.setPosition(new TextPosition(fct, end));
                    MathFunction mathFunction = mf;
                    return mathFunction;
                }
                MathFunction mf = null;
                return mf;
            }
            catch (Exception ex) {
                throw this.generateParseException(ex);
            }
        }
        finally {
            this.trace_return("TrigFunction");
        }
    }

    /*
     * Exception decompiling
     */
    public final UserDefinedFunction UserDefinedFunction() throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    private boolean jj_3R_104() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_146() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_101() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_123()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_124()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_125()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_126()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_127()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_128()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_152() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_144() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_113() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_149() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_112() {
        return this.jj_3R_130();
    }

    private boolean jj_3R_150() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_70() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_116()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_117()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_118()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_16() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3R_111() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_135() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_110() {
        return this.jj_3R_129();
    }

    private boolean jj_3R_148() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_107() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_110()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_111()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_112()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_113()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_99() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_148()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_149()) {
                return true;
            }
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_150()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_151()) {
                return true;
            }
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_98() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_146()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_147()) {
                return true;
            }
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_97() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_144()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_145()) {
                return true;
            }
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_96() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_114()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_103() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_154() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(9)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_95() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(58)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(59)) {
                return true;
            }
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_114()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_114()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_153() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_154()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(101);
    }

    private boolean jj_3R_106() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_95()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_96()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_97()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_98()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_99()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_136() {
        if (this.jj_3R_100()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_100();
    }

    private boolean jj_3R_140() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(47)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(48)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(49)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(50)) {
                        return true;
                    }
                }
            }
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(19)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_42()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_129() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(99)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(100)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(101)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_139() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(19)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_152()) {
                return true;
            }
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_102() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_102()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_103()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_104()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_64()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_130() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_139()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_140()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_22() {
        Token xsp;
        if (this.jj_3R_37()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_37());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_105() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_65() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_105()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_106()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_107()) {
                    return true;
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_65()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_47();
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3_16() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_42();
    }

    private boolean jj_3R_109() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3_13() {
        return this.jj_3R_26();
    }

    private boolean jj_3_3() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_47() {
        return this.jj_3R_66();
    }

    private boolean jj_3_15() {
        if (this.jj_3R_27()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3_14() {
        if (this.jj_3R_21()) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3_2() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_108() {
        return this.jj_3R_71();
    }

    private boolean jj_3R_133() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_42();
    }

    private boolean jj_3R_66() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_2()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_109()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_25() {
        return this.jj_3R_42();
    }

    private boolean jj_3_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(41)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_25()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_115() {
        Token xsp;
        if (this.jj_3R_42()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_133());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_52() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_71();
    }

    private boolean jj_3R_21() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_143() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_153();
    }

    private boolean jj_3R_142() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_153();
    }

    private boolean jj_3R_36() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_120() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_119() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_71() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_119()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_120()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_132() {
        return this.jj_3R_101();
    }

    private boolean jj_3R_24() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_115()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(96);
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(97);
    }

    private boolean jj_3R_141() {
        return this.jj_3R_100();
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_29()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_94() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_131() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_93() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_114() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_131()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_132()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_92() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_91() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_90() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_51() {
        return this.jj_3R_70();
    }

    private boolean jj_3R_89() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_11() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_88() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_50() {
        return this.jj_3R_69();
    }

    private boolean jj_3R_87() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_11()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_51()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_87()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_88()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_89()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_90()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_91()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_92()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_93()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_94()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_49() {
        return this.jj_3R_68();
    }

    private boolean jj_3R_86() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_143()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_85() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_84() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_142()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_83() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_141()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_82() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_81() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_80() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_79() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_78() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_77() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_76() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_75() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_43() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_35();
    }

    private boolean jj_3R_74() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_73() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_72() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_27() {
        Token xsp;
        if (this.jj_3R_35()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_43());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_73()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_74()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_75()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_76()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_77()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_78()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_79()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_80()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_81()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_82()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_83()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_84()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_85()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_86()) {
                                                                    return true;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_67() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_41() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_40() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_39() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_38() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_39()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_40()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_41()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_30() {
        if (this.jj_3R_14()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_10() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_67()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_15() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(4)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_134() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(11)) {
                return true;
            }
        }
        return this.jj_3R_121();
    }

    private boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_49()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_69() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_114()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_147() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_145() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_138() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_136();
    }

    private boolean jj_3R_19() {
        if (this.jj_3R_34()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(9)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(10)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(11)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_122() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(9)) {
                return true;
            }
        }
        return this.jj_3R_100();
    }

    private boolean jj_3R_20() {
        if (this.jj_3R_35()) {
            return true;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_137() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_135()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_136()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_121() {
        if (this.jj_3R_34()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_134()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_128() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_27()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_9() {
        return this.jj_3R_22();
    }

    private boolean jj_3_8() {
        return this.jj_3R_21();
    }

    private boolean jj_3_1() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(4)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_15()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        return this.jj_scan_token(2);
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(63)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_127() {
        Token xsp;
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_135()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_136()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_136()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_136()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_138());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(3);
    }

    private boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_19()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(9)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_63() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_126() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_62() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_61() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_100() {
        if (this.jj_3R_121()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_60() {
        return this.jj_3R_101();
    }

    private boolean jj_3R_59() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_58() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_42()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_57() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_125() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_135()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_136()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_56() {
        return this.jj_3R_100();
    }

    private boolean jj_3R_124() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_114()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_118() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_27()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_123() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_135()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_136()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_117() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_57()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_58()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_59()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_60()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_61()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_62()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_63()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_116() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_151() {
        return this.jj_3R_21();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{65, 0, 0, 0, 0, 524288, 0x100000, 32, 0, 0, 0x400000, 1024, 772, 32, 32, 32, 0, 16, 16, 16, 0, 0, 0, 0, 0x400000, 0x400000, 0x400000, 0, 4, 1031798784, 0x1C000000, 0x2000000, 0x1D000000, 0x1D000000, 0x1C000000, 0x2000000, 0x1D000000, 0x1D000000, 32, -1073741824, 1031798784, 0, 0, 0, 768, 768, 4, 4, 0, 772, 768, 768, 3072, 3072, 768, 768, 4, 128, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 258048, 0, 0, 772, 258048, 0, 0, 32, 4, 524288, 1796, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 772, 32, 32, 0, 0, 32, 772};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 1, 1024, 2048, 4096, 0, 0, 0, 0, 0, 0, 0, Short.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24576, 24576, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1015808, 0, 0x3F00000, 2081390592, 0, 0, 0, 0, 0, 0, 1015808, 0, Integer.MIN_VALUE, 0, 0x3F00000, 8, 6, 6, 8, 0, 8, 8, 0, 264, 512, Short.MIN_VALUE, 0, 8, 8, 0, 0, 0, Short.MIN_VALUE, 491520, 0, 1015808, 0xC000000, 0x800000, 0x800000, 0x800000, 0x800000, 0x7C000000, 0, 0x3F00000, 0x7C000000, 2081390592, 0, 0, 0, 0, 0, Short.MIN_VALUE};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20FFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0x20000000, 0, 0xFFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20FFFFFF, 0, 0, 0, 0, 0, 0, 0x20FFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0xFFFFFF, 0xFFFFFF, 0, 0, 65534, 0xFF0000, 0, 0x20FFFFFF};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 59, 0, 0, 0, 3, 0, 0, 0, 35, 35, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 48, 0, 0, 59, 3, 0, 59, 0, 0, 0, 0, 0, 0, 59, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 0, 2, 59, 0, 0, 0, 0, 0, 59};
    }

    public ADQLParser(InputStream stream) {
        this(stream, (String)null);
    }

    public ADQLParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ADQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ADQLParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ADQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ADQLParser(ADQLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ADQLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 98; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            this.trace_token(this.token, "");
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        this.trace_token(this.token, " (in getNextToken)");
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[103];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 98; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 103; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
        this.trace_enabled = true;
    }

    public final void disable_tracing() {
        this.trace_enabled = false;
    }

    private void trace_call(String s) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Call:   " + s);
        }
        this.trace_indent += 2;
    }

    private void trace_return(String s) {
        this.trace_indent -= 2;
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Return: " + s);
        }
    }

    private void trace_token(Token t, String where) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Consumed token: <" + tokenImage[t.kind]);
            if (t.kind != 0 && !tokenImage[t.kind].equals("\"" + t.image + "\"")) {
                System.out.print(": \"" + t.image + "\"");
            }
            System.out.println(" at line " + t.beginLine + " column " + t.beginColumn + ">" + where);
        }
    }

    private void trace_scan(Token t1, int t2) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Visited token: <" + tokenImage[t1.kind]);
            if (t1.kind != 0 && !tokenImage[t1.kind].equals("\"" + t1.image + "\"")) {
                System.out.print(": \"" + t1.image + "\"");
            }
            System.out.println(" at line " + t1.beginLine + " column " + t1.beginColumn + ">; Expected token: <" + tokenImage[t2] + ">");
        }
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 16; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ADQLParser.jj_la1_init_0();
        ADQLParser.jj_la1_init_1();
        ADQLParser.jj_la1_init_2();
        ADQLParser.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

