/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.parser.Token;
import adql.query.TextPosition;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected TextPosition position = null;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.position = new TextPosition(this.currentToken.next);
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    public ParseException(String message, TextPosition errorPosition) {
        this(message);
        this.position = errorPosition;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        int maxSize = 0;
        StringBuffer expected = new StringBuffer();
        for (int i = 0; i < expectedTokenSequences.length; ++i) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            for (int j = 0; j < expectedTokenSequences[i].length; ++j) {
                expected.append(tokenImage[expectedTokenSequences[i][j]]);
            }
            expected.append(" ");
        }
        StringBuffer msg = new StringBuffer();
        msg.append(" Encountered \"");
        Token tok = currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                msg.append(' ');
            }
            if (tok.kind == 0) {
                msg.append(tokenImage[0]);
                break;
            }
            msg.append(ParseException.add_escapes(tok.image));
            tok = tok.next;
        }
        msg.append("\".");
        if (expectedTokenSequences.length == 1) {
            msg.append(" Was expecting: ");
        } else {
            msg.append(" Was expecting one of: ");
        }
        msg.append(expected);
        return msg.toString();
    }

    static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

