/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ADQLList<T extends ADQLObject>
implements ADQLObject,
Iterable<T> {
    private final String name;
    private final Vector<T> list = new Vector();
    private TextPosition position = null;

    protected ADQLList(String name) {
        if (name != null && (name = name.trim()).length() == 0) {
            name = null;
        }
        this.name = name;
    }

    protected ADQLList(ADQLList<T> toCopy) throws Exception {
        this(toCopy.getName());
        for (ADQLObject obj : toCopy) {
            this.add(obj.getCopy());
        }
        this.position = toCopy.position != null ? new TextPosition(toCopy.position) : null;
    }

    public boolean add(T item) throws NullPointerException {
        if (item == null) {
            throw new NullPointerException("It is impossible to add NULL items to an ADQL clause !");
        }
        if (this.list.add(item)) {
            this.position = null;
            return true;
        }
        return false;
    }

    public void add(int index, T item) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (item == null) {
            throw new NullPointerException("It is impossible to add NULL items to an ADQL clause !");
        }
        this.list.add(index, item);
        this.position = null;
    }

    public T set(int index, T item) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (item != null) {
            ADQLObject removed = (ADQLObject)this.list.set(index, item);
            this.position = null;
            return (T)removed;
        }
        throw new NullPointerException("It is impossible to replace an ADQL item by a NULL item into an ADQL clause !");
    }

    public T get(int index) throws ArrayIndexOutOfBoundsException {
        return (T)((ADQLObject)this.list.get(index));
    }

    public T remove(int index) throws ArrayIndexOutOfBoundsException {
        ADQLObject removed = (ADQLObject)this.list.remove(index);
        if (removed != null) {
            this.position = null;
        }
        return (T)removed;
    }

    public void clear() {
        this.list.clear();
        this.position = null;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public String toADQL() {
        StringBuffer adql = new StringBuffer(this.getName() == null ? "" : this.getName() + " ");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                adql.append(" " + this.getSeparator(i) + " ");
            }
            adql.append(this.get(i).toADQL());
        }
        return adql.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLListIterator(this);
    }

    public abstract String[] getPossibleSeparators();

    public abstract String getSeparator(int var1) throws ArrayIndexOutOfBoundsException;

    @Override
    public abstract ADQLObject getCopy() throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ADQLListIterator
    implements ADQLIterator {
        protected final ADQLList<ADQLObject> list;
        protected int index = -1;
        protected boolean removed = false;

        public ADQLListIterator(ADQLList<? extends ADQLObject> lst) {
            this.list = lst;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.list.size();
        }

        @Override
        public ADQLObject next() {
            this.removed = false;
            return this.list.get(++this.index);
        }

        @Override
        public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
            if (this.index <= -1) {
                throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
            }
            if (this.removed) {
                throw new IllegalStateException("The remove() has already been called !");
            }
            if (replacer == null) {
                this.remove();
            } else {
                this.list.set(this.index, replacer);
            }
        }

        @Override
        public void remove() {
            if (this.index <= -1) {
                throw new IllegalStateException("remove() impossible: next() has not yet been called !");
            }
            if (this.removed) {
                throw new IllegalStateException("The remove() has already been called !");
            }
            this.list.remove(this.index--);
            this.removed = true;
        }
    }
}

