/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLObject;
import adql.query.ColumnReference;

public class ADQLOrder
extends ColumnReference {
    private boolean descSorting = false;

    public ADQLOrder(int colIndex) throws ArrayIndexOutOfBoundsException {
        this(colIndex, false);
    }

    public ADQLOrder(int colIndex, boolean desc) throws ArrayIndexOutOfBoundsException {
        super(colIndex);
        this.descSorting = desc;
    }

    public ADQLOrder(String colName) throws NullPointerException {
        this(colName, false);
    }

    public ADQLOrder(String colName, boolean desc) throws NullPointerException {
        super(colName);
        this.descSorting = desc;
    }

    public ADQLOrder(ADQLOrder toCopy) {
        super(toCopy);
        this.descSorting = toCopy.descSorting;
    }

    public boolean isDescSorting() {
        return this.descSorting;
    }

    public void setOrder(int colIndex, boolean desc) throws ArrayIndexOutOfBoundsException {
        if (colIndex <= 0) {
            throw new ArrayIndexOutOfBoundsException("Impossible to make a reference to the " + colIndex + "th column: a column index must be greater or equal 1 !");
        }
        this.setColumnIndex(colIndex);
        this.descSorting = desc;
    }

    public void setOrder(String colName, boolean desc) throws NullPointerException {
        if (colName == null) {
            throw new NullPointerException("Impossible to make a reference: the given name is null or is an empty string !");
        }
        this.setColumnName(colName);
        this.descSorting = desc;
    }

    public ADQLObject getCopy() throws Exception {
        return new ADQLOrder(this);
    }

    public String getName() {
        return super.getName() + (this.descSorting ? " DESC" : " ASC");
    }

    public String toADQL() {
        return super.toADQL() + (this.descSorting ? " DESC" : " ASC");
    }
}

