/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.db.DBColumn;
import adql.db.DefaultDBColumn;
import adql.parser.ParseException;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLOrder;
import adql.query.ClauseADQL;
import adql.query.ClauseConstraints;
import adql.query.ClauseSelect;
import adql.query.ColumnReference;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.TextPosition;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.search.ISearchHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADQLQuery
implements ADQLObject {
    private ClauseSelect select;
    private FromContent from;
    private ClauseConstraints where;
    private ClauseADQL<ColumnReference> groupBy;
    private ClauseConstraints having;
    private ClauseADQL<ADQLOrder> orderBy;
    private TextPosition position = null;

    public ADQLQuery() {
        this.select = new ClauseSelect();
        this.from = null;
        this.where = new ClauseConstraints("WHERE");
        this.groupBy = new ClauseADQL("GROUP BY");
        this.having = new ClauseConstraints("HAVING");
        this.orderBy = new ClauseADQL("ORDER BY");
    }

    public ADQLQuery(ADQLQuery toCopy) throws Exception {
        this.select = (ClauseSelect)toCopy.select.getCopy();
        this.from = (FromContent)toCopy.from.getCopy();
        this.where = (ClauseConstraints)toCopy.where.getCopy();
        this.groupBy = (ClauseADQL)toCopy.groupBy.getCopy();
        this.having = (ClauseConstraints)toCopy.having.getCopy();
        this.orderBy = (ClauseADQL)toCopy.orderBy.getCopy();
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    public void reset() {
        this.select.clear();
        this.select.setDistinctColumns(false);
        this.select.setNoLimit();
        this.from = null;
        this.where.clear();
        this.groupBy.clear();
        this.having.clear();
        this.orderBy.clear();
        this.position = null;
    }

    public final ClauseSelect getSelect() {
        return this.select;
    }

    public void setSelect(ClauseSelect newSelect) throws NullPointerException {
        if (newSelect == null) {
            throw new NullPointerException("Impossible to replace the SELECT clause of a query by NULL !");
        }
        this.select = newSelect;
        this.position = null;
    }

    public final FromContent getFrom() {
        return this.from;
    }

    public void setFrom(FromContent newFrom) throws NullPointerException {
        if (newFrom == null) {
            throw new NullPointerException("Impossible to replace the FROM clause of a query by NULL !");
        }
        this.from = newFrom;
        this.position = null;
    }

    public final ClauseConstraints getWhere() {
        return this.where;
    }

    public void setWhere(ClauseConstraints newWhere) throws NullPointerException {
        if (newWhere == null) {
            this.where.clear();
        } else {
            this.where = newWhere;
        }
        this.position = null;
    }

    public final ClauseADQL<ColumnReference> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(ClauseADQL<ColumnReference> newGroupBy) throws NullPointerException {
        if (newGroupBy == null) {
            this.groupBy.clear();
        } else {
            this.groupBy = newGroupBy;
        }
        this.position = null;
    }

    public final ClauseConstraints getHaving() {
        return this.having;
    }

    public void setHaving(ClauseConstraints newHaving) throws NullPointerException {
        if (newHaving == null) {
            this.having.clear();
        } else {
            this.having = newHaving;
        }
        this.position = null;
    }

    public final ClauseADQL<ADQLOrder> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(ClauseADQL<ADQLOrder> newOrderBy) throws NullPointerException {
        if (newOrderBy == null) {
            this.orderBy.clear();
        } else {
            this.orderBy = newOrderBy;
        }
        this.position = null;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ADQLQuery(this);
    }

    @Override
    public String getName() {
        return "{ADQL query}";
    }

    public DBColumn[] getResultingColumns() {
        ArrayList<DBColumn> columns = new ArrayList<DBColumn>(this.select.size());
        for (SelectItem item : this.select) {
            ADQLOperand operand = item.getOperand();
            if (item instanceof SelectAllColumns) {
                try {
                    if (((SelectAllColumns)item).getAdqlTable() != null) {
                        columns.addAll(((SelectAllColumns)item).getAdqlTable().getDBColumns());
                        continue;
                    }
                    columns.addAll(this.from.getDBColumns());
                }
                catch (ParseException pe) {}
                continue;
            }
            DBColumn col = null;
            if (item.hasAlias()) {
                if (operand instanceof ADQLColumn && ((ADQLColumn)operand).getDBLink() != null) {
                    col = ((ADQLColumn)operand).getDBLink();
                    col = col.copy(col.getDBName(), item.getAlias(), col.getTable());
                } else {
                    col = new DefaultDBColumn(item.getAlias(), null);
                }
            } else {
                if (operand instanceof ADQLColumn && ((ADQLColumn)operand).getDBLink() != null) {
                    col = ((ADQLColumn)operand).getDBLink();
                }
                if (col == null) {
                    col = new DefaultDBColumn(item.getName(), null);
                }
            }
            columns.add(col);
        }
        DBColumn[] resColumns = new DBColumn[columns.size()];
        return columns.toArray(resColumns);
    }

    public Iterator<ADQLObject> search(ISearchHandler sHandler) {
        sHandler.search(this);
        return sHandler.iterator();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;
            private ClauseADQL<?> currentClause = null;

            public ADQLObject next() {
                ++this.index;
                switch (this.index) {
                    case 0: {
                        this.currentClause = ADQLQuery.this.select;
                        break;
                    }
                    case 1: {
                        this.currentClause = null;
                        return ADQLQuery.this.from;
                    }
                    case 2: {
                        this.currentClause = ADQLQuery.this.where;
                        break;
                    }
                    case 3: {
                        this.currentClause = ADQLQuery.this.groupBy;
                        break;
                    }
                    case 4: {
                        this.currentClause = ADQLQuery.this.having;
                        break;
                    }
                    case 5: {
                        this.currentClause = ADQLQuery.this.orderBy;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException();
                    }
                }
                return this.currentClause;
            }

            public boolean hasNext() {
                return this.index + 1 < 6;
            }

            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (replacer == null) {
                    this.remove();
                } else {
                    switch (this.index) {
                        case 0: {
                            if (replacer instanceof ClauseSelect) {
                                ADQLQuery.this.select = (ClauseSelect)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseSelect (" + ADQLQuery.this.select.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                        }
                        case 1: {
                            if (replacer instanceof FromContent) {
                                ADQLQuery.this.from = (FromContent)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a FromContent (" + ADQLQuery.this.from.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                        }
                        case 2: {
                            if (replacer instanceof ClauseConstraints) {
                                ADQLQuery.this.where = (ClauseConstraints)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseConstraints (" + ADQLQuery.this.where.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                        }
                        case 3: {
                            if (replacer instanceof ClauseADQL) {
                                ADQLQuery.this.groupBy = (ClauseADQL)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseADQL (" + ADQLQuery.this.groupBy.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                        }
                        case 4: {
                            if (replacer instanceof ClauseConstraints) {
                                ADQLQuery.this.having = (ClauseConstraints)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseConstraints (" + ADQLQuery.this.having.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                        }
                        case 5: {
                            if (replacer instanceof ClauseADQL) {
                                ADQLQuery.this.orderBy = (ClauseADQL)replacer;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseADQL (" + ADQLQuery.this.orderBy.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                        }
                    }
                    ADQLQuery.this.position = null;
                }
            }

            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                if (this.index == 0 || this.index == 1) {
                    throw new UnsupportedOperationException("Impossible to remove a " + (this.index == 0 ? "SELECT" : "FROM") + " clause from a query !");
                }
                this.currentClause.clear();
                ADQLQuery.this.position = null;
            }
        };
    }

    @Override
    public String toADQL() {
        StringBuffer adql = new StringBuffer(this.select.toADQL());
        adql.append("\nFROM ").append(this.from.toADQL());
        if (!this.where.isEmpty()) {
            adql.append('\n').append(this.where.toADQL());
        }
        if (!this.groupBy.isEmpty()) {
            adql.append('\n').append(this.groupBy.toADQL());
        }
        if (!this.having.isEmpty()) {
            adql.append('\n').append(this.having.toADQL());
        }
        if (!this.orderBy.isEmpty()) {
            adql.append('\n').append(this.orderBy.toADQL());
        }
        return adql.toString();
    }
}

