/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.db.DBColumn;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;
import adql.query.from.ADQLTable;

public class ColumnReference
implements ADQLObject {
    private TextPosition position = null;
    private int columnIndex = -1;
    private String columnName = null;
    private DBColumn dbLink = null;
    private ADQLTable adqlTable = null;
    private boolean caseSensitive = false;

    public ColumnReference(int index) throws ArrayIndexOutOfBoundsException {
        if (index <= 0) {
            throw new IndexOutOfBoundsException("Impossible to make a reference to the " + index + "th column: a column index must be greater or equal 1 !");
        }
        this.columnIndex = index;
        this.columnName = null;
    }

    public ColumnReference(String colName) throws NullPointerException {
        if (!this.setColumnName(colName)) {
            throw new NullPointerException("Impossible to make a reference: the given column name is null or is an empty string !");
        }
    }

    public ColumnReference(ColumnReference toCopy) {
        this.columnName = toCopy.columnName;
        this.caseSensitive = toCopy.caseSensitive;
        this.columnIndex = toCopy.columnIndex;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public void setPosition(TextPosition pos) {
        this.position = pos;
    }

    public final int getColumnIndex() {
        return this.columnIndex;
    }

    public final boolean setColumnIndex(int index) {
        if (index > 0) {
            this.columnName = null;
            this.columnIndex = index;
            return true;
        }
        return false;
    }

    public final boolean isIndex() {
        return this.columnName == null;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public final boolean setColumnName(String name) {
        if (name == null) {
            return false;
        }
        StringBuffer n = new StringBuffer(name);
        n.trimToSize();
        if (n.length() > 1 && n.charAt(0) == '\"' && n.charAt(name.length() - 1) == '\"') {
            n.deleteCharAt(0);
            n.deleteCharAt(n.length() - 1);
            n.trimToSize();
            if (n.length() > 0) {
                this.caseSensitive = true;
            }
        }
        if (n.length() == 0) {
            return false;
        }
        this.columnIndex = -1;
        this.columnName = n.toString();
        return true;
    }

    public final boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public final void setCaseSensitive(boolean sensitive) {
        this.caseSensitive = sensitive;
    }

    public final DBColumn getDBLink() {
        return this.dbLink;
    }

    public final void setDBLink(DBColumn dbLink) {
        this.dbLink = dbLink;
    }

    public final ADQLTable getAdqlTable() {
        return this.adqlTable;
    }

    public final void setAdqlTable(ADQLTable adqlTable) {
        this.adqlTable = adqlTable;
    }

    public ADQLObject getCopy() throws Exception {
        return new ColumnReference(this);
    }

    public String getName() {
        return this.isIndex() ? this.columnIndex + "" : this.columnName;
    }

    public final ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    public String toADQL() {
        return this.isIndex() ? "" + this.columnIndex : (this.isCaseSensitive() ? "\"" + this.columnName + "\"" : this.columnName);
    }
}

